/*
 * Decompiled with CFR 0.152.
 */
package virtual.dv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmOutputStream;
import rad.dicom.dcm.DcmValue;
import rad.dicom.ima.GeneralImageIOD;
import rad.dicom.ima.SecondaryCaptureIOD;
import rad.ijplugin.dcm.ExportData;
import rad.ijplugin.dcm.ExportPanel;
import rad.ijplugin.dcm.ImportData;
import rad.ijplugin.dcm.ImportPanel;
import rad.ijplugin.util.Util;
import virtual.dv.AnimationFrame;
import virtual.dv.DVPanel;
import virtual.dv.MIPParamDlg;
import virtual.dv.ProjParamDlg;
import virtual.dv.SeriesLoader;
import virtual.dv.ViewerReferenceSeries;
import virtual.tools.AboutBox;
import virtual.tools.DcmImage;
import virtual.tools.ErrorMessage;
import virtual.tools.Histogramm;
import virtual.tools.ImagePlus;
import virtual.tools.ImageStack;
import virtual.tools.KSpaceFrame;
import virtual.tools.KSpaceManipulator;
import virtual.tools.SliderPanel;

public class ViewerFrame
extends JFrame {
    private final Cursor DEFAULT_CURSOR = new Cursor(0);
    private final Cursor ZOOM_CURSOR = new Cursor(1);
    private final Cursor WINDOW_CURSOR = new Cursor(13);
    private JMenuBar menuBar1 = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuFileImageOpen = new JMenuItem();
    private JMenuItem menuFileSave = new JMenuItem();
    private JMenuItem menuFilePrint = new JMenuItem();
    private JMenuItem menuFileExit = new JMenuItem();
    private JMenu menuEdit = new JMenu();
    private JMenuItem menuEditClear = new JMenuItem();
    private JMenuItem menuEditClearAll = new JMenuItem();
    private JMenu menuTools = new JMenu();
    private JMenuItem menuToolsAbout = new JMenuItem();
    private ImageIcon iOpen;
    private ImageIcon iSave;
    private ImageIcon iPrint;
    private ImageIcon iRefIma;
    private ImageIcon i1Image;
    private ImageIcon i4Images;
    private ImageIcon iInfoText;
    private ImageIcon iHistogram;
    private ImageIcon iKSpace;
    private ImageIcon iKSpaceMan;
    private ImageIcon iAngel;
    private ImageIcon iPointer;
    private ImageIcon iZoom;
    private ImageIcon iRotate;
    private ImageIcon iMirror;
    private ImageIcon iInvert;
    private ImageIcon iGrayValue;
    private ImageIcon iDistance;
    private ImageIcon iProjection1;
    private ImageIcon iProjection2;
    private ImageIcon iDelete;
    private ImageIcon iAnimation;
    protected JLabel statusBar = new JLabel();
    private JProgressBar prbarProgress = new JProgressBar();
    private JLabel lPosition = new JLabel();
    private JLabel lPositionText = new JLabel();
    DVPanel pCanvas = new DVPanel(this);
    JScrollBar sbVerScrollbar = new JScrollBar();
    private JPanel pToolbar = new JPanel();
    private JTabbedPane tpMain = new JTabbedPane();
    private JButton pbLoad = new JButton();
    private JButton pbSave = new JButton();
    private JButton pbPrint = new JButton();
    private JButton pbReferenceData = new JButton();
    private JPanel tpLayout = new JPanel();
    private JPanel tpTools = new JPanel();
    private JPanel tpWindow = new JPanel();
    private JPanel tp3D = new JPanel();
    private JPanel tpExtras = new JPanel();
    JToggleButton rb1Image = new JToggleButton();
    JToggleButton rb4Images = new JToggleButton();
    private ButtonGroup bgNumOfImages = new ButtonGroup();
    private JButton pbKSpace = new JButton();
    private JButton pbHistogram = new JButton();
    JToggleButton tbImageText = new JToggleButton();
    private JButton pbKSpaceManip = new JButton();
    private JToggleButton rbPointer = new JToggleButton();
    JToggleButton rbZoom = new JToggleButton();
    JToggleButton rbDistance = new JToggleButton();
    JToggleButton rbAngel = new JToggleButton();
    JToggleButton rbGrayValue = new JToggleButton();
    private JButton pbMirror = new JButton();
    private JButton pbRotate = new JButton();
    private JButton pbInvert = new JButton();
    private JButton pbDelete = new JButton();
    protected SliderPanel pCenter;
    protected SliderPanel pWindow;
    private JButton pbResetWindowing = new JButton();
    private JButton pbOptWindowing = new JButton();
    private JButton pbAnimation = new JButton();
    private JButton pbCalcMIP = new JButton();
    private JButton pbProjection1 = new JButton();
    private JButton pbProjection2 = new JButton();
    private SliderPanel pTimeFactor;
    private JPanel pNextImageAt = new JPanel();
    private JLabel lNextImageAt = new JLabel();
    public JRadioButton rbNextImageAtSelection = new JRadioButton();
    private JRadioButton rbNextImageAtFreePlace = new JRadioButton();
    private ButtonGroup bgPlaceNextImage = new ButtonGroup();
    public JCheckBox chbActivateNewImg = new JCheckBox();
    private int curr_x;
    private int curr_y;
    private int lastMouseClickX;
    private int lastMouseClickY;
    private int mouseClicks = 0;
    private long lastTime;
    private int lastCenter;
    private int lastWindow;
    private boolean unsavedChanges = false;
    private Properties preferences = new Properties();
    private boolean isApplication = true;

    public ViewerFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadPreferences();
    }

    public void setAppType(boolean ia) {
        this.isApplication = ia;
    }

    private void jbInit() throws Exception {
        this.iAnimation = new ImageIcon(this.getClass().getResource("resources/animation.gif"));
        this.iDelete = new ImageIcon(this.getClass().getResource("resources/delete.gif"));
        this.iOpen = new ImageIcon(this.getClass().getResource("resources/openfile.gif"));
        this.iSave = new ImageIcon(this.getClass().getResource("resources/save.gif"));
        this.iPrint = new ImageIcon(this.getClass().getResource("resources/print.gif"));
        this.iRefIma = new ImageIcon(this.getClass().getResource("resources/refima.gif"));
        this.i1Image = new ImageIcon(this.getClass().getResource("resources/1image.gif"));
        this.i4Images = new ImageIcon(this.getClass().getResource("resources/4images.gif"));
        this.iInfoText = new ImageIcon(this.getClass().getResource("resources/imageinfo.gif"));
        this.iHistogram = new ImageIcon(this.getClass().getResource("resources/histogramm.gif"));
        this.iKSpace = new ImageIcon(this.getClass().getResource("resources/k_raum.gif"));
        this.iKSpaceMan = new ImageIcon(this.getClass().getResource("resources/k_raum_man.gif"));
        this.iAngel = new ImageIcon(this.getClass().getResource("resources/winkel.gif"));
        this.iPointer = new ImageIcon(this.getClass().getResource("resources/picktool.gif"));
        this.iZoom = new ImageIcon(this.getClass().getResource("resources/zoomtool.gif"));
        this.iRotate = new ImageIcon(this.getClass().getResource("resources/drehen.gif"));
        this.iMirror = new ImageIcon(this.getClass().getResource("resources/spiegeln.gif"));
        this.iInvert = new ImageIcon(this.getClass().getResource("resources/invertieren.gif"));
        this.iGrayValue = new ImageIcon(this.getClass().getResource("resources/grauwert.gif"));
        this.iDistance = new ImageIcon(this.getClass().getResource("resources/abstand.gif"));
        this.iProjection1 = new ImageIcon(this.getClass().getResource("resources/projektion1.gif"));
        this.iProjection2 = new ImageIcon(this.getClass().getResource("resources/projektion2.gif"));
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(800, 585));
        this.setResizable(false);
        this.setBackground(new Color(204, 204, 204));
        this.setTitle("DICOM-Viewer");
        this.menuBar1.add(this.menuFile);
        this.menuBar1.add(this.menuEdit);
        this.menuBar1.add(this.menuTools);
        this.setJMenuBar(this.menuBar1);
        this.menuFile.setText("Datei");
        this.menuFileImageOpen.setText("Bild Oeffnen...");
        this.menuFileImageOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.fileImageOpen_actionPerformed();
            }
        });
        this.menuFileSave.setText("Speichern unter...");
        this.menuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.fileSave_actionPerformed();
            }
        });
        this.menuFilePrint.setText("Drucken...");
        this.menuFilePrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.filePrint_actionPerformed();
            }
        });
        this.menuFileExit.setText("Beenden");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.fileExit_actionPerformed();
            }
        });
        this.menuFile.add(this.menuFileImageOpen);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.add(this.menuFilePrint);
        this.menuFile.add(this.menuFileExit);
        this.menuEdit.setText("Bearbeiten");
        this.menuEditClear.setText("Selektiertes Bild loeschen");
        this.menuEditClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.editClear_actionPerformed();
            }
        });
        this.menuEditClearAll.setText("Alle Bilder loeschen");
        this.menuEditClearAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.editClearAll_actionPerformed();
            }
        });
        this.menuEdit.add(this.menuEditClear);
        this.menuEdit.add(this.menuEditClearAll);
        this.menuTools.setText("Tools");
        this.menuToolsAbout.setText("About...");
        this.menuToolsAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.helpAbout_actionPerformed();
            }
        });
        this.menuTools.add(this.menuToolsAbout);
        this.statusBar.setText("Bereit.");
        this.statusBar.setForeground(Color.black);
        this.statusBar.setFont(new Font("Dialog", 0, 12));
        this.statusBar.setBounds(new Rectangle(1, 516, 512, 15));
        this.getContentPane().add((Component)this.statusBar, null);
        this.prbarProgress.setToolTipText("Fortschrittsanzeige");
        this.prbarProgress.setBounds(new Rectangle(675, 516, 112, 15));
        this.prbarProgress.setMinimum(0);
        this.prbarProgress.setMaximum(100);
        this.prbarProgress.setValue(0);
        this.getContentPane().add((Component)this.prbarProgress, null);
        this.pCanvas.setMaximumSize(new Dimension(512, 512));
        this.pCanvas.setPreferredSize(new Dimension(512, 512));
        this.pCanvas.setBackground(Color.black);
        this.pCanvas.setMinimumSize(new Dimension(512, 512));
        this.pCanvas.setBounds(new Rectangle(1, 0, 512, 512));
        this.pCanvas.setLayout(null);
        this.getContentPane().add((Component)this.pCanvas, null);
        this.pCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                ViewerFrame.this.pCanvas_mouseExited();
            }

            public void mouseClicked(MouseEvent e) {
                ViewerFrame.this.pCanvas_mouseClicked(e);
            }

            public void mousePressed(MouseEvent e) {
                ViewerFrame.this.pCanvas_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                ViewerFrame.this.pCanvas_mouseReleased(e);
            }
        });
        this.pCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ViewerFrame.this.pCanvas_mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                ViewerFrame.this.pCanvas_mouseDragged(e);
            }
        });
        this.sbVerScrollbar = this.pCanvas.createVerticalScrollBar();
        this.sbVerScrollbar.setBounds(new Rectangle(513, 1, 20, 512));
        this.sbVerScrollbar.setBorder(BorderFactory.createEtchedBorder());
        this.sbVerScrollbar.setMinimum(0);
        this.sbVerScrollbar.setMaximum(1024);
        this.sbVerScrollbar.setVisibleAmount(511);
        this.sbVerScrollbar.setBlockIncrement(512);
        this.sbVerScrollbar.setUnitIncrement(512);
        this.getContentPane().add((Component)this.sbVerScrollbar, null);
        this.sbVerScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ViewerFrame.this.sbVerScrollbar_adjustmentValueChanged();
            }
        });
        this.pToolbar.setBounds(new Rectangle(535, 0, 255, 514));
        this.pToolbar.setLayout(null);
        this.pToolbar.add((Component)this.tpMain, null);
        this.getContentPane().add((Component)this.pToolbar, null);
        this.pbReferenceData.setMargin(new Insets(2, 2, 2, 2));
        this.pbReferenceData.setIcon(this.iRefIma);
        this.pbReferenceData.setBounds(new Rectangle(3, 12, 27, 26));
        this.pbReferenceData.setToolTipText("Referenzserie laden");
        this.pbReferenceData.setEnabled(true);
        this.pToolbar.add((Component)this.pbReferenceData, null);
        this.pbReferenceData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbReferenceData_actionPerformed();
            }
        });
        this.pbLoad.setMargin(new Insets(2, 2, 2, 2));
        this.pbLoad.setIcon(this.iOpen);
        this.pbLoad.setBounds(new Rectangle(40, 12, 27, 27));
        this.pbLoad.setToolTipText("DICOM-Bild laden");
        this.pToolbar.add((Component)this.pbLoad, null);
        this.pbLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbLoad_actionPerformed();
            }
        });
        this.pbSave.setMargin(new Insets(2, 2, 2, 2));
        this.pbSave.setBounds(new Rectangle(77, 12, 27, 27));
        this.pbSave.setToolTipText("Selektiertes Bild speichern");
        this.pbSave.setIcon(this.iSave);
        this.pToolbar.add((Component)this.pbSave, null);
        this.pbSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbSave_actionPerformed();
            }
        });
        this.pbPrint.setMargin(new Insets(2, 2, 2, 2));
        this.pbPrint.setBounds(new Rectangle(114, 12, 27, 27));
        this.pbPrint.setIcon(this.iPrint);
        this.pbPrint.setToolTipText("Selektiertes Bild drucken");
        this.pToolbar.add((Component)this.pbPrint, null);
        this.pbPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbPrint_actionPerformed();
            }
        });
        this.tpMain.setBounds(new Rectangle(3, 45, 250, 185));
        this.tpLayout.setLayout(null);
        this.tpMain.add((Component)this.tpLayout, "Ansicht");
        this.pbKSpaceManip.setIcon(this.iKSpaceMan);
        this.pbKSpaceManip.setToolTipText("k-Raum Manipulationswerkzeug");
        this.pbKSpaceManip.setBounds(new Rectangle(190, 10, 27, 27));
        this.pbKSpaceManip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbKSpaceManip_actionPerformed();
            }
        });
        this.tpLayout.add((Component)this.pbKSpaceManip, null);
        this.pbKSpace.setIcon(this.iKSpace);
        this.pbKSpace.setToolTipText("Transformiertes Bild im k-Raum anzeigen");
        this.pbKSpace.setBounds(new Rectangle(153, 10, 27, 27));
        this.pbKSpace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbKSpace_actionPerformed();
            }
        });
        this.tpLayout.add((Component)this.pbKSpace, null);
        this.pbHistogram.setIcon(this.iHistogram);
        this.pbHistogram.setToolTipText("Histogramm des selektierten Bildes anzeigen");
        this.pbHistogram.setBounds(new Rectangle(116, 10, 27, 27));
        this.pbHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbHistogram_actionPerformed();
            }
        });
        this.tpLayout.add((Component)this.pbHistogram, null);
        this.tbImageText.setIcon(this.iInfoText);
        this.tbImageText.setToolTipText("Bildbeschriftung ein-/ausblenden");
        this.tbImageText.setBounds(new Rectangle(79, 10, 27, 27));
        this.tbImageText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ViewerFrame.this.tbImageText_mouseClicked();
            }
        });
        this.tpLayout.add((Component)this.tbImageText, null);
        this.rb1Image.setMargin(new Insets(2, 2, 2, 2));
        this.rb1Image.setIcon(this.i1Image);
        this.rb1Image.setSelected(true);
        this.rb1Image.setToolTipText("1 Bild anzeigen");
        this.rb1Image.setBounds(new Rectangle(5, 10, 27, 27));
        this.tpLayout.add((Component)this.rb1Image, null);
        this.rb1Image.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.rb1Image_actionPerformed();
            }
        });
        this.rb4Images.setMargin(new Insets(2, 2, 2, 2));
        this.rb4Images.setIcon(this.i4Images);
        this.rb4Images.setToolTipText("4 Bilder anzeigen");
        this.rb4Images.setBounds(new Rectangle(42, 10, 27, 27));
        this.tpLayout.add((Component)this.rb4Images, null);
        this.rb4Images.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.rb4Images_actionPerformed();
            }
        });
        this.bgNumOfImages.add(this.rb1Image);
        this.bgNumOfImages.add(this.rb4Images);
        this.tpTools.setLayout(null);
        this.tpMain.add((Component)this.tpTools, "Tools");
        this.rbPointer.setIcon(this.iPointer);
        this.rbPointer.setBounds(5, 10, 27, 27);
        this.rbPointer.setSelected(true);
        this.rbPointer.setToolTipText("Einfacher Mauszeiger und Fensterungswerkzeug.");
        this.tpTools.add((Component)this.rbPointer, null);
        this.rbZoom.setIcon(this.iZoom);
        this.rbZoom.setBounds(42, 10, 27, 27);
        this.rbZoom.setToolTipText("Lupe");
        this.tpTools.add((Component)this.rbZoom, null);
        this.rbDistance.setIcon(this.iDistance);
        this.rbDistance.setBounds(79, 10, 27, 27);
        this.rbDistance.setToolTipText("Distanzmessung");
        this.tpTools.add((Component)this.rbDistance, null);
        this.rbAngel.setIcon(this.iAngel);
        this.rbAngel.setBounds(116, 10, 27, 27);
        this.rbAngel.setToolTipText("Winkelmessung");
        this.tpTools.add((Component)this.rbAngel, null);
        this.rbGrayValue.setIcon(this.iGrayValue);
        this.rbGrayValue.setBounds(153, 10, 27, 27);
        this.rbGrayValue.setToolTipText("Grauwerterfassung");
        this.tpTools.add((Component)this.rbGrayValue, null);
        this.pbMirror.setIcon(this.iMirror);
        this.pbMirror.setBounds(5, 47, 27, 27);
        this.pbMirror.setToolTipText("Horizontales Spiegeln");
        this.tpTools.add((Component)this.pbMirror, null);
        this.pbMirror.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbMirror_actionPerformed();
            }
        });
        this.pbRotate.setIcon(this.iRotate);
        this.pbRotate.setBounds(42, 47, 27, 27);
        this.pbRotate.setToolTipText("90\u00b0 im Urzeigersinn drehen");
        this.tpTools.add((Component)this.pbRotate, null);
        this.pbRotate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbRotate_actionPerformed();
            }
        });
        this.pbInvert.setIcon(this.iInvert);
        this.pbInvert.setBounds(79, 47, 27, 27);
        this.pbInvert.setToolTipText("Invertieren");
        this.tpTools.add((Component)this.pbInvert, null);
        this.pbInvert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbInvert_actionPerformed();
            }
        });
        this.pbDelete.setIcon(this.iDelete);
        this.pbDelete.setBounds(5, 84, 27, 27);
        this.pbDelete.setToolTipText("Selektiertes Bild loeschen");
        this.tpTools.add((Component)this.pbDelete, null);
        this.pbDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbDelete_actionPerformed();
            }
        });
        ButtonGroup bgTools = new ButtonGroup();
        bgTools.add(this.rbPointer);
        bgTools.add(this.rbZoom);
        bgTools.add(this.rbDistance);
        bgTools.add(this.rbAngel);
        bgTools.add(this.rbGrayValue);
        this.tpWindow.setLayout(null);
        this.tpMain.add((Component)this.tpWindow, "Fenstern");
        this.pCenter = new SliderPanel("Zentrum:", 0, 4096, "");
        this.pCenter.setBounds(new Rectangle(2, 5, 185, 70));
        this.pCenter.setToolTip("Einstellung der Bildhelligkeit");
        this.pCenter.setToolTipText("Mit diesem Wert wird die Helligkeit des Bildes beeinflusst.");
        this.pCenter.setTextRange(0, 4095);
        this.pCenter.setTickSpacing(1024, 0);
        this.pCenter.fillPanel();
        this.pCenter.setSliderMaximum(4095);
        this.tpWindow.add(this.pCenter);
        this.pCenter.setValue(2048);
        this.pCenter.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                ViewerFrame.this.updateCenter();
                ViewerFrame.this.pCanvas.repaint();
            }
        });
        this.pWindow = new SliderPanel("Breite:", 0, 4096, "");
        this.pWindow.setBounds(new Rectangle(2, 80, 185, 70));
        this.pWindow.setToolTip("Einstellung der Bildhelligkeit");
        this.pWindow.setTextRange(1, 4096);
        this.pWindow.setTickSpacing(1024, 0);
        this.pWindow.setToolTipText("Mit diesem Wert wird der Kontrast des Bildes beeinflusst.");
        this.pWindow.fillPanel();
        this.pWindow.setSliderMinimum(1);
        this.tpWindow.add(this.pWindow);
        this.pWindow.setValue(4096);
        this.pWindow.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                ViewerFrame.this.updateWindow();
                ViewerFrame.this.pCanvas.repaint();
            }
        });
        this.pbResetWindowing.setBounds(193, 5, 45, 70);
        this.pbResetWindowing.setText("R");
        this.pbResetWindowing.setToolTipText("Standardfensterung (2048/4096)");
        this.tpWindow.add(this.pbResetWindowing);
        this.pbResetWindowing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pWindow.setValue(4096);
                ViewerFrame.this.pCenter.setValue(2048);
                ViewerFrame.this.updateCW();
                ViewerFrame.this.pCanvas.repaint();
            }
        });
        this.pbOptWindowing.setBounds(193, 80, 45, 70);
        this.pbOptWindowing.setText("O");
        this.pbOptWindowing.setToolTipText("Optimale Fensterung");
        this.tpWindow.add(this.pbOptWindowing);
        this.pbOptWindowing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbOptWindowing_actionPerformed();
            }
        });
        this.tp3D.setLayout(null);
        this.tpMain.add((Component)this.tp3D, "3D");
        this.pbAnimation.setMargin(new Insets(2, 2, 2, 2));
        this.pbAnimation.setIcon(this.iAnimation);
        this.pbAnimation.setBounds(new Rectangle(5, 10, 27, 27));
        this.pbAnimation.setToolTipText("oeffnet ein Animationsfenster");
        this.tp3D.add((Component)this.pbAnimation, null);
        this.pbAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbAnimation_actionPerformed();
            }
        });
        this.pbCalcMIP.setMargin(new Insets(2, 2, 2, 2));
        this.pbCalcMIP.setText("M");
        this.pbCalcMIP.setBounds(new Rectangle(42, 10, 27, 27));
        this.pbCalcMIP.setToolTipText("MIP-Bild berechnen");
        this.tp3D.add((Component)this.pbCalcMIP, null);
        this.pbCalcMIP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbCalcMIP_actionPerformed();
            }
        });
        this.pbProjection1.setMargin(new Insets(2, 2, 2, 2));
        this.pbProjection1.setIcon(this.iProjection1);
        this.pbProjection1.setBounds(new Rectangle(79, 10, 27, 27));
        this.pbProjection1.setToolTipText("90\u00b0-Projektion");
        this.tp3D.add((Component)this.pbProjection1, null);
        this.pbProjection1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbProjection1_actionPerformed();
            }
        });
        this.pbProjection2.setMargin(new Insets(2, 2, 2, 2));
        this.pbProjection2.setIcon(this.iProjection2);
        this.pbProjection2.setBounds(new Rectangle(116, 10, 27, 27));
        this.pbProjection2.setToolTipText("90\u00b0-Projektion");
        this.tp3D.add((Component)this.pbProjection2, null);
        this.pbProjection2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.pbProjection2_actionPerformed();
            }
        });
        this.tpExtras.setLayout(null);
        this.tpMain.add((Component)this.tpExtras, "Extras");
        this.pNextImageAt.setBounds(2, 2, 240, 44);
        this.pNextImageAt.setLayout(null);
        this.pNextImageAt.setBorder(BorderFactory.createEtchedBorder());
        this.tpExtras.add((Component)this.pNextImageAt, null);
        this.lNextImageAt.setText("Naechstes Bild positionieren:");
        this.lNextImageAt.setBounds(2, 0, 240, 20);
        this.pNextImageAt.add(this.lNextImageAt);
        this.rbNextImageAtSelection.setText("Selektion");
        this.rbNextImageAtSelection.setBounds(2, 22, 125, 20);
        this.pNextImageAt.add((Component)this.rbNextImageAtSelection, null);
        this.rbNextImageAtFreePlace.setText("Freie Stelle");
        this.rbNextImageAtFreePlace.setBounds(130, 22, 105, 20);
        this.pNextImageAt.add((Component)this.rbNextImageAtFreePlace, null);
        this.rbNextImageAtFreePlace.setSelected(true);
        this.bgPlaceNextImage.add(this.rbNextImageAtSelection);
        this.bgPlaceNextImage.add(this.rbNextImageAtFreePlace);
        this.chbActivateNewImg.setText("Neues Bild aktivieren");
        this.chbActivateNewImg.setBounds(new Rectangle(2, 47, 145, 25));
        this.chbActivateNewImg.setSelected(true);
        this.tpExtras.add((Component)this.chbActivateNewImg, null);
        this.lPosition.setText("");
        this.lPosition.setForeground(Color.black);
        this.lPosition.setFont(new Font("Dialog", 0, 12));
        this.lPosition.setBounds(new Rectangle(590, 516, 95, 15));
        this.getContentPane().add((Component)this.lPosition, null);
        this.lPositionText.setText("Position:");
        this.lPositionText.setForeground(Color.black);
        this.lPositionText.setFont(new Font("Dialog", 0, 12));
        this.lPositionText.setBounds(new Rectangle(538, 516, 50, 15));
        this.getContentPane().add((Component)this.lPositionText, null);
    }

    private void editClear_actionPerformed() {
        int response = JOptionPane.showConfirmDialog(null, "Moechten Sie wirklich das\nselektierte Bild loeschen?");
        if (response == 0) {
            this.pCanvas.getImageStack().deletePictureAtPos(this.pCanvas.getActiveImage());
            this.pCanvas.updateScrollbar();
            this.pCanvas.repaint();
            this.setVisible(true);
        }
    }

    private void editClearAll_actionPerformed() {
        int response = JOptionPane.showConfirmDialog(null, "Moechten Sie wirklich alle\nBilder loeschen?");
        if (response == 0) {
            this.pCanvas.getImageStack().clearImageStack();
            this.pCanvas.updateScrollbar();
            this.pCanvas.repaint();
            this.setVisible(true);
        }
    }

    private void pCanvas_mouseDragged(MouseEvent e) {
        int actImg;
        int startImg;
        if (this.rbPointer.isSelected()) {
            this.pCanvas.setCursor(this.WINDOW_CURSOR);
            long curWhen = e.getWhen();
            int difT = (int)(curWhen - this.lastTime);
            if (difT < 100) {
                return;
            }
            int curX = e.getX();
            int curY = e.getY();
            int difX = curX - this.lastMouseClickX;
            int difY = this.lastMouseClickY - curY;
            if (Math.abs(difX) > 10) {
                difX *= 10;
            }
            if (Math.abs(difY) > 10) {
                difY *= 10;
            }
            if (this.lastCenter + difY <= 4095 && this.lastCenter + difY >= 0) {
                this.pCenter.setValue(this.lastCenter + difY);
                this.lastCenter += difY;
            }
            if (this.lastWindow + difX <= 4096 && this.lastWindow + difX >= 1) {
                this.pWindow.setValue(this.lastWindow + difX);
                this.lastWindow += difX;
            }
            this.lastMouseClickX = curX;
            this.lastMouseClickY = curY;
            this.lastTime = curWhen;
            this.updateCW();
            this.pCanvas.repaint();
        }
        if (this.rbDistance.isSelected()) {
            this.pCanvas.setCursor(this.ZOOM_CURSOR);
            if (this.rb1Image.isSelected()) {
                this.pCanvas.setCurrentPos(e.getX(), e.getY());
            } else {
                startImg = this.getImageMouseIsOn(this.lastMouseClickX, this.lastMouseClickY);
                if (startImg == (actImg = this.getImageMouseIsOn(e.getX(), e.getY()))) {
                    this.pCanvas.setCurrentPos(e.getX(), e.getY());
                }
            }
            this.pCanvas.repaint();
        }
        if (this.rbAngel.isSelected()) {
            this.pCanvas.setCursor(this.ZOOM_CURSOR);
            if (this.rb1Image.isSelected()) {
                this.pCanvas.setCurrentPos(e.getX(), e.getY());
            } else {
                startImg = this.getImageMouseIsOn(this.lastMouseClickX, this.lastMouseClickY);
                if (startImg == (actImg = this.getImageMouseIsOn(e.getX(), e.getY()))) {
                    this.pCanvas.setCurrentPos(e.getX(), e.getY());
                }
            }
            this.pCanvas.repaint();
        }
    }

    private void helpAbout_actionPerformed() {
        AboutBox abox = new AboutBox();
        abox.setFileURL(this.getClass().getResource("resources/splash_de.htm"));
        Dimension ts = this.getSize();
        Dimension as = abox.getSize();
        abox.setLocation((ts.width - as.width) / 2 + this.getLocation().x, (ts.height - as.height) / 2 + this.getLocation().y);
        abox.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.savePreferences();
            this.fileExit_actionPerformed();
        }
    }

    private void updateCW() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int c = this.pCenter.getValue();
                int w = this.pWindow.getValue();
                ip.setCW(c, w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateCenter() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int c = this.pCenter.getValue();
                ip.setCenter(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateWindow() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int w = this.pWindow.getValue();
                ip.setWindow(w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void pbLoad_actionPerformed() {
        GeneralImageIOD gi = null;
        ImportData imda = new ImportData();
        InputStream pfs = Util.getPropertyFileStream("");
        if (pfs != null) {
            imda.getProperties(pfs);
        }
        ImportPanel imPan = new ImportPanel();
        imPan.initWithDataBlock(imda);
        imPan.copyrightL.setText("(C) 2000 T. Hacklaender unter der GPL Lizenz. Dcm Ver.: 2.5");
        int diaRes = JOptionPane.showConfirmDialog(null, imPan, "DICOM Dateien einlesen", 2, -1, null);
        if (diaRes != 0) {
            return;
        }
        imPan.updateDataBlock();
        gi = imda.theGI;
        if (gi == null) {
            return;
        }
        SeriesLoader sLoader = new SeriesLoader(this, gi, imda);
        sLoader.start();
    }

    private void pbSave_actionPerformed() {
        SecondaryCaptureIOD scIOD = new SecondaryCaptureIOD();
        ImagePlus currentImage = this.getSelectedImage();
        scIOD.setPublicFields(currentImage.getDDO());
        short[] dcmPixels = currentImage.getImage12BitShort();
        int size = (int)(Math.sqrt(dcmPixels.length) + 0.5);
        scIOD.set16UBitGrayImage(dcmPixels, size, size, 15);
        scIOD.setVOILUTModule(currentImage.getCenter(), currentImage.getWindow());
        ExportData exda = new ExportData();
        exda.theSC = scIOD;
        InputStream pfs = Util.getPropertyFileStream("");
        if (pfs != null) {
            exda.getProperties(pfs);
        }
        ExportPanel exPan = new ExportPanel();
        exPan.initWithDataBlock(exda);
        exPan.copyrightL.setText("(C) 2000 T. Hacklaender unter der GPL Lizenz. Dcm Ver.: 2.5");
        int diaRes = JOptionPane.showConfirmDialog(null, exPan, "Als DICOM Secondary Capture Datei speichern", 2, -1, null);
        if (diaRes != 0) {
            return;
        }
        exPan.updateDataBlock();
        DcmDataObject ddo = exda.theSC.getDDO(exda.encoding, exda.structure, exda.storage);
        try {
            String pn = exda.outputDir.getPath() + File.separator + exda.fileNameToSave + exda.fileNameSuffix;
            File f = new File(pn);
            DcmOutputStream.saveDDO(ddo, f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void pbPrint_actionPerformed() {
        PrintJob pj = this.getToolkit().getPrintJob(this, "Print MRT", null);
        if (pj != null) {
            Graphics gc = pj.getGraphics();
            this.pCanvas.paint(gc);
            gc.dispose();
            pj.end();
        }
    }

    private void pbDelete_actionPerformed() {
        this.editClear_actionPerformed();
    }

    private void pbReferenceData_actionPerformed() {
        this.createReferenceSeries();
    }

    private void pCanvas_mouseMoved(MouseEvent e) {
        int y;
        int x;
        int small = 2;
        String bild = new String();
        this.curr_x = x = e.getX();
        this.curr_y = y = e.getY();
        int img_x = x / 2;
        int img_y = y / 2;
        bild = "(Bild1)";
        if (this.rb4Images.isSelected()) {
            small = 1;
            int bildnr = 1 + 2 * (y / 256) + x / 256;
            bild = "(Bild " + bildnr + ")";
            switch (bildnr) {
                case 1: {
                    break;
                }
                case 2: {
                    x -= 256;
                    break;
                }
                case 3: {
                    y -= 256;
                    break;
                }
                case 4: {
                    x -= 256;
                    y -= 256;
                }
            }
            img_x = x;
            img_y = y;
        }
        this.lPosition.setText("" + x + " ; " + y + " ");
        if (this.rbZoom.isSelected()) {
            int part_x = 32;
            int part_y = 32;
            this.pCanvas.setCursor(this.ZOOM_CURSOR);
            ImageStack is = this.pCanvas.getImageStack();
            ImagePlus ip = null;
            int mouseImage = this.getImageMouseIsOn(this.curr_x, this.curr_y);
            ip = is.getPictureAtPos(mouseImage);
            if (ip != null) {
                Image myImagePart = ip.getImagePart(img_x - 16 / small, img_y - 16 / small, 32 / small, 32 / small);
                Image myZoomImage = myImagePart.getScaledInstance(64, 64, 1);
                this.pCanvas.setZoomImage(myZoomImage);
                this.pCanvas.setZoomPos(this.curr_x - 32, this.curr_y - 32);
            } else {
                this.pCanvas.setZoomImage(null);
            }
            this.pCanvas.repaint();
        }
        if (this.rbGrayValue.isSelected()) {
            ImageStack is = this.pCanvas.getImageStack();
            ImagePlus ip = null;
            int mouseImage = this.getImageMouseIsOn(this.curr_x, this.curr_y);
            ip = is.getPictureAtPos(mouseImage);
            if (ip != null) {
                this.pCanvas.setCursor(this.ZOOM_CURSOR);
                this.pCanvas.setCurrentPos(this.curr_x, this.curr_y);
                this.pCanvas.setGrayValue(ip.getGrayValue(img_x, img_y));
            }
            this.pCanvas.repaint();
        }
        if (this.rbAngel.isSelected()) {
            if (this.rb1Image.isSelected()) {
                this.pCanvas.setCurrentPos(e.getX(), e.getY());
            } else {
                int actImg;
                int startImg = this.getImageMouseIsOn(this.lastMouseClickX, this.lastMouseClickY);
                if (startImg == (actImg = this.getImageMouseIsOn(e.getX(), e.getY()))) {
                    this.pCanvas.setCurrentPos(e.getX(), e.getY());
                }
            }
            this.pCanvas.repaint();
        }
    }

    private void pCanvas_mouseExited() {
        this.lPosition.setText("");
        this.pCanvas.setZoomImage(null);
        this.pCanvas.setGrayValue(-1);
        this.pCanvas.setCurrentPos(-1, -1);
        this.pCanvas.setLastClickPos(-1, -1);
        this.pCanvas.setReleasePos(-1, -1);
        this.pCanvas.setCursor(this.DEFAULT_CURSOR);
        this.pCanvas.repaint();
    }

    private void rb4Images_actionPerformed() {
        this.pCanvas.setFourImages();
        this.pCanvas.repaint();
    }

    private void rb1Image_actionPerformed() {
        this.pCanvas.setOneImage();
        this.pCanvas.repaint();
    }

    private void pCanvas_mousePressed(MouseEvent e) {
        this.lastMouseClickX = e.getX();
        this.lastMouseClickY = e.getY();
        if (this.rbPointer.isSelected()) {
            this.lastCenter = this.pCenter.getValue();
            this.lastWindow = this.pWindow.getValue();
            this.lastTime = e.getWhen();
        }
        if (this.rbDistance.isSelected()) {
            this.pCanvas.setLastClickPos(this.lastMouseClickX, this.lastMouseClickY);
        }
        if (this.rbAngel.isSelected()) {
            this.pCanvas.setLastClickPos(this.lastMouseClickX, this.lastMouseClickY);
        }
    }

    private void pCanvas_mouseReleased(MouseEvent e) {
        this.pCanvas.setCursor(this.DEFAULT_CURSOR);
        if (this.rbAngel.isSelected()) {
            this.pCanvas.setReleasePos(e.getX(), e.getY());
        }
    }

    private void pCanvas_mouseClicked(MouseEvent e) {
        ImagePlus ip = null;
        int actImage = this.getImageMouseIsOn(e.getX(), e.getY());
        this.pCanvas.setActiveImage(actImage);
        ip = this.pCanvas.getImageStack().getPictureAtPos(actImage);
        if (ip != null) {
            int newc = ip.getCenter();
            int neww = ip.getWindow();
            this.pCenter.setValue(newc);
            this.pWindow.setValue(neww);
        }
        this.pCanvas.repaint();
    }

    private void tbImageText_mouseClicked() {
        this.pCanvas.repaint();
    }

    private void fileImageOpen_actionPerformed() {
        this.pbLoad_actionPerformed();
    }

    private void fileSave_actionPerformed() {
        this.pbSave_actionPerformed();
    }

    private void filePrint_actionPerformed() {
        this.pbPrint_actionPerformed();
    }

    private void fileExit_actionPerformed() {
        if (this.unsavedChanges) {
            JButton[] buttons = new JButton[]{new JButton("Ja"), new JButton("Nein"), new JButton("Abbrechen")};
            int response = JOptionPane.showConfirmDialog(null, "Sie haben neue nichtgespeicherte\nBilder. Moechten Sie wirklich Beenden?");
            if (response != 0) {
                return;
            }
        }
        if (this.isApplication) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void pbMirror_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            ip.mirrorHor();
            this.pCanvas.repaint();
        }
    }

    private void pbRotate_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            ip.rotate90CW();
            this.pCanvas.repaint();
        }
    }

    private void pbInvert_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            ip.invert();
            this.pCanvas.repaint();
        }
    }

    public void pbOptWindowing_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        ip.optimalWindowing();
        this.pWindow.setValue(ip.getWindow());
        this.pCenter.setValue(ip.getCenter());
        this.pCanvas.repaint();
    }

    private void pbHistogram_actionPerformed() {
        short[][] myShortImage = null;
        int actImage = this.pCanvas.getActiveImage();
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            myShortImage = ip.get8BitImageShort();
            Histogramm myHist = new Histogramm(this, myShortImage, "Histogramm zu Bild " + actImage);
            myHist.setVisible(true);
        }
    }

    private void pbKSpaceManip_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        KSpaceManipulator manipulator = new KSpaceManipulator(ip, this.pCanvas);
        manipulator.show();
    }

    private void pbKSpace_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            KSpaceFrame myOrig = new KSpaceFrame(ip);
            myOrig.setVisible(true);
        }
    }

    private int getImageMouseIsOn(int x, int y) {
        int bildnr;
        if (this.rb4Images.isSelected()) {
            int off = this.sbVerScrollbar.getValue() / 256;
            bildnr = 1 + 2 * (y / 256) + x / 256 + 2 * off;
        } else {
            int off = this.sbVerScrollbar.getValue() / 512;
            bildnr = 1 + off;
        }
        if (x < 0 || x > 512 || y < 0 || y > 512) {
            bildnr = -1;
        }
        return bildnr;
    }

    public JProgressBar getProgressBar() {
        return this.prbarProgress;
    }

    public void setChanges() {
        this.unsavedChanges = true;
    }

    private void resetChanges() {
        this.unsavedChanges = false;
    }

    private ImagePlus getSelectedImage() {
        int actImage = this.pCanvas.getActiveImage();
        ImagePlus ip = null;
        if (actImage >= 0) {
            ip = this.pCanvas.getImageStack().getPictureAtPos(actImage);
        }
        return ip;
    }

    private void sbVerScrollbar_adjustmentValueChanged() {
        this.pCanvas.repaint();
        this.pCanvas.updateScrollbar();
    }

    private void pbAnimation_actionPerformed() {
        AnimationFrame anim = new AnimationFrame(this);
        anim.show();
    }

    private void pbCalcMIP_actionPerformed() {
        ImageStack myIS = this.pCanvas.getImageStack();
        int start = 0;
        int end = 0;
        int numimages = myIS.getStackSize();
        if (numimages != 0) {
            start = 1;
            end = numimages;
        }
        MIPParamDlg myDlg = new MIPParamDlg(this, "MIP-Parameter", true);
        myDlg.setImages(start, end);
        myDlg.show();
    }

    public void calcMIPImage(int start, int end) {
        ImageStack myIS = this.pCanvas.getImageStack();
        if (end != 0) {
            int size = myIS.getPictureAtPos(start).getSize();
            short[] MIPImage = new short[size * size];
            for (int i = start; i <= end; ++i) {
                ImagePlus ip = myIS.getPictureAtPos(i);
                short[] actImage = new short[size * size];
                actImage = ip.getImage12BitShort();
                for (int x = 0; x < size * size; ++x) {
                    short val = actImage[x];
                    if (val <= MIPImage[x]) continue;
                    MIPImage[x] = val;
                }
            }
            DcmDataObject myddo = myIS.getPictureAtPos(start).getDDO();
            DcmImage dcmimg = null;
            try {
                dcmimg = new DcmImage(myddo);
                dcmimg.pixel16 = MIPImage;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            ImagePlus ip = this.pCanvas.createNewImage(dcmimg);
            ip.setDDO(myddo);
            ip.setCurrentDate();
            ip.setCW(2048, 4096);
        }
        this.pCanvas.repaint();
    }

    private void pbProjection1_actionPerformed() {
        ImageStack myIS = this.pCanvas.getImageStack();
        int start = 0;
        int end = 0;
        int numimages = myIS.getStackSize();
        if (numimages != 0) {
            start = 1;
            end = numimages;
        }
        ProjParamDlg myDlg = new ProjParamDlg(this, "Projektions-Parameter", true);
        myDlg.setImages(start, end);
        myDlg.setProjectionNr(1);
        myDlg.show();
    }

    public void createNewProj1Image(int start, int end, int slice, boolean interpolate) {
        int pos = this.pCanvas.createNewImage(this.calcProjection1(slice, start, end, interpolate));
        this.pCanvas.setActiveImage(pos);
        this.pbOptWindowing_actionPerformed();
    }

    public ImagePlus calcProjection1(int position, int fromSlice, int toSlice, boolean interpolate) {
        ImageStack imaStack = this.pCanvas.getImageStack();
        int numSlices = toSlice - fromSlice + 1;
        int size = imaStack.getPictureAtPos(fromSlice).getSize();
        short[] projImg = new short[size * size];
        int slicenum = fromSlice;
        ImagePlus ip = imaStack.getPictureAtPos(slicenum);
        short[] origImg = ip.getImage12BitShort();
        double loc1 = 0.0;
        double loc2 = 0.0;
        double relThick = 1.0;
        loc1 = DcmValue.str2Double(ip.getSliceLocation(), 9999.9);
        if (loc1 == 9999.9 | numSlices == 1) {
            relThick = 1.0;
        } else {
            loc2 = DcmValue.str2Double(imaStack.getPictureAtPos(slicenum + 1).getSliceLocation(), 9999.9);
            relThick = Math.abs(loc2 - loc1) / ip.getPixelSpacingRow();
        }
        double thickness = 0.0;
        for (int y = 0; y < size; ++y) {
            if (thickness > relThick) {
                thickness -= relThick;
                if (++slicenum > toSlice) break;
                ip = imaStack.getPictureAtPos(slicenum);
                origImg = ip.getImage12BitShort();
            }
            for (int x = 0; x < size; ++x) {
                projImg[y * size + x] = origImg[position * size + x];
            }
            thickness += 1.0;
        }
        if (interpolate) {
            int nThick = (int)Math.round(relThick);
            if (nThick % 2 == 0) {
                ++nThick;
            }
            int nThickHalf = nThick / 2;
            for (int x = 0; x < size; ++x) {
                for (int y = nThickHalf; y < size - nThickHalf; ++y) {
                    long summe = 0L;
                    for (int i = y - nThickHalf; i <= y + nThickHalf; ++i) {
                        summe += (long)projImg[i * size + x];
                    }
                    projImg[y * size + x] = (short)(summe / (long)nThick);
                }
            }
        }
        DcmDataObject myddo = imaStack.getPictureAtPos(fromSlice).getDDO();
        DcmImage dcmimg = null;
        try {
            dcmimg = new DcmImage(myddo);
            dcmimg.pixel16 = projImg;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ImagePlus newip = new ImagePlus(dcmimg);
        newip.setDDO(myddo);
        newip.setCurrentDate();
        newip.setCW(2048, 4096);
        return newip;
    }

    private void pbProjection2_actionPerformed() {
        ImageStack myIS = this.pCanvas.getImageStack();
        int start = 0;
        int end = 0;
        int numimages = myIS.getStackSize();
        if (numimages != 0) {
            start = 1;
            end = numimages;
        }
        ProjParamDlg myDlg = new ProjParamDlg(this, "Projektions-Parameter", true);
        myDlg.setImages(start, end);
        myDlg.setProjectionNr(2);
        myDlg.show();
    }

    public void createNewProj2Image(int start, int end, int slice, boolean interpolate) {
        int pos = this.pCanvas.createNewImage(this.calcProjection2(slice, start, end, interpolate));
        this.pCanvas.setActiveImage(pos);
        this.pbOptWindowing_actionPerformed();
    }

    public ImagePlus calcProjection2(int position, int fromSlice, int toSlice, boolean interpolate) {
        ImageStack imaStack = this.pCanvas.getImageStack();
        int numSlices = toSlice - fromSlice + 1;
        int size = imaStack.getPictureAtPos(fromSlice).getSize();
        short[] projImg = new short[size * size];
        int slicenum = fromSlice;
        ImagePlus ip = imaStack.getPictureAtPos(slicenum);
        short[] origImg = ip.getImage12BitShort();
        double loc1 = 0.0;
        double loc2 = 0.0;
        double relThick = 1.0;
        loc1 = DcmValue.str2Double(ip.getSliceLocation(), 9999.9);
        if (loc1 == 9999.9 | numSlices == 1) {
            relThick = 1.0;
        } else {
            loc2 = DcmValue.str2Double(imaStack.getPictureAtPos(slicenum + 1).getSliceLocation(), 9999.9);
            relThick = Math.abs(loc2 - loc1) / ip.getPixelSpacingRow();
        }
        double thickness = 0.0;
        for (int x = 0; x < size; ++x) {
            if (thickness > relThick) {
                thickness -= relThick;
                if (++slicenum > toSlice) break;
                ip = imaStack.getPictureAtPos(slicenum);
                origImg = ip.getImage12BitShort();
            }
            for (int y = 0; y < size; ++y) {
                projImg[y * size + x] = origImg[y * size + position];
            }
            thickness += 1.0;
        }
        if (interpolate) {
            int nThick = (int)Math.round(relThick);
            if (nThick % 2 == 0) {
                ++nThick;
            }
            int nThickHalf = nThick / 2;
            for (int y = 0; y < size; ++y) {
                for (int x = nThickHalf; x < size - nThickHalf; ++x) {
                    long summe = 0L;
                    for (int i = x - nThickHalf; i <= x + nThickHalf; ++i) {
                        summe += (long)projImg[y * size + i];
                    }
                    projImg[y * size + x] = (short)(summe / (long)nThick);
                }
            }
        }
        DcmDataObject myddo = imaStack.getPictureAtPos(fromSlice).getDDO();
        DcmImage dcmimg = null;
        try {
            dcmimg = new DcmImage(myddo);
            dcmimg.pixel16 = projImg;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ImagePlus newip = new ImagePlus(dcmimg);
        newip.setDDO(myddo);
        newip.setCurrentDate();
        newip.setCW(2048, 4096);
        return newip;
    }

    private void setStdDirectory(JFileChooser fd) {
        String Path2 = (String)this.preferences.get("Path");
        if (Path2 != null) {
            File myPath = new File(Path2);
            if (!myPath.exists()) {
                Exception e = new Exception("Ung\u00fcltiger Pfad in \nVoreinstellungsdatei\ndv_preferences.properties !");
                ErrorMessage.showMessage(e);
                myPath = new File("C:\\");
            }
            fd.setCurrentDirectory(myPath);
            Object var3_3 = null;
        }
    }

    private void loadPreferences() {
        LineNumberReader numRead = null;
        boolean ok = true;
        try {
            FileReader streamIn = new FileReader("dv_preferences.properties");
            numRead = new LineNumberReader(streamIn);
        }
        catch (Exception e) {
            System.out.println("Preferencesdatei nicht gefunden");
            return;
        }
        String e = null;
        do {
            try {
                e = numRead.readLine();
            }
            catch (Exception err) {
                return;
            }
            if (e == null) break;
            StringTokenizer token = new StringTokenizer(e, "=");
            String key = token.nextToken();
            String value = token.nextToken();
            value = value.replace('\"', ' ').trim();
            try {
                this.preferences.put(key, value);
            }
            catch (Exception err) {
                System.out.println("Fehler beim Lesen der Preferencesdatei");
            }
        } while (e != null);
        try {
            numRead.close();
        }
        catch (Exception err) {
            System.out.println("Fehler beim Schlie\u00dfen der Preferencesdatei");
        }
    }

    private void savePreferences() {
        BufferedWriter bufWriter = null;
        FileWriter streamOut = null;
        boolean ok = true;
        try {
            streamOut = new FileWriter("dv_preferences.properties");
            bufWriter = new BufferedWriter(streamOut);
        }
        catch (Exception e) {
            System.out.println("Fehler beim \u00d6ffnen der Preferencesdatei");
        }
        Enumeration<?> iterator = this.preferences.propertyNames();
        while (iterator.hasMoreElements()) {
            String key = (String)iterator.nextElement();
            String value = (String)this.preferences.get(key);
            try {
                streamOut.write(key);
                streamOut.write("=\"");
                streamOut.write(value + "\"\n");
            }
            catch (Exception err) {
                System.out.println("Fehler beim Schreiben der Preferencesdatei");
            }
            try {
                streamOut.flush();
            }
            catch (Exception err) {
                System.out.println("Fehler beim Schreiben der Preferencesdatei");
            }
            try {
                streamOut.close();
            }
            catch (Exception err) {
                System.out.println("Fehler beim Schlie\u00dfen der Preferencesdatei");
            }
            streamOut = null;
        }
    }

    public DVPanel getCanvasReference() {
        return this.pCanvas;
    }

    private void createReferenceSeries() {
        int nRows = 256;
        int nColumns = 256;
        int bits = 12;
        DcmImage di = null;
        boolean selection = false;
        if (this.rbNextImageAtSelection.isSelected()) {
            selection = true;
            this.rbNextImageAtFreePlace.setSelected(true);
        }
        ViewerReferenceSeries vrs = new ViewerReferenceSeries(256, 256, 12);
        for (int imaNumber = 1; imaNumber <= 16; ++imaNumber) {
            int windowWidth;
            int windowCenter;
            int zPosition = (imaNumber - 1) * 4;
            DcmDataObject ddo = vrs.getDDO(zPosition, imaNumber);
            try {
                di = new DcmImage(ddo);
            }
            catch (Exception e) {
                // empty catch block
            }
            ImagePlus ip = this.pCanvas.createNewImage(di);
            ip.setDDO(ddo);
            if (ddo.isAvailable(506) & ddo.hasValue(506)) {
                String[] sa = DcmValue.str2StringArray(ddo.getString(506), "\\");
                windowCenter = (int)DcmValue.str2Long(sa[0], 2048L);
                sa = DcmValue.str2StringArray(ddo.getString(507), "\\");
                windowWidth = (int)DcmValue.str2Long(sa[0], 4096L);
            } else {
                windowCenter = 2048;
                windowWidth = 4096;
            }
            this.pCenter.setValue(windowCenter);
            this.pWindow.setValue(windowWidth);
        }
        this.rbNextImageAtSelection.setSelected(selection);
    }
}

