/*
 * Decompiled with CFR 0.152.
 */
package virtual.dv;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import virtual.dv.ViewerFrame;
import virtual.tools.DcmImage;
import virtual.tools.ImagePanel;
import virtual.tools.ImagePlus;
import virtual.tools.ImageStack;

public class DVPanel
extends ImagePanel {
    private int iNumImages = 1;
    private int iActiveImage = -1;
    private ImageStack is;
    private Image zoomImage = null;
    private int zoomX = 0;
    private int zoomY = 0;
    private int lastClickX = -1;
    private int lastClickY = -1;
    private int lastReleaseX = -1;
    private int lastReleaseY = -1;
    private int currentX = -1;
    private int currentY = -1;
    private int currentGray = -1;
    private ViewerFrame myViewerFrame;

    public DVPanel() {
    }

    public DVPanel(ViewerFrame backReference) {
        this.myViewerFrame = backReference;
        this.is = new ImageStack();
    }

    public void updateScrollbar() {
        int num = this.is.getStackSize();
        if (this.myViewerFrame.rb1Image.isSelected()) {
            this.myViewerFrame.sbVerScrollbar.setMinimum(0);
            this.myViewerFrame.sbVerScrollbar.setMaximum(num * 512 + 512);
            this.myViewerFrame.sbVerScrollbar.setBlockIncrement(512);
            this.myViewerFrame.sbVerScrollbar.setUnitIncrement(512);
            this.myViewerFrame.sbVerScrollbar.setVisibleAmount(511);
        } else {
            int max = 512;
            if (num > 0) {
                max = num / 2 * 256 + 256;
            }
            this.myViewerFrame.sbVerScrollbar.setMinimum(0);
            this.myViewerFrame.sbVerScrollbar.setMaximum(max);
            this.myViewerFrame.sbVerScrollbar.setBlockIncrement(512);
            this.myViewerFrame.sbVerScrollbar.setUnitIncrement(256);
            this.myViewerFrame.sbVerScrollbar.setVisibleAmount(511);
        }
    }

    public void setOneImage() {
        this.iNumImages = 1;
        this.updateScrollbar();
        this.myViewerFrame.sbVerScrollbar.setValue(this.iActiveImage * 512 - 512);
    }

    public void setFourImages() {
        this.iNumImages = 4;
        this.updateScrollbar();
        this.myViewerFrame.sbVerScrollbar.setValue(this.iActiveImage / 2 * 256 - 256);
    }

    public void setActiveImage(int activeImage) {
        this.iActiveImage = activeImage;
    }

    public void setZoomImage(Image zoomI) {
        this.zoomImage = zoomI;
    }

    public void setZoomPos(int x, int y) {
        this.zoomX = x;
        this.zoomY = y;
    }

    public void setLastClickPos(int x, int y) {
        this.lastClickX = x;
        this.lastClickY = y;
    }

    public void setReleasePos(int x, int y) {
        this.lastReleaseX = x;
        this.lastReleaseY = y;
    }

    public void setCurrentPos(int x, int y) {
        this.currentX = x;
        this.currentY = y;
    }

    public void setGrayValue(int g) {
        this.currentGray = g;
    }

    public int getActiveImage() {
        return this.iActiveImage;
    }

    public ImageStack getImageStack() {
        return this.is;
    }

    public ImagePlus createNewImage(DcmImage di) {
        int pos = this.getPosForNewImage();
        ImagePlus ip = this.is.createPictureAtPos(pos, di);
        this.myViewerFrame.setChanges();
        this.updateScrollbar();
        if (this.myViewerFrame.chbActivateNewImg.isSelected()) {
            this.setActiveImage(pos);
            if (this.iNumImages == 4) {
                this.myViewerFrame.sbVerScrollbar.setValue((pos - 1) / 2 * 256);
            } else {
                this.myViewerFrame.sbVerScrollbar.setValue((pos - 1) * 512);
            }
        }
        return ip;
    }

    public int createNewImage(ImagePlus myip) {
        int pos = this.getPosForNewImage();
        this.is.setPictureAtPos(pos, myip);
        this.myViewerFrame.setChanges();
        this.updateScrollbar();
        if (this.myViewerFrame.chbActivateNewImg.isSelected()) {
            this.setActiveImage(pos);
            if (this.iNumImages == 4) {
                this.myViewerFrame.sbVerScrollbar.setValue((pos - 1) / 2 * 256);
            } else {
                this.myViewerFrame.sbVerScrollbar.setValue((pos - 1) * 512);
            }
        }
        return pos;
    }

    private int getPosForNewImage() {
        if (this.is == null) {
            this.is = new ImageStack();
        }
        this.iActiveImage = this.iActiveImage == -1 ? 1 : this.iActiveImage;
        int pos = 0;
        if (this.myViewerFrame.rbNextImageAtSelection.isSelected()) {
            pos = this.iActiveImage;
        } else {
            pos = this.is.getNextFreePosition();
            if (pos == 0) {
                ++pos;
            }
        }
        return pos;
    }

    private int getSBOffset() {
        int off = 0;
        off = this.iNumImages == 4 ? this.myViewerFrame.sbVerScrollbar.getValue() / 256 : this.myViewerFrame.sbVerScrollbar.getValue() / 512;
        return off;
    }

    public void paint(Graphics g) {
        int off;
        g.clearRect(0, 0, 511, 511);
        ImagePlus ip = null;
        if (this.iNumImages == 4) {
            off = this.getSBOffset();
            for (int i = 0; i < 4; ++i) {
                ip = this.is.getPictureAtPos(2 * off + i + 1);
                if (ip == null) continue;
                g.drawImage(ip.getAWTImage(), i % 2 * 256, i / 2 * 256, 256, 256, this);
            }
        } else {
            off = this.getSBOffset();
            ip = this.is.getPictureAtPos(off + 1);
            if (ip != null) {
                g.drawImage(ip.getAWTImage(), 0, 0, 512, 512, this);
            }
        }
        g.setColor(Color.white);
        g.drawRect(0, 0, 511, 511);
        switch (this.iNumImages) {
            case 4: {
                g.drawLine(255, 0, 255, 511);
                g.drawLine(0, 255, 511, 255);
                break;
            }
        }
        g.setColor(Color.red);
        if (this.iActiveImage != -1) {
            if (this.iNumImages == 1) {
                off = this.getSBOffset();
                if (this.iActiveImage == off + 1) {
                    g.drawRect(0, 0, 511, 511);
                }
            } else {
                off = this.getSBOffset();
                if (this.iActiveImage > off * 2 && this.iActiveImage <= off * 2 + 4) {
                    int num = this.iActiveImage - off * 2;
                    int startx = 0;
                    int starty = 0;
                    switch (num) {
                        case 1: {
                            startx = 0;
                            starty = 0;
                            break;
                        }
                        case 3: {
                            startx = 0;
                            starty = 255;
                            break;
                        }
                        case 2: {
                            startx = 255;
                            starty = 0;
                            break;
                        }
                        case 4: {
                            startx = 255;
                            starty = 255;
                        }
                    }
                    g.drawRect(startx, starty, 255, 255);
                }
            }
        }
        g.setColor(Color.green);
        if (this.myViewerFrame.tbImageText.isSelected()) {
            Font myFont;
            if (this.iNumImages == 4) {
                myFont = new Font("Arial", 0, 10);
                g.setFont(myFont);
                for (int i = 0; i < 4; ++i) {
                    String[] commentsSE;
                    String[] commentsSW;
                    String[] commentsNE;
                    int j;
                    int off2 = this.getSBOffset();
                    ip = this.is.getPictureAtPos(2 * off2 + 1 + i);
                    if (ip == null) continue;
                    String[] commentsNW = ip.getTextNW();
                    if (commentsNW != null) {
                        for (j = 0; j < commentsNW.length; ++j) {
                            g.drawString(commentsNW[j], i % 2 * 256 + 5, i / 2 * 256 + 22 + 12 * j);
                        }
                    }
                    if ((commentsNE = ip.getTextNE()) != null) {
                        for (j = 0; j < commentsNE.length; ++j) {
                            g.drawString(commentsNE[j], i % 2 * 256 + 152, i / 2 * 256 + 10 + 10 * j);
                        }
                    }
                    if ((commentsSW = ip.getTextSW()) != null) {
                        for (j = 0; j < commentsSW.length; ++j) {
                            g.drawString(commentsSW[j], i % 2 * 256 + 5, i / 2 * 256 + 256 - 8 - 10 * j);
                        }
                    }
                    if ((commentsSE = ip.getTextSE()) != null) {
                        for (j = 0; j < commentsSE.length; ++j) {
                            g.drawString(commentsSE[j], i % 2 * 256 + 152, i / 2 * 256 + 256 - 8 - 10 * j);
                        }
                    }
                    g.drawString("Bild " + (2 * off2 + i + 1), i % 2 * 256 + 5, i / 2 * 256 + 10);
                }
            } else {
                myFont = new Font("Arial", 0, 12);
                g.setFont(myFont);
                int off3 = this.getSBOffset();
                ip = this.is.getPictureAtPos(off3 + 1);
                if (ip != null) {
                    String[] commentsSE;
                    String[] commentsSW;
                    String[] commentsNE;
                    int i;
                    String[] commentsNW = ip.getTextNW();
                    if (commentsNW != null) {
                        for (i = 0; i < commentsNW.length; ++i) {
                            g.drawString(commentsNW[i], 5, 30 + 15 * i);
                        }
                    }
                    if ((commentsNE = ip.getTextNE()) != null) {
                        for (i = 0; i < commentsNE.length; ++i) {
                            g.drawString(commentsNE[i], 393, 15 + 15 * i);
                        }
                    }
                    if ((commentsSW = ip.getTextSW()) != null) {
                        for (i = 0; i < commentsSW.length; ++i) {
                            g.drawString(commentsSW[i], 5, 500 - 15 * i);
                        }
                    }
                    if ((commentsSE = ip.getTextSE()) != null) {
                        for (i = 0; i < commentsSE.length; ++i) {
                            g.drawString(commentsSE[i], 390, 500 - 15 * i);
                        }
                    }
                    g.drawString("Bild " + (off3 + 1), 5, 15);
                }
            }
        }
        if (this.myViewerFrame.rbZoom.isSelected() && this.zoomImage != null) {
            g.drawImage(this.zoomImage, this.zoomX, this.zoomY, this);
            g.setColor(Color.yellow);
            g.drawRect(this.zoomX - 1, this.zoomY - 1, 65, 65);
        }
        if (this.myViewerFrame.rbGrayValue.isSelected() && this.currentGray != -1) {
            int offX = 5;
            int offY = 5;
            if (this.currentX > this.getWidth() - 40) {
                offX = -30;
            }
            if (this.currentY > this.getHeight() - 40) {
                offY = -20;
            }
            this.getWidth();
            g.setColor(Color.yellow);
            g.fillRect(this.currentX + offX, this.currentY + offY, 27, 12);
            g.setFont(new Font("Arial", 0, 10));
            g.setColor(Color.black);
            g.drawString("" + this.currentGray, this.currentX + offX + 2, this.currentY + offY + 9);
        }
        if (this.myViewerFrame.rbDistance.isSelected() && this.lastClickX != -1 && this.currentX != -1) {
            g.setColor(Color.yellow);
            g.drawLine(this.lastClickX, this.lastClickY, this.currentX, this.currentY);
            int distanceX = Math.abs(this.lastClickX - this.currentX);
            int distanceY = Math.abs(this.lastClickY - this.currentY);
            double spacingX = ip.getPixelSpacingColumn();
            double spacingY = ip.getPixelSpacingRow();
            String unit = "";
            if (spacingX > 0.0 && spacingY > 0.0) {
                distanceX = (int)((double)distanceX * spacingX);
                distanceY = (int)((double)distanceY * spacingY);
                unit = " mm";
            } else {
                unit = " Pixel";
            }
            int distance = (int)Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
            if (this.myViewerFrame.rb1Image.isSelected()) {
                distance /= 2;
            }
            int offX = 10;
            int offY = 10;
            if (this.currentX > this.getWidth() - 60) {
                offX = -50;
            }
            if (this.currentY > this.getHeight() - 30) {
                offY = -20;
            }
            g.fillRect(this.currentX + offX, this.currentY + offY, 50, 12);
            g.setFont(new Font("Arial", 0, 10));
            g.setColor(Color.black);
            g.drawString("" + distance + unit, this.currentX + offX + 2, this.currentY + offY + 9);
        }
        if (this.myViewerFrame.rbAngel.isSelected() && this.lastClickX != -1 && this.currentX != -1) {
            if (this.lastReleaseX == -1) {
                g.setColor(Color.yellow);
                g.drawLine(this.lastClickX, this.lastClickY, this.currentX, this.currentY);
            } else {
                g.setColor(Color.yellow);
                g.drawLine(this.lastClickX, this.lastClickY, this.lastReleaseX, this.lastReleaseY);
                g.drawLine(this.lastClickX, this.lastClickY, this.currentX, this.currentY);
                double a1 = (double)this.lastReleaseX - (double)this.lastClickX;
                double a2 = (double)this.lastReleaseY - (double)this.lastClickY;
                double b1 = (double)this.currentX - (double)this.lastClickX;
                double b2 = (double)this.currentY - (double)this.lastClickY;
                double cosPhi = (a1 * b1 + a2 * b2) / (Math.sqrt(a1 * a1 + a2 * a2) * Math.sqrt(b1 * b1 + b2 * b2));
                int phi = (int)(Math.acos(cosPhi) * 360.0 / Math.PI / 2.0);
                int offX = 10;
                int offY = 10;
                if (this.currentX > this.getWidth() - 40) {
                    offX = -35;
                }
                if (this.currentY > this.getHeight() - 30) {
                    offY = -20;
                }
                g.fillRect(this.currentX + offX, this.currentY + offY, 25, 12);
                g.setFont(new Font("Arial", 0, 10));
                g.setColor(Color.black);
                g.drawString("" + phi + "\u00b0", this.currentX + offX + 2, this.currentY + offY + 9);
            }
        }
    }
}

