/*
 * Decompiled with CFR 0.152.
 */
package virtual.dv;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import virtual.dv.ViewerFrame;
import virtual.tools.ImagePlus;
import virtual.tools.ImageStack;
import virtual.tools.LabTFLabTFPanel;
import virtual.tools.SliderPanel;

public class AnimationFrame
extends JFrame
implements Runnable {
    private Thread myThread;
    private ViewerFrame mainFrame;
    private Image myImage = null;
    private ImageStack is = null;
    private boolean paintAll = true;
    private static final int ONE_TIME = 1;
    private static final int LOOP = 2;
    private static final int LOOPBACK = 3;
    private static final int MANUAL = 4;
    private int sleep = 0;
    private int startImage = 1;
    private int stopImage = 1;
    private int mode = 2;
    private ImageIcon iPlay;
    private ImageIcon iPause;
    private ImageIcon iStop;
    private ImageIcon iOneWay;
    private ImageIcon iLoop;
    private ImageIcon iLoopBack;
    private ImageIcon iOrigProj;
    private ImageIcon iProj1;
    private ImageIcon iProj2;
    private SliderPanel pFps;
    private JPanel pSliderPanel = new JPanel();
    private JLabel lSliderLabel = new JLabel();
    private JSlider slImage = new JSlider();
    private JLabel lAnimModus = new JLabel();
    private JToggleButton tbAnimMode1 = new JToggleButton();
    private JToggleButton tbAnimMode2 = new JToggleButton();
    private JToggleButton tbAnimMode3 = new JToggleButton();
    private JToggleButton tbAnimMode4 = new JToggleButton();
    private LabTFLabTFPanel pImages;
    private JLabel lProjection = new JLabel();
    private JToggleButton tbProj1 = new JToggleButton();
    private JToggleButton tbProj2 = new JToggleButton();
    private JToggleButton tbProj3 = new JToggleButton();
    private JButton pbAnimStart = new JButton();
    private JButton pbAnimStop = new JButton();
    private JToggleButton tbAnimPause = new JToggleButton();

    public AnimationFrame(Frame fra) {
        this.mainFrame = (ViewerFrame)fra;
        this.is = this.mainFrame.pCanvas.getImageStack();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.is = null;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.myThread.setPriority(9);
            this.myThread.start();
        }
    }

    public void run() {
        int num = 0;
        boolean forward = true;
        num = this.mode == 1 || this.mode == 2 ? this.startImage : this.stopImage;
        while (true) {
            ImagePlus ip;
            if (this.tbProj2.isSelected()) {
                ip = this.mainFrame.calcProjection1(num, this.pImages.getValue1(), this.pImages.getValue2(), true);
                ip.optimalWindowing();
                this.myImage = ip.getAWTImage();
            } else if (this.tbProj3.isSelected()) {
                ip = this.mainFrame.calcProjection2(num, this.pImages.getValue1(), this.pImages.getValue2(), true);
                ip.optimalWindowing();
                this.myImage = ip.getAWTImage();
            } else {
                ip = this.is.getPictureAtPos(num);
                this.myImage = ip.getAWTImage();
            }
            this.repaint();
            num = forward ? ++num : --num;
            if (num > this.stopImage || num < this.startImage) {
                if (this.mode == 1) break;
                if (this.mode == 2) {
                    num = this.startImage;
                    forward = true;
                }
                if (this.mode == 3) {
                    if (forward) {
                        forward = false;
                        num = this.stopImage;
                    } else {
                        forward = true;
                        num = this.startImage;
                    }
                }
            }
            try {
                Thread.sleep((long)(1000.0 / ((double)this.pFps.getValue() + 0.5)));
            }
            catch (Exception exception) {}
        }
        this.pbAnimStop_actionPerformed();
    }

    public void stop() {
        this.is = null;
        if (this.mode != 1 || !this.tbProj1.isSelected()) {
            this.myThread.stop();
        }
        this.myThread = null;
    }

    private void jbInit() throws Exception {
        this.iPlay = new ImageIcon(AnimationFrame.class.getResource("play.gif"));
        this.iPause = new ImageIcon(AnimationFrame.class.getResource("pause.gif"));
        this.iStop = new ImageIcon(AnimationFrame.class.getResource("stop.gif"));
        this.iOneWay = new ImageIcon(AnimationFrame.class.getResource("oneway.gif"));
        this.iLoop = new ImageIcon(AnimationFrame.class.getResource("loop.gif"));
        this.iLoopBack = new ImageIcon(AnimationFrame.class.getResource("loopback.gif"));
        this.iOrigProj = new ImageIcon(AnimationFrame.class.getResource("origproj.gif"));
        this.iProj1 = new ImageIcon(AnimationFrame.class.getResource("projektion1.gif"));
        this.iProj2 = new ImageIcon(AnimationFrame.class.getResource("projektion2.gif"));
        this.getContentPane().setLayout(null);
        this.setLocation(100, 100);
        this.setTitle("Animation");
        this.setSize(new Dimension(323, 465));
        this.setResizable(false);
        this.pSliderPanel.setLayout(null);
        this.pSliderPanel.setBounds(260, 0, 55, 256);
        this.pSliderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(this.pSliderPanel);
        this.lSliderLabel.setText("Bild:");
        this.lSliderLabel.setBounds(3, 0, 55, 20);
        this.pSliderPanel.add(this.lSliderLabel);
        this.slImage.setBounds(2, 20, 50, 233);
        this.slImage.setOrientation(1);
        this.slImage.setMinimum(1);
        this.slImage.setMaximum(1);
        this.slImage.setValue(1);
        this.slImage.setPaintLabels(true);
        this.slImage.setEnabled(false);
        this.pSliderPanel.add(this.slImage);
        this.slImage.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnimationFrame.this.slImage_stateChanged();
            }
        });
        this.pFps = new SliderPanel("Geschwindigkeit:", 0, 30, "fps");
        this.pFps.setTextRange(0, 100);
        this.pFps.setBounds(new Rectangle(2, 347, 313, 60));
        this.pFps.setToolTip("Einstellung fuer die Anzahl der Bilder pro Sekunde");
        this.pFps.setTextRange(1, 30);
        this.pFps.setTickSpacing(5, 0);
        this.getContentPane().add(this.pFps);
        this.pFps.fillPanel();
        this.pFps.setValue(10);
        this.lAnimModus.setText("Modus:");
        this.lAnimModus.setBounds(2, 260, 70, 20);
        this.getContentPane().add(this.lAnimModus);
        this.tbAnimMode1.setIcon(this.iOneWay);
        this.tbAnimMode1.setBounds(82, 260, 57, 25);
        this.tbAnimMode1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.mode = 1;
                AnimationFrame.this.slImage.setEnabled(false);
            }
        });
        this.getContentPane().add(this.tbAnimMode1);
        this.tbAnimMode2.setIcon(this.iLoop);
        this.tbAnimMode2.setBounds(142, 260, 57, 25);
        this.tbAnimMode2.setSelected(true);
        this.tbAnimMode2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.mode = 2;
                AnimationFrame.this.slImage.setEnabled(false);
            }
        });
        this.getContentPane().add(this.tbAnimMode2);
        this.tbAnimMode3.setIcon(this.iLoopBack);
        this.tbAnimMode3.setBounds(202, 260, 55, 25);
        this.tbAnimMode3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.mode = 3;
                AnimationFrame.this.slImage.setEnabled(false);
            }
        });
        this.getContentPane().add(this.tbAnimMode3);
        this.tbAnimMode4.setText("M");
        this.tbAnimMode4.setBounds(260, 260, 55, 25);
        this.tbAnimMode4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.mode = 4;
                AnimationFrame.this.slImage.setEnabled(true);
            }
        });
        this.getContentPane().add(this.tbAnimMode4);
        ButtonGroup bgAnimMode = new ButtonGroup();
        bgAnimMode.add(this.tbAnimMode1);
        bgAnimMode.add(this.tbAnimMode2);
        bgAnimMode.add(this.tbAnimMode3);
        bgAnimMode.add(this.tbAnimMode4);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                AnimationFrame.this.this_windowActivated(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                AnimationFrame.this.this_componentMoved(e);
            }
        });
        this.pImages = new LabTFLabTFPanel("Bilder:", "1", "bis", "1");
        this.pImages.setBounds(2, 322, 270, 20);
        this.pImages.setRange1(1, this.is.getStackSize());
        this.pImages.setRange2(1, this.is.getStackSize());
        this.getContentPane().add(this.pImages);
        this.pImages.fillPanel();
        this.lProjection.setText("Projektion:");
        this.lProjection.setBounds(2, 293, 70, 20);
        this.getContentPane().add(this.lProjection);
        this.tbProj1.setIcon(this.iOrigProj);
        this.tbProj1.setBounds(82, 291, 57, 25);
        this.tbProj1.setSelected(true);
        this.getContentPane().add(this.tbProj1);
        this.tbProj1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.tbProj1_actionPerformed();
            }
        });
        this.tbProj2.setIcon(this.iProj1);
        this.tbProj2.setBounds(142, 291, 57, 25);
        this.getContentPane().add(this.tbProj2);
        this.tbProj2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.tbProj2_actionPerformed();
            }
        });
        this.tbProj3.setIcon(this.iProj2);
        this.tbProj3.setBounds(202, 291, 55, 25);
        this.getContentPane().add(this.tbProj3);
        this.tbProj3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.tbProj3_actionPerformed();
            }
        });
        ButtonGroup bgProjections = new ButtonGroup();
        bgProjections.add(this.tbProj1);
        bgProjections.add(this.tbProj2);
        bgProjections.add(this.tbProj3);
        this.pbAnimStart.setIcon(this.iPlay);
        this.pbAnimStart.setBounds(2, 411, 90, 25);
        this.pbAnimStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.pbAnimStart_actionPerformed();
            }
        });
        this.getContentPane().add(this.pbAnimStart);
        this.tbAnimPause.setIcon(this.iPause);
        this.tbAnimPause.setBounds(113, 411, 90, 25);
        this.tbAnimPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.tbAnimPause_actionPerformed();
            }
        });
        this.getContentPane().add(this.tbAnimPause);
        this.pbAnimStop.setIcon(this.iStop);
        this.pbAnimStop.setBounds(222, 411, 90, 25);
        this.pbAnimStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationFrame.this.pbAnimStop_actionPerformed();
            }
        });
        this.getContentPane().add(this.pbAnimStop);
        if (this.is != null) {
            int size = this.is.getStackSize();
            this.pImages.setValue2("" + size);
            this.slImage.setMaximum(size);
            int val = (this.slImage.getMaximum() - this.slImage.getMinimum()) / 10;
            this.slImage.setMajorTickSpacing(val);
            if (size == 0) {
                this.pImages.setValue1("" + size);
                this.slImage.setMaximum(0);
                this.slImage.setMinimum(0);
            }
        }
    }

    private void pbAnimStart_actionPerformed() {
        this.pbAnimStop.setEnabled(true);
        this.pbAnimStart.setEnabled(false);
        this.tbProj1.setEnabled(false);
        this.tbProj2.setEnabled(false);
        this.tbProj3.setEnabled(false);
        this.pImages.getTextFieldReference1().setEnabled(false);
        this.pImages.getTextFieldReference2().setEnabled(false);
        this.is = this.mainFrame.pCanvas.getImageStack();
        this.sleep = 1000 / this.pFps.getValue();
        if (this.tbAnimMode1.isSelected()) {
            this.mode = 1;
        }
        if (this.tbAnimMode2.isSelected()) {
            this.mode = 2;
        }
        if (this.tbAnimMode3.isSelected()) {
            this.mode = 3;
        }
        if (this.tbAnimMode4.isSelected()) {
            this.mode = 4;
        }
        try {
            if (this.tbProj2.isSelected() || this.tbProj3.isSelected()) {
                this.startImage = 0;
                this.stopImage = 255;
            } else {
                this.startImage = this.pImages.getValue1();
                this.stopImage = this.pImages.getValue2();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start();
    }

    private void tbAnimPause_actionPerformed() {
        if (this.tbAnimPause.isSelected()) {
            this.myThread.suspend();
        } else {
            this.myThread.resume();
        }
    }

    private void pbAnimStop_actionPerformed() {
        this.pbAnimStart.setEnabled(true);
        this.pbAnimStop.setEnabled(false);
        this.tbAnimPause.setSelected(false);
        this.pImages.getTextFieldReference1().setEnabled(true);
        this.pImages.getTextFieldReference2().setEnabled(true);
        this.tbProj1.setEnabled(true);
        this.tbProj2.setEnabled(true);
        this.tbProj3.setEnabled(true);
        this.stop();
    }

    public void paint(Graphics g) {
        if (this.paintAll) {
            super.paint(g);
        }
        this.paintAll = false;
        if (this.myImage != null) {
            g.drawImage(this.myImage, 4, 23, 256, 256, this);
        } else {
            g.drawRect(4, 23, 256, 256);
            g.drawLine(4, 23, 260, 279);
            g.drawLine(260, 23, 4, 279);
        }
    }

    private void this_componentMoved(ComponentEvent e) {
        this.paintAll = true;
        this.repaint();
    }

    private void this_windowActivated(WindowEvent e) {
        this.paintAll = true;
        this.repaint();
    }

    private void slImage_stateChanged() {
        ImagePlus ip;
        int actimg = this.slImage.getValue();
        if (this.tbProj1.isSelected()) {
            this.myImage = this.mainFrame.pCanvas.getImageStack().getPictureAtPos(actimg).getAWTImage();
        }
        if (this.tbProj2.isSelected()) {
            ip = this.mainFrame.calcProjection1(actimg - 1, this.pImages.getValue1(), this.pImages.getValue2(), true);
            ip.optimalWindowing();
            this.myImage = ip.getAWTImage();
        }
        if (this.tbProj3.isSelected()) {
            ip = this.mainFrame.calcProjection2(actimg - 1, this.pImages.getValue1(), this.pImages.getValue2(), true);
            ip.optimalWindowing();
            this.myImage = ip.getAWTImage();
        }
        this.repaint();
    }

    private void tbProj1_actionPerformed() {
        this.slImage.setMinimum(this.pImages.getValue1());
        this.slImage.setMaximum(this.pImages.getValue2());
        int val = (this.slImage.getMaximum() - this.slImage.getMinimum()) / 10;
        this.slImage.setMajorTickSpacing(val);
    }

    private void tbProj2_actionPerformed() {
        this.slImage.setMinimum(1);
        this.slImage.setMaximum(256);
        int val = (this.slImage.getMaximum() - this.slImage.getMinimum()) / 10;
        this.slImage.setMajorTickSpacing(val);
    }

    private void tbProj3_actionPerformed() {
        this.slImage.setMinimum(1);
        this.slImage.setMaximum(256);
        int val = (this.slImage.getMaximum() - this.slImage.getMinimum()) / 10;
        this.slImage.setMajorTickSpacing(val);
    }
}

