/*
 * Decompiled with CFR 0.152.
 */
package jigl.image.utils;

import jigl.image.ComplexImage;
import jigl.image.Image;
import jigl.image.RealGrayImage;

public class FFT {
    static final int MAX_POW = 31;
    static final int[] pow2 = new int[32];

    static int BitReverse(int i, int k) {
        int rev = 0;
        for (int j = 0; j < k; ++j) {
            if ((i & pow2[k - j - 1]) <= 0) continue;
            rev |= pow2[j];
        }
        return rev;
    }

    public static ComplexImage forward(Image im) {
        return FFT.doFFT(im, true);
    }

    public static ComplexImage inverse(Image im) {
        return FFT.doFFT(im, false);
    }

    public static ComplexImage doFFT(Image im, boolean forward) {
        int lgn = 0;
        int n = 0;
        int rev = 0;
        int size = im.X() * im.Y();
        float[][] a = null;
        for (int x = 0; x <= 31; ++x) {
            if (pow2[x] < size) continue;
            lgn = x;
            n = pow2[lgn];
            a = new float[2][n];
            for (int y = 0; y < n; ++y) {
                rev = FFT.BitReverse(y, lgn);
                try {
                    if (forward) {
                        if (im instanceof RealGrayImage) {
                            RealGrayImage ub = (RealGrayImage)im;
                            if (y < ub.X() * ub.Y()) {
                                a[0][rev] = ub.get(y % ub.X(), y / ub.X());
                                a[1][rev] = 0.0f;
                                continue;
                            }
                            a[0][rev] = 0.0f;
                            a[1][rev] = 0.0f;
                            continue;
                        }
                        System.out.println("Nichtunterstuetzter Bildtype bei FFT");
                        continue;
                    }
                    if (im instanceof ComplexImage) {
                        ComplexImage ci = (ComplexImage)im;
                        if (y < ci.X() * ci.Y()) {
                            a[0][rev] = ci.getReal(y % ci.X(), y / ci.X()) / (float)n;
                            a[1][rev] = ci.getImag(y % ci.X(), y / ci.X()) / (float)n;
                            continue;
                        }
                        a[0][rev] = 0.0f;
                        a[1][rev] = 0.0f;
                        continue;
                    }
                    System.out.println("Nichtunterstuetzter Bildtype bei FFT");
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    a[0][rev] = 0.0f;
                    a[1][rev] = 0.0f;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("FFT Error:  " + e.toString());
                }
            }
            break;
        }
        int m = 0;
        int mdiv2 = 0;
        float omega_m0 = 0.0f;
        float omega_m1 = 0.0f;
        float[][] b = new float[2][n];
        int w = im.X();
        int h = im.Y();
        double minustwotimesPI = Math.PI * -2;
        double twotimesPI = Math.PI * 2;
        long starttime = System.currentTimeMillis();
        for (int s = 1; s <= lgn; ++s) {
            m = pow2[s];
            mdiv2 = m >> 1;
            if (forward) {
                double minustwotimesPIdivm = minustwotimesPI / (double)m;
                omega_m0 = (float)Math.cos(minustwotimesPIdivm);
                omega_m1 = (float)Math.sin(minustwotimesPIdivm);
            } else {
                double twotimesPIdivm = twotimesPI / (double)m;
                omega_m0 = (float)Math.cos(twotimesPIdivm);
                omega_m1 = (float)Math.sin(twotimesPIdivm);
            }
            float omega0 = 1.0f;
            float omega1 = 0.0f;
            for (int j = 0; j < mdiv2; ++j) {
                for (int k = j; k < n; k += m) {
                    int kplusmdiv2 = k + mdiv2;
                    float t0 = omega0;
                    float t1 = omega1;
                    float u0 = a[0][k];
                    float u1 = a[1][k];
                    float temp = t0 * a[0][kplusmdiv2] - t1 * a[1][kplusmdiv2];
                    t1 = t0 * a[1][kplusmdiv2] + t1 * a[0][kplusmdiv2];
                    t0 = temp;
                    a[0][k] = u0 + t0;
                    a[1][k] = u1 + t1;
                    a[0][kplusmdiv2] = u0 - t0;
                    a[1][kplusmdiv2] = u1 - t1;
                }
                float t2 = omega0 * omega_m0 - omega1 * omega_m1;
                omega1 = omega0 * omega_m1 + omega1 * omega_m0;
                omega0 = t2;
            }
        }
        ComplexImage ar = new ComplexImage(w, h);
        for (int i = 0; i < n; ++i) {
            ar.set(i % w, i / w, a[0][i], a[1][i]);
        }
        long endtime = System.currentTimeMillis();
        return ar;
    }

    static {
        FFT.pow2[0] = 1;
        for (int i = 1; i <= 31; ++i) {
            FFT.pow2[i] = 2 * pow2[i - 1];
        }
    }
}

