/*
 * Decompiled with CFR 0.152.
 */
package jigl.image;

import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jigl.image.ConvertImage;
import jigl.image.DummyObserver;
import jigl.image.Image;
import jigl.image.ImageKernel;
import jigl.image.ROI;

public class RealGrayImage
implements Image {
    protected float[][] data;
    protected int X;
    protected int Y;

    public RealGrayImage() {
        this.X = 0;
        this.Y = 0;
        this.data = null;
    }

    public float[][] getData() {
        return this.data;
    }

    public RealGrayImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.data = new float[this.Y][this.X];
    }

    public RealGrayImage(int x, int y, float[] dat) {
        this.X = x;
        this.Y = y;
        this.data = new float[this.Y][this.X];
        for (int a = 0; a < y; ++a) {
            for (int b = 0; b < x; ++b) {
                this.data[a][b] = dat[a * this.Y + b];
            }
        }
    }

    public RealGrayImage(float[][] dat) {
        boolean max = false;
        this.Y = dat.length;
        this.X = dat[0].length;
        System.out.println("Konstruktor RealGrayImage" + this.X + " " + this.Y);
        this.data = dat;
    }

    public RealGrayImage(RealGrayImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = img.data;
    }

    public RealGrayImage(java.awt.Image img) {
        int w = img.getWidth(DummyObserver.dummy);
        int h = img.getHeight(DummyObserver.dummy);
        this.X = w;
        this.Y = h;
        this.data = new float[this.Y][this.X];
        this.InitFromImage(img, 0, 0, w, h);
    }

    public Image copy() {
        RealGrayImage g = new RealGrayImage(this.X, this.Y);
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                g.data[y][x] = this.data[y][x];
            }
        }
        return g;
    }

    public void convolve(ImageKernel kernel) {
        int NumX = kernel.X();
        int NumY = kernel.Y();
        int midX = NumX / 2;
        int midY = NumY / 2;
        double sum = 0.0;
        float[][] value = new float[this.Y][this.X];
        float[][] kern = ConvertImage.toRealGray((RealGrayImage)kernel).data;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                sum = 0.0;
                for (int j = -midY; j <= midY; ++j) {
                    for (int i = -midX; i <= midX; ++i) {
                        if (y + j < 0 || x + i < 0 || y + j >= this.Y || x + i >= this.X || midY + j < 0 || midX + i < 0 || midY + j >= NumY || midX + i >= NumX) continue;
                        sum += (double)(this.data[y + j][x + i] * kern[midY + j][midX + i]);
                    }
                }
                value[y][x] = (float)sum;
            }
        }
        this.data = value;
    }

    private void InitFromImage(java.awt.Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        int index = 0;
        for (int iy = 0; iy < this.Y; ++iy) {
            for (int ix = 0; ix < this.X; ++ix) {
                red = 0xFF & pixels[index] >> 16;
                green = 0xFF & pixels[index] >> 8;
                blue = 0xFF & pixels[index];
                this.data[iy][ix] = (float)((double)red * 0.299 + (double)green * 0.587 + (double)blue * 0.114);
                ++index;
            }
        }
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public final float get(int x, int y) {
        return this.data[y][x];
    }

    public final void set(int x, int y, float value) {
        this.data[y][x] = value;
    }

    public final RealGrayImage clear() {
        this.clear(0.0f);
        return this;
    }

    public final RealGrayImage clear(float val) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                this.data[y][x] = val;
            }
        }
        return this;
    }

    public final void add(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] + value;
    }

    public final void subtract(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] - value;
    }

    public final void multiply(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] * value;
    }

    public final void divide(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] / value;
    }

    public final float min() {
        float min = 32767.0f;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                float p = this.data[y][x];
                if (!(p < min)) continue;
                min = p;
            }
        }
        return min;
    }

    public final float max() {
        float max = -32768.0f;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                float p = this.data[y][x];
                if (!(p > max)) continue;
                max = p;
            }
        }
        return max;
    }

    public final float addSum() {
        float sum = 0.0f;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                sum += this.data[y][x];
            }
        }
        return sum;
    }

    public final float absSum() {
        float sum = 0.0f;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (this.data[y][x] < 0.0f) {
                    sum += -this.data[y][x];
                    continue;
                }
                sum += this.data[y][x];
            }
        }
        return sum;
    }

    public final double sqrSum() {
        double sum = 0.0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                sum += (double)(this.data[y][x] * this.data[y][x]);
            }
        }
        return sum;
    }

    public final RealGrayImage add(float v) {
        float sv = v;
        for (int y = 0; y < this.Y; ++y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] + sv;
            }
        }
        return this;
    }

    public final RealGrayImage subtract(float v) {
        float sv = v;
        for (int y = 0; y < this.Y; ++y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] - sv;
            }
        }
        return this;
    }

    public final RealGrayImage multiply(float v) {
        float sv = v;
        for (int y = 0; y < this.Y; ++y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] * sv;
            }
        }
        return this;
    }

    public final RealGrayImage divide(float v) {
        float sv = v;
        for (int y = 0; y < this.Y; ++y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] / sv;
            }
        }
        return this;
    }

    public final RealGrayImage add(RealGrayImage im) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (y >= im.Y() || x >= im.X()) continue;
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] + im.get(x, y);
            }
        }
        return this;
    }

    public final RealGrayImage subtract(RealGrayImage im) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (y >= im.Y() || x >= im.X()) continue;
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] - im.get(x, y);
            }
        }
        return this;
    }

    public final RealGrayImage diff(RealGrayImage im) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] - im.get(x, y);
                if (!(this.data[y][x] < 0.0f)) continue;
                this.data[y][x] = (short)(-this.data[y][x]);
            }
        }
        return this;
    }

    public final RealGrayImage multiply(RealGrayImage im) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (y >= im.Y() || x >= im.X()) continue;
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] * im.get(x, y);
            }
        }
        return this;
    }

    public final RealGrayImage divide(RealGrayImage im) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (y >= im.Y() || x >= im.X()) continue;
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] / im.get(x, y);
            }
        }
        return this;
    }

    public String toString() {
        String str = this.X + ":" + this.Y + "\n";
        for (int x = 0; x < this.X; ++x) {
            for (int y = 0; y < this.Y; ++y) {
                str = str + this.data[y][x] + " ";
            }
            str = str + "\n";
        }
        return str;
    }

    public ImageProducer getJavaImage() {
        float min = this.min();
        float max = this.max();
        if (min >= 0.0f && max <= 255.0f) {
            min = 0.0f;
            max = 255.0f;
        }
        float range = max - min;
        int[] pix = new int[this.X * this.Y];
        int index = 0;
        int value = 0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                value = (int)(255.0 / (double)range * (double)((float)((int)this.data[y][x]) - min));
                value = 0xFF & value;
                pix[index] = 0xFF000000 | value << 16 | value << 8 | value;
                ++index;
            }
        }
        return new MemoryImageSource(this.X, this.Y, pix, 0, this.X);
    }

    public void byteSize() {
        float min = this.min();
        float max = this.max();
        float range = max - min;
        int value = 0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                value = (int)(255.0 / (double)range * (double)(this.data[y][x] - min));
                value = 0xFF & value;
                this.data[y][x] = value;
            }
        }
    }

    public void clip(int min, int max) {
        float value = 0.0f;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                value = this.data[y][x];
                value = value > (float)max ? (float)max : value;
                this.data[y][x] = value = value < (float)min ? (float)min : value;
            }
        }
    }

    private float[] sort(float[] vals, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size - 1; ++j) {
                try {
                    if (!(vals[j] > vals[j + 1])) continue;
                    float temp = vals[j];
                    vals[j] = vals[j + 1];
                    vals[j + 1] = temp;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return vals;
    }

    public void median(int size) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        float[] value = new float[NumX * NumY];
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                int count = 0;
                for (int j = -midY; j <= midY; ++j) {
                    for (int i = -midX; i <= midX; ++i) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                value = this.sort(value, count);
                this.data[y][x] = value[count / 2];
            }
        }
    }

    public Image copy(ROI r) {
        RealGrayImage g = new RealGrayImage(r.lx() - r.ux(), r.ly() - r.uy());
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                g.data[y][x] = this.data[y][x];
            }
        }
        return g;
    }

    public final void set(int x, int y, float value, ROI r) {
        this.data[r.uy() + y][r.ux() + x] = value;
    }

    public final void add(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] + value;
    }

    public final void subtract(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] - value;
    }

    public final void multiply(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] * value;
    }

    public final void divide(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] / value;
    }

    public final float min(ROI r) {
        float min = 32767.0f;
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                float p = this.data[y][x];
                if (!(p < min)) continue;
                min = p;
            }
        }
        return min;
    }

    public final float max(ROI r) {
        float max = -32768.0f;
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                float p = this.data[y][x];
                if (!(p > max)) continue;
                max = p;
            }
        }
        return max;
    }

    public final RealGrayImage add(float v, ROI r) {
        float sv = v;
        for (int y = r.uy(); y < r.ly(); ++y) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] + sv;
            }
        }
        return this;
    }

    public final RealGrayImage subtract(float v, ROI r) {
        float sv = v;
        for (int y = r.uy(); y < r.ly(); ++y) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] - sv;
            }
        }
        return this;
    }

    public final RealGrayImage multiply(float v, ROI r) {
        float sv = v;
        for (int y = r.uy(); y < r.ly(); ++y) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] * sv;
            }
        }
        return this;
    }

    public final RealGrayImage divide(float v, ROI r) {
        float sv = v;
        for (int y = r.uy(); y < r.ly(); ++y) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] / sv;
            }
        }
        return this;
    }

    public final RealGrayImage add(RealGrayImage im, ROI sourceImage, ROI destImage) {
        for (int y = sourceImage.uy(); y < sourceImage.ly(); ++y) {
            for (int x = sourceImage.ux(); x < sourceImage.lx(); ++x) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] + im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
            }
        }
        return this;
    }

    public final RealGrayImage subtract(RealGrayImage im, ROI sourceImage, ROI destImage) {
        for (int y = sourceImage.uy(); y < sourceImage.ly(); ++y) {
            for (int x = sourceImage.ux(); x < sourceImage.lx(); ++x) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] - im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
            }
        }
        return this;
    }

    public final RealGrayImage multiply(RealGrayImage im, ROI sourceImage, ROI destImage) {
        for (int y = sourceImage.uy(); y < sourceImage.ly(); ++y) {
            for (int x = sourceImage.ux(); x < sourceImage.lx(); ++x) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] * im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
            }
        }
        return this;
    }

    public final RealGrayImage divide(RealGrayImage im, ROI sourceImage, ROI destImage) {
        for (int y = sourceImage.uy(); y < sourceImage.ly(); ++y) {
            for (int x = sourceImage.ux(); x < sourceImage.lx(); ++x) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] / im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
            }
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.X + ":" + this.Y + "\n";
        for (int x = r.ux(); x < r.lx(); ++x) {
            for (int y = r.uy(); y < r.ly(); ++y) {
                str = str + this.data[y][x] + " ";
            }
            str = str + "\n";
        }
        return str;
    }

    public void clip(int min, int max, ROI r) {
        float value = 0.0f;
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                value = this.data[y][x];
                value = value > (float)max ? (float)max : value;
                this.data[y][x] = value = value < (float)min ? (float)min : value;
            }
        }
    }

    public void median(int size, ROI r) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        float[] value = new float[NumX * NumY];
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                int count = 0;
                for (int j = -midY; j <= midY; ++j) {
                    for (int i = -midX; i <= midX; ++i) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                value = this.sort(value, count);
                this.data[y][x] = value[count / 2];
            }
        }
    }
}

