/*
 * Decompiled with CFR 0.152.
 */
package jigl.image;

import jigl.image.BinaryImage;
import jigl.image.ColorImage;
import jigl.image.ColorModelNotSupportedException;
import jigl.image.ColorModelUnknownException;
import jigl.image.ComplexImage;
import jigl.image.GrayImage;
import jigl.image.Image;
import jigl.image.RealColorImage;
import jigl.image.RealGrayImage;

public class ConvertImage {
    public static GrayImage toGray(Image img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        System.out.println("***Image");
        if (img instanceof GrayImage) {
            return ConvertImage.toGray((GrayImage)img);
        }
        if (img instanceof RealGrayImage) {
            return ConvertImage.toGray((RealGrayImage)img);
        }
        if (img instanceof ColorImage) {
            return ConvertImage.toGray((ColorImage)img);
        }
        if (img instanceof RealColorImage) {
            return ConvertImage.toGray((RealColorImage)img);
        }
        return ConvertImage.toGray((ComplexImage)img);
    }

    public static RealGrayImage toRealGray(Image img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        if (img instanceof GrayImage) {
            return ConvertImage.toRealGray((GrayImage)img);
        }
        if (img instanceof RealGrayImage) {
            return ConvertImage.toRealGray((RealGrayImage)img);
        }
        if (img instanceof ColorImage) {
            return ConvertImage.toRealGray((ColorImage)img);
        }
        if (img instanceof RealColorImage) {
            return ConvertImage.toRealGray((RealColorImage)img);
        }
        return ConvertImage.toRealGray((ComplexImage)img);
    }

    public static ColorImage toColor(Image img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        if (img instanceof GrayImage) {
            return ConvertImage.toColor((GrayImage)img);
        }
        if (img instanceof RealGrayImage) {
            return ConvertImage.toColor((RealGrayImage)img);
        }
        if (img instanceof ColorImage) {
            return ConvertImage.toColor((ColorImage)img);
        }
        if (img instanceof RealColorImage) {
            return ConvertImage.toColor((RealColorImage)img);
        }
        return ConvertImage.toColor((ComplexImage)img);
    }

    public static RealColorImage toRealColor(Image img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        if (img instanceof GrayImage) {
            return ConvertImage.toRealColor((GrayImage)img);
        }
        if (img instanceof RealGrayImage) {
            return ConvertImage.toRealColor((RealGrayImage)img);
        }
        if (img instanceof ColorImage) {
            return ConvertImage.toRealColor((ColorImage)img);
        }
        if (img instanceof RealColorImage) {
            return ConvertImage.toRealColor((RealColorImage)img);
        }
        return ConvertImage.toRealColor((ComplexImage)img);
    }

    public static ComplexImage toComplex(Image img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        if (img instanceof GrayImage) {
            return ConvertImage.toComplex((GrayImage)img);
        }
        if (img instanceof RealGrayImage) {
            return ConvertImage.toComplex((RealGrayImage)img);
        }
        if (img instanceof ColorImage) {
            return ConvertImage.toComplex((ColorImage)img);
        }
        if (img instanceof RealColorImage) {
            return ConvertImage.toComplex((RealColorImage)img);
        }
        return ConvertImage.toComplex((ComplexImage)img);
    }

    public static GrayImage toGray(GrayImage img) {
        System.out.println("***GrayImage");
        int X = img.X();
        int Y = img.Y();
        GrayImage newimg = new GrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.get(x, y));
            }
        }
        return newimg;
    }

    public static GrayImage toGray(BinaryImage img) {
        System.out.println("***BinaryImage");
        int X = img.X();
        int Y = img.Y();
        GrayImage newimg = new GrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                if (img.get(x, y) == 0) {
                    newimg.set(x, y, 0);
                    continue;
                }
                newimg.set(x, y, 255);
            }
        }
        return newimg;
    }

    public static GrayImage toGray(RealGrayImage img) {
        System.out.println("***RealGrayImage");
        int X = img.X();
        int Y = img.Y();
        GrayImage newimg = new GrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, (short)img.get(x, y));
            }
        }
        return newimg;
    }

    public static GrayImage toGray(ColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        System.out.println("***ColorImage");
        int X = img.X();
        int Y = img.Y();
        int[] color = new int[3];
        GrayImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new GrayImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        int gray = (int)((double)color[0] * 0.299 + (double)color[1] * 0.587 + (double)color[2] * 0.114);
                        newimg.set(x, y, gray);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static GrayImage toGray(RealColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        System.out.println("***RealColorImage");
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        GrayImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new GrayImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        int gray = (int)((double)color[0] * 0.299 + (double)color[1] * 0.587 + (double)color[2] * 0.114);
                        newimg.set(x, y, gray);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static GrayImage toGray(ComplexImage img) {
        System.out.println("***ComplexImage");
        int X = img.X();
        int Y = img.Y();
        GrayImage newimg = null;
        newimg = new GrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, (int)img.getReal(x, y));
            }
        }
        return newimg;
    }

    public static RealGrayImage toRealGray(GrayImage img) {
        int X = img.X();
        int Y = img.Y();
        RealGrayImage newimg = new RealGrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.get(x, y));
            }
        }
        return newimg;
    }

    public static RealGrayImage toRealGray(RealGrayImage img) {
        int X = img.X();
        int Y = img.Y();
        RealGrayImage newimg = new RealGrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.get(x, y));
            }
        }
        return newimg;
    }

    public static RealGrayImage toRealGray(ColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        int X = img.X();
        int Y = img.Y();
        int[] color = new int[3];
        RealGrayImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new RealGrayImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        float gray = (float)color[0] * 0.299f + (float)color[1] * 0.587f + (float)color[2] * 0.114f;
                        newimg.set(x, y, gray);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static RealGrayImage toRealGray(RealColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        RealGrayImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new RealGrayImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        float gray = color[0] * 0.299f + color[1] * 0.587f + color[2] * 0.114f;
                        newimg.set(x, y, gray);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static RealGrayImage toRealGray(ComplexImage img) {
        int X = img.X();
        int Y = img.Y();
        RealGrayImage newimg = null;
        newimg = new RealGrayImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.getReal(x, y));
            }
        }
        return newimg;
    }

    public static ColorImage toColor(GrayImage img) {
        int X = img.X();
        int Y = img.Y();
        int[] color = new int[3];
        ColorImage newimg = new ColorImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                int gray;
                color[0] = gray = img.get(x, y);
                color[1] = gray;
                color[2] = gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static ColorImage toColor(RealGrayImage img) {
        int X = img.X();
        int Y = img.Y();
        int[] color = new int[3];
        ColorImage newimg = new ColorImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray = img.get(x, y);
                color[0] = (int)gray;
                color[1] = (int)gray;
                color[2] = (int)gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static ColorImage toColor(ColorImage img) {
        int X = img.X();
        int Y = img.Y();
        ColorImage newimg = null;
        newimg = new ColorImage(X, Y);
        newimg.setColorModel(img.getColorModel());
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.get(x, y));
            }
        }
        return newimg;
    }

    public static ColorImage toColor(RealColorImage img) {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        int[] icolor = new int[3];
        ColorImage newimg = null;
        newimg = new ColorImage(X, Y);
        newimg.setColorModel(img.getColorModel());
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                color = img.get(x, y);
                icolor[0] = (int)color[0];
                icolor[1] = (int)color[1];
                icolor[2] = (int)color[2];
                newimg.set(x, y, icolor);
            }
        }
        return newimg;
    }

    public static ColorImage toColor(ComplexImage img) {
        int X = img.X();
        int Y = img.Y();
        ColorImage newimg = null;
        newimg = new ColorImage(X, Y);
        int[] color = new int[3];
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                int gray;
                color[0] = gray = (int)img.getReal(x, y);
                color[1] = gray;
                color[2] = gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static RealColorImage toRealColor(GrayImage img) {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        RealColorImage newimg = new RealColorImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray;
                color[0] = gray = (float)img.get(x, y);
                color[1] = gray;
                color[2] = gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static RealColorImage toRealColor(RealGrayImage img) {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        RealColorImage newimg = new RealColorImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray;
                color[0] = gray = img.get(x, y);
                color[1] = gray;
                color[2] = gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static RealColorImage toRealColor(ColorImage img) {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        int[] icolor = new int[3];
        RealColorImage newimg = null;
        newimg = new RealColorImage(X, Y);
        newimg.setColorModel(img.getColorModel());
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                icolor = img.get(x, y);
                color[0] = icolor[0];
                color[1] = icolor[1];
                color[2] = icolor[2];
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static RealColorImage toRealColor(RealColorImage img) {
        int X = img.X();
        int Y = img.Y();
        RealColorImage newimg = null;
        newimg = new RealColorImage(X, Y);
        newimg.setColorModel(img.getColorModel());
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.set(x, y, img.get(x, y));
            }
        }
        return newimg;
    }

    public static RealColorImage toRealColor(ComplexImage img) {
        int X = img.X();
        int Y = img.Y();
        RealColorImage newimg = null;
        newimg = new RealColorImage(X, Y);
        float[] color = new float[3];
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray;
                color[0] = gray = img.getReal(x, y);
                color[1] = gray;
                color[2] = gray;
                newimg.set(x, y, color);
            }
        }
        return newimg;
    }

    public static ComplexImage toComplex(GrayImage img) {
        int X = img.X();
        int Y = img.Y();
        ComplexImage newimg = new ComplexImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray = img.get(x, y);
                newimg.setReal(x, y, gray);
                newimg.setImag(x, y, 0.0f);
            }
        }
        return newimg;
    }

    public static ComplexImage toComplex(RealGrayImage img) {
        int X = img.X();
        int Y = img.Y();
        ComplexImage newimg = new ComplexImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                float gray = img.get(x, y);
                newimg.setReal(x, y, gray);
                newimg.setImag(x, y, 0.0f);
            }
        }
        return newimg;
    }

    public static ComplexImage toComplex(ColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        int X = img.X();
        int Y = img.Y();
        int[] color = new int[3];
        ComplexImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new ComplexImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        float real = (float)color[0] * 0.299f + (float)color[1] * 0.587f + (float)color[2] * 0.114f;
                        newimg.setReal(x, y, real);
                        newimg.setImag(x, y, 0.0f);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static ComplexImage toComplex(RealColorImage img) throws ColorModelNotSupportedException, ColorModelUnknownException {
        int X = img.X();
        int Y = img.Y();
        float[] color = new float[3];
        ComplexImage newimg = null;
        switch (img.getColorModel()) {
            case 0: {
                newimg = new ComplexImage(X, Y);
                for (int y = 0; y < Y; ++y) {
                    for (int x = 0; x < X; ++x) {
                        color = img.get(x, y);
                        float real = color[0] * 0.299f + color[1] * 0.587f + color[2] * 0.114f;
                        newimg.setReal(x, y, real);
                        newimg.setImag(x, y, 0.0f);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new ColorModelNotSupportedException();
            }
            default: {
                throw new ColorModelUnknownException();
            }
        }
        return newimg;
    }

    public static ComplexImage toComplex(ComplexImage img) {
        int X = img.X();
        int Y = img.Y();
        ComplexImage newimg = null;
        newimg = new ComplexImage(X, Y);
        for (int y = 0; y < Y; ++y) {
            for (int x = 0; x < X; ++x) {
                newimg.setReal(x, y, img.getReal(x, y));
                newimg.setImag(x, y, img.getImag(x, y));
            }
        }
        return newimg;
    }
}

