/*
 * Decompiled with CFR 0.152.
 */
package jigl.image;

import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import jigl.image.GrayImage;
import jigl.image.Image;
import jigl.image.ROI;
import jigl.image.RealGrayImage;

public class BinaryImage
implements Image {
    protected byte[][] data;
    protected int X;
    protected int Y;

    public BinaryImage() {
        this.X = 0;
        this.Y = 0;
        this.data = null;
    }

    public BinaryImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.data = new byte[this.Y][this.X];
    }

    public ImageProducer getJavaImage() {
        int min = 0;
        int max = 1;
        if (min >= 0 && max <= 255) {
            min = 0;
            max = 255;
        }
        int range = max - min;
        int[] pix = new int[this.X * this.Y];
        int index = 0;
        int value = 0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                value = (int)(255.0 / (double)range * (double)((float)this.data[y][x] - (float)min));
                value = 0xFF & value;
                pix[index] = 0xFF000000 | value << 16 | value << 8 | value;
                ++index;
            }
        }
        return new MemoryImageSource(this.X, this.Y, pix, 0, this.X);
    }

    public BinaryImage(int x, int y, byte[] dat) {
        this.X = x;
        this.Y = y;
        boolean count = false;
        this.data = new byte[this.Y][this.X];
        for (int a = 0; a < this.Y; ++a) {
            for (int b = 0; b < this.X; ++b) {
                this.data[a][b] = dat[a * this.Y + b] > 0 ? (byte)1 : 0;
            }
        }
    }

    public BinaryImage(GrayImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = new byte[this.Y][this.X];
        for (int a = 0; a < this.X; ++a) {
            for (int b = 0; b < this.Y; ++b) {
                this.data[b][a] = img.get(a, b) > 0 ? (byte)1 : 0;
            }
        }
    }

    public BinaryImage(RealGrayImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = new byte[this.Y][this.X];
        for (int a = 0; a < this.X; ++a) {
            for (int b = 0; b < this.Y; ++b) {
                if (img.get(a, b) > 0.0f) {
                    this.set(a, b, 1);
                    continue;
                }
                this.set(a, b, 0);
            }
        }
    }

    public BinaryImage(BinaryImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = img.data;
    }

    public Image copy() {
        BinaryImage g = new BinaryImage(this.X, this.Y);
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                g.data[y][x] = this.data[y][x];
            }
        }
        return g;
    }

    public Image copy(ROI r) {
        BinaryImage g = new BinaryImage(this.X, this.Y);
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.lx(); x < r.ux(); ++x) {
                g.data[y][x] = this.data[y][x];
            }
        }
        return g;
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public final byte get(int x, int y) {
        return this.data[y][x];
    }

    public final void set(int x, int y, int value) {
        this.data[y][x] = value > 0 ? (byte)1 : 0;
    }

    public final BinaryImage union(BinaryImage image) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (image.get(x, y) == this.data[y][x]) continue;
                this.data[y][x] = 1;
            }
        }
        return this;
    }

    public final BinaryImage intersection(BinaryImage image) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (image.get(x, y) == this.data[y][x]) continue;
                this.data[y][x] = 0;
            }
        }
        return this;
    }

    public final BinaryImage compliment(BinaryImage image) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                this.data[y][x] = this.data[y][x] == 0 ? (byte)1 : 0;
            }
        }
        return this;
    }

    public final int count() {
        int count = 0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                if (this.data[y][x] == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public final BinaryImage difference(BinaryImage image) {
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                this.data[y][x] = this.data[y][x] == 1 && image.get(x, y) == 0 ? (byte)1 : (this.data[y][x] == 1 && image.get(x, y) == 0 ? (byte)1 : 0);
            }
        }
        return this;
    }

    public final BinaryImage shift(int horizonal, int vertical) {
        BinaryImage image2 = (BinaryImage)this.copy();
        byte set1 = 0;
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                set1 = y - vertical < 0 || y - vertical >= this.Y ? (byte)0 : (x - horizonal < 0 || x - horizonal >= this.X ? (byte)0 : image2.get(x - horizonal, y - vertical));
                this.data[y][x] = set1;
            }
        }
        return this;
    }
}

