/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Decoder;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public class J2KRenderedImageCodecLib
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KMetadata metadata;
    private ImageInputStream iis = null;
    private J2KImageReaderCodecLib reader;
    private J2KImageReadParam param = null;
    private Decoder decoder;
    private Size size;
    private int xStep;
    private int yStep;
    Rectangle destinationRegion;
    Rectangle originalRegion;
    Point sourceOrigin;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private int[] channelMap;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    static /* synthetic */ Class array$B;

    public J2KRenderedImageCodecLib(ImageInputStream iis, J2KImageReaderCodecLib reader, ImageReadParam param) throws IOException {
        int i;
        this.iis = iis;
        this.reader = reader;
        boolean allowZeroDestOffset = true;
        if (param == null) {
            param = (J2KImageReadParam)reader.getDefaultReadParam();
            allowZeroDestOffset = false;
        } else if (!(param instanceof J2KImageReadParam)) {
            param = new J2KImageReadParamJava(param);
            allowZeroDestOffset = false;
        }
        this.param = (J2KImageReadParam)param;
        this.decoder = new Decoder(iis);
        this.decoder.setMode(2);
        int resolution = ((J2KImageReadParam)param).getResolution();
        if (resolution != -1) {
            this.decoder.setMaxLevels(resolution);
        }
        this.size = this.decoder.decodeSize(null);
        CompParams compParam = new CompParams();
        for (i = 0; i < this.size.csize; ++i) {
            this.decoder.decodeCompParams(compParam, i);
            if (i == 0) {
                this.xStep = compParam.xstep;
                this.yStep = compParam.ystep;
                continue;
            }
            if (compParam.xstep == this.xStep && compParam.ystep == this.yStep) continue;
            throw new IIOException("All components must have the same subsampling factors!");
        }
        this.sourceBands = param.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.size.csize;
            this.sourceBands = new int[this.nComp];
            for (i = 0; i < this.nComp; ++i) {
                this.sourceBands[i] = i;
            }
        } else {
            for (i = 0; i < this.sourceBands.length; ++i) {
                if (this.sourceBands[i] >= 0 && this.sourceBands[i] < this.size.csize) continue;
                throw new IIOException("Source band out of range!");
            }
        }
        this.nComp = this.sourceBands.length;
        this.destinationBands = param.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            for (i = 0; i < this.nComp; ++i) {
                this.destinationBands[i] = i;
            }
        } else {
            for (i = 0; i < this.destinationBands.length; ++i) {
                if (this.destinationBands[i] >= 0 && this.destinationBands[i] < this.size.csize) continue;
                throw new IIOException("Destination band out of range!");
            }
        }
        if (this.destinationBands.length != this.sourceBands.length) {
            throw new IIOException("Number of source and destination bands must be equal!");
        }
        this.width = (this.size.xosize + this.size.xsize + this.xStep - 1) / this.xStep;
        this.height = (this.size.yosize + this.size.ysize + this.yStep - 1) / this.yStep;
        Rectangle sourceRegion = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)sourceRegion.clone();
        this.destinationRegion = (Rectangle)sourceRegion.clone();
        J2KImageReader.computeRegionsWrapper(param, allowZeroDestOffset, this.width, this.height, param.getDestination(), sourceRegion, this.destinationRegion);
        this.scaleX = param.getSourceXSubsampling();
        this.scaleY = param.getSourceYSubsampling();
        this.xOffset = param.getSubsamplingXOffset();
        this.yOffset = param.getSubsamplingYOffset();
        this.sourceOrigin = new Point(sourceRegion.x, sourceRegion.y);
        if (!this.destinationRegion.equals(this.originalRegion)) {
            this.noTransform = false;
        }
        this.tileWidth = (this.size.xtsize + this.xStep - 1) / this.xStep;
        this.tileHeight = (this.size.ytsize + this.yStep - 1) / this.yStep;
        this.tileGridXOffset = (this.size.xtosize + this.xStep - 1) / this.xStep - (this.size.xosize + this.xStep - 1) / this.xStep;
        this.tileGridYOffset = (this.size.ytosize + this.yStep - 1) / this.yStep - (this.size.yosize + this.yStep - 1) / this.yStep;
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.originalSampleModel = this.createOriginalSampleModel();
        this.sampleModel = this.createSampleModel();
        this.colorModel = this.createColorModel();
        this.tileGridXOffset += (this.XToTileX(this.minX) - this.XToTileX(this.tileGridXOffset)) * this.tileWidth;
        this.tileGridYOffset += (this.YToTileY(this.minY) - this.YToTileY(this.tileGridYOffset)) * this.tileHeight;
        double rate = ((J2KImageReadParam)param).getDecodingRate();
        if (rate != Double.MAX_VALUE) {
            this.decoder.setRate(rate /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        }
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (this.currentTile != null && this.currentTileGrid.x == tileX && this.currentTileGrid.y == tileY) {
            return this.currentTile;
        }
        if (tileX < this.getMinTileX() || tileY < this.getMinTileY() || tileX > this.getMaxTileX() || tileY > this.getMaxTileY()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        int x = this.tileXToX(tileX);
        int y = this.tileYToY(tileY);
        this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(x, y));
        try {
            this.readAsRaster((WritableRaster)this.currentTile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(tileX, tileY);
        } else {
            this.currentTileGrid.x = tileX;
            this.currentTileGrid.y = tileY;
        }
        return this.currentTile;
    }

    synchronized WritableRaster readAsRaster(WritableRaster raster) throws IOException {
        int x = raster.getMinX();
        int y = raster.getMinY();
        try {
            if (this.noTransform) {
                int E2c = (this.size.xosize + this.xStep - 1) / this.xStep;
                int E1c = (this.size.yosize + this.yStep - 1) / this.yStep;
                int tXStart = ((x + E2c) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int tXEnd = ((x + raster.getWidth() - 1 + E2c) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int tYStart = ((y + E2c) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int tYEnd = ((y + raster.getHeight() - 1 + E2c) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int sourceFormatTag = MediaLibAccessor.findCompatibleTag(raster);
                if (tXStart == tXEnd && tYStart == tYEnd) {
                    MediaLibAccessor accessor = new MediaLibAccessor(raster, raster.getBounds().intersection(this.originalRegion), sourceFormatTag, true);
                    mediaLibImage[] mlImage = accessor.getMediaLibImages();
                    int tileNo = tXStart + tYStart * this.size.nxtiles;
                    this.decoder.decode(mlImage, tileNo);
                    accessor.copyDataToRaster(this.channelMap);
                } else {
                    for (int ty = tYStart; ty <= tYEnd; ++ty) {
                        for (int tx = tXStart; tx <= tXEnd; ++tx) {
                            int sx = (this.size.xtosize + tx * this.size.xtsize + this.xStep - 1) / this.xStep - E2c;
                            int sy = (this.size.ytosize + ty * this.size.ytsize + this.yStep - 1) / this.yStep - E1c;
                            int ex = (this.size.xtosize + (tx + 1) * this.size.xtsize + this.xStep - 1) / this.xStep - E2c;
                            int ey = (this.size.ytosize + (ty + 1) * this.size.ytsize + this.yStep - 1) / this.yStep - E1c;
                            Rectangle subRect = new Rectangle(sx, sy, ex - sx, ey - sy);
                            if (subRect.isEmpty()) continue;
                            if (this.rasForATile == null) {
                                this.rasForATile = Raster.createWritableRaster(this.originalSampleModel, null);
                            }
                            WritableRaster subRaster = this.rasForATile.createWritableChild(this.rasForATile.getMinX(), this.rasForATile.getMinY(), subRect.width, subRect.height, subRect.x, subRect.y, null);
                            MediaLibAccessor accessor = new MediaLibAccessor(subRaster, subRect, sourceFormatTag, true);
                            mediaLibImage[] mlImage = accessor.getMediaLibImages();
                            int tileNo = tx + ty * this.size.nxtiles;
                            this.decoder.decode(mlImage, tileNo);
                            accessor.copyDataToRaster(this.channelMap);
                            Rectangle rasBounds = raster.getBounds();
                            Rectangle childRect = rasBounds.intersection(subRect);
                            if (childRect.isEmpty()) continue;
                            Raster childRaster = subRaster.createChild(childRect.x, childRect.y, childRect.width, childRect.height, childRect.x, childRect.y, null);
                            raster.setRect(childRaster);
                        }
                    }
                }
            } else {
                this.readSubsampledRaster(raster);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return raster;
    }

    private void readSubsampledRaster(WritableRaster raster) throws IOException {
        int numBands = this.sourceBands.length;
        Rectangle destRect = raster.getBounds().intersection(this.destinationRegion);
        int offx = this.destinationRegion.x;
        int offy = this.destinationRegion.y;
        int sourceSX = (destRect.x - offx) * this.scaleX + this.sourceOrigin.x;
        int sourceSY = (destRect.y - offy) * this.scaleY + this.sourceOrigin.y;
        int sourceEX = (destRect.width - 1) * this.scaleX + sourceSX;
        int sourceEY = (destRect.height - 1) * this.scaleY + sourceSY;
        int E2c = (this.size.xosize + this.xStep - 1) / this.xStep;
        int E1c = (this.size.yosize + this.yStep - 1) / this.yStep;
        int startXTile = ((sourceSX + E2c) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int endXTile = ((sourceEX + E2c) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int startYTile = ((sourceSY + E1c) * this.yStep - this.size.ytosize) / this.size.ytsize;
        int endYTile = ((sourceEY + E1c) * this.yStep - this.size.ytosize) / this.size.ytsize;
        startXTile = this.clip(startXTile, 0, this.size.nxtiles - 1);
        startYTile = this.clip(startYTile, 0, this.size.nytiles - 1);
        endXTile = this.clip(endXTile, 0, this.size.nxtiles - 1);
        endYTile = this.clip(endYTile, 0, this.size.nytiles - 1);
        int totalXTiles = endXTile - startXTile + 1;
        int totalYTiles = endYTile - startYTile + 1;
        int totalTiles = totalXTiles * totalYTiles;
        int[] pixbuf = null;
        for (int y = startYTile; y <= endYTile && !this.reader.getAbortRequest(); ++y) {
            for (int x = startXTile; x <= endXTile && !this.reader.getAbortRequest(); ++x) {
                int x1;
                int x2;
                int lineLength;
                float percentage = ((float)(x - startXTile) + 1.0f + (float)(y * totalXTiles)) / (float)totalTiles;
                int startX = (x * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - E2c;
                int startY = (y * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - E1c;
                int endX = ((x + 1) * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - E2c;
                int endY = ((y + 1) * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - E1c;
                this.rasForATile = this.rasForATile == null ? Raster.createWritableRaster(this.originalSampleModel, new Point(startX, startY)) : this.rasForATile.createWritableTranslatedChild(startX, startY);
                int tw = endX - startX;
                int th = endY - startY;
                WritableRaster targetRas = tw != this.tileWidth || th != this.tileHeight ? this.rasForATile.createWritableChild(startX, startY, tw, th, startX, startY, null) : this.rasForATile;
                int sourceFormatTag = MediaLibAccessor.findCompatibleTag(targetRas);
                MediaLibAccessor accessor = new MediaLibAccessor(targetRas, targetRas.getBounds().intersection(this.originalRegion), sourceFormatTag, true);
                mediaLibImage[] mlImage = accessor.getMediaLibImages();
                this.decoder.decode(mlImage, x + y * this.size.nxtiles);
                accessor.copyDataToRaster(this.channelMap);
                int cTileHeight = th;
                int cTileWidth = tw;
                if (startY + cTileHeight >= this.originalRegion.height) {
                    cTileHeight = this.originalRegion.height - startY;
                }
                if (startX + cTileWidth >= this.originalRegion.width) {
                    cTileWidth = this.originalRegion.width - startX;
                }
                int tx = startX;
                int ty = startY;
                if (sourceSX > startX) {
                    cTileWidth += startX - sourceSX;
                    tx = sourceSX;
                    startX = sourceSX;
                }
                if (sourceSY > startY) {
                    cTileHeight += startY - sourceSY;
                    ty = sourceSY;
                    startY = sourceSY;
                }
                if (sourceEX < startX + cTileWidth - 1) {
                    cTileWidth += sourceEX - startX - cTileWidth + 1;
                }
                if (sourceEY < startY + cTileHeight - 1) {
                    cTileHeight += sourceEY - startY - cTileHeight + 1;
                }
                if ((lineLength = (x2 = (startX + this.scaleX - 1 + cTileWidth - this.sourceOrigin.x) / this.scaleX) - (x1 = (startX + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX)) <= 0) continue;
                x2 = (x2 - 1) * this.scaleX + this.sourceOrigin.x;
                int y1 = (startY + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                startY = y1 * this.scaleY + this.sourceOrigin.y;
                startX = x1 * this.scaleX + this.sourceOrigin.x;
                x1 += offx;
                y1 += offy;
                if (pixbuf == null || pixbuf.length < lineLength) {
                    pixbuf = new int[lineLength];
                }
                int l = startY;
                int m = y1;
                while (l < ty + cTileHeight && !this.reader.getAbortRequest()) {
                    for (int i = 0; i < numBands; ++i) {
                        int j = lineLength - 1;
                        int k1 = x2;
                        while (j >= 0) {
                            pixbuf[j] = targetRas.getSample(k1, l, i);
                            --j;
                            k1 -= this.scaleX;
                        }
                        raster.setSamples(x1, m, lineLength, 1, this.destinationBands[i], pixbuf);
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, x1, m, cTileWidth, 1, 1, 1, this.destinationBands);
                    }
                    this.reader.processImageProgressWrapper(percentage + ((float)(l - startY) + 1.0f) / (float)cTileHeight / (float)totalTiles);
                    l += this.scaleY;
                    ++m;
                }
            }
        }
    }

    public void setDestImage(BufferedImage image) {
        this.destImage = image;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int x, int y) {
        int num = (y - this.getMinTileY()) * this.getNumXTiles() + x - this.getMinTileX();
        if (num < 0 || num >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        return num;
    }

    private int clip(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private SampleModel createSampleModel() throws IOException {
        int i;
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int maxDepth = 0;
        boolean isSigned = false;
        if (header != null) {
            maxDepth = header.getBitDepth();
            isSigned = (maxDepth & 0x80) > 0;
            maxDepth = (maxDepth & 0x7F) + 1;
        } else {
            CompParams compParam = new CompParams();
            for (int i2 = 0; i2 < this.size.csize; ++i2) {
                this.decoder.decodeCompParams(compParam, i2);
                maxDepth = (compParam.depth & 0x7F) + 1;
                isSigned = (compParam.depth & 0x80) > 0;
            }
        }
        BitsPerComponentBox bits = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (bits != null) {
            byte[] depths = bits.getBitDepth();
            maxDepth = (depths[0] & 0x7F) + 1;
            isSigned = (depths[0] & 0x80) > 0;
            for (i = 1; i < this.nComp; ++i) {
                if (maxDepth <= depths[this.sourceBands[i]]) continue;
                maxDepth = (depths[this.sourceBands[i]] & 0x7F) + 1;
            }
        }
        int[] bandOffsets = new int[this.nComp];
        for (i = 0; i < this.nComp; ++i) {
            bandOffsets[i] = i;
        }
        ChannelDefinitionBox cdb = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (cdb != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] assoc = cdb.getAssociation();
            short[] types = cdb.getTypes();
            short[] channels = cdb.getChannel();
            for (int i3 = 0; i3 < types.length; ++i3) {
                if (types[i3] == 0) {
                    bandOffsets[this.sourceBands[channels[i3]]] = assoc[i3] - 1;
                    continue;
                }
                if (types[i3] != 1 && types[i3] != 2) continue;
                bandOffsets[this.sourceBands[channels[i3]]] = channels[i3];
            }
        }
        return this.createSampleModel(this.nComp, maxDepth, bandOffsets, isSigned, this.tileWidth, this.tileHeight);
    }

    private SampleModel createOriginalSampleModel() throws IOException {
        int i;
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int maxDepth = 0;
        boolean isSigned = false;
        int nc = this.size.csize;
        if (header != null) {
            maxDepth = header.getBitDepth();
            isSigned = (maxDepth & 0x80) > 0;
            maxDepth = (maxDepth & 0x7F) + 1;
        } else {
            CompParams compParam = new CompParams();
            for (int i2 = 0; i2 < this.size.csize; ++i2) {
                this.decoder.decodeCompParams(compParam, i2);
                maxDepth = (compParam.depth & 0x7F) + 1;
                isSigned = (compParam.depth & 0x80) > 0;
            }
        }
        BitsPerComponentBox bits = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (bits != null) {
            byte[] depths = bits.getBitDepth();
            maxDepth = (depths[0] & 0x7F) + 1;
            isSigned = (depths[0] & 0x80) > 0;
            for (i = 1; i < nc; ++i) {
                if (maxDepth <= depths[i]) continue;
                maxDepth = (depths[i] & 0x7F) + 1;
            }
        }
        int[] bandOffsets = new int[nc];
        for (i = 0; i < nc; ++i) {
            bandOffsets[i] = i;
        }
        ChannelDefinitionBox cdb = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (cdb != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] assoc = cdb.getAssociation();
            short[] types = cdb.getTypes();
            short[] channels = cdb.getChannel();
            this.channelMap = new int[nc];
            for (int i3 = 0; i3 < types.length; ++i3) {
                if (types[i3] == 0) {
                    bandOffsets[channels[i3]] = assoc[i3] - 1;
                    this.channelMap[assoc[i3] - 1] = channels[i3];
                    continue;
                }
                if (types[i3] != 1 && types[i3] != 2) continue;
                bandOffsets[channels[i3]] = channels[i3];
                this.channelMap[channels[i3]] = channels[i3];
            }
        }
        return this.createSampleModel(nc, maxDepth, bandOffsets, isSigned, this.tileWidth, this.tileHeight);
    }

    private SampleModel createSampleModel(int nc, int maxDepth, int[] bandOffsets, boolean isSigned, int tw, int th) {
        SampleModel sm = null;
        if (nc == 1 && (maxDepth == 1 || maxDepth == 2 || maxDepth == 4)) {
            sm = new MultiPixelPackedSampleModel(0, tw, th, maxDepth);
        } else if (maxDepth <= 8) {
            sm = new PixelInterleavedSampleModel(0, tw, th, nc, tw * nc, bandOffsets);
        } else if (maxDepth <= 16) {
            sm = new PixelInterleavedSampleModel(isSigned ? 2 : 1, tw, th, nc, tw * nc, bandOffsets);
        } else if (maxDepth <= 32) {
            sm = new PixelInterleavedSampleModel(3, tw, th, this.nComp, tw * this.nComp, bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + maxDepth);
        }
        return sm;
    }

    private ColorModel createColorModel() throws IOException {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        PaletteBox pBox = (PaletteBox)this.metadata.getElement("JPEG2000PaletteBox");
        ChannelDefinitionBox cdef = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (pBox != null && this.nComp == 1) {
            byte[][] lut = pBox.getLUT();
            int numComp = pBox.getNumComp();
            int[] mapping = new int[numComp];
            for (int i = 0; i < numComp; ++i) {
                mapping[i] = i;
            }
            ComponentMappingBox cmap = (ComponentMappingBox)this.metadata.getElement("JPEG2000ComponentMappingBox");
            short[] comps = null;
            byte[] type = null;
            byte[] maps = null;
            if (cmap != null) {
                comps = cmap.getComponent();
                type = cmap.getComponentType();
                maps = cmap.getComponentAssociation();
            }
            if (comps != null) {
                for (int i = 0; i < numComp; ++i) {
                    if (type[i] != 1) continue;
                    mapping[i] = maps[i];
                }
            }
            if (numComp == 3) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), lut[0].length, lut[mapping[0]], lut[mapping[1]], lut[mapping[2]]);
            } else if (numComp == 4) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), lut[0].length, lut[mapping[0]], lut[mapping[1]], lut[mapping[2]], lut[mapping[3]]);
            }
        } else if (cdef != null) {
            HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
            int numComp = header.getNumComponents();
            byte bitDepth = header.getBitDepth();
            boolean hasAlpha = false;
            int alphaChannel = numComp - 1;
            short[] channels = cdef.getChannel();
            short[] cType = cdef.getTypes();
            short[] associations = cdef.getAssociation();
            for (int i = 0; i < channels.length; ++i) {
                if (cType[i] != 1 || channels[i] != alphaChannel) continue;
                hasAlpha = true;
            }
            boolean[] isPremultiplied = new boolean[]{false};
            if (hasAlpha) {
                int i;
                isPremultiplied = new boolean[alphaChannel];
                for (i = 0; i < alphaChannel; ++i) {
                    isPremultiplied[i] = false;
                }
                for (i = 0; i < channels.length; ++i) {
                    if (cType[i] != 2) continue;
                    isPremultiplied[associations[i] - 1] = true;
                }
                for (i = 1; i < alphaChannel; ++i) {
                    isPremultiplied[0] = isPremultiplied[0] & isPremultiplied[i];
                }
            }
            ColorSpecificationBox cBox = (ColorSpecificationBox)this.metadata.getElement("JPEG2000ColorSpecificationBox");
            ICC_Profile profile = null;
            int colorSpaceType = 0;
            if (cBox != null) {
                profile = cBox.getICCProfile();
                colorSpaceType = cBox.getEnumeratedColorSpace();
            }
            ColorSpace cs = null;
            if (profile != null) {
                cs = new ICC_ColorSpace(profile);
            } else if (colorSpaceType == 16) {
                cs = ColorSpace.getInstance(1000);
            } else if (colorSpaceType == 17) {
                cs = ColorSpace.getInstance(1003);
            } else if (colorSpaceType == 18) {
                cs = ColorSpace.getInstance(1002);
            }
            byte[] bitDepths = null;
            boolean isSigned = (bitDepth & 0x80) == 128;
            BitsPerComponentBox bitBox = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
            if (bitBox != null) {
                bitDepths = bitBox.getBitDepth();
            }
            int[] bits = new int[numComp];
            for (int i = 0; i < numComp; ++i) {
                bits[i] = bitDepths != null ? (bitDepths[i] & 0x7F) + 1 : (bitDepth & 0x7F) + 1;
            }
            int maxBitDepth = 1 + (bitDepth & 0x7F);
            if (bitDepths != null) {
                for (int i = 0; i < numComp; ++i) {
                    if (bits[i] <= maxBitDepth) continue;
                    maxBitDepth = bits[i];
                }
            }
            int type = -1;
            if (maxBitDepth <= 8) {
                type = 0;
            } else if (maxBitDepth <= 16) {
                type = isSigned ? 2 : 1;
            } else if (maxBitDepth <= 32) {
                type = 3;
            }
            if (type == -1) {
                return null;
            }
            if (cs != null) {
                this.colorModel = new ComponentColorModel(cs, bits, hasAlpha, isPremultiplied[0], hasAlpha ? 3 : 1, type);
            }
        }
        if (this.colorModel != null) {
            return this.colorModel;
        }
        return ImageUtil.createColorModel(null, this.getSampleModel());
    }

    public J2KMetadata readImageMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new J2KMetadata();
            com.sun.medialib.codec.jp2k.Box mlibBox = null;
            Box box = null;
            while ((mlibBox = this.decoder.decodeBox()) != null) {
                box = null;
                Class c = Box.getBoxClass(mlibBox.type);
                if (c != null) {
                    try {
                        Constructor cons = c.getConstructor(array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                        if (cons != null) {
                            box = (Box)cons.newInstance(new Object[]{mlibBox.data});
                        }
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor cons = c.getConstructor(Integer.TYPE, array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                            if (cons != null) {
                                box = (Box)cons.newInstance(new Integer(mlibBox.type), mlibBox.data);
                            }
                        }
                        catch (NoSuchMethodException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (InvocationTargetException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (IllegalAccessException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (InstantiationException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                    }
                    catch (InvocationTargetException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                    catch (IllegalAccessException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                    catch (InstantiationException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                } else if (mlibBox.data != null) {
                    box = this.createUnknowBox(mlibBox);
                }
                if (box == null) continue;
                this.metadata.addNode(box);
            }
        }
        return this.metadata;
    }

    private Box createUnknowBox(com.sun.medialib.codec.jp2k.Box mlibBox) {
        return new Box(8 + mlibBox.data.length, mlibBox.type, mlibBox.data);
    }
}

