/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CLibJPEGImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader";
    private static final String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi"};
    private boolean registered = false;

    public CLibJPEGImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            List list = ImageUtil.getJDKImageReaderWriterSPI(registry, "JPEG", true);
            for (int i = 0; i < list.size(); ++i) {
                registry.setOrdering(category, this, list.get(i));
            }
        }
    }

    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " natively-accelerated JPEG Image Reader";
        return desc;
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        int byte1 = iis.read();
        int byte2 = iis.read();
        if (byte1 != 255 || byte2 != 216) {
            iis.reset();
            return false;
        }
        block0: while (true) {
            byte1 = iis.read();
            byte2 = iis.read();
            if (byte1 != 255 || byte2 == 218) break;
            if (byte2 == 194) {
                iis.reset();
                return false;
            }
            if (byte2 >= 192 && byte2 <= 195) break;
            int length = iis.read() << 8;
            length += iis.read();
            length -= 2;
            while (true) {
                if (length <= 0) continue block0;
                length -= iis.skipBytes(length);
            }
            break;
        }
        iis.reset();
        return true;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new CLibJPEGImageReader(this);
    }
}

