/*
Copyright (C) GLI Interactive LLC 2007. Public domain.

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/
#ifndef __TRACKER_MOTIONNODE_H
#define __TRACKER_MOTIONNODE_H

#include "vrpn_Tracker.h"

#ifdef VRPN_USE_MOTIONNODE

class VRPN_API vrpn_Tracker_MotionNode : public vrpn_Tracker {
public:
   vrpn_Tracker_MotionNode(
     const char * name,
     vrpn_Connection * c,
     unsigned num_sensor,
     const char * address,
     unsigned port);
  ~vrpn_Tracker_MotionNode();

  virtual void mainloop();

private:
  unsigned m_num_sensor;
  /**
    Handle to our MotionNode SDK sampler. Actual type is
    ::MotionNode::SDK::Device::Sampler<> if not NULL.
  */
  void * m_handle;

  void get_report();
  void send_report();
}; // class MotionNode

#endif // VRPN_USE_MOTIONNODE

#endif // __TRACKER_MOTION_NODE_H
