
% Statistical Parametric Mapping - SPM8
% ______________________________________________________________________
% 
%  ___  ____  __  __
% / __)(  _ \(  \/  )  
% \__ \ )___/ )    (   Statistical Parametric Mapping
% (___/(__)  (_/\/\_)  SPM - http://www.fil.ion.ucl.ac.uk/spm/
%
% ______________________________________________________________________
%
%    Statistical Parametric Mapping refers to the construction and
%    assessment of spatially extended statistical process used to test
%    hypotheses about functional imaging data. These ideas have been 
%    instantiated in software that is called SPM.
%    The SPM software package has been designed for the analysis of 
%    brain imaging data sequences. The sequences can be a series of 
%    images from different cohorts, or time-series from the same 
%    subject. The current release is designed for the analysis of
%    fMRI, PET, SPECT, EEG and MEG.
%
%                           ----------------
%
% Please refer to this version as "SPM8" in papers and communications.
%
%                           ----------------
%
% ======================================================================
%                  S P M   -   T h e   s o f t w a r e
% ======================================================================
%
% SPM was written to organise and interpret our data (at the Wellcome
% Trust Centre for Neuroimaging). The distributed version is the same as
% that we use ourselves.
%
% SPM is made freely available to the [neuro]imaging community, to
% promote collaboration and a common analysis scheme across laboratories.
% 
% ______________________________________________________________________
%                                                                Authors
%
% SPM is developed under the auspices of Functional Imaging Laboratory
% (FIL), The Wellcome Trust Centre for NeuroImaging, in the Institute of
% Neurology at University College London (UCL), UK.
%
% SPM94 was written primarily by Karl Friston in the first half of
% 1994, with assistance from John Ashburner (MRC-CU), Jon Heather
% (WDoIN), and Andrew Holmes (Department of Statistics, University of
% Glasgow). Subsequent development, under the direction of Prof. Karl
% Friston at the Wellcome Department of Imaging Neuroscience, has
% benefited from substantial input (technical and theoretical) from:
% John Ashburner (WDoIN), Andrew Holmes (WDoIN & Robertson Centre for
% Biostatistics, University of Glasgow, Scotland), Jean-Baptiste Poline
% (WDoIN & CEA/DRM/SHFJ, Orsay, France), Christian Buechel (WDoIN),
% Matthew Brett (MRC-CBU, Cambridge, England), Chloe Hutton (WDoIN) and
% Keith Worsley (Department of Statistics, McGill University, Montreal,
% Canada).
%
% SPM8 was developed by: John Ashburner, Chun-Chuan Chen, Justin 
% Chumbley, Jean Daunizeau, Guillaume Flandin, Karl Friston, Darren
% Gitelman, Volkmar Glauche, Lee Harrison, Rik Henson, Chloe Hutton, 
% Maria Joao Rosa, Stefan Kiebel, James Kilner, Vladimir Litvak, Robert 
% Oostenveld, Will Penny, Christophe Phillips, and Klaas Enno Stephan. 
% Theoretical inputs were provided by Carlton Chu, Ferath Kherif, 
% Andre Marreiros, Jeremie Mattout, Rosalyn Moran, Tom Nichols, Keith 
% Worsley and loads of other people.
% We would like to thank everyone who has provided feedback on SPM.
%
% ______________________________________________________________________
%                                                              Resources
% 
% The SPMweb site is the central repository for SPM resources:
%                  http://www.fil.ion.ucl.ac.uk/spm/
% Introductory material, installation details, documentation, course
% details and patches are published on the site.
%
% There is an SPM eMail discussion list, hosted at 
% <spm@jiscmail.ac.uk>.  The list is monitored by the authors, and
% discusses theoretical, methodological and practical issues of
% Statistical Parametric Mapping and SPM. The SPMweb site has further 
% details:
%                  http://www.fil.ion.ucl.ac.uk/spm/support/
% 
%                           ----------------
%
% In order to use the advanced spatial, statistical modelling and
% inference tools of SPM, it is vital to have at least a conceptual
% understanding of the theoretical underpinnings. Therefore, we
% recommend the theoretical articles published in the peer reviewed
% literature, and the SPMcourse notes (available from the SPMweb site).
%
%                           ----------------
%
% Please report bugs to the authors at <fil.spm@ucl.ac.uk>
% Peculiarities may actually be features, and should be raised on the
% SPM eMail discussion list, <spm@jiscmail.ac.uk>.
% ______________________________________________________________________
%                                                   The SPM distribution
%
% The SPM software is a suite of MATLAB functions, scripts and data
% files, with some externally compiled C routines, implementing
% Statistical Parametric Mapping. MATLAB, a commercial engineering
% mathematics package, is required to use SPM. MATLAB is produced by The
% MathWorks, Inc.  Natick, MA, USA. http://www.mathworks.com/
% eMail:info@mathworks.com. SPM requires only core MATLAB to run (no
% special toolboxes are required).
% 
% SPM8 is written for MATLAB version 7.1 onwards under Windows and UNIX.
% (SPM8 will not work with versions of MATLAB prior to 7.1 (R14SP3)).
% Binaries of the external C-mex routines are provided for Windows, Linux 
% and Mac. Users of other UNIX platforms need an ANSI C compiler to 
% compile the supplied C source (Makefile provided). 
% See http://www.fil.ion.ucl.ac.uk/spm/software/spm8/ for details.
% 
% Later versions of MATLAB (released after SPM8), will probably
% need additional patches in order to run.  Once developed, these will 
% be made available from:
%      ftp://ftp.fil.ion.ucl.ac.uk/spm/spm8_updates/ 
% 
% With the compiled c-mex files in place, simply prepend the SPM
% directory to your MATLAB path to complete the installation. (Type `help
% path` in matlab for information on the MATLAB path.)
% ______________________________________________________________________
%                                                  Copyright & licencing
% 
% SPM (being the collection of files given in the manifest in the
% Contents.m file) is free but copyright software, distributed under
% the terms of the GNU General Public Licence as published by the Free
% Software Foundation (either version 2, as given in file
% spm_LICENCE.man, or at your option, any later version). Further
% details on "copyleft" can be found at http://www.gnu.org/copyleft/.
%
% SPM is supplied as is. 
% No formal support or maintenance is provided or implied.
%
%__________________________________________________________________________
% Copyright (C) 1991,1994-2013 Wellcome Trust Centre for Neuroimaging

% The FIL Methods Group
% $Id: spm.man 5187 2013-01-17 12:10:06Z guillaume $

