C Modified 1996-1999 by Charles Peterson, SFBR.
C
      SUBROUTINE SEARCH(CNSTR,CVALUE,DELTA,DF,DFOLD,EXTRA,GRID,HESS
     1,INFORM,KIN2,OMEGA,PAR,PARINC,PARMAX,PARMIN,PAROLD,QDERIV,SCORE
     2,TABLE,UNIFRM,VAR,VMEAN,VVAR,WORK1,WORK2,DEGREE,DEPVAR,FATHER
     3,GROUP,MOTHER,NSWEEP,PERSON,PNAME,DP,PEDCUT,PERCUT,MAXPAR
     4,MAXPEO,MAXTAB,MAXVAR,MCNSTR,MOMEGA,MWORK,MXITER,MXSTEP,NCNSTR
     5,NCONV,NEXTRA,NPAR,NPED,NPOINT,NSAMP,NTRAIT,NVAR,PROBLM,UNIT2
     6,UNIT3,TRAVEL,ASYCV,DIAG,NORMAL,OUTLIE,STAND,MODFIL,UNIT4
     7,IBIG,ITER,LAST,INASYC,LOGLIK,QDFORM,PSCORE,PNPEO,SCOVAR,ROBUST
     8,IPVT,CONOUT,VMIN,VMAX,VERBOSITY,STATUS,PAREST,UPDFIL,IROBST
     9,TOL,PSCMEAN,SCORINDX,RAWSD,RAWMU,BIG,IDISCQ)
C
C                    COPYRIGHT 1984 BY KENNETH LANGE.
C     DO NOT DISTRIBUTE EXCEPT BY THE EXPRESS PERMISSION OF THE AUTHOR.
C
C     THIS SUBROUTINE COMPUTES THE CONSTRAINED MINIMUM OF A FUNCTION F
C     BY THE VARIABLE METRIC METHOD OF BIGGS, HAN, AND POWELL.  SEE:
C     M.J.D. POWELL(1978) "A FAST ALGORITHM FOR NONLINEARLY CONSTRAINED
C     OPTIMIZATION CALCULATIONS."  PROCEEDINGS OF THE 1977 DUNDEE
C     CONFERENCE ON NUMERICAL ANALYSIS. G.A. WATSON EDITOR. SPRINGER-VERLAG.
C     IN THE LIST BELOW ITEMS MARKED BY * OR ** MUST BE PROVIDED BY THE USER.
C     ITEMS MARKED BY ** SHOULD BE INITIALIZED IN THE SUBROUTINE INITAL.
C
C     CNSTR**          MATRIX OF LINEAR EQUALITY CONSTRAINTS
C     CVALUE**         CONSTANTS FOR PARAMETER/CONSTRAINT INNER PRODUCTS
C     DELTA            UPDATE DIRECTION FOR PARAMETERS
C     DF               CURRENT DIFFERENTIAL OF THE FUNCTION F
C     DFOLD            PREVIOUS DIFFERENTIAL OF THE FUNCTION F
C     GRID**           GRID OF POINTS TO EVALUATE F ON
C     HESS             CURRENT APPROXIMATE HESSIAN OF F
C     PAR**            CURRENT PARAMETERS
C     PARMAX,PARMIN**  PARAMETER MAXIMA AND MINIMA
C     PAROLD           PREVIOUS PARAMETERS
C     TABLE            TABLEAU FOR QUADRATIC PROGRAMMING PROBLEM
C     WORK1,WORK2      WORK VECTORS
C     NSWEEP           INDICATOR FOR WHICH PARAMETERS HAVE BEEN SWEPT
C                        IN TABLE
C     PNAME**          PARAMETER NAMES
C     CONV*            CONVERGENCE CRITERION FOR CHANGE IN F
C     DP*              NUMERICAL DIFFERENTIATION INTERVAL
C     SMALL*           SMALL POSITIVE NUMBER FOR CHECKING BOUNDS
C     TOL*             TOLERANCE FOR MATRIX SWEEPING
C     MAXPAR*          MAXIMUM(NPAR,1)
C     MAXTAB*          NCNSTR+NPAR+1
C     MCNSTR*          MAXIMUM(NCNSTR,1)
C     MXITER*          MAXIMUM NUMBER OF ITERATIONS
C     MXSTEP*          MAXIMUM NUMBER OF STEPS PER ITERATION
C     NCONV*           NUMBER OF TIMES CONVERGENCE CRITERION MUST BE MET
C     NCNSTR*          NUMBER OF LINEAR EQUALITY CONSTRAINTS
C     NPAR*            NUMBER OF PARAMETERS
C     NPOINT*          NUMBER OF POINTS FOR 'GRID' OPTION
C     UNIT3            OUTPUT UNIT NUMBER
C     TRAVEL*          'SEARCH' OR 'GRID' OPTION
C     ASYCV*           TRUE WHEN ASYMPTOTIC COVARIANCE MATRIX DESIRED
C     EXACT*           TRUE WHEN EXACT DIFFERENTIAL AVAILABLE
C     VMIN             MINIMUM VALUE OF PED VARIABLE (charlesp)
C     VMAX             MAXIMUM VALUE OF PED VARIABLE (charlesp)
C     IDISCQ           Analyzing discrete trait quantitatively (charlesp)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR)
     1,DELTA(MAXPAR),DF(MAXPAR),DFOLD(MAXPAR),EXTRA(NEXTRA)
     2,GRID(NPOINT,MAXPAR),HESS(MAXPAR,MAXPAR),INFORM(MAXPAR,MAXPAR)
     3,KIN2(MAXPEO),OMEGA(MOMEGA,MOMEGA),PAR(MAXPAR),PARINC(MAXPAR)
     4,PARMAX(MAXPAR),PARMIN(MAXPAR),PAROLD(MAXPAR),QDERIV(MAXPAR)
     5,SCORE(MAXPAR),TABLE(MAXTAB,MAXTAB),UNIFRM(NPED),VAR(MAXVAR)
     6,VMEAN(NVAR),VVAR(NVAR),WORK1(MAXPAR),WORK2(MWORK),LOGLIK
     7,PSCORE(NPED+1,MAXPAR),SCOVAR(MAXPAR,MAXPAR),ROBUST(MAXPAR,MAXPAR)
     8,VMIN(NVAR),VMAX(NVAR),PAREST(MAXPAR),PSCMEAN(MAXPAR),TOL,RAWSD
     9,RAWMU,BIG,WQDFORM,ENFORCEB,ENFORCEC
      DOUBLE PRECISION PARPENT(NPAR)

      INTEGER DEGREE(NPED),DEPVAR(NTRAIT),FATHER(MAXPEO),GROUP(MAXPEO)
     1,MOTHER(MAXPEO),NSWEEP(MAXPAR),PERSON(MAXPEO),PROBLM
     2,UNIT2,UNIT3,UNIT4,IBIG,ITER,LAST,PNPEO(NPED),IPVT(MAXPAR),CONOUT
     3,VERBOSITY,STATUS,IERROR,SCORINDX,GETVIRT,NVTRAIT,IDISCQ,ISNAN_F
     4,PED

      CHARACTER PNAME(MAXPAR)*(*),TRAVEL*8,MODFIL*40,UPDFIL*(*)
      LOGICAL ASYCV,DIAG,NORMAL,OUTLIE,STAND,INASYC,IROBST,VERBOSE

C     Please declare local variables only after this line

      DOUBLE PRECISION DET(2)
      INTEGER SEED,NewRandom
      LOGICAL EXACT,FORWRD,WEIGHT,SCNEG,DISCRETE,VSUB,VNUM
C
C     INITIALIZE SOME CONSTANTS USED IN SUBROUTINE SEARCH.
C
      SAVE SMALL,SEED,EXACT,DISCRETE
      DATA SMALL,SEED,EXACT,DISCRETE/1.0D-12,5431,.FALSE.,.FALSE./
      CONV=QDERIV(1)
C
C     INITIALIZE THE PARAMETER VALUES, THEIR BOUNDS, THEIR CONSTRAINTS,
C     AND THEIR NAMES.

      VSUB = VERBOSE ('SUBITER')
      VNUM = VERBOSE ('NUMERICAL')
      WRITE (UNIT3,1)
      IF (VERBOSE('ITERATE')) WRITE (CONOUT,1)
 1    FORMAT(/
     1,'                    Using SOLAR Quantitative Trait Modeling')

      IF (IDISCQ.EQ.1) THEN
         WRITE (UNIT3,2)
         IF (VERBOSE('ITERATE')) WRITE (CONOUT,2)
 2       FORMAT (/T10,'WARNING!  You are analyzing a discrete trait as'
     *,' quantitative!'/T10,'See help discrete-notes for discussion.')
      END IF

C Check for special options

      CALL DOPTION ('EnforceBounds',ENFORCEB)
      CALL DOPTION ('EnforceConstraints',ENFORCEC)
      CALL IOPTION ('ResetRandom',NewRandom);

C Reset random seed if requested

      if (NewRandom.gt.0) then
         SEED = 5431
      endif

C Use nvtrait when computing normalized quadratic
C It reflects the actual number of traits, virtual or not

      NVTRAIT=GETVIRT()
      IF (NVTRAIT.EQ.0) THEN
         NVTRAIT=NTRAIT
      ENDIF

C  These assignments force an error if arrays allocated improperly
      PERSON(MAXPEO) = 0
      PSCMEAN(MAXPAR) = 0

      IF (NPAR.GT.0) THEN
      DO 10 I=1,NPAR
      PAR(I)=1.0D-6
      PARMAX(I)=1.0D20
      PARMIN(I)=-1.0D20
      WRITE(PNAME(I),'(I6)') I
      PNAME(I)(2:4)='PAR'
      DO 20 J=1,NPAR
 20   HESS(I,J)=0.0D0
 10   HESS(I,I)=1.0D0
      DO 30 I=1,NCNSTR
      CVALUE(I)=0.0D0
      DO 30 J=1,NPAR
 30   CNSTR(I,J)=0.0D0
      CALL INITAL(CNSTR,CVALUE,PAR,PARMAX,PARMIN,VMEAN,VVAR,PNAME
     1,MCNSTR,NPAR,NTRAIT,NVAR,UNIT3,VMIN,VMAX,CONOUT,PAREST,IERROR)
      IF (IERROR.NE.0) THEN
         STATUS = 1
         RETURN
      END IF
      END IF
C
C     COMPUTE FUNCTION VALUES OVER A USER DEFINED GRID OF POINTS.
C
      IF (TRAVEL(1:4).EQ.'GRID') THEN
      LAST=NPOINT
      NPASS=1
      DO 40 ITER=1,NPOINT
      DO 50 J=1,NPAR
 50   PAR(J)=GRID(ITER,J)
      CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,QDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)
      CALL SCOR(DF,SCORE,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
      CALL OUTPUT(PAR,PNAME,LOGLIK,(QDFORM/(NSAMP*NVTRAIT)),ITER,LAST
     1,NPAR,0,UNIT3,STAND,IBIG,CONOUT,DISCRETE,BIG)

C  NaN Handling Test
C     F = 0.0 / 0.0
C  End test

      IF (1.EQ.ISNAN_F (F)) THEN
         STATUS = 6
         RETURN
      END IF
 40   CONTINUE
C
C     OTHERWISE SEARCH THE FUNCTION SURFACE.  FIRST CALL PREOPT
C     TO CHECK THAT THE PARAMETERS SATISFY THEIR BOUNDS AND THEIR
C     LINEAR EQUALITY CONSTRAINTS.  PREOPT ALSO CHECKS THAT THE
C     CONSTRAINTS ARE NOT REDUNDANT.  IF ANY OF THESE CHECKS FAIL,
C     THEN return with error status.
C
      ELSE
      CALL PREOPT(CNSTR,CVALUE,PAR,PARMAX,PARMIN,TABLE,WORK2
     1,PNAME,CNORM,TOL,IERROR,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR
     2,UNIT3,TRAVEL,CONOUT)
      IF (IERROR.GE.1) THEN
         STATUS = 1
         RETURN
      ENDIF
C
C     INITIALIZE SOME VARIABLES.
C
      ITER=1
      LAST=MXITER
      NPASS=2
      NCRIT=0
      FORWRD=.TRUE.
C
C     COMPUTE THE INITIAL FUNCTION VALUE AND DIFFERENTIAL, AND OUTPUT
C     THE FIRST ITERATION.
C
      CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,QDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)
      CALL SCOR(DF,SCORE,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
      CALL OUTPUT(PAR,PNAME,LOGLIK,(QDFORM/(NSAMP*NVTRAIT)),1,LAST
     1,NPAR,0,UNIT3,STAND,IBIG,CONOUT,DISCRETE,BIG)

C  NaN Handling Test
C      F = 0.0 / 0.0
C  End test

      IF (1.EQ.ISNAN_F (F)) THEN
         STATUS = 6
         RETURN
      END IF
C
C     ENTER THE MAIN ITERATION LOOP.
C
      IF (MXITER.GT.1) THEN
      DO 60 ITER=2,MXITER
C
C     CREATE THE TABLEAU FOR THE QUADRATIC PROGRAMMING PROBLEM.
C
 90   CALL SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)
C
C     SOLVE THE QUADRATIC PROGRAMMING PROBLEM FOR THE NEXT 
C     STEP DIRECTION DELTA.
C
      CALL QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2,NSWEEP
     1,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,NTAB)
C
C     CHECK THAT THE EQUALITY CONSTRAINTS ARE SATISFIED 
C     IF NOT, DERIVATIVES IN TABLEAU HAVE EXCEEDED NUMERICAL LIMITS
C     SO RESET THE HESSIAN (BELOW) AND TRY AGAIN
C
      IF (ENFORCEC.EQ.1D0) THEN
         DO 99 I=1,NCNSTR
            S=CVALUE(I)
            DO 101 J=1,NPAR
 101        S=S-CNSTR(I,J)*(PAR(J)+DELTA(J))
            IF (ABS(S).GT.1.0D-4) THEN
               NCYCLE=0
            END IF
 99      CONTINUE
      END IF
C
C     IF NCYCLE IS NEGATIVE, THE QUADRATIC PROGRAMMING PROBLEM IS
C     SOLVED.  IF NCYCLE IS ZERO, IT IS IMPOSSIBLE TO ADEQUATELY
C     SWEEP THE TABLEAU.  IF NCYCLE IS POSITIVE, THERE IS A
C     POSSIBLE INFINITE LOOP IN THE QUADRATIC PROGRAMMING ALGORITHM.
C     IN EITHER 0F THE LAST TWO CASES, RESET THE HESSIAN AND TRY AGAIN.
C
      IF (NCYCLE.GE.0) THEN
      HMIN=1.0D20
      DO 70 J=1,NPAR
 70   IF (HESS(J,J).GT.0.0D0) HMIN=MIN(HMIN,HESS(J,J))
      DO 80 J=1,NPAR
 80   HESS(J,J)=MAX(HESS(J,J),HMIN)*(1.0D0+RANDOM(SEED))
      GO TO 90
      END IF
C
C     COMPUTE THE INNER PRODUCT D OF DELTA AND THE DIFFERENTIAL DF.
C     IF D IS POSITIVE, THEN DELTA IS NOT A DESCENT DIRECTION.
C     CONVERGENCE HAS OCCURRED, OR THE SEARCH IS IN DEEP TROUBLE.
C
      D=0.0D0
      DO 100 J=1,NPAR
 100  D=D+DF(J)*DELTA(J)
C
C     WHEN THE DIFFERENTIAL IS COMPUTED NUMERICALLY, CHANGE FROM
C     FORWARD DIFFERENCES TO CENTRAL DIFFERENCES AND VICE VERSA
C     BASED ON THE QUANTITY D.  REDO THE QUADRATIC PROGRAMMING
C     PROBLEM IF NECESSARY.
C
      IF (.NOT.EXACT) THEN
      IF (FORWRD.AND.D.GE.0.0D0) THEN
      FORWRD=.FALSE.
      CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,QDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)
      GO TO 90
      END IF
      FORWRD=D.LE.-CONV
      END IF
C
C     ENTER THE STEP DECREMENTING LOOP.  T IS THE FRACTION OF DELTA
C     TAKEN.
C
      T=1.0D0
      NSTEP=0
      D=MIN(D,0.0D0)
C
C     RECORD THE OLD DATA IN PREPARATION FOR THE NEXT STEP.
C
      FOLD=F
      DO 110 J=1,NPAR
      PARPENT(J)=PAROLD(J)
      PAROLD(J)=PAR(J)
      DFOLD(J)=DF(J)
 110  CONTINUE

C
C     COMPUTE A NEW POINT AND A NEW FUNCTION VALUE.
C
 130  DO 120 J=1,NPAR
         PAR(J)=PAROLD(J)+T*DELTA(J)
         IF (ENFORCEB.NE.0D0) THEN
         IF (PAR(J).GT.PARMAX(J)) THEN
            PAR(J)=PARMAX(J)
            IF (VNUM) PRINT *,'Adjusted down PAR(',I,')'
         ELSE IF (PAR(J).LT.PARMIN(J)) THEN
            PAR(J)=PARMIN(J)
            IF (VNUM) PRINT *,'Adjusted up PAR(',I,')'
         END IF
         END IF
 120  CONTINUE

      CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,QDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)

C Detect and handle NaN appropriately

C Test NaN Handling
C     Test numbers 2-4 in the following
C     IF (ITER.EQ.2) F = 0.0 / 0.0
C End Tests Section

      IF (1.0.EQ.ISNAN_F(F)) THEN
         IF (NSTEP.LT.MXSTEP) THEN
            T=0.1D0*T
            NSTEP=NSTEP+1
            GO TO 130
         ELSE
C Report results, then resume NaN handling by salvaging "best"
C parameters and returning with restartable status
            GO TO 131
         ENDIF
      ENDIF
C
C     IF THERE IS NOT A SUFFICIENT DECREASE IN F, THEN TRY TO
C     FIND A BETTER POINT ALONG THE DIRECTION DELTA.  COMPUTE
C     THE MINIMUM POINT FOR THE QUADRATIC IN T WHICH PASSES
C     THROUGH FOLD AND F AND HAS SLOPE D AT T=0.  IF THIS
C     MINIMUM IS TOO CLOSE TO 0, DECREMENT T BY ONLY 90 PER CENT.
C
      IF (F.GT.FOLD+0.1D0*T*D.AND.NSTEP.LT.MXSTEP) THEN
      T1=-0.5D0*D*T*T/(F-FOLD-T*D)
      IF (VSUB) print *,'T1,D,T,F,FOLD: ',T1,D,T,F,FOLD
      T2=0.1D0*T
      T=MAX(T1,T2)
      NSTEP=NSTEP+1
      GO TO 130
      END IF
C
C     QUIT WHEN THERE IS A SUFFICIENT DECREASE IN F OR TOO
C     MANY STEPS.  CHECK THE CONVERGENCE CRITERION.  IF IT HAS
C     BEEN SATISFIED NCONV TIMES, THEN EXIT THE MAIN LOOP.
C     OTHERWISE, OUTPUT THE CURRENT ITERATION.
C
      IF (ABS(FOLD-F).GT.CONV) NCRIT=-1
      NCRIT=NCRIT+1
      IF (NCRIT.GE.NCONV) GO TO 140
 131  CALL SCOR(DF,SCORE,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
      CALL OUTPUT(PAR,PNAME,LOGLIK,(QDFORM/(NSAMP*NVTRAIT)),ITER,LAST
     1,NPAR,NSTEP,UNIT3,STAND,IBIG,CONOUT,DISCRETE,BIG)
C
C Finish off handling NaN that couldn't be repaired
C
      IF (1.EQ.ISNAN_F (F)) THEN
         IF (ITER.LE.2) THEN
C
C For iteration two, PAROLD has starting values
C   which is the best we can do
            
            WRITE (UNIT3,134) 1
            WRITE (UNIT4,134) 1
            IF (VERBOSE('ITERATE')) WRITE (CONOUT,134) 1

            DO 132 I=1,NPAR
               PAR(I) = PAROLD(I)
 132        CONTINUE
C
C For higher iterations, we go back one iteration to get out of this
C   Apparently untenable position
C
         ELSE
            WRITE (UNIT3,134) ITER - 2
            WRITE (UNIT4,134) ITER - 2
            IF (VERBOSE('ITERATE')) WRITE (CONOUT,134) ITER - 2
            
            DO 133 I = 1, NPAR
               PAR(I) = PARPENT(I)
 133        CONTINUE
         ENDIF
C
C Return status 7, which is considered "restartable"
C   Since we have restored parameters which do not cause NaN
C
         STATUS = 7
         RETURN
      END IF
 134  FORMAT (/'    **  Restoring parameters from iteration',I4)
C
C     RESET DELTA SO THAT IT IS THE ACTUAL STEP TAKEN.
C
      DO 150 J=1,NPAR
 150  DELTA(J)=T*DELTA(J)
C
C     PREPARE TO UPDATE THE HESSIAN.  STORE IN WORK1 THE
C     PRODUCT HESS*DELTA.  WORK1 APPROXIMATES THE DIFFERENCE
C     IN DIFFERENTIALS DF-DFOLD.  STORE IN C1 AND C2 THE 
C     INNER PRODUCT OF THESE TWO VECTORS WITH DELTA.
C
      C1=0.0D0
      DO 160 J=1,NPAR
      S=0.0D0
      DO 170 K=1,NPAR
 170  S=S+HESS(J,K)*DELTA(K)
      WORK1(J)=S
 160  C1=C1+DELTA(J)*S
      C2=0.0D0
      DO 180 J=1,NPAR
 180  C2=C2+(DF(J)-DFOLD(J))*DELTA(J)
C
C     IF C2 IS TOO SMALL, BIAS DF-DFOLD BY TAKING A CONVEX
C     COMBINATION WITH WORK1.  STORE THE RESUTING VECTOR
C     IN WORK2.  ITS INNER PRODUCT WITH DELTA WILL BE C4.
C
      IF (C1.GT.0.0D0) THEN
      IF (C2.GT.0.2D0*C1) THEN
      C3=1.0D0
      ELSE
      C3=0.8D0*C1/(C1-C2)
      END IF
      DO 190 J=1,NPAR
 190  WORK2(J)=C3*(DF(J)-DFOLD(J))+(1.0D0-C3)*WORK1(J)
      C4=C3*C2+(1.0D0-C3)*C1
C
C     NOW RESET THE HESSIAN USING THE RANK TWO BFGS UPDATE.
C
      DO 200 J=1,NPAR
      DO 200 K=1,NPAR
 200  HESS(J,K)=HESS(J,K)-WORK1(J)*WORK1(K)/C1+WORK2(J)*WORK2(K)/C4
      END IF
C      CALL UPDATEMOD(CNSTR,CVALUE,EXTRA,GRID,PAR,PARMAX,PARMIN,VMEAN
C     1,VVAR,PNAME,MCNSTR,NEXTRA,NPAR,NPOINT,NSAMP,NTRAIT,NVAR,PROBLM
C     2,UNIT3,TRAVEL,NORMAL,UPDFIL)
 60   CONTINUE
      IF (MXITER.GT.1) THEN
         WRITE (CONOUT, 905) MXITER
         WRITE (UNIT3, 905) MXITER
         WRITE (UNIT4, 905) MXITER
 905     FORMAT (/,'    *** No convergence within ',I6,' iterations!')
         STATUS=5
         RETURN
      ENDIF

      RETURN
      END IF
C
C     CONVERGENCE HAS OCCURRED.  OUTPUT THE LAST ITERATION
C
 140  IF (ITER.NE.MXITER) THEN
      CALL SCOR(DF,SCORE,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
      CALL OUTPUT(PAR,PNAME,LOGLIK,(QDFORM/(NSAMP*NVTRAIT)),ITER,ITER
     1,NPAR,NSTEP,UNIT3,STAND,IBIG,CONOUT,DISCRETE,BIG)

C  NaN Handling Test
C     F = 0.0 / 0.0
C  End test

      IF (1.EQ.ISNAN_F (F)) THEN
         STATUS = 6
         RETURN
      END IF
      END IF
C
C  Output the final .upd file
C
C      CALL UPDATEMOD(CNSTR,CVALUE,EXTRA,GRID,PAR,PARMAX,PARMIN,VMEAN
C     1,VVAR,PNAME,MCNSTR,NEXTRA,NPAR,NPOINT,NSAMP,NTRAIT,NVAR,PROBLM
C     2,UNIT3,TRAVEL,NORMAL,UPDFIL)
C
C     IF THE ASYMPTOTIC COVARIANCE MATRIX IS DESIRED, THEN RECOMPUTE
C     THE HESSIAN AND CALL ASYCOV.  USE CENTRAL DIFFERENCES FOR THE
C     FIRST PARTIALS AND FORWARD DIFFERENCES FOR THE SECOND PARTIALS.
C     ADJUST THE DIFFERENTIATION INTERVAL FOR THE SECOND PARTIALS.
C
      WQDFORM=QDFORM
      IF (ASYCV) THEN

         IF (VERBOSE ("ITERATE")) WRITE (CONOUT,907)
 907     FORMAT(/T20
     *,'Computing Standard Errors (a misc option)...')

      IF (.NOT.EXACT) THEN
      DP23=DP**0.66667D0
      IF (FORWRD) THEN
      FORWRD=.FALSE.
      CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,WQDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)
      END IF
      ELSE
      DP23=DP
      END IF
C
C     COMPUTE THE SECOND PARTIALS
C
      DO 210 J=1,NPAR
      IF (PAR(J).LE.PARMIN(J)+SMALL.OR.PAR(J).GE.PARMAX(J)-SMALL) THEN
      NSWEEP(J)=0
      ELSE
      NSWEEP(J)=1
      DPJ=DP23*MAX(ABS(PAR(J)),1.0D0)
      PAR(J)=PAR(J)+DPJ
      CALL FUN(WORK1,DFOLD,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,WQDFORM,PEDCUT,PERCUT,TOL,ITER,0,MAXPAR,MAXPEO
     3,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR,UNIT2
     4,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD,RAWMU)
      PAR(J)=PAR(J)-DPJ
      END IF
      DO 220 I=1,J
      IF (NSWEEP(I).EQ.0.OR.NSWEEP(J).EQ.0) THEN
      HESS(I,J)=0.0D0
      ELSE
      HESS(I,J)=(DFOLD(I)-DF(I))/DPJ
      END IF
 220  HESS(J,I)=HESS(I,J)
 210  CONTINUE
C
C     Sum the pedigree scores
C
      DO I = 1, NPAR
        PSCORE(NPED+1,I) = 0
        DO PED = 1, NPED
            PSCORE(NPED+1,I) = PSCORE(NPED+1,I) + PSCORE(PED,I)
        ENDDO
      ENDDO
C
C     If only SCORE is needed, bail now if score is negative
C       (bypassing ASYCOV)
C
      IF (SCORINDX.GT.0) THEN
         IF (PSCORE(NPED+1,SCORINDX).LE.0.0D0) THEN
            STATUS = 4
            RETURN
         END IF
      END IF
C
C     Call ASYCOV on second partials
C
      CALL ASYCOV(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK1,WORK2
     1,NSWEEP,PNAME,CNORM,SMALL,TOL,MAXPAR,MAXTAB,MCNSTR,NCNSTR
     2,NPAR,UNIT3,INASYC,UNIT4,CONOUT)
C
C     Sum the number of individuals with data
C
      NPEO = 0
      DO PED = 1, NPED
        NPEO = NPEO + PNPEO(PED)
      ENDDO

C  The following (until almost the end) is for
C  Robust Standard Error only.

      IF (IROBST) THEN
      WEIGHT = .FALSE.
C
C     Build the information matrix with estimated parameters
C     only.  (The matrix HESS contains -1 times the Hessian!)
C
      NEP = 0
      DO I = 1, NPAR
        IF (WORK2(I) .NE. 0) THEN
          NEP = NEP + 1
          JJ = 0
          DO J = 1, NPAR
            IF (WORK2(J) .NE. 0) THEN
              JJ = JJ + 1
              HESS(NEP,JJ) = HESS(I,J)
            ENDIF
          ENDDO
          DO PED = 1, NPED+1
            PSCORE(PED,NEP) = PSCORE(PED,I)
          ENDDO
        ENDIF
      ENDDO
C
C     Invert the information matrix.  The resulting matrix is
C     the usual variance-covariance matrix.
C
      CALL dgefa(HESS,MAXPAR,NEP,IPVT,INFO)
      IF (INFO .NE. 0) THEN
 901     FORMAT (/T26
     1,'Hessian matrix is singular!')
 902     FORMAT (T26,'Unable to compute scores!'/)
         WRITE (CONOUT, 901) 
         WRITE (UNIT3, 901)
         WRITE (UNIT4, 901)
         WRITE (CONOUT, 902) 
         WRITE (UNIT3, 902)
         WRITE (UNIT4, 902)
         STATUS = 2
         RETURN
      ENDIF
      CALL dgedi(HESS,MAXPAR,NEP,IPVT,DET,INFORM,1)
C
C     Compute the sample covariance matrix of the scores.
C
      IF (WEIGHT) THEN
        DO PED=1, NPED
          DO J=1, NEP 
            PSCMEAN(J)=PSCMEAN(J)+PNPEO(PED)*PSCORE(PED,J)/NPEO
          ENDDO
        ENDDO
      ENDIF
      DO I = 1, NEP
        DO J = 1, NEP
          SCOVAR(I,J) = 0
          DO PED = 1, NPED
            IF (WEIGHT) THEN
               SCOVAR(I,J) = SCOVAR(I,J) + PNPEO(PED) *
     &                       (PSCORE(PED,I) - PSCMEAN(I)) *
     &                       (PSCORE(PED,J) - PSCMEAN(J))
            ELSE
               SCOVAR(I,J) = SCOVAR(I,J) +
     &                       (PSCORE(PED,I) - PSCORE(NPED+1,I)/NPED) *
     &                       (PSCORE(PED,J) - PSCORE(NPED+1,J)/NPED)
            ENDIF
          ENDDO
          IF (WEIGHT) THEN
             SCOVAR(I,J) = SCOVAR(I,J) / NPEO
          ENDIF
        ENDDO
      ENDDO
C
C     Compute the robust variance-covariance matrix.
C
         DO I = 1, NEP
            DO J = 1, NEP
               ROBUST(I,J) = 0
               DO K = 1, NEP
                  DO L = 1, NEP
                     ROBUST(I,J) = ROBUST(I,J) +
     &                    HESS(I,L) * SCOVAR(L,K) * HESS(K,J)
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
C
C     Invert the sample covariance matrix of the scores.
C
      CALL dgefa(SCOVAR,MAXPAR,NEP,IPVT,INFO)
      IF (INFO .NE. 0) THEN
 903     FORMAT (/T14
     1,"Sample covariance matrix of the scores is singular!")
         WRITE (CONOUT, 903)
         WRITE (UNIT3, 903)
         WRITE (UNIT4, 903)
         WRITE (CONOUT, 902)
         WRITE (UNIT3, 902)
         WRITE (UNIT4, 902)
         STATUS = 3
         RETURN
      ENDIF
      CALL dgedi(SCOVAR,MAXPAR,NEP,IPVT,DET,INFORM,1)
      SCNEG = .FALSE.
      DO I = 1, NEP
        IF (SCOVAR(I,I) .LT. 0) THEN
          SCOVAR(I,I) = 0
          SCNEG = .TRUE.
        ENDIF
      ENDDO
 904  FORMAT (/'Inverted sample covariance matrix '
     1,'has negative elements on main diagonal.'/)

      IF (SCNEG) THEN
         WRITE (CONOUT, 904)
         WRITE (UNIT3, 904)
         WRITE (UNIT4, 904)
      ENDIF
C
C     Sum the pedigree scores without weighting.
C
      IF (WEIGHT) THEN
        DO I = 1, NPAR
          PSCORE(NPED+1,I) = 0
          DO PED = 1, NPED
            PSCORE(NPED+1,I) = PSCORE(NPED+1,I) + PSCORE(PED,I)
          ENDDO
        ENDDO
      ENDIF
C
      END IF
      END IF
      END IF

C ** End of Robust Standard Error section

C
C     IF OUTLIER PEOPLE AND PEDIGREES ARE TO BE FLAGGED, THEN CALL
C     FUN.  ALSO SET LAST EQUAL TO THE CURRENT ITERATION NUMBER AND
C     NPASS TO 1.
C
      IF (OUTLIE) CALL FUN(WORK1,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR
     1,PARINC,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK2,DEGREE,DEPVAR,FATHER
     2,GROUP,MOTHER,PERSON,DP,F,WQDFORM,PEDCUT,PERCUT,TOL,ITER,ITER
     3,MAXPAR,MAXPEO,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,1,NPED,NTRAIT,NVAR
     4,UNIT2,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD
     5,RAWMU)
      END
