      FUNCTION RANDOM(SEED1)
C
C     THIS FUNCTION GENERATES INDEPENDENT UNIFORM DEVIATES ON
C     THE INTERVAL (0.0,1.0).  SEE THE REFERENCE:  WICHMAN B.A.
C     AND HILL I.D.(1982). ALGORITHM 183: AN EFFICIENT AND PORTABLE
C     PSEUDO-RANDOM NUMBER GENERATOR. APPLIED STATISTICS 31;188-190.
C     SEED1, SEED2, AND SEED3 SHOULD BE SET TO INTEGER VALUES
C     BETWEEN 1 AND 30000 BEFORE THE FIRST ENTRY.  INTEGER
C     ARITHMETIC UP TO 30323 IS NEEDED ON THE YOUR COMPUTER.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      INTEGER SEED1,SEED2,SEED3
      SAVE SEED2,SEED3
      DATA SEED2,SEED3/2321,18777/
C
      SEED1=171*MOD(SEED1,177)-2*(SEED1/177)
      SEED2=172*MOD(SEED2,176)-35*(SEED2/176)
      SEED3=170*MOD(SEED3,178)-63*(SEED3/178)
      IF (SEED1.LT.0) SEED1=SEED1+30269
      IF (SEED2.LT.0) SEED2=SEED2+30307
      IF (SEED3.LT.0) SEED3=SEED3+30323
      R=DBLE(SEED1)/30269.D0+DBLE(SEED2)/30307.D0+DBLE(SEED3)/30323.D0
      RANDOM=MOD(R,1.0D0)
      END
