C Modified 1996-1997 by Charles Peterson, SFBR.
C This is the New Fisher signature.  Do not remove.  fI6%.
C
      SUBROUTINE PREOPT(CNSTR,CVALUE,PAR,PARMAX,PARMIN,TABLE,WORK2
     1,PNAME,CNORM,TOL,IERROR,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR
     2,UNIT3,TRAVEL,CONOUT)
C
C     THIS SUBROUTINE CHECKS THAT THE PARAMETERS ARE INITIALLY
C     WITHIN THEIR BOUNDS, THAT THE LINEAR EQUALITY CONSTRAINTS ARE
C     SATISFIED, AND THAT THE CONSTRAINTS ARE LINEARLY INDEPENDENT.
C     IT ALSO COMPUTES A MATRIX NORM FOR CNSTR(TRANSPOSE)*CNSTR.
C     THIS WILL BE USED AS A SCALE FACTOR IN THE SUBROUTINE SETTAB.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),PAR(MAXPAR)
     1,PARMAX(MAXPAR),PARMIN(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK2(MAXTAB)
      INTEGER UNIT3,CONOUT
      CHARACTER PNAME(MAXPAR)*(*),TRAVEL*8
C
      IERROR=0
C
C     CHECK THE PARAMETER BOUNDS.
C
      DO 10 I=1,NPAR

C      CALL PARCADJ (I,PAR,PARMIN,PARMAX,IOTHER)
C      IF (IOTHER .NE. 0) THEN
C         WRITE(UNIT3,11) I, IOTHER
C         WRITE(CONOUT,11) I, IOTHER
C 11   FORMAT('   *** WARNING ***  PARAMETERS',I3,' AND',I3,' WERE'
C     1,' ADJUSTED TO SATISFY CONSTRAINT')
C      ENDIF

      IF (PAR(I).LT.PARMIN(I)) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,20) I
      WRITE(CONOUT,20) I
 20   FORMAT(' *** ERROR *** PARAMETER',I3,' IS LESS THAN ITS MINIMUM.')
      ELSE IF (PAR(I).GT.PARMAX(I)) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,30) I
      WRITE(CONOUT,30) I
 30   FORMAT(' *** ERROR *** PARAMETER',I3,' EXCEEDS ITS MAXIMUM.')
      END IF
      IF (PARMIN(I).GE.PARMAX(I)-1.0D-4) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,35) I
      WRITE(CONOUT,35) I
 35   FORMAT(' *** ERROR *** THE BOUNDS ON PARAMETER',I3
     :,' ARE TOO CLOSE OR',/,' INCONSISTENT.')
      END IF
 10   CONTINUE
C
C     CHECK THAT NO PARAMETER IS CONSTRAINED TO A BOUND AND THAT
C     THE EQUALITY CONSTRAINTS ARE SATISFIED 
C
      DO 40 I=1,NCNSTR
      S=0.0D0
      N=0
      DO 50 J=1,NPAR
      IF (CNSTR(I,J).NE.0.0D0) THEN
      N=N+1
      K=J
      END IF
 50   S=S+CNSTR(I,J)*PAR(J)
      IF (N.EQ.1) THEN
      CRIT=MIN(ABS(PAR(K)-PARMIN(K)),ABS(PAR(K)-PARMAX(K)))
      IF (CRIT.LT.1.0D-4) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,55) K
      WRITE(CONOUT,55) K
 55   FORMAT(' *** ERROR *** PARAMETER',I3
     :,' MAY BE CONSTRAINED TO ONE OF ITS BOUNDS.',/  
     :,' IF SO REMOVE THE OFFENDING BOUND.')
      END IF
      END IF
      IF (ABS(S-CVALUE(I)).GT.1.0D-4) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,60) I
 60   FORMAT(' *** ERROR *** LINEAR EQUALITY CONSTRAINT',I3
     1,' IS NOT SATISFIED.')

C CONOTSAT will throw C++ error condition halting maximization here

      CALL CONOTSAT (I)
      END IF
 40   CONTINUE
C
C     CHECK THAT THE EQUALITY CONSTRAINTS ARE LINEARLY INDEPENDENT
C     BY SWEEPING ON CNSTR*CNSTR(TRANSPOSE).
C       
      DO 70 J=1,NCNSTR
      DO 70 I=1,J
      S=0.0D0
      DO 80 K=1,NPAR
 80   S=S+CNSTR(I,K)*CNSTR(J,K)
 70   TABLE(I,J)=S
      NTAB=NCNSTR
      DO 90 I=1,NCNSTR
      IF (TABLE(I,I).LT.TOL) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,100) I
      WRITE(CONOUT,100) I
 100  FORMAT(' *** ERROR *** LINEAR EQUALITY CONSTRAINT',I3
     1,' IS UNDEFINED OR A',/,' COMBINATION OF PREVIOUS ONES.')
      ELSE
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,.FALSE.)
      END IF
 90   CONTINUE
C
C     COMPUTE A MATRIX NORM FOR CNSTR(TRANSPOSE)*CNSTR.
C
      CNORM=0.0D0
      DO 110 I=1,NPAR
      DO 110 J=1,NPAR
      S=0.0D0
      DO 120 K=1,NCNSTR
 120  S=S+CNSTR(K,I)*CNSTR(K,J)
 110  CNORM=CNORM+S*S
      CNORM=SQRT(CNORM)
C
C     WRITE OUT THE PARAMETER BOUNDS AND THE CONSTRAINTS.
C
      IF (TRAVEL.EQ.'SEARCH'.AND.NPAR.GT.0) THEN
      WRITE(UNIT3,130)
 130  FORMAT(/,'                         Parameter Minima and Maxima')
      WRITE(UNIT3,140) (PNAME(I),I=1,NPAR)
 140  FORMAT(100(/6(1X,A11),:))
      WRITE(UNIT3,150) (PARMIN(I),I=1,NPAR)
      WRITE(UNIT3,150) (PARMAX(I),I=1,NPAR)
 150  FORMAT(/100(6(1X,D11.4),:,/))
      IF (NCNSTR.GT.0) THEN
      WRITE(UNIT3,160)
 160  FORMAT(/,
     1'                             Parameter Constraints')
      WRITE(UNIT3,170) (PNAME(I),I=1,NPAR)
 170  FORMAT(/'    CVALUE  ',5(1X,A11),:,100(/6(1X,A11),:))
      DO 180 I=1,NCNSTR
 180  WRITE(UNIT3,150) CVALUE(I),(CNSTR(I,J),J=1,NPAR)
      END IF
      END IF
      END
