      FUNCTION DIGAM(X)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE COMPUTES THE DERIVATIVE OF LOG(GAMMA(X)) VIA A
C     RECURRENCE RELATION AND THE ASYMPTOTIC EXPANSION GIVEN IN:
C     JM BERNARDO(1976). ALGORITHM AS 103 PSI (DIGAMMA) FUNCTION.
C     APPLIED STAT. 25,315-317.  NOTE THAT THE ASYMPTOTIC FORMULA
C     IN THIS PAPER CAN BE CHECKED BY THE EULER-MACLAURIN SUMMATION
C     FORMULA.
C
      Y=X
      F=0.D0
 10   IF (Y.LT.10.D0) THEN
      F=F-1.D0/Y
      Y=Y+1.D0
      GO TO 10
      END IF
      DIGAM=F+LOG(Y)-1.D0/(2.D0*Y)-1.D0/(12.D0*Y**2)
      DIGAM=DIGAM+1.D0/(120.D0*Y**4)-1.D0/(252.D0*Y**6)
      END
