C  FUNCTION COVAR is used to estimate the parameters for a simple 
C  quantitative genetic model.  This is now just an interface.
C  See also DCOVAR, the interface for discrete.
C
      DOUBLE PRECISION FUNCTION COVAR(PAR,VARI,VARJ,DELTA7,KIN2
     1,NPAR,NTRAIT,NVAR,PERI,PERJ,TRAITI,TRAITJ,ITSE,MALEI,MALEJ)
C
C     COVAR SUPPLIES THE COVARIANCE VALUE FOR TWO PEOPLE INDICATED
C     BY THE SUFFIXES I AND J.  THE FIRST PERSON IS PERSON NUMBER
C     PERI OF PEDIGREE NUMBER PED, MALEI IS TRUE WHEN THE FIRST PERSON
C     IS A MALE, AND VARI CONTAINS HIS QUANTITATIVE VARIABLES.  HIS CURRENT
C     TRAIT NUMBER IS TRAITI.  SIMILAR CONVENTIONS HOLD FOR THE SECOND
C     PERSON.  KIN2 IS TWICE THEIR KINSHIP COEFFICIENT, AND DELTA7 IS
C     THEIR PROBABILITY OF SHARING BOTH GENES IDENTICAL BY DESCENT
C     AT ANY GIVEN LOCUS.  DELTA7 SHOULD ONLY BE USED IN NON-INBRED
C     PEDIGREES.  TWINS IS TRUE WHEN THEY ARE MZ-TWINS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION PAR(NPAR),VARI(NVAR),VARJ(NVAR)
     1,KIN2,DELTA7,OMEGAC
      INTEGER PERI,PERJ,TRAITI,TRAITJ,ITSE
      LOGICAL MALEI,MALEJ
C
C     DOUBLE PRECISION H2,PVAR,E2,COVAR1
C
C  On entry,
C  Heritability (H2) is PAR(3), and
C  Phenotypic standard deviation is PAR(2).
C  If non-zero, ITSE is index to intra-individual standard deviation
C    for Trait in VARI
C
C      H2 = PAR(3)
C      E2 = 1.0 - H2
C
C      IF (PERI .GT. 10) CALL EXIT
C      PVAR = PAR(2)*PAR(2)
C      COVAR = KIN2*H2*PVAR
C      IF (PERI .EQ. PERJ) THEN
C         IF (ITSE .EQ. 0) THEN
C            COVAR = COVAR + E2 * PVAR
C         ELSE
C            COVAR = COVAR + E2 * PVAR +
C     1           VARI(ITSE) * VARI(ITSE)
C         ENDIF
C      ENDIF

      COVAR = OMEGAC (PERI, PERJ, VARI, VARJ, PAR, KIN2, DELTA7, 
     1                 ITSE, NTRAIT,MALEI,MALEJ,TRAITI,TRAITJ)

C     WRITE(6,1000) PERI, PERJ, COVAR
 1000 FORMAT (1X,"(",I4,",",I4,") COVAR=",F13.5)
      END


