C Modified 1996-1997 by Charles Peterson, SFBR.
C This is the New Fisher signature.  Do not remove.  fI6%.
C
      SUBROUTINE CALC(DERIV,EXTRA,INFORM,KIN2,OMEGA,PAR,PARINC,QDERIV
     1,SCORE,VAR,WORK,FOOBAR,FATHER,GROUP,MOTHER,PERSON,BORDER,MAXPAR
     2,MAXPEO,MAXVAR,MOMEGA,NEXTRA,NOMEGA,NPAR,NPBAND,NPEO,NTRAIT,NVAR
     3,PED,FORWRD,INFRM,PASS1,RAWSD,RAWMU)
C
C     ON PASS ONE THIS SUBROUTINE SETS UP AN UPPER TRIANGULAR TABLEAU
C     CONTAINING THE COVARIANCE MATRIX AND RESIDUAL VECTOR FOR A PEDIGREE.
C     ON PASS TWO IT COMPUTES THE SCORE VECTOR.  IF THE VARIABLE INFRM
C     IS TRUE, AND THE COVARIANCE MATRIX IS DIAGONAL AND NONSINGULAR, IT
C     WILL ALSO CORRECTLY COMPUTE THE INFORMATION MATRIX ON PASS TWO.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION DERIV(MAXPAR),EXTRA(NEXTRA),INFORM(MAXPAR,MAXPAR)
     1,KIN2(MAXPEO),OMEGA(MOMEGA,MOMEGA),PAR(MAXPAR),PARINC(MAXPAR)
     2,QDERIV(MAXPAR),SCORE(MAXPAR),VAR(MAXVAR),WORK(MAXPAR,NOMEGA)
     3,KIN2IJ,MEAN,TUNE,ROBUST,SDII,MUII,RAWSD,RAWMU

      INTEGER FOOBAR(NTRAIT),FATHER(MAXPEO),GROUP(MAXPEO),MOTHER(MAXPEO)
     1,PERSON(MAXPEO),BORDER,PED,PERI,PERJ,TRAITI,TRAITJ
     2,TNUMI,TNUMJ,TINDXI

      LOGICAL FORWRD,INFRM,MALEI,MALEJ,PASS1,TWINOK,TWINS,IFVIRT

      INTEGER ITSE, GETITSE, GETVIRT
C
C     IF THIS IS PASS ONE, INSERT THE COVARIANCE MATRIX INTO THE UPPER
C     TRIANGLE OF OMEGA.  BORDER IT ON THE RIGHT BY THE RESIDUAL VECTOR.
C     IF THIS IS PASS TWO, COMPUTE THE SCORE VECTOR AND POSSIBLY THE
C     INFORMATION MATRIX.  NOTE THAT THE VARIABLE I GIVES THE CURRENT
C     ROW NUMBER IN OMEGA.
C
      I=1
      IVAR=1-NVAR
      IFVIRT = (GETVIRT().NE.0)

      DO 10 IPER=1,NPEO
C
C     FOR PERSON NUMBER IPER, COMPUTE THE OFFSET IVAR FOR LOCATING HIS
C     QUANTITATIVE VARIABLES.  ALSO RECORD HIS POSITION ON DATA ENTRY,
C     HIS SEX, AND WHETHER HE IS AN MZ TWIN.
C
      IVAR=IVAR+NVAR
      PERI=PERSON(IPER)
      IGRP=GROUP(IPER)
      MALEI=IGRP.LT.0
      ITWIN=IABS(IGRP)/100000
      TWINOK=ITWIN.NE.0

      DO 10 TRAITI=1,NTRAIT
C
C TNUMI....Actual effective (virtual) trait number
C TINDXI...Index to effective trait value in VAR array
C  this allows TINDXI to replace the IVAR+DEPVxR(TNUMI)-1
C
         TNUMI = TRAITI
         TINDXI = IVAR+TRAITI-1
         IF (IFVIRT) THEN
            TNUMI = VAR(IVAR)
            TINDXI = IVAR+1
         ENDIF
         ITSE = GETITSE (TNUMI)

C     IF THIS IS THE FIRST PASS, THEN COMPUTE THE RESIDUAL FOR TRAIT NUMBER
C     TNUMI OF PERSON PERI.
C
      IF (PASS1) THEN
      CALL DOPTION ("ROBUSTEST",ROBUST)
      IF (ROBUST.NE.0) THEN
         CALL DOPTION ("TUNE",TUNE)
C         SDII=COVAR(PAR,VAR(IVAR),VAR(IVAR),1.0,1.0
C     1        ,MAXPAR,NTRAIT,NVAR,PERI,PERI,TNUMI,TNUMI,ITSE
C     2        ,MALEI,MALEI)
         SDII=RAWSD
         MUII=RAWMU
C        IF(DABS(OMEGA(I,BORDER)).GT.TUNE*SDII)
C    1        OMEGA(I,BORDER)=DSIGN(1.d0,OMEGA(I,BORDER))*TUNE*SDII
         IF(DABS( VAR(TINDXI)-MUII).GT.TUNE*SDII)
     1        VAR(TINDXI)=DSIGN(1.d0,
     2        VAR(TINDXI)-MUII)*TUNE*SDII+MUII
      END IF
      OMEGA(I,BORDER)=VAR(TINDXI)-MEAN(EXTRA,PAR
     1,VAR(IVAR),NEXTRA,MAXPAR,NTRAIT,NVAR,PED,PERI,TNUMI,MALEI)
      ELSE
C
C     IF THIS IS THE PASS FOR COMPUTING THE SCORE VECTOR, THEN
C     NUMERICALLY COMPUTE THE PARTIALS OF THE MEAN WITH RESPECT TO
C     ALL PARAMETERS.  USE THESE PARTIALS TO UPDATE THE SCORE VECTOR.
C     THE COMMENTS BELOW ASSUME FOR THE SAKE OF CONVENIENCE THAT THE
C     PARAMETERS CAN BE DIVIDED INTO MEAN COMPONENTS AND COVARIANCE
C     COMPONENTS.  HOWEVER, THE CODE IS MORE GENERAL AND DOES NOT MAKE
C     THIS DISTINCTION.
C
      IF (FORWRD) THEN
C
C     COMPUTE THE PARTIAL DERIVATIVES BY FORWARD DIFFERENCES.
C
      BMEAN=MEAN(EXTRA,PAR,VAR(IVAR),NEXTRA,MAXPAR,NTRAIT,NVAR,PED
     1,PERI,TNUMI,MALEI)
      DO 20 M=1,NPAR
      D=PARINC(M)
      PTEMP=PAR(M)
      PAR(M)=PTEMP+D
      AMEAN=MEAN(EXTRA,PAR,VAR(IVAR),NEXTRA,MAXPAR,NTRAIT,NVAR,PED
     1,PERI,TNUMI,MALEI)
      PAR(M)=PTEMP
 20   DERIV(M)=(AMEAN-BMEAN)/D
C
C     COMPUTE THE PARTIAL DERIVATIVES BY CENTRAL DIFFERENCES.
C
      ELSE
      DO 30 M=1,NPAR
      D=PARINC(M)
      PTEMP=PAR(M)
      PAR(M)=PTEMP+D
      AMEAN=MEAN(EXTRA,PAR,VAR(IVAR),NEXTRA,MAXPAR,NTRAIT,NVAR,PED
     1,PERI,TNUMI,MALEI)
      PAR(M)=PTEMP-D
      BMEAN=MEAN(EXTRA,PAR,VAR(IVAR),NEXTRA,MAXPAR,NTRAIT,NVAR,PED
     1,PERI,TNUMI,MALEI)
      PAR(M)=PTEMP
 30   DERIV(M)=(AMEAN-BMEAN)/(D+D)
      END IF
C
C     UPDATE THE SCORE VECTOR.  RECALL THAT THE SCORE FOR THE MTH MEAN
C     PARAMETER IS GIVEN BY THE PRODUCT DMEAN(M)*COV(INVERSE)*RESIDUAL,
C     WHERE DMEAN(M) IS THE MTH PARTIAL OF THE MEAN VECTOR, COV IS THE
C     COVARIANCE MATRIX, AND RESIDUAL IS THE OBSERVATION VECTOR MINUS
C     THE MEAN VECTOR.  NOTE THAT COV(INVERSE)*RESIDUAL WILL APPEAR IN
C     THE LAST COLUMN OF OMEGA AFTER THE FIRST PASS AND SWEEPING.
C
      DO 40 M=1,NPAR
      TERM=DERIV(M)*OMEGA(I,BORDER)
      QDERIV(M)=QDERIV(M)+TERM
 40   SCORE(M)=SCORE(M)+TERM
C
C     THE CONDITIONAL INFORMATION MATRIX CAN BE VIEWED AS A SUM OF TWO
C     CONTRIBUTIONS.  THE FIRST PART CAN BE WRITTEN AS THE MATRIX PRODUCT
C             WORK*OMEGA(22.1)(INVERSE)*WORK(TRANSPOSE),
C     WHERE WORK IS A MATRIX TO BE DESCRIBED AND OMEGA(22.1) IS THE
C     CONDITIONAL COVARIANCE MATRIX FOR THE NON-PROBANDS GIVEN THE PROBANDS.
C     THE MTH ROW OF WORK IS THE VECTOR
C            DMEAN(2)+DCOV(21)*OMEGA(11)(INVERSE)*RESIDUAL(1)
C     WHERE DMEAN(2) IS THE VECTOR OF MTH PARTIALS OF THE NON-PROBANDS
C     AND DCOV(21) IS THE MATRIX OF MTH PARTIALS FOR THE NON-PROBANDS BY
C     THE PROBANDS.  OMEGA(11) AND RESIDUAL(1) ARE DEFINED IN THE OBVIOUS
C     WAY FOR THE PROBANDS.  AT THIS STEP WE UPDATE WORK BY ADDING THE
C     DMEAN(2) TERMS.
C
      IF (INFRM.AND.IPER.GT.NPBAND) THEN
      DO 50 M=1,NPAR
 50   WORK(M,I)=WORK(M,I)+DERIV(M)
      END IF
      END IF
C
C     BEGIN THE COVARIANCE CALCULATIONS.  THE VARIABLE J GIVES THE CURRENT
C     COLUMN NUMBER IN OMEGA.
C
      J=I
      JVAR=IVAR-NVAR
      DO 60 JPER=IPER,NPEO
C
C     FOR PERSON NUMBER JPER, COMPUTE THE OFFSET JVAR FOR LOCATING HIS
C     QUANTITATIVE VARIABLES.  ALSO RECORD HIS POSITION ON DATA ENTRY,
C     HIS SEX, AND WHETHER HE IS AN MZ TWIN OF IPER.
C
      JVAR=JVAR+NVAR
      PERJ=PERSON(JPER)
      MALEJ=GROUP(JPER).LT.0
      TWINS=TWINOK.AND.IPER.NE.JPER.AND.ITWIN.EQ.
     1     IABS(GROUP(JPER))/100000
C
C     RETRIEVE TWICE THE KINSHIP COFFICIENT AND THE DELTA7 COEFFICIENT
C     FOR THE CURRENT PAIR IPER AND JPER.
C
      IF (IPER.EQ.JPER) THEN
      KIN2IJ=KIN2(IPER)
      JSTART=TRAITI
      ELSE
      KIN2IJ=OMEGA(JPER,IPER)
      JSTART=1
      END IF
      D7IJ=DELTA7(KIN2,OMEGA,FATHER,MOTHER,IPER,JPER,MAXPEO,MOMEGA
     1,TWINS)
C
      DO 60 TRAITJ=JSTART,NTRAIT
C
C TNUMJ....Actual effective (virtual) trait number
C
         TNUMJ = TRAITJ
         IF (IFVIRT) THEN
            TNUMJ = VAR(JVAR)
         ENDIF
C
C     IF THIS IS THE FIRST PASS, THEN COMPUTE THE COVARIANCE BETWEEN
C     TRAIT NUMBER TNUMI OF PERSON PERI AND TRAIT NUMBER TNUMJ OF
C     PERSON PERJ.
C
      IF (PASS1) THEN
      OMEGA(I,J)=COVAR(PAR,VAR(IVAR),VAR(JVAR),D7IJ,KIN2IJ
     1,MAXPAR,NTRAIT,NVAR,PERI,PERJ,TNUMI,TNUMJ
     2,ITSE,MALEI,MALEJ)
      ELSE
C
C     IF THIS IS THE PASS FOR COMPUTING THE SCORE VECTOR, THEN
C     NUMERICALLY COMPUTE THE PARTIALS OF THE COVARIANCE WITH RESPECT TO
C     ALL PARAMETERS.  USE THESE PARTIALS TO UPDATE THE SCORE VECTOR.
C
      IF (FORWRD) THEN
C
C     COMPUTE THE PARTIAL DERIVATIVES BY FORWARD DIFFERENCES.
C
      BOMEGA=COVAR(PAR,VAR(IVAR),VAR(JVAR),D7IJ,KIN2IJ
     1,MAXPAR,NTRAIT,NVAR,PERI,PERJ,TNUMI,TNUMJ
     2,ITSE,MALEI,MALEJ)
      DO 70 M=1,NPAR
      D=PARINC(M)
      PTEMP=PAR(M)
      PAR(M)=PTEMP+D
      AOMEGA=COVAR(PAR,VAR(IVAR),VAR(JVAR),D7IJ,KIN2IJ
     1,MAXPAR,NTRAIT,NVAR,PERI,PERJ,TNUMI,TNUMJ
     2,ITSE,MALEI,MALEJ)
      PAR(M)=PTEMP
 70   DERIV(M)=(AOMEGA-BOMEGA)/D
C
C     COMPUTE THE PARTIAL DERIVATIVES BY CENTRAL DIFFERENCES.
C
      ELSE
      DO 80 M=1,NPAR
      D=PARINC(M)
      PTEMP=PAR(M)
      PAR(M)=PTEMP+D
      AOMEGA=COVAR(PAR,VAR(IVAR),VAR(JVAR),D7IJ,KIN2IJ
     1,MAXPAR,NTRAIT,NVAR,PERI,PERJ,TNUMI,TNUMJ
     2,ITSE,MALEI,MALEJ)
      PAR(M)=PTEMP-D
      BOMEGA=COVAR(PAR,VAR(IVAR),VAR(JVAR),D7IJ,KIN2IJ
     1,MAXPAR,NTRAIT,NVAR,PERI,PERJ,TNUMI,TNUMJ
     2,ITSE,MALEI,MALEJ)
      PAR(M)=PTEMP
 80   DERIV(M)=(AOMEGA-BOMEGA)/(D+D)
      END IF
C
C     UPDATE THE SCORE VECTOR.  RECALL THAT THE SCORE FOR THE MTH COVARIANCE
C     PARAMETER IS GIVEN BY HALF THE SUM
C                    -TRACE(COV(INVERSE)*DCOV(M))
C     +RESIDUAL(TRANSPOSE)*COV(INVERSE)*DCOV(M)*COV(INVERSE)*RESIDUAL,
C     WHERE DCOV(M) IS THE MTH PARTIAL OF THE COVARIANCE MATRIX, COV IS
C     THE COVARIANCE MATRIX, AND RESIDUAL IS THE OBSERVATION VECTOR MINUS
C     THE MEAN VECTOR.  NOTE THAT COV(INVERSE)*RESIDUAL WILL APPEAR IN THE
C     LAST COLUMN OF OMEGA AFTER THE FIRST PASS AND SWEEPING, AND -COV(INVERSE)
C     WILL APPEAR WHERE COV WAS.
C
      IF (I.NE.J) THEN
      DO 90 M=1,NPAR
      TERM=OMEGA(I,BORDER)*DERIV(M)*OMEGA(J,BORDER)
      QDERIV(M)=QDERIV(M)+TERM
 90   SCORE(M)=SCORE(M)+OMEGA(I,J)*DERIV(M)+TERM
      ELSE
      DO 100 M=1,NPAR
      TERM=OMEGA(I,BORDER)*DERIV(M)*OMEGA(J,BORDER)
      QDERIV(M)=QDERIV(M)+0.5D0*TERM
 100  SCORE(M)=SCORE(M)+0.5D0*(OMEGA(I,J)*DERIV(M)+TERM)
      END IF
C
C     UPDATE THE SECOND CONTRIBUTION TO THE INFORMATION MATRIX.  WHEN THE
C     COVARIANCE MATRIX IS DIAGONAL, THEN THE ENTRY IN ROW M AND COLUMN N OF
C     THIS PART OF THE INFORMATION MATRIX IS GIVEN BY HALF THE TRACE OF
C         OMEGA(22)(INVERSE)*DCOV(22)(M)*OMEGA(22)(INVERSE)*DCOV(22)(N),
c     WHERE 22 REFERS TO THE NON-PROBAND PART OF THE PEDIGREE.
C
      IF (INFRM.AND.IPER.GT.NPBAND.AND.JPER.GT.NPBAND) THEN
      IF (I.NE.J) THEN
      DO 110 M=1,NPAR
      DO 110 N=M,NPAR
 110  INFORM(M,N)=INFORM(M,N)+OMEGA(I,I)*DERIV(M)*OMEGA(J,J)
     1*DERIV(N)
      ELSE
      DO 120 M=1,NPAR
      DO 120 N=M,NPAR
 120  INFORM(M,N)=INFORM(M,N)+0.5D0*OMEGA(I,I)*DERIV(M)*OMEGA(J,J)
     1*DERIV(N)
      END IF
      END IF
C
C     UPDATE THE WORK VECTOR FOR THE FIRST CONTRIBUTION TO THE THE
C     INFORMATION MATRIX BY ADDING THE TERMS
C           DCOV(21)*OMEGA(11)(INVERSE)*RESIDUAL(1).
C     SEE THE COMMENTS ABOVE.  ALSO RECALL THAT THE LAST COLUMN OF
C     THE TABLEAU CONTAINS OMEGA(INVERSE)*RESIDUAL.
C
      IF (INFRM.AND.IPER.LE.NPBAND.AND.JPER.GT.NPBAND) THEN
      DO 130 M=1,NPAR
 130  WORK(M,J)=WORK(M,J)+DERIV(M)*OMEGA(I,BORDER)
      END IF
      END IF
 60   J=J+1
 10   I=I+1

C
C     DO THE FINAL WEIGHTED INNER PRODUCT COMPUTATION TO FIND THE FIRST
C     CONTRIBUTION TO THE INFORMATION MATRIX.  RECALL THAT THE TABLEAU
C     CONTAINS -OMEGA(INVERSE) AND THIS MATRIX IS DIAGONAL WHEN THE
C     INFORMATION MATRIX IS TO BE COMPUTED.
C
 113  IF (INFRM) THEN
      KSTART=NPBAND*NTRAIT+1
      DO 140 M=1,NPAR
      DO 140 N=M,NPAR
      SUM=0.0D0
      DO 150 K=KSTART,NOMEGA
 150  SUM=SUM+WORK(M,K)*OMEGA(K,K)*WORK(N,K)
 140  INFORM(M,N)=INFORM(M,N)-SUM
      END IF
      END
