      FUNCTION BETA(X,P,Q)
C
C     THIS FUNCTION SUBROUTINE COMPUTES THE BETA CUMULATIVE
C     DISTRIBUTION FUNCTION AT THE POINT X.  P AND Q ARE THE
C     EXPONENTS OF X AND 1-X IN THE BETA DENSITY.  SEE KL MAJUMDER
C     GP BHATTACHARJEE(1973). ALGORITHM AS 63 THE INCOMPLETE BETA
C     INTEGRAL. APPLIED STAT. 22,409-411.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL LEFT
C
      IF (X.LE.0.D0) THEN
      BETA=0.D0
      RETURN
      ELSE IF (X.GE.1.D0) THEN
      BETA=1.D0
      RETURN
      END IF
C
C     DECIDE IF X IS TO THE LEFT OR RIGHT OF THE MEAN P/SUMPQ.
C
      SUMPQ=P+Q
      IF (P.GE.X*SUMPQ) THEN
      LEFT=.TRUE.
      CX=1.D0-X
      XX=X
      PP=P
      QQ=Q
      ELSE
      LEFT=.FALSE.
      CX=X
      XX=1.D0-X
      PP=Q
      QQ=P
      END IF
C
C     INTIALIZE TERMS.
C
      B=GAMLOG(SUMPQ)-GAMLOG(PP)-GAMLOG(QQ+1.D0)
      TERM=EXP((PP-1.D0)*LOG(XX)+QQ*LOG(CX)+B)
      FIRST=TERM
      BETA=0.D0
C
C     USE THE INTEGRATION BY PARTS FORMULA TO RAISE PP AND LOWER QQ.
C
 20   IF (QQ.GT.1.D0) THEN
      TERM=XX*QQ*TERM/(PP*CX)
      BETA=BETA+TERM
      IF (TERM/FIRST.LT.1.D-10) GO TO 10
      PP=PP+1.D0
      QQ=QQ-1.D0
      GO TO 20
      END IF
C
C     USE SOPER'S FORMULA TO RAISE PP.
C
      TERM=QQ*TERM
 30   IF (TERM/FIRST.GE.1.D-10) THEN
      TERM=XX*TERM/PP
      BETA=BETA+TERM
      TERM=SUMPQ*TERM
      PP=PP+1.D0
      SUMPQ=SUMPQ+1.D0
      GO TO 30
      END IF
C
 10   IF (.NOT.LEFT) BETA=1.D0-BETA
      END
