      SUBROUTINE ALLFRQ(SHOWSTAT,MXITER,CARRAY,LENC,IARRAY,LENI,LARRAY,
     &                  LENL,RARRAY,LENR,NLENC,NLENI,NLENL,NLENR)
C
C     ARRAY AND VARIABLE DECLARATIONS.
C
      PARAMETER(NEXTRA=2)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA), RARRAY(*)
      INTEGER   IARRAY(*), COND, CONIN, CONOUT, UNIT1, UNIT2, UNIT3
      CHARACTER*8 CARRAY(*),BASE,LOCFIL*40,MUTLOC,OUTFIL*40
     1,PEDFIL*40,TITLE*40,TRAVEL,XXSIGN,XYSIGN,SHOWSTAT*1
      LOGICAL LARRAY(*),ASYCV,BATCH,ECHO,STAND

      LOGICAL DISPSTAT
      COMMON /STATLINE/ DISPSTAT

      INTEGER NLENC, NLENI, NLENL, NLENR
      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED
C
C     LOGICAL UNIT NUMBERS AND DEFAULT VALUES FOR SOME VARIABLES.
C     DON'T MESS WITH THESE IN ORDINARY CIRCUMSTANCES.
C
      DATA CONIN,CONOUT,UNIT1,UNIT2,UNIT3 /5,6,1,2,3/
      DATA MXLOCI,MXTWIN,ABSENT/1,10,-1.0D20/
      DATA CONV,NCONV,MXSTEP,DP/1.0D-4,4,3,1.0D-7/
C
C     DEFAULT VALUES FOR THE PROBLEM MENU.
C
      DATA TITLE,LOCFIL/'Genotype Frequency Estimation','allfreq.loc'/
      DATA PEDFIL,OUTFIL/'allfreq.ped','genfreq.out'/
      DATA ECHO,XXSIGN,XYSIGN,NVAR/.FALSE.,'2','1',0/
      DATA EXTRA/0.0D0,0.0D0/
      DATA MUTLOC,XXRATE,XYRATE,COND/' ',1.0D-6,1.0D-6,0/
      DATA BASE,STAND,TRAVEL,NPOINT/'E',.FALSE.,'SEARCH',1/
      DATA NPAR,NCNSTR,ASYCV/6,1,.FALSE./
C
C     TO RUN THE PROGRAM IN BATCH MODE SET THE LOGICAL VARIABLE 'BATCH'
C     TO .TRUE.  READING OF THE RESPONSES TO THE PROBLEM MENU
C     WILL THEN TAKE PLACE FROM THE USER SUPPLIED FILE 'BATCH.DAT'.
C
      BATCH = .TRUE.
      IF (BATCH) OPEN (CONIN, FILE='allfreq.bat', STATUS='OLD')
      CALL UNLINK('genfreq.frq')
      DISPSTAT = .FALSE.
      IF (SHOWSTAT .EQ. 'y') DISPSTAT = .TRUE.
      IF (DISPSTAT) OPEN (9, FILE='/dev/tty', STATUS='UNKNOWN')
      IF (MXITER .LT. 0) THEN
      MXITER = -MXITER
      ASYCV = .TRUE.
      ENDIF
C
C     THE ARRAYS AND VARIABLES BEGIN A LONG DESCENT INTO THE
C     PROGRAM.  SAY GOODBYE TO THEM AND WISH THEM LUCK.
C
      CNEED = 0
      INEED = 0
      LNEED = 0
      RNEED = 0
      CALL MENDEL (EXTRA,  RARRAY, IARRAY, CARRAY, LARRAY, ABSENT,
     &             CONV,   DP,     XXRATE, XYRATE, COND,   LENC,
     &             LENI,   LENL,   LENR,   MXITER, MXLOCI, MXSTEP,
     &             MXTWIN, NCNSTR, NCONV,  NEXTRA, NPAR,   NPOINT,
     &             NVAR,   CONIN,  CONOUT, UNIT1,  UNIT2,  UNIT3,
     &             BASE,   LOCFIL, MUTLOC, OUTFIL, PEDFIL, TITLE,
     &             TRAVEL, XXSIGN, XYSIGN, ASYCV,  BATCH,  ECHO,
     &             STAND)
      NLENC = CNEED
      NLENI = INEED
      NLENL = LNEED
      NLENR = RNEED
      CLOSE(UNIT1)
      CLOSE(UNIT2)
      CLOSE(UNIT3)
      IF (DISPSTAT) CLOSE(9)
      IF (BATCH) CLOSE(CONIN)
      RETURN
      END

      SUBROUTINE INITAL(ALLFRQ,CNSTR,CVALUE,EXTRA,GRID,PAR,PARMAX
     1,PARMIN,PNAME,XLINK,XXRATE,XYRATE,MAXALL,MUTATE,NCNSTR,NEXTRA
     2,NLOCI,NPAR,NPOINT,NVAR,PROBLM,UNIT3,TRAVEL)
C
C     IN THIS SUBROUTINE THE USER SHOULD DEFINE THE INITIAL
C     PARAMETER VALUES, THE PARAMETER BOUNDS, AND THE LINEAR
C     EQUALITY CONSTRAINTS FOR A LIKELIHOOD SEARCH.  WHEN A
C     GRID OF LIKELIHOOD VALUES IS DESIRED, THEN ONLY DEFINE
C     THE ARRAY GRID.  PARAMETER NAMES CAN BE OPTIONALLY INPUT.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION ALLFRQ(NLOCI,MAXALL),CNSTR(NCNSTR,NPAR)
     1,CVALUE(NCNSTR),EXTRA(NEXTRA),GRID(NPOINT,NPAR),PAR(NPAR)
     2,PARMAX(NPAR),PARMIN(NPAR)
C     2,PARMAX(NPAR),PARMIN(NPAR),CCON,CVINP
C      INTEGER PROBLM,UNIT3,NCLIN,CIND1,CIND2,NCV,CVIND
      INTEGER PROBLM,UNIT3
      CHARACTER*8 PNAME(NPAR),TRAVEL
      CHARACTER*20 MODFIL
      LOGICAL XLINK(NLOCI)
C      WRITE(6,100)
C  100 FORMAT(' ENTER MODEL FILE: ')
C      READ(5,101)MODFIL
C  101 FORMAT(A20)
      MODFIL='allfreq.mod'
      OPEN(UNIT=30,FILE=MODFIL,STATUS='OLD')
c      ipar = sqrt(2*npar-.25) - .5
      ipar = sqrt(2*npar-.25)
c	print *, "ipar =",ipar
      DO 1 I=1,ipar
      READ(30,200)PNAME(I),PAR(I),PARMIN(I),PARMAX(I)
  200 FORMAT(2X,A8,3F15.0)
    1 CONTINUE
      do i=ipar,1,-1
      parmin(i*(i+1)/2)=parmin(i)
      parmax(i*(i+1)/2)=parmax(i)
      par(i*(i+1)/2)=par(i)
c	print *, "i =",i,"  par(",i*(i+1)/2,") =",par(i*(i+1)/2)
      enddo
      do i=2,ipar
      do j=1,i-1
      parmin(i*(i-1)/2+j)=parmin(i*(i+1)/2)
      parmax(i*(i-1)/2+j)=parmax(i*(i+1)/2)
      par(i*(i-1)/2+j)=2*par(i*(i+1)/2)*par(j*(j+1)/2)
c	print *, "i =",i,"  j =",j,"  par(",i*(i-1)/2+j,") =",par(i*(i-1)/2+j)
      enddo
      enddo
      do i=1,ipar
      par(i*(i+1)/2)=par(i*(i+1)/2)**2
c	print *, "i =",i,"  par(",i*(i+1)/2,") =",par(i*(i+1)/2)
      enddo
      par(npar) = 1.
      do i=1,npar-1
      par(npar) = par(npar) - par(i)
      enddo
      do i=1,npar
      write(pname(i),'(i8)') i
      enddo
c      	do i=1,npar
c	print *, "par(",i,") =",par(i)
c	enddo
C      READ(30,300)NCLIN
C  300 FORMAT(10X,I3)
C      IF(NCLIN .EQ. 0)GO TO 999
C      DO 2 I=1,NCLIN
C      READ(30,401)CIND1,CIND2,CCON
C  401 FORMAT(2I3,F8.0)
C      CNSTR(CIND1,CIND2)=CCON
C    2 CONTINUE
C      READ(30,300)NCV
C      DO 3 I=1,NCV
C      READ(30,500)CVIND,CVINP
C  500 FORMAT(3X,I3,F8.0)
C      CVALUE(CVIND)=CVINP
C    3 CONTINUE
      do 2 i=1,npar
    2 cnstr(1,i)=1.
      cvalue(1)=1.
  999 CONTINUE
      CLOSE(UNIT=30)
      END

      SUBROUTINE OUTPUT(EXTRA,PAR,SCORE,PNAME,LOGLIK,ITER,LAST,MAXPAR
     1,NEXTRA,NPAR,NSTEP,UNIT3,BASE,TRAVEL,STAND,UMOVE)
C
C     THIS SUBROUTINE OUTPUTS THE LOGLIKELIHOOD AND PARAMETERS
C     AT EACH ITERATION.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA),PAR(MAXPAR),SCORE(MAXPAR),LOGLIK
      DOUBLE PRECISION MFREQ
      INTEGER UNIT3,IMAX
      CHARACTER*8 PNAME(MAXPAR),BASE,TRAVEL,TEMP
      LOGICAL STAND,UMOVE
      SAVE BIG,FIRST,IBIG
      LOGICAL DISPSTAT
      COMMON /STATLINE/ DISPSTAT
C
      IF (ITER.EQ.1) THEN
      BIG=-1.0D20
      FIRST=LOGLIK
      WRITE(UNIT3,10) (PNAME(I),I=1,NPAR)
C      WRITE(6,10) (PNAME(I),I=1,NPAR)
 10   FORMAT(/,' ITER  NSTEP  LOGLIKELIHOOD',(T28,4(4X,A8),:))
      END IF
      IF (STAND) LOGLIK=LOGLIK-FIRST
      IF (LOGLIK.GE.BIG) THEN
      IBIG=ITER
      BIG=LOGLIK
      END IF
      IF (BASE(1:2).EQ.'10') LOGLIK=LOG10(EXP(1.0D0))*LOGLIK
      WRITE(UNIT3,20) ITER,NSTEP,LOGLIK,(PAR(I),I=1,NPAR)
      IF (DISPSTAT) THEN
        IF (ITER.GT.1) WRITE(9,'(37A1,$)') (CHAR(8),I=1,37)
        WRITE(9,'("iter",I4,"  delta loglike = ",F10.4," "$)')
     &        ITER,LOGLIK-FIRST
        CALL FLUSH(9)
      ENDIF
C      WRITE(6,20) ITER,NSTEP,LOGLIK,(PAR(I),I=1,NPAR)
 20   FORMAT(/,I4,3X,I3,3X,D14.7,(T28,4(1X,D11.4),:))
      IF (ITER.EQ.LAST) WRITE(UNIT3,30) IBIG
 30   FORMAT(/,' THE MAXIMUM LOGLIKELIHOOD OCCURS AT ITERATION',I4,'.')
      IF (ITER.EQ.LAST) THEN
         HET=1.0D0
         PIC=1.0D0
         DO 50 I=1,NPAR
            HET=HET-PAR(I)**2
            PIC=PIC-PAR(I)**2
            DO 50 J=I+1,NPAR
 50      PIC=PIC-2.0D0*PAR(I)**2*PAR(J)**2
         WRITE(UNIT3,60) HET,PIC
 60      FORMAT(/,' THE FRACTION 0F HETEROZYGOTES AT THE LOCUS IS ',
     &         F5.4, '.', '  IF IT IS AN', /,
     &         ' AUTOSOMAL CODOMINANT, ITS POLYMORPHISM',
     &         ' INFORMATION CONTENT IS ',F5.4,'.')
      END IF
      IF (ITER.EQ.LAST) THEN
         OPEN(UNIT=31,FILE='genfreq.frq',STATUS='UNKNOWN')
         MFREQ=0
         DO I=1,NPAR
            IF (PAR(NPAR).GT.MFREQ) THEN
               MFREQ=PAR(NPAR)
               IMAX=I
            ENDIF
         ENDDO
         PAR(IMAX)=0
         DO I=1,NPAR
            IF (I.NE.IMAX) THEN
               WRITE(TEMP,'(F8.6)') PAR(I)
               IF (TEMP.EQ.'0.000001') TEMP='0.000000'
               READ(TEMP,*) PAR(I)
               PAR(IMAX)=PAR(IMAX)+PAR(I)
            ENDIF
         ENDDO
         PAR(IMAX)=1.-PAR(IMAX)
         DO I=1,NPAR
            WRITE(31,32) PNAME(I),PAR(I)
 32      FORMAT(A8,F9.6)
         ENDDO
         WRITE(31,*) LOGLIK
         CLOSE(31)
      ENDIF
      END

      SUBROUTINE NEWLIK(EXTRA,PAR,LOGLIK,COND,ITER,NEXTRA,NPAR,NPED,PED)
C
C     THIS SUBROUTINE ALLOWS THE USER TO MODIFY THE LOGLIKELIHOOD
C     OF A PARTICULAR PEDIGREE.  FOR INSTANCE, IN GENETIC COUNSELING
C     PROBLEMS IT IS MAY BE NECESSARY TO FORM CONDITIONAL PROBABILITIES.
C     COND TELLS WHICH PEDIGREE, IF ANY, TO CONDITION ON.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA),PAR(NPAR),LOGLIK
      INTEGER COND,PED
C
      END

      SUBROUTINE APEN(EXTRA,PAR,PEN,VAR,GENES,XLINK,ABSENT,XXRATE
     1,XYRATE,MUTATE,NEXTRA,NGTYPE,NLOCI,NPAR,NVAR,PED,PER,MALE)
C
C     PEN SUPPLIES THE PENETRANCE PROBABILITIES FOR EACH PERSON
C     IN A PEDIGREE.  THE CURRENT VERSION IS VALID ONLY FOR SIMPLE
C     EITHER/OR TRAITS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA),PAR(NPAR),PEN(NGTYPE),VAR(NVAR)
      INTEGER GENES(NLOCI,2,NGTYPE),PED,PER
      LOGICAL XLINK(NLOCI),MALE
C
      DO 10 I=1,NGTYPE
 10   PEN(I)=1.0D0
      END

      SUBROUTINE APRIOR(ALLFRQ,EXTRA,PAR,PRIOR,VAR,GENES,XLINK
     1,ABSENT,XXRATE,XYRATE,MAXALL,MUTATE,NEXTRA,NGTYPE,NLOCI
     2,NPAR,NVAR,PED,PER,MALE)
C
C     PRIOR SUPPLIES THE PRIOR PROBABILITIES FOR EACH FOUNDER IN
C     A PEDIGREE.  THE CURRENT VERSION IS VALID IF HARDY-WEINBERG
C     AND LINKAGE EQUILIBRIUM HOLD AT ALL LOCI.  LOCI MAY BE AUTOSOMAL
C     OR X-LINKED.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION ALLFRQ(NLOCI,MAXALL),EXTRA(NEXTRA),PAR(NPAR)
     1,PRIOR(NGTYPE),VAR(NVAR)
      INTEGER GENES(NLOCI,2,NGTYPE),PED,PER
      LOGICAL XLINK(NLOCI),MALE
C      LOGICAL XLINK(NLOCI),MALE,TWICE
C
      DO 10 I=1,NGTYPE
      DO 20 LOCUS=1,NLOCI
      IG1=GENES(LOCUS,1,I)
      IG2=GENES(LOCUS,2,I)
      if (ig1.ge.ig2) then
         prior(i)=par(ig1*(ig1-1)/2+ig2)
      else
         prior(i)=par(ig2*(ig2-1)/2+ig1)
      endif
 20   CONTINUE
 10   CONTINUE
      END

      SUBROUTINE ATRANS(EXTRA,PAR,TRANS,VARI,VARJ,GAMETE,GENES,XLINK
     1,ABSENT,XXRATE,XYRATE,MUTATE,NEXTRA,NGTYPE,NLOCI,NPAR,NVAR,PED
     2,PERI,PERJ,MALEI,MALEJ)
C
C     TRANS SUPPLIES THE TRANSMISSION PROBABILITIES FOR EACH
C     PARENT-OFFSPRING PAIR IN A PEDIGREE.  THE CURRENT VERSION OF
C     ATRANS IS VALID FOR MULTIPLE LINKED LOCI UNDER THE SIMPLIFYING
C     ASSUMPTION OF NO CHIASMA INTERFERENCE.  THE LOCI MAY BE ALL
C     AUTOSOMAL OR ALL X-LINKED.  PARAMETERS 1 TO NLOCI-1 ARE THE
C     FEMALE RECOMBINATION FRACTIONS FOR THE SEQUENCE OF ADJACENT
C     INTERVALS DEFINED BY THE LOCI.  PARAMETERS NLOCI TO 2*NLOCI-2
C     ARE THE CORRESPONDING MALE RECOMBINATION FRACTIONS.  THE SUFFIX
C     I INDICATES THE PARENT AND THE SUFFIX J THE THE CHILD.  SEVERAL
C     MULTIPLE LOCUS GENOTYPES OF THE PARENT ARE PASSED VIA THE
C     ARRAY GENES.  THE ARRAY GAMETE REPRESENTS ONE OF THE TWO
C     GAMETES MAKING UP A MULTIPLE LOCUS GENOTYPE OF THE CHILD.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA),PAR(NPAR),TRANS(NGTYPE)
     1,VARI(NVAR),VARJ(NVAR)
      INTEGER GAMETE(NLOCI),GENES(NLOCI,2,NGTYPE),PED,PERI,PERJ
      LOGICAL XLINK(NLOCI),FIRST,FOUND,MALEI,MALEJ,PHASE,SECOND
C
C     IF THE LOCI ARE XLINKED AND BOTH THE PARENT AND CHILD ARE
C     MALE, THEN THE TRANSMISSION PROBABILITY IS BY DEFINITION 1.
C
      IF (XLINK(1).AND.MALEI.AND.MALEJ) THEN
      DO 10 I=1,NGTYPE
 10   TRANS(I)=1.0D0
      RETURN
      END IF
C
C     SET THE COUNTER FOR THE FIRST PARAMETER.
C
      IF (MALEI) THEN
      K=NLOCI-1
      ELSE
      K=0
      END IF
C
C     REDUCE THE COMPUTATIONS BY CONSIDERING ONLY THE HETEROZYGOUS LOCI.
C     EXPRESS THE RECOMBINATION FRACTION BETWEEN TWO HETEROZYGOUS
C     LOCI IN TERMS OF THE RECOMBINATION FRACTIONS BETWEEN THE ADJACENT
C     LOCI WHICH SEPARATE THEM.  SET THE LOGICAL VARIABLE FOUND TO TRUE
C     WHEN THE FIRST HETEROZYGOUS PARENTAL LOCUS IS FOUND.  PHASE RECORDS
C     THE PHASE OF THE MOST RECENT HETEROZYGOUS PARENTAL LOCUS.
C
      DO 20 I=1,NGTYPE
      FOUND=.FALSE.
      DO 30 LOCUS=1,NLOCI
      FIRST=GENES(LOCUS,1,I).EQ.GAMETE(LOCUS)
      SECOND=GENES(LOCUS,2,I).EQ.GAMETE(LOCUS)
C
C     CHECK WHETHER EITHER THE FIRST OR SECOND PARENTAL GENE AT THE
C     CURRENT LOCUS MATCHES THE GAMETE GENE AT THIS LOCUS.  IF NOT,
C     THEN RETURN WITH 0. FOR THE TRANSMISSION PROBABILITY.
C
      IF (.NOT.FIRST.AND..NOT.SECOND) THEN
      T=0.0D0
      GO TO 20
      END IF
C
C     CHECK WHETHER THE CURRENT LOCUS IS HETEROZYGOUS.
C
      IF (FIRST.NEQV.SECOND) THEN
      IF (FOUND) THEN
      IF (PHASE.EQV.FIRST) THEN
      T=T*(0.5D0+R)
      ELSE
      T=T*(0.5D0-R)
      END IF
      ELSE
      FOUND=.TRUE.
      T=0.5D0
      END IF
      PHASE=FIRST
      R=0.5D0
      END IF
 30   IF (FOUND.AND.LOCUS.LT.NLOCI) R=R*(1.0D0-2.0D0*PAR(LOCUS+K))
      IF (.NOT.FOUND) T=1.0D0
 20   TRANS(I)=T
      END

*======================================================================*
*  SUBROUTINE MENDEL                                                   *
*======================================================================*
      SUBROUTINE MENDEL (EXTRA,  RARRAY, IARRAY, CARRAY, LARRAY, ABSENT,
     *                   CONV,   DP,     XXRATE, XYRATE, COND,   LENC,
     *                   LENI,   LENL,   LENR,   MXITER, MXLOCI, MXSTEP,
     *                   MXTWIN, NCNSTR, NCONV,  NEXTRA, NPAR,   NPOINT,
     *                   NVAR,   CONIN,  CONOUT, UNIT1,  UNIT2,  UNIT3,
     *                   BASE,   LOCFIL, MUTLOC, OUTFIL, PEDFIL, TITLE,
     *                   TRAVEL, XXSIGN, XYSIGN, ASYCV,  BATCH,  ECHO,
     *                   STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION EXTRA(NEXTRA),RARRAY(LENR)
      INTEGER   IARRAY(LENI), COND, PROBLM, CONIN, CONOUT
      INTEGER   UNIT1, UNIT2, UNIT3
      CHARACTER*8 CARRAY(LENC),BASE,LINE*80,LOCFIL*40,MUTLOC,OUTFIL*40
     1,PEDFIL*40,TITLE*40,TRAVEL,XXSIGN,XYSIGN
      LOGICAL LARRAY(LENL),ASYCV,BATCH,ECHO,FULL,STAND

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

*     INITIALIZE THE SCREEN FOR THE
C      IF (.NOT.BATCH) CALL SCREEN
C
C     LIBERATE THE NEXT STATEMENT FOR UNIX SYSTEMS.
C
*      IF (.NOT.BATCH) OPEN(UNIT=SCRN,FILE='/dev/tty')
C
C     ON VMS SYSTEMS USE THE ALTERNATIVE STATEMENT:
C
C     IF (.NOT.BATCH) OPEN(UNIT=SCREEN,FILE='SYS$COMMAND'
C    1,STATUS='UNKNOWN')
C
      IF (.NOT.BATCH) THEN
      CALL CLRSCR
      CALL LOGO (CONIN, CONOUT, LINE)
      END IF
      K2=MXLOCI+1
      LENCC=LENC-MXLOCI

      CALL INPUT (EXTRA,  RARRAY, IARRAY, CARRAY(K2), CARRAY, LARRAY,
     *            ABSENT, XXRATE, XYRATE, COND,       LENCC,  LENI,
     *            LENL,   LENR,   MAXPEO, MXITER,     MXLOCI, MXTWIN,
     *            NALTOT, NCNSTR, NCVAR,  NEXTRA,     NPAR,   NPED,
     *            NPHSET, NPOINT, NPPEND, NVAR,       PROBLM, CONIN,
     *            CONOUT, UNIT1,  UNIT2,  UNIT3,      BASE,   LINE,
     *            LOCFIL, MUTLOC, OUTFIL, PEDFIL,     TITLE,  TRAVEL,
     *            XXSIGN, XYSIGN, ASYCV,  BATCH,      ECHO,   STAND)
      IF (INEED.NE.0 .OR. LNEED.NE.0 .OR. RNEED.NE.0) RETURN
      IF (CNEED.NE.0) THEN
        CNEED=CNEED+MXLOCI
        RETURN
      ENDIF

      K3=K2+MXLOCI
      IF (MXLOCI+MXLOCI+NCVAR.GT.LENC) THEN
        CNEED=MXLOCI+MXLOCI+NCVAR
        RETURN
      ENDIF
C      IF (MXLOCI+MXLOCI+NCVAR.GT.LENC) CALL ASTOP(UNIT3,'C','MENDEL')
      N2=MXLOCI+1
      N3=NCVAR+N2
      IF (MXLOCI+NCVAR+MXLOCI.GT.LENI) THEN
        INEED=MXLOCI+NCVAR+MXLOCI
        RETURN
      ENDIF
C      IF (MXLOCI+NCVAR+MXLOCI.GT.LENI) CALL ASTOP(UNIT3,'I','MENDEL')
      L2=MXLOCI+1
      L3=NCVAR+L2
      IF (MXLOCI+NCVAR+MXLOCI.GT.LENL) THEN
        LNEED=MXLOCI+NCVAR+MXLOCI
        RETURN
      ENDIF
C      IF (MXLOCI+NCVAR+MXLOCI.GT.LENL) CALL ASTOP(UNIT3,'L','MENDEL')
      IF (NEXTRA.GT.LENR) THEN
        RNEED=NEXTRA
        RETURN
      ENDIF
C      IF (NEXTRA.GT.LENR) CALL ASTOP(UNIT3,'R','MENDEL')
      DO 10 IPROB=1,PROBLM
      REWIND(UNIT1)
      CALL GETDAT(EXTRA,RARRAY,IARRAY,IARRAY(N2),IARRAY(N3),CARRAY
     1,CARRAY(K2),CARRAY(K3),LARRAY,LARRAY(L3),LARRAY(L2),XXRATE,XYRATE
     2,COND,IPROB,LENR,MAXALL,MAXPAR,MAXPEO,MAXPH,MAXTAB,MAXV,MAXVAR
     3,MCNSTR,MUTATE,MXITER,MXLOCI,NALTOT,NCNSTR,NCVAR,NEXTRA,NLOCI
     4,NPAR,NPOINT,NVAR,PROBLM,UNIT1,UNIT3,BASE,MUTLOC,TITLE,TRAVEL
     5,ASYCV,STAND)
      IF (RNEED.NE.0) RETURN
      WRITE(UNIT3,20)
 20   FORMAT(' ')
      FULL=IPROB.EQ.1
      CALL MENU(EXTRA,CARRAY,XXRATE,XYRATE,COND,UNIT3,MXITER,MXLOCI
     1,NCNSTR,NEXTRA,NLOCI,NPAR,NPOINT,NVAR,IPROB,BASE,LINE,LOCFIL
     2,MUTLOC,OUTFIL,PEDFIL,TITLE,TRAVEL,XXSIGN,XYSIGN,ASYCV,ECHO
     3,FULL,STAND)
      IF (NLOCI.GT.5) THEN
      WRITE(UNIT3,20)
      LINE=' COMPLETE LIST OF LOCI IN PROBLEM:'
      WRITE(UNIT3,30) LINE(1:79)
 30   FORMAT(A)
      DO 40 I=1,NLOCI,8
      K=3
      LINE=' '
      DO 50 J=I,MIN(I+7,NLOCI)
      LINE(K:K+7)=CARRAY(J)
 50   K=K+9
 40   WRITE(UNIT3,30) LINE(1:79)
      WRITE(UNIT3,20)
      END IF
      REWIND(UNIT2)
      MXWORK=MAXTAB
      M2=MAXALL*NLOCI+1
      M3=MAXPAR*MCNSTR+M2
      M4=MCNSTR+M3
      M5=MAXPAR+M4
      M6=MAXPAR+M5
      M7=MAXPAR+M6
      M8=MAXPAR*NPOINT+M7
      M9=MAXPAR*MAXPAR+M8
      M10=MAXPAR+M9
      M11=MAXPAR+M10
      M12=MAXPAR+M11
      M13=MAXPAR+M12
      M14=MAXTAB*MAXTAB+M13
      M15=MAXV+M14
      MAXA=LENR-M15+1
      LENRR=LENR-MAXALL*NLOCI
      N4=MAXPEO*(NLOCI+1)+N3
      N5=MAXPEO+N4
      N6=MAXPEO+N5
      N7=MAXPH+N6
      N8=NPHSET+N7
      N9=NPPEND+N8
      LENII=LENI-N9+1
      IF (LENII.LE.0) THEN
        INEED=N9
        RETURN
      ENDIF
C      IF (LENII.LE.0) CALL ASTOP(UNIT3,'I','MENDEL')
      CALL PREINF(RARRAY(M2),IARRAY(N4),IARRAY(N9),IARRAY
     1,IARRAY(N5),IARRAY(N2),IARRAY(N3),IARRAY(N6),IARRAY(N7)
     2,IARRAY(N8),CARRAY,LARRAY,LARRAY(L2),LENII,LENRR,MAXA,MAXGL
     3,MAXI,MAXLST,MAXPEO,MAXPH,MXWORK,NCVAR,NLOCI,NPED,NPHSET
     4,NPPEND,NVAR,UNIT1,UNIT2,UNIT3)
      IF (INEED.NE.0) THEN
        INEED=INEED+LENI
        RETURN
      ENDIF
      IF (RNEED.NE.0) THEN
        RNEED=RNEED+LENR
        RETURN
      ENDIF
      N4=MAXPEO+N3
      N5=MAXGL+N4
      N6=MAXPEO+N5
      N8=MAXPEO+N6
      N9=MAXI+N8
      N11=3*MAXLST+N9
      N12=MAXPEO+N11
      N13=MAXPAR+N12
      IF (N13+MAXPEO-1.GT.LENI) THEN
        INEED=N13+MAXPEO-1
        RETURN
      ENDIF
C      IF (N13+MAXPEO-1.GT.LENI) CALL ASTOP(UNIT3,'I','MENDEL')
      IF (MAXPAR.GT.LENC) THEN
        CNEED=MAXPAR
        RETURN
      ENDIF
C      IF (MAXPAR.GT.LENC) CALL ASTOP(UNIT3,'C','MENDEL')
      M16=MXWORK+M15
      M17=MXWORK+M16
      M18=MAXPAR+M17
      IF (LENR-M18+1.LT.MAX(5,MAXA)) THEN
        RNEED=MAX(5,MAXA)+M18-1
        RETURN
      ENDIF
C      IF (LENR-M18+1.LT.MAX(5,MAXA)) CALL ASTOP(UNIT3,'R','MENDEL')
      RARRAY(M18)=ABSENT
      RARRAY(M18+1)=CONV
      RARRAY(M18+2)=DP
      RARRAY(M18+3)=XXRATE
      RARRAY(M18+4)=XYRATE
 10   CALL SEARCH(RARRAY,RARRAY(M18),RARRAY(M2),RARRAY(M3),RARRAY(M4)
     1,RARRAY(M5),RARRAY(M6),EXTRA,RARRAY(M7),RARRAY(M8),RARRAY(M9)
     2,RARRAY(M10),RARRAY(M11),RARRAY(M12),RARRAY(M13),RARRAY(M14)
     3,RARRAY(M15),RARRAY(M16),RARRAY(M17),IARRAY(N4),IARRAY(N5)
     4,IARRAY(N6),IARRAY(N8),IARRAY(N9),IARRAY(N11),IARRAY(N12)
     5,IARRAY(N13),CARRAY,LARRAY(L2),COND,MAXA,MAXALL,MAXGL,MAXI
     6,MAXLST,MAXPAR,MAXPEO,MAXTAB,MAXV,MAXVAR,MCNSTR,MUTATE,MXITER
     7,MXSTEP,MXWORK,NCNSTR,NCONV,NEXTRA,NLOCI,NPAR,NPED,NPOINT,NVAR
     8,IPROB,UNIT2,UNIT3,BASE,TRAVEL,ASYCV,STAND)
      END

*======================================================================*
*  SUBROUTINE GETDAT                                                   *
*======================================================================*
      SUBROUTINE GETDAT(EXTRA,RARRAY,LCVAR,NALL,NTEMP,LNAME,LTEMP
     1,NAME,MENDEL,MTEMP,XLINK,XXRATE,XYRATE,COND,IPROB,LENR,MAXALL
     2,MAXPAR,MAXPEO,MAXPH,MAXTAB,MAXV,MAXVAR,MCNSTR,MUTATE,MXITER
     3,MXLOCI,NALTOT,NCNSTR,NCVAR,NEXTRA,NLOCI,NPAR,NPOINT,NVAR
     4,PROBLM,UNIT1,UNIT3,BASE,MUTLOC,TITLE,TRAVEL,ASYCV,STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION EXTRA(NEXTRA),RARRAY(LENR)
      INTEGER LCVAR(MXLOCI),NALL(NCVAR),NTEMP(MXLOCI),COND,PROBLM
     1,UNIT1,UNIT3
      CHARACTER*8 LNAME(MXLOCI),LTEMP(MXLOCI),NAME(NCVAR),BASE,BTEMP
     1,MUTLOC,MUTEMP,TITLE*40,TITEMP*40,TRAVEL,TRTEMP
      LOGICAL MENDEL(MXLOCI),MTEMP(MXLOCI),XLINK(NCVAR),ASYCV,ATEMP
     1,STAND,STTEMP

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      MUTLOC=' '
      MUTATE=0
      DO 10 I=1,PROBLM
      READ(UNIT1) TITEMP,I2,LTEMP,MUTEMP
      READ(UNIT1) XX,XY,I3,BTEMP,STTEMP,TRTEMP
      READ(UNIT1) I4,I5,I6,ATEMP,I7
      CALL RSCRAT(RARRAY,NEXTRA,UNIT1,.FALSE.)
      IF (I.EQ.IPROB) THEN
      TITLE=TITEMP
      NLOCI=I2
      DO 20 J=1,NLOCI
      LNAME(J)=LTEMP(J)
      IF (MUTEMP.EQ.LNAME(J)) THEN
      MUTLOC=MUTEMP
      MUTATE=J
      MENDEL(J)=.FALSE.
      ELSE
      MENDEL(J)=.TRUE.
      END IF
 20   CONTINUE
      XXRATE=XX
      XYRATE=XY
      COND=I3
      BASE=BTEMP
      STAND=STTEMP
      TRAVEL=TRTEMP
      NPOINT=I4
      NPAR=I5
      NCNSTR=I6
      ASYCV=ATEMP
      MXITER=I7
      DO 30 J=1,NEXTRA
 30   EXTRA(J)=RARRAY(J)
      END IF
 10   CONTINUE
      READ(UNIT1) NAME
      READ(UNIT1) XLINK
      CALL ISCRAT(NALL,NCVAR,UNIT1,.FALSE.)
      MAXALL=1
      DO 40 LOCUS=1,NLOCI
      NMATCH=0
      DO 50 I=1,NCVAR
      IF (LNAME(LOCUS).EQ.NAME(I)) THEN
      NMATCH=NMATCH+1
      MAXALL=MAX(MAXALL,NALL(I))
      LCVAR(LOCUS)=I
      NTEMP(LOCUS)=NALL(I)
      MTEMP(LOCUS)=XLINK(I)
      END IF
 50   CONTINUE
      IF (NMATCH.EQ.0.OR.NMATCH.GE.2) THEN
      WRITE(UNIT3,60) IPROB,LNAME(LOCUS)
 60   FORMAT(' *** ERROR *** IN PROBLEM',I3,'.  LOCUS ',A8,' IS NOT IN'
     1,' THE LOCUS FILE',/,' OR IS PRESENT THERE MULTIPLE TIMES.')
      CALL EXIT(1)
      END IF
 40   CONTINUE
      CALL RSCRAT(RARRAY,NALTOT,UNIT1,.FALSE.)
      M=MAX(NALTOT,MAXALL*NLOCI)
      IF (M+M.GT.LENR) THEN
        RNEED=M+M
        RETURN
      ENDIF
C      IF (M+M.GT.LENR) CALL ASTOP(UNIT3,'R','GETDAT')
      DO 70 LOCUS=1,NLOCI
      N=0
      L=LCVAR(LOCUS)
      DO 80 I=1,L-1
 80   N=N+NALL(I)
      NA=NALL(L)
      DO 90 J=1,NA
 90   RARRAY(M+(J-1)*NLOCI+LOCUS)=RARRAY(N+J)
 70   CONTINUE
      DO 100 LOCUS=1,NLOCI
      NALL(LOCUS)=NTEMP(LOCUS)
 100  XLINK(LOCUS)=MTEMP(LOCUS)
      DO 110 LOCUS=1,NLOCI
      NA=NALL(LOCUS)
      DO 110 J=1,NA
 110  RARRAY((J-1)*NLOCI+LOCUS)=RARRAY(M+(J-1)*NLOCI+LOCUS)
      MAXPAR=MAX(NPAR,1)
      MAXPH=MAXPEO*NCVAR
      MAXTAB=NCNSTR+NPAR+1
      MAXV=MAX(MAXPEO*NVAR,1)
      MAXVAR=MAX(NVAR,1)
      MCNSTR=MAX(NCNSTR,1)
      IF (TRAVEL(1:1).EQ.'S') NPOINT=1
      END

*======================================================================*
*  SUBROUTINE ASTOP                                                    *
*======================================================================*
      SUBROUTINE ASTOP(LOUT,C,WHERE)

      CHARACTER C,NAME*7,WHERE*6

      NAME='  ARRAY'
      NAME(2:2)=C
      WRITE(LOUT,10) WHERE,NAME
 10   FORMAT(' *** ERROR *** THE PROGRAM HAS STOPPED IN SUBROUTINE '
     1,A6,' BECAUSE',/,A7,' IS TOO SMALL.')
      CALL EXIT(1)
      END

*======================================================================*
*  SUBROUTINE ISCRAT                                                   *
*======================================================================*
      SUBROUTINE ISCRAT(STUFF,LEN,SCRAT,RITE)

      INTEGER STUFF(LEN),SCRAT
      LOGICAL RITE

      DO 10 M=1,LEN,256
      N=MIN(LEN-M+1,256)
 10   CALL SCRATI(STUFF(M),N,SCRAT,RITE)
      END

*======================================================================*
*  SUBROUTINE SCRATI                                                   *
*======================================================================*
      SUBROUTINE SCRATI(STUFF,LEN,SCRAT,RITE)

      INTEGER STUFF(LEN),SCRAT
      LOGICAL RITE

      IF (RITE) THEN
      WRITE(SCRAT) STUFF
      ELSE
      READ(SCRAT) STUFF
      END IF
      END

*======================================================================*
*  SUBROUTINE RSCRAT                                                   *
*======================================================================*
      SUBROUTINE RSCRAT(STUFF,LEN,SCRAT,RITE)

      DOUBLE PRECISION STUFF(LEN)
      INTEGER SCRAT
      LOGICAL RITE

      DO 10 M=1,LEN,128
      N=MIN(LEN-M+1,128)
 10   CALL SCRATR(STUFF(M),N,SCRAT,RITE)
      END

*======================================================================*
*  SUBROUTINE SCRATR                                                   *
*======================================================================*
      SUBROUTINE SCRATR(STUFF,LEN,SCRAT,RITE)

      DOUBLE PRECISION STUFF(LEN)
      INTEGER SCRAT
      LOGICAL RITE

      IF (RITE) THEN
      WRITE(SCRAT) STUFF
      ELSE
      READ(SCRAT) STUFF
      END IF
      END

*======================================================================*
*  SUBROUTINE LOGO                                                     *
*======================================================================*
      SUBROUTINE LOGO(LIN, LOUT,LINE)

      CHARACTER*80 LINE

      LINE=' '
      LINE(15:80)='        WELCOME TO MENDEL, VERSION 2.3.        '
      WRITE(LOUT,10) LINE
 10   FORMAT(/A)
      LINE(15:80)='PROGRAMMED BY KENNETH LANGE AND MICHAEL BOEHNKE'
      WRITE(LOUT,10) LINE
      LINE(15:80)='  (c) COPYRIGHT KENNETH LANGE, 1985,1987,1988  '
      WRITE(LOUT,10) LINE
      LINE(15:80)='       PRESS ENTER OR RETURN TO CONTINUE.      '
      WRITE(LOUT,20) LINE
 20   FORMAT(///A)
      READ (LIN, 30) LINE
 30   FORMAT(A)
      END

*======================================================================*
*  SUBROUTINE INPUT                                                    *
*======================================================================*
      SUBROUTINE INPUT (EXTRA,  RARRAY,  IARRAY, CARRAY, LNAME,  LARRAY,
     *                  ABSENT, XXRATE,  XYRATE, COND,   LENC,   LENI,
     *                  LENL,   LENR,    MAXPEO, MXITER, MXLOCI, MXTWIN,
     *                  NALTOT, NCNSTR,  NCVAR,  NEXTRA, NPAR,   NPED,
     *                  NPHSET, NPOINT,  NPPEND, NVAR,   PROBLM, CONIN,
     *                  CONOUT, UNIT1,   UNIT2,  UNIT3,  BASE,   LINE1,
     *                  LOCFIL, MUTLOC,  OUTFIL, PEDFIL, TITLE,  TRAVEL,
     *                  XXSIGN, XYSIGN,  ASYCV,  BATCH,  ECHO,   STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION EXTRA(NEXTRA),RARRAY(LENR)
      INTEGER   IARRAY(LENI), COND, PROBLM, CONIN, CONOUT
      INTEGER   UNIT1, UNIT2, UNIT3
      CHARACTER*8 CARRAY(LENC),LNAME(MXLOCI),BASE,LINE1*80,LINE2*80
     1,LOCFIL*40,MUTLOC,OUTFIL*40,PEDFIL*40,TITLE*40,TRAVEL,XXSIGN
     2,XYSIGN
      LOGICAL LARRAY(LENL),ASYCV,BATCH,ECHO,STAND

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      DO 10 I=1,MXLOCI
 10   LNAME(I)=' '
      OPEN(UNIT1,STATUS='SCRATCH',FORM='UNFORMATTED')

      CALL CHOICE (EXTRA,  LNAME,  XXRATE, XYRATE, COND,   MXITER,
     *             MXLOCI, NCNSTR, NEXTRA, NPAR,   NPOINT, NVAR,
     *             PROBLM, CONIN,  CONOUT, UNIT1,  BASE,   LINE1,
     *             LOCFIL, MUTLOC, OUTFIL, PEDFIL, TITLE,  TRAVEL,
     *             XXSIGN, XYSIGN, ASYCV,  BATCH,  ECHO,   STAND)

      OPEN(UNIT3,FILE=OUTFIL,STATUS='UNKNOWN')
      OPEN(UNIT2,FILE=LOCFIL,STATUS='OLD',ERR=20)
      REWIND(UNIT2)
      GO TO 30
 20   WRITE(UNIT3,40)
 40   FORMAT(/,' THE PROGRAM HAS STOPPED BECAUSE OF A FAILURE'
     1,' TO OPEN THE LOCUS FILE.')
      CALL EXIT(1)
 30   CALL LFILE1(RARRAY,IARRAY,CARRAY,LARRAY,LENC,LENI,LENL
     1,LENR,NALTOT,NCVAR,NPHSET,NPPEND,UNIT1,UNIT2,UNIT3,ECHO)
      IF (CNEED.NE.0 .OR. INEED.NE.0 .OR. LNEED.NE.0 .OR. RNEED.NE.0)
     *  RETURN
      CLOSE(UNIT2)
      OPEN(UNIT2,FILE=PEDFIL,STATUS='OLD',ERR=50)
      REWIND(UNIT2)
      GO TO 60
 50   WRITE(UNIT3,70)
 70   FORMAT(/,' THE PROGRAM HAS STOPPED BECAUSE OF A FAILURE'
     1,' TO OPEN THE PEDIGREE FILE.')
      CALL EXIT(1)
 60   K2=NALTOT+1
      K3=NCVAR+K2
      K4=NPPEND+K3
      N2=NCVAR+1
      N3=NCVAR+N2
      CALL PREPED(RARRAY,IARRAY(N3),IARRAY,IARRAY(N2),CARRAY
     1,CARRAY(K4),CARRAY(K2),CARRAY(K3),ABSENT,LENC,LENI,LENR
     2,MAXPEO,MXTWIN,NALTOT,NCVAR,NPED,NPPEND,NVAR,UNIT1,UNIT2
     3,UNIT3,LINE1,LINE2,XYSIGN,XXSIGN,ECHO)
      IF (CNEED.NE.0 .OR. INEED.NE.0 .OR. RNEED.NE.0) RETURN
      CLOSE(UNIT2)
      OPEN(UNIT2,STATUS='SCRATCH',FORM='UNFORMATTED')
      END

*======================================================================*
*  SUBROUTINE CHOICE                                                   *
*======================================================================*
      SUBROUTINE CHOICE (EXTRA,  LNAME,  XXRATE, XYRATE, COND,
     *                   MXITER, MXLOCI, NCNSTR, NEXTRA, NPAR,
     *                   NPOINT, NVAR,   PROBLM, CONIN,  CONOUT,
     *                   UNIT1,  BASE,   LINE,   LOCFIL, MUTLOC,
     *                   OUTFIL, PEDFIL, TITLE,  TRAVEL, XXSIGN,
     *                   XYSIGN, ASYCV,  BATCH,  ECHO,   STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION EXTRA(NEXTRA)
      INTEGER   COND, PROBLM, CONIN, CONOUT, UNIT1
      CHARACTER*8 LNAME(MXLOCI),ANSWER,BASE,LINE*80,LOCFIL*40,MUTLOC
     1,OUTFIL*40,PEDFIL*40,TITLE*40,TRAVEL,XXSIGN,XYSIGN
      LOGICAL ASYCV,BATCH,ECHO,FULL,STAND

      PROBLM=1
 1000 IF (.NOT.BATCH) THEN
      CALL CLRSCR
      FULL=PROBLM.EQ.1

      CALL MENU (EXTRA,  LNAME,  XXRATE, XYRATE, COND,   CONOUT,
     &           MXITER, MXLOCI, NCNSTR, NEXTRA, NLOCI,  NPAR,
     &           NPOINT, NVAR,   PROBLM, BASE,   LINE,   LOCFIL,
     &           MUTLOC, OUTFIL, PEDFIL, TITLE,  TRAVEL, XXSIGN,
     &           XYSIGN, ASYCV,  ECHO,   FULL,   STAND)

      END IF
 510  FORMAT(A)
      LINE=' 21 ACCEPT PROBLEM'
      IF (.NOT. BATCH) WRITE (CONOUT, 510) LINE
      IF (.NOT. BATCH) WRITE (CONOUT, 520)
 520  FORMAT(/,' CHOOSE AN ITEM [1,...,21]: ',$)

      READ (CONIN, 530, ERR=1000) ITEM
 530  FORMAT(I6)

      IF (ITEM.LT.1.OR.ITEM.GT.21) GO TO 1000

      GO TO (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
     1,21),ITEM

*-------------*
*  Choice  1  *
*-------------*
    1 IF (.NOT. BATCH) WRITE (CONOUT, 540)
  540 FORMAT(' NEW VALUE: ',$)

      READ (CONIN, 510, ERR=1000) TITLE
      GO TO 1000

*-------------*
*  Choice  2  *
*-------------*
    2 IF (.NOT. BATCH) WRITE (CONOUT, 540)

      READ (CONIN, 510, ERR=1000) LOCFIL
      GO TO 1000

*-------------*
*  Choice  3  *
*-------------*
    3 IF (.NOT. BATCH) WRITE (CONOUT, 540)

      READ (CONIN, 510, ERR=1000) PEDFIL
      GO TO 1000

*-------------*
*  Choice  4  *
*-------------*
    4 IF (.NOT. BATCH) WRITE (CONOUT, 540)

      READ (CONIN, 510, ERR=1000) OUTFIL
      GO TO 1000

*-------------*
*  Choice  5  *
*-------------*
 5    ECHO=.NOT.ECHO
      GO TO 1000

*-------------*
*  Choice  6  *
*-------------*
    6 IF (.NOT. BATCH) WRITE (CONOUT, 550)
  550 FORMAT(' FEMALE SYMBOL: ',$)

      READ (CONIN, 510, ERR=1000) XXSIGN

      IF (.NOT. BATCH) WRITE (CONOUT, 560)
  560 FORMAT(' MALE SYMBOL: ',$)

      READ (CONIN, 510, ERR=1000) XYSIGN
      GO TO 1000

*-------------*
*  Choice  7  *
*-------------*
    7 IF (.NOT. BATCH) WRITE(CONOUT, 540)
      READ (CONIN, 530, ERR=1000) NVAR
      GO TO 1000

*-------------*
*  Choice  8  *
*-------------*
 8    DO 30 I=1,NEXTRA
         IF (.NOT. BATCH) WRITE (CONOUT, 570) I
  570    FORMAT(' NEW VALUE FOR CONSTANT NUMBER',I3,': ',$)
         READ (CONIN, 510, ERR=1000) ANSWER
         CALL MBLANK(ANSWER)
         IF (ANSWER(1:1).EQ.' ') GO TO 1000
         READ(ANSWER,'(G8.2)') EXTRA(I)
   30 CONTINUE
      GO TO 1000

*-------------*
*  Choice  9  *
*-------------*
 9    NLOCI=0
      DO 40 I=1,MXLOCI
         IF (.NOT. BATCH) WRITE (CONOUT, 580) I
  580    FORMAT(' NAME OF LOCUS ',I2,': ',$)
         READ (CONIN, 510, ERR=1000) LNAME(I)
         CALL UPCASE(LNAME(I))
         CALL MBLANK(LNAME(I))
         IF (LNAME(I)(1:1).EQ.' ') GO TO 1000
         NLOCI=NLOCI+1
   40 CONTINUE
      GO TO 1000

*-------------*
*  Choice 10  *
*-------------*
   10 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 510, ERR=1000) MUTLOC
      GO TO 1000

*-------------*
*  Choice 11  *
*-------------*
   11 IF (.NOT. BATCH) WRITE (CONOUT, 590)
  590 FORMAT(' FEMALE MUTATION RATE: ',$)
      READ (CONIN, 600, ERR=1000) XXRATE
 600  FORMAT(D15.8)
      IF (.NOT. BATCH) WRITE (CONOUT, 610)
  610 FORMAT(' MALE MUTATION RATE: ',$)
      READ (CONIN, 600, ERR=1000) XYRATE
      GO TO 1000

*-------------*
*  Choice 12  *
*-------------*
   12 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 530, ERR=1000) COND
      GO TO 1000

*-------------*
*  Choice 13  *
*-------------*
 13   IF (BASE(1:1).EQ.'E') THEN
         BASE='10'
      ELSE
         BASE='E'
      END IF
      GO TO 1000

*-------------*
*  Choice 14  *
*-------------*
 14   STAND=.NOT.STAND
      GO TO 1000

*-------------*
*  Choice 15  *
*-------------*
 15   IF (TRAVEL(1:4).EQ.'GRID') THEN
         TRAVEL='SEARCH'
      ELSE
         TRAVEL='GRID'
      END IF
      GO TO 1000

*-------------*
*  Choice 16  *
*-------------*
   16 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 530, ERR=1000) NPOINT
      GO TO 1000

*-------------*
*  Choice 17  *
*-------------*
   17 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 530, ERR=1000) NPAR
      npar = npar*(npar+1)/2
      GO TO 1000

*-------------*
*  Choice 18  *
*-------------*
   18 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 530, ERR=1000) NCNSTR
      GO TO 1000

*-------------*
*  Choice 19  *
*-------------*
 19   ASYCV=.NOT.ASYCV
      GO TO 1000

*-------------*
*  Choice 20  *
*-------------*
   20 IF (.NOT. BATCH) WRITE (CONOUT, 540)
      READ (CONIN, 530, ERR=1000) MXITER
      GO TO 1000

*-------------*
*  Choice 21  *
*-------------*
 21   NVAR=MAX(NVAR,0)
      NLOCI=MAX(NLOCI,1)
      NPOINT=MAX(NPOINT,1)
      NPAR=MAX(NPAR,0)
      NCNSTR=MAX(NCNSTR,0)
      MXITER=MAX(MXITER,1)
      WRITE(UNIT1) TITLE,NLOCI,LNAME,MUTLOC
      WRITE(UNIT1) XXRATE,XYRATE,COND,BASE,STAND,TRAVEL
      WRITE(UNIT1) NPOINT,NPAR,NCNSTR,ASYCV,MXITER
      CALL RSCRAT(EXTRA,NEXTRA,UNIT1,.TRUE.)
   50 IF (.NOT. BATCH) WRITE (CONOUT, 620)
  620 FORMAT(' ANOTHER PROBLEM [YES/NO]: ',$)
      READ (CONIN, 510, ERR=50) ANSWER
      CALL MBLANK(ANSWER)
      IF (ANSWER(1:1).EQ.'Y'.OR.ANSWER(1:1).EQ.'y') THEN
         PROBLM=PROBLM+1
      GO TO 1000
      END IF
      END

*======================================================================*
*  SUBROUTINE MENU                                                     *
*======================================================================*
      SUBROUTINE MENU(EXTRA,LNAME,XXRATE,XYRATE,COND,LOUT,MXITER,MXLOCI
     1,NCNSTR,NEXTRA,NLOCI,NPAR,NPOINT,NVAR,PROBLM,BASE,LINE,LOCFIL
     2,MUTLOC,OUTFIL,PEDFIL,TITLE,TRAVEL,XXSIGN,XYSIGN,ASYCV,ECHO
     3,FULL,STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA)
      INTEGER COND,PROBLM
      CHARACTER*8 LNAME(MXLOCI),BASE,LINE*80,LOCFIL*40,MUTLOC,OUTFIL*40
     1,PEDFIL*40,TEMP,TITLE*40,TRAVEL,XXSIGN,XYSIGN
      LOGICAL ASYCV,ECHO,FULL,STAND

 10   FORMAT(A)
      M=40
      LINE='  0 PROBLEM NUMBER'
      WRITE(TEMP,'(I6)') PROBLM
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      LINE='  1 TITLE'
      LINE(M:80)=TITLE
      WRITE(LOUT,10) LINE(1:79)
      IF (FULL) THEN
      LINE='  2 LOCUS FILE'
      LINE(M:80)=LOCFIL
      WRITE(LOUT,10) LINE(1:79)
      LINE='  3 PEDIGREE FILE'
      LINE(M:80)=PEDFIL
      WRITE(LOUT,10) LINE(1:79)
      LINE='  4 OUTPUT FILE'
      LINE(M:80)=OUTFIL
      WRITE(LOUT,10) LINE(1:79)
      LINE='  5 ECHO LOCUS AND PEDIGREE FILES'
      CALL YESNO(M,LINE,ECHO)
      WRITE(LOUT,10) LINE(1:79)
      LINE='  6 FEMALE AND MALE SYMBOLS'
      CALL MBLANK(XXSIGN)
      CALL MBLANK(XYSIGN)
      LINE(M:M+7)=XXSIGN
      LINE(M+8:80)=XYSIGN
      WRITE(LOUT,10) LINE(1:79)
      LINE='  7 NUMBER OF QUANTITATIVE VARIABLES'
      WRITE(TEMP,'(I6)') NVAR
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      END IF
      K=M
      LINE='  8 EXTRA CONSTANTS FOR PROBLEM'
      DO 20 I=1,MIN(NEXTRA,5)
      WRITE(TEMP,'(G8.2E1)') EXTRA(I)
      CALL MBLANK(TEMP)
      LINE(K:K+7)=TEMP
 20   K=K+8
      WRITE(LOUT,10) LINE(1:79)
      K=M
      LINE='  9 NAMES OF LOCI IN PROBLEM'
      DO 30 I=1,MIN(NLOCI,5)
      LINE(K:K+7)=LNAME(I)
 30   K=K+8
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 10 NAME OF MUTABLE LOCUS IN PROBLEM'
      CALL UPCASE(MUTLOC)
      CALL MBLANK(MUTLOC)
      LINE(M:80)=MUTLOC
      WRITE(LOUT,10) LINE(1:79)
      IF (MUTLOC(1:1).NE.' ') THEN
      LINE=' 11 FEMALE AND MALE MUTATION RATES'
      WRITE(TEMP,'(D8.2)') XXRATE
      CALL MBLANK(TEMP)
      LINE(M:M+7)=TEMP
      LINE(M+8:M+9)='  '
      WRITE(TEMP,'(D8.2)') XYRATE
      CALL MBLANK(TEMP)
      LINE(M+10:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      END IF
      LINE=' 12 PEDIGREE TO CONDITION ON'
      WRITE(TEMP,'(I6)') COND
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 13 BASE FOR LOGLIKELIHOODS'
      CALL UPCASE(BASE)
      CALL MBLANK(BASE)
      LINE(M:80)=BASE
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 14 STANDARDIZE LOGLIKELIHOODS'
      CALL YESNO(M,LINE,STAND)
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 15 GRID OR SEARCH OPTION'
      CALL MBLANK(TRAVEL)
      LINE(M:80)=TRAVEL
      WRITE(LOUT,10) LINE(1:79)
      IF (TRAVEL(1:4).EQ.'GRID') THEN
      LINE=' 16 NUMBER OF GRID POINTS'
      WRITE(TEMP,'(I6)') NPOINT
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      END IF
      LINE=' 17 NUMBER OF PARAMETERS'
      WRITE(TEMP,'(I6)') NPAR
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      IF (TRAVEL(1:6).EQ.'SEARCH') THEN
      LINE=' 18 NUMBER OF CONSTRAINTS'
      WRITE(TEMP,'(I6)') NCNSTR
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 19 ASYMPTOTIC STANDARD ERRORS'
      CALL YESNO(M,LINE,ASYCV)
      WRITE(LOUT,10) LINE(1:79)
      LINE=' 20 MAXIMUM NUMBER OF ITERATIONS'
      WRITE(TEMP,'(I6)') MXITER
      CALL MBLANK(TEMP)
      LINE(M:80)=TEMP
      WRITE(LOUT,10) LINE(1:79)
      END IF
      END

*======================================================================*
*  SUBROUTINE UPCASE                                                   *
*======================================================================*
      SUBROUTINE UPCASE(STRING)

      CHARACTER STRING*(*)

      M=ICHAR('a')
      N=ICHAR('A')
      DO 10 I=1,LEN(STRING)
      J=ICHAR(STRING(I:I))-M
 10   IF (J.GE.0.AND.J.LE.25) STRING(I:I)=CHAR(N+J)
      END

*======================================================================*
*  SUBROUTINE MBLANK                                                   *
*======================================================================*
      SUBROUTINE MBLANK(STRING)

      CHARACTER C*1,STRING*(*)

      I=1
      DO 10 J=1,LEN(STRING)
      IF (STRING(J:J).NE.' ') THEN
      C=STRING(I:I)
      STRING(I:I)=STRING(J:J)
      STRING(J:J)=C
      I=I+1
      END IF
 10   CONTINUE
      END

*======================================================================*
*  SUBROUTINE CLEAR or CLRSCR                                          *
*======================================================================*
      SUBROUTINE CLRSCR

C      INCLUDE 'ctrlterm.h'

C      WRITE (CONOUT, AFMT) HOME, CLEAR
      END

*======================================================================*
*  SUBROUTINE YESNO                                                    *
*======================================================================*
      SUBROUTINE YESNO(M,LINE,DECIDE)

      CHARACTER LINE*80
      LOGICAL DECIDE

      IF (DECIDE) THEN
      LINE(M:80)='YES'
      ELSE
      LINE(M:80)='NO'
      END IF
      END

*======================================================================*
*  SUBROUTINE LFILE1                                                   *
*======================================================================*
      SUBROUTINE LFILE1(RARRAY,IARRAY,CARRAY,LARRAY,LENC,LENI,LENL
     1,LENR,NALTOT,NCVAR,NPHSET,NPPEND,UNIT1,UNIT2,UNIT3,ECHO)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION RARRAY(LENR)
      INTEGER IARRAY(LENI),UNIT1,UNIT2,UNIT3
      CHARACTER*8 CARRAY(LENC),ALLELE,CHROMO,GTYPE*17,NAME,PHENO
      LOGICAL LARRAY(LENL),ECHO

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      MNALL=1
      NALTOT=0
      NCVAR=0
      NPHSET=0
      NPPEND=1
C 130  READ(UNIT2,10,ERR=20,END=30) NAME,CHROMO,NALL,NPTYPE
C 10   FORMAT(2A8,2I2)
 130  READ(UNIT2,10,ERR=20,END=30) NAME,CHROMO,NALL
 10   FORMAT(2A8,I2)
      NPTYPE=NALL*NALL
      NCVAR=NCVAR+1
      IF (ECHO) THEN
         CALL UPCASE(NAME)
         CALL MBLANK(NAME)
         CALL MBLANK(CHROMO)
         WRITE(UNIT3,40) NAME,CHROMO,NALL,NPTYPE
   40    FORMAT(/,' LOCUS ',A8,1X,A8,1X,I3,' ALLELES ',I3,' PHENOTYPES',
     &         /,' ALLELE NAMES AND FREQUENCIES')
      END IF
      MNALL=MIN(MNALL,NALL)
      NALTOT=NALTOT+NALL
      NPPEND=NPPEND+NPTYPE
      DO 50 N=1,NALL
         READ(UNIT2,60,ERR=20,END=20) ALLELE,ALLFRQ
 60      FORMAT(A8,F8.5)
         IF (ECHO) THEN
            CALL MBLANK(ALLELE)
            WRITE(NAME,'(F8.5)') ALLFRQ
            CALL MBLANK(NAME)
            WRITE(UNIT3,70) ALLELE,NAME
 70         FORMAT(6X,A8,4X,A8)
         END IF
 50   CONTINUE
      IF (ECHO.AND.NPTYPE.GT.0) WRITE(UNIT3,75)
 75   FORMAT(' PHENOTYPES')
      DO 80 N=1,NPTYPE
C         READ(UNIT2,90,ERR=20,END=20) PHENO,NSET
C 90      FORMAT(A8,I2)
         NSET=1
         IF (ECHO) THEN
            CALL MBLANK(PHENO)
            WRITE(UNIT3,100) PHENO,NSET
 100        FORMAT(6X,A8,1X,I2,' GENOTYPES')
         END IF
         NPHSET=NPHSET+NSET
C         DO 80 M=1,NSET
C            READ(UNIT2,110,ERR=20,END=20) GTYPE
C 110        FORMAT(A17)
 80   IF (ECHO) WRITE(UNIT3,120) GTYPE
 120  FORMAT(8X,A17)
      GO TO 130
 20   WRITE(UNIT3,140) NCVAR
 140  FORMAT(' *** ERROR *** ERROR ENCOUNTERED IN READING LOCUS'
     1,I3,' OF THE LOCUS FILE.')
      CALL EXIT(1)
 30   NPHSET=MAX(NPHSET,1)
      REWIND(UNIT2)
      IF (NALTOT.GT.LENR) THEN
        RNEED=NALTOT
        RETURN
      ENDIF
C      IF (NALTOT.GT.LENR) CALL ASTOP(UNIT3,'R','LFILE1')
      N2=NCVAR+1
      N3=NCVAR+N2
      N4=NPHSET+N3
      IF (N4+NPPEND-1.GT.LENI) THEN
        INEED=N4+NPPEND-1
        RETURN
      ENDIF
C      IF (N4+NPPEND-1.GT.LENI) CALL ASTOP(UNIT3,'I','LFILE1')
      K2=NALTOT+1
      K3=NCVAR+K2
      IF (K3+NPPEND-1.GT.LENC) THEN
        CNEED=K3+NPPEND-1
        RETURN
      ENDIF
C      IF (K3+NPPEND-1.GT.LENC) CALL ASTOP(UNIT3,'C','LFILE1')
      IF (NCVAR.GT.LENL) THEN
        LNEED=NCVAR
        RETURN
      ENDIF
C      IF (NCVAR.GT.LENL) CALL ASTOP(UNIT3,'L','LFILE1')
      IF (NCVAR.EQ.0.OR.MNALL.LE.0) THEN
      WRITE(UNIT3,150)
 150  FORMAT(' *** ERROR *** THE LOCUS FILE MUST CONTAIN AT LEAST ONE'
     1,' LOCUS AND',/,' ONE ALLELE PER LOCUS.')
      CALL EXIT(1)
      END IF
      CALL LFILE2(RARRAY,IARRAY,IARRAY(N2),IARRAY(N3),IARRAY(N4)
     1,CARRAY,CARRAY(K2),CARRAY(K3),LARRAY,NALTOT,NCVAR,NPHSET
     2,NPPEND,UNIT1,UNIT2,UNIT3,CHROMO,GTYPE,PHENO)
      END

*======================================================================*
*  SUBROUTINE LFILE2                                                   *
*======================================================================*
      SUBROUTINE LFILE2(ALLFRQ,NALL,NPTYPE,PHLIST,PPOINT,ALLELE
     1,NAME,PTYPE,XLINK,NALTOT,NCVAR,NPHSET,NPPEND,UNIT1,UNIT2
     2,UNIT3,CHROMO,GTYPE,PHENO)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ALLFRQ(NALTOT)
      INTEGER NALL(NCVAR),NPTYPE(NCVAR),PHLIST(NPHSET)
     1,PPOINT(NPPEND),UNIT1,UNIT2,UNIT3
      CHARACTER*8 ALLELE(NALTOT),NAME(NCVAR),PTYPE(NPPEND),CHROMO
     2,GTYPE*17,PHENO
      LOGICAL XLINK(NCVAR)

      IERROR=0
      I=0
      J=0
      K=0
      L=0
 120  I=I+1
C      READ(UNIT2,10,END=20) NAME(I),CHROMO,NALL(I),NPTYPE(I)
C 10   FORMAT(2A8,2I2)
      READ(UNIT2,10,END=20) NAME(I),CHROMO,NALL(I)
 10   FORMAT(2A8,I2)
      NPTYPE(I) = NALL(I)*NALL(I)
      CALL MBLANK(CHROMO)
      IF (CHROMO(1:1).EQ.'A'.OR.CHROMO(1:1).EQ.'a') THEN
      XLINK(I)=.FALSE.
      ELSE IF (CHROMO(1:1).EQ.'X'.OR.CHROMO(1:1).EQ.'x') THEN
      XLINK(I)=.TRUE.
      ELSE
      WRITE(UNIT3,30) NAME(I)
 30   FORMAT(' *** ERROR *** IS LOCUS ',A8,' X-LINKED OR AUTOSOMAL?')
      CALL EXIT(1)
      END IF
      CALL UPCASE(NAME(I))
      CALL MBLANK(NAME(I))
      SUM=0.D0
      JSTART=J+1
      DO 40 N=1,NALL(I)
         J=J+1
         READ(UNIT2,50) ALLELE(J),ALLFRQ(J)
 50      FORMAT(A8,F8.5)
         IF (ALLFRQ(J).LE.0.D0.OR.ALLFRQ(J).GT.1.D0) THEN
            WRITE(UNIT3,60) ALLELE(J),NAME(I)
 60         FORMAT(' *** ERROR *** THE FREQUENCY OF ALLELE ',A8,' OF',
     &            ' LOCUS ',A8,/,' IS OUTSIDE THE RANGE 0.0 TO 1.0.')
            CALL EXIT(1)
         END IF
         SUM=SUM+ALLFRQ(J)
 40   CALL MBLANK(ALLELE(J))
      IF (ABS(SUM-1.0D0).GT.1.0D-4) WRITE(UNIT3,70) NAME(I),SUM
 70   FORMAT(' *** WARNING *** THE SUM OF THE ALLELE FREQUENCIES'
     1,' FOR LOCUS ',A8,/,' IS',F8.5,'.')
C      DO 80 N=1,NPTYPE(I)
      DO 80 NI=1,NALL(I)
      DO 80 NJ=1,NALL(I)
C         READ(UNIT2,90) PHENO,NSET
C 90      FORMAT(A8,I2)
         WRITE(PHENO,'(A8)') ALLELE(NI)(1:LNBLNK(ALLELE(NI))) // ' ' //
     &                       ALLELE(NJ)(1:LNBLNK(ALLELE(NJ)))
         NSET=1
         CALL MBLANK(PHENO)
         K=K+1
         PTYPE(K)=PHENO
         PPOINT(K)=L+1
         DO 80 M=1,NSET
C            READ(UNIT2,100) GTYPE
C 100        FORMAT(A17)
            GTYPE=ALLELE(NI)(1:LNBLNK(ALLELE(NI))) // '/' //
     &            ALLELE(NJ)(1:LNBLNK(ALLELE(NJ)))
            L=L+1
            CALL GETGEN(ALLELE(JSTART),IERROR,NALL(I),PHLIST(L),GTYPE)
            IF (IERROR.EQ.1) THEN
               WRITE(UNIT3,110) GTYPE,PHENO,NAME(I)
 110           FORMAT(' *** ERROR *** NO MATCH TO ALLELES FOR GENOTYPE',
     &               1X, A17,/,' OF PHENOTYPE ',A8,' OF LOCUS ',A8,'.')
               CALL EXIT(1)
            END IF
 80   CONTINUE
      GO TO 120
 20   PPOINT(K+1)=L+1
      WRITE(UNIT1) NAME
      WRITE(UNIT1) XLINK
      CALL ISCRAT(NALL,NCVAR,UNIT1,.TRUE.)
      CALL RSCRAT(ALLFRQ,NALTOT,UNIT1,.TRUE.)
      CALL ISCRAT(PHLIST,NPHSET,UNIT1,.TRUE.)
      CALL ISCRAT(PPOINT,NPPEND,UNIT1,.TRUE.)
      END

*======================================================================*
*  SUBROUTINE GETGEN                                                   *
*======================================================================*
      SUBROUTINE GETGEN(ALLELE,IERROR,NALL,PHLIST,GTYPE)

      INTEGER KALL(2),PHLIST
      CHARACTER*8 ALLELE(NALL),C(2),GTYPE*(*)

      I=INDEX(GTYPE,'/')
      LGTYPE=LEN(GTYPE)
      IF (I.EQ.0.OR.I.EQ.LGTYPE) GO TO 10
      C(1)=GTYPE(MAX(I-8,1):I-1)
      C(2)=GTYPE(I+1:MIN(I+8,LGTYPE))
      DO 20 I=1,2
      CALL MBLANK(C(I))
      DO 30 J=1,NALL
      IF (C(I).EQ.ALLELE(J)) THEN
      KALL(I)=J
      GO TO 20
      END IF
 30   CONTINUE
      GO TO 10
 20   CONTINUE
      PHLIST=(MIN(KALL(1),KALL(2))-1)*NALL+MAX(KALL(1),KALL(2))
      RETURN
 10   IERROR=1
      END

*======================================================================*
*  SUBROUTINE PREPED                                                   *
*======================================================================*
      SUBROUTINE PREPED(RARRAY,IARRAY,NALL,NPTYPE,ALLELE,CARRAY
     1,NAME,PTYPE,ABSENT,LENC,LENI,LENR,MAXPEO,MXTWIN,NALTOT,NCVAR
     2,NPED,NPPEND,NVAR,UNIT1,UNIT2,UNIT3,FRMT1,FRMT2,XYSIGN
     3,XXSIGN,ECHO)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION RARRAY(LENR)
      INTEGER IARRAY(LENI),NALL(NCVAR),NPTYPE(NCVAR),UNIT1,UNIT2
     1,UNIT3
      CHARACTER*8 ALLELE(NALTOT),CARRAY(LENC),NAME(NCVAR)
     1,PTYPE(NPPEND),FRMT1*80,FRMT2*80,IDFAM,XYSIGN,XXSIGN
      LOGICAL ECHO,QUIT

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

 510  FORMAT(A)
 520  FORMAT(/,' FORMATS FOR INPUT OF PEDIGREE DATA:',2(/,' ',A))
 530  FORMAT(' *** ERROR *** THE PROGRAM CANNOT READ THE PEDIGREE'
     1,' RECORD FOR PEDIGREE'/' NUMBER',I4,'.')
 540  FORMAT(' *** ERROR *** PEDIGREE NUMBER',I4,' HAS',I6,' PEOPLE.'
     1,'  THE MINIMUM NUMBER IS 1.')
 550  FORMAT(/,' PEDIGREE',I4,' HAS',I4,' PEOPLE AND PEDIGREE ID ',A8)
 560  FORMAT(/,'      ID       PARENT   IDS      SEX      TWIN'
     1,(T51,3(1X,A8),:))
 570  FORMAT(/,' PEDIGREE',I4,' HAS PEDIGREE ID ',A8)
 580  FORMAT(/,' TOTALS:  PEDIGREES   PEOPLE  FEMALES    MALES  MZTWINS'
     1,' FOUNDERS'
     1,/,13X,I5,5(4X,I5))
 590  FORMAT(/,' THE PROGRAM HAS STOPPED BECAUSE OF ERRORS IN THE'
     1,' PEDIGREE FILE.  THESE'/' ARE NOTED ABOVE.')
      MAXPEO=1
      NCVAR5=NCVAR+5
      NDATA=NCVAR5+NVAR
      NPED=0
      NUMPEO=0
      NMALES=0
      NTWINS=0
      NFOUND=0
      QUIT=.FALSE.
      IF (NALTOT+NDATA+NCVAR+NPPEND.GT.LENC) THEN
        CNEED=NALTOT+NDATA+NCVAR+NPPEND
        RETURN
      ENDIF
C      IF (NALTOT+NDATA+NCVAR+NPPEND.GT.LENC)
C     1CALL ASTOP(UNIT3,'C','PREPED')
      READ(UNIT2,510) FRMT1
      READ(UNIT2,510) FRMT2
      IF (ECHO) WRITE(UNIT3,520) FRMT1(1:78),FRMT2(1:78)
 40   READ(UNIT2,FRMT1,ERR=10,END=20) NPTOT,IDFAM
      GO TO 30
 10   NPED=NPED+1
      WRITE(UNIT3,530) NPED
      CALL EXIT(1)
 30   NPED=NPED+1
      NUMPEO=NUMPEO+NPTOT
      IF (NPTOT.LE.0) THEN
         WRITE(UNIT3,540) NPED,NPTOT
         CALL EXIT(1)
      END IF
      IF (ECHO) THEN
         WRITE(UNIT3,550) NPED,NPTOT,IDFAM
         DO 50 I=1,NVAR
            WRITE(CARRAY(I),'(I5)') I
 50      CARRAY(I)(1:3)='VAR'
         WRITE(UNIT3,560) (NAME(I),I=1,NCVAR),(CARRAY(I),I=1,NVAR)
      END IF
      MAXPEO=MAX(MAXPEO,NPTOT)
      MAXPH=NCVAR*NPTOT
      MAXV=MAX(NVAR*NPTOT,1)
      M2=MXTWIN+1
      M3=2*NPTOT+M2
      M4=NPTOT+M3
      M5=NPTOT+M4
      IF (M5+MAXV-1.GT.LENR) THEN
        RNEED=M5+MAXV-1
        RETURN
      ENDIF
C      IF (M5+MAXV-1.GT.LENR) CALL ASTOP(UNIT3,'R','PREPED')
      N2=NPTOT+1
      N3=NPTOT+N2
      N4=NPTOT+N3
      N5=NPTOT+N4
      N6=MXTWIN+N5
      N7=NPTOT+N6
      N8=NPTOT+N7
      N9=MAXPH+N8
      IF (2*NCVAR+N9+MXTWIN-1.GT.LENI) THEN
        INEED=2*NCVAR+N9+MXTWIN-1
        RETURN
      ENDIF
C      IF (2*NCVAR+N9+MXTWIN-1.GT.LENI) CALL ASTOP(UNIT3,'I','PREPED')
      IERROR=0
      CALL PINPUT(RARRAY,RARRAY(M2),RARRAY(M3),RARRAY(M4),RARRAY(M5)
     1,IARRAY,IARRAY(N2),IARRAY(N3),IARRAY(N4),NALL,NPTYPE,IARRAY(N5)
     2,IARRAY(N6),IARRAY(N7),IARRAY(N8),IARRAY(N9),ALLELE,CARRAY,NAME
     3,PTYPE,ABSENT,IERROR,NPED,MXTWIN,MAXPH,MAXV,NALTOT,NCVAR,NCVAR5
     4,NDATA,NFOUND,NMALES,NPPEND,NPTOT,NTWINS,NVAR,UNIT1,UNIT2,UNIT3
     5,FRMT2,IDFAM,XYSIGN,XXSIGN,ECHO)
      IF (.NOT.ECHO.AND.IERROR.NE.0.AND.IDFAM.NE.' ')
     &      WRITE(UNIT3,570) NPED,IDFAM
      IF (IERROR.GE.2) CALL EXIT(1)
      IF (IERROR.NE.0) QUIT=.TRUE.
      GO TO 40
 20   WRITE(UNIT3,580) NPED,NUMPEO,NUMPEO-NMALES,NMALES,NTWINS,NFOUND
      IF (QUIT) THEN
      WRITE(UNIT3,590)
      CALL EXIT(1)
      END IF
      END

*======================================================================*
*  SUBROUTINE PINPUT                                                   *
*======================================================================*
      SUBROUTINE PINPUT(GRLIST,PARENT,PERID,RDUMMY,VAR,FATHER,GROUP
     1,IDUMMY,MOTHER,NALL,NPTYPE,NTL,PERM,PERSON,PHEN,PTL,ALLELE
     2,CARRAY,NAME,PTYPE,ABSENT,IERROR,IPED,MXTWIN,MAXPH,MAXV
     3,NALTOT,NCVAR,NCVAR5,NDATA,NFOUND,NMALES,NPPEND,NPTOT,NTWINS
     4,NVAR,UNIT1,UNIT2,UNIT3,FRMT2,IDFAM,XYSIGN,XXSIGN,ECHO)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION GRLIST(MXTWIN),PARENT(2,NPTOT),PERID(NPTOT)
     1,RDUMMY(NPTOT),VAR(MAXV)
      INTEGER FATHER(NPTOT),GROUP(NPTOT),IDUMMY(NPTOT),MOTHER(NPTOT)
     1,NALL(NCVAR),NPTYPE(NCVAR),NTL(MXTWIN),PERM(NPTOT)
     2,PERSON(NPTOT),PHEN(MAXPH),PTL(MXTWIN),UNIT1,UNIT2,UNIT3
      CHARACTER*8 ALLELE(NALTOT),CARRAY(NDATA),IDFAM,NAME(NCVAR)
     1,PTYPE(NPPEND),BLANK8,CTYPE,FRMT2*80,XYSIGN,XXSIGN
      LOGICAL ECHO

 500  FORMAT(1X,I3,1X,5(1X,A8),(T51,3(1X,A8),:))
 510  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS A BLANK'/' PERSON ID.')
 520  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS THE SAME'/' PERSON ID AS ONE OF HIS/HER PARENTS.')
 530  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS AN ILLEGAL'/' SEX CODE.')
 540  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS ONLY ONE'/' PARENT SPECIFIED.')
 550  FORMAT(' *** ERROR *** MZ TWINS NUMBERED',I4,' AND',I4
     1,' IN PEDIGREE'/' NUMBER',I4,' HAVE DIFFERENT PARENTS.')
 560  FORMAT(' *** ERROR *** MZ TWINS NUMBERED',I4,' AND',I4
     1,' IN PEDIGREE'/' NUMBER',I4,' ARE OF OPPOSITE SEX.')
 570  FORMAT(' *** ERROR *** PEDIGREE NUMBER',I4,' EXCEEDS THE MAXIMUM'
     1,' OF',I3,' FOR'/' TOTAL MZ TWIN SETS.')
 580  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS AN ILLEGAL'/' PHENOTYPE AT LOCUS ',A8,'.')
 590  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' IS AN MZ TWIN'/' WITH NO IDENTICAL SIBS.')
 600  FORMAT(' *** WARNING *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' IS AN MZ TWIN'/' WITH MORE THAN ONE IDENTICAL SIB.')
 610  FORMAT(' *** ERROR *** PERSON NUMBER',I4,' IN PEDIGREE NUMBER'
     1,I4,' HAS PARENTS OF'/' THE SAME SEX.')
 620  FORMAT(' *** ERROR *** PARENT NUMBER',I2,' OF PERSON NUMBER'
     1,I4,' IN PEDIGREE NUMBER',/,I4,' IS NOT IN THE PEDIGREE.')
 630  FORMAT(' *** ERROR *** PERSONS NUMBERED',I4,' AND',I4,' IN'
     1,' PEDIGREE NUMBER',I4,' HAVE'/' THE SAME ID.')
 640  FORMAT(' *** ERROR *** MZ TWINS NUMBERED',I4,' AND',I4
     1,' IN PEDIGREE NUMBER',I4,/,' HAVE CONFLICTING PHENOTYPES'
     2,' AT LOCUS ',A8,'.')
 650  FORMAT(' *** ERROR *** SOMEONE NEAR PERSON NUMBER',I4,' IN'
     1,' PEDIGREE NUMBER',/,I4,' IS HIS/HER OWN ANCESTOR.')
 660  FORMAT(' *** ERROR *** END OF FILE OR ERROR ENCOUNTERED WHILE'
     1,' INPUTTING PERSON'/' NUMBER',I4,' OF PEDIGREE NUMBER',I4,'.')
      BLANK8='        '
      READ(BLANK8,'(A8)') BR8
      LGR=0
      DO 10 I=1,NPTOT
         PERSON(I)=I
         READ (UNIT2,FRMT2,ERR=1000,END=1000) (CARRAY(J),J=1,NDATA)
         DO 20 J=1,NDATA
 20      CALL MBLANK(CARRAY(J))
         IF (ECHO) THEN
            WRITE(UNIT3,500) I,(CARRAY(J),J=1,NDATA)
         END IF
         READ(CARRAY(1),'(A8)') PERID(I)
         READ(CARRAY(2),'(A8)') PARENT(1,I)
         READ(CARRAY(3),'(A8)') PARENT(2,I)
         READ(CARRAY(5),'(A8)') GRP
         IF (CARRAY(1).EQ.BLANK8) THEN
            IERROR=1
            WRITE(UNIT3,510) I,IPED
         ELSE IF (CARRAY(1).EQ.CARRAY(2).OR.CARRAY(1).EQ.CARRAY(3)) THEN
            IERROR=1
            WRITE(UNIT3,520) I,IPED
         END IF
         IF (CARRAY(4).EQ.XYSIGN) THEN
         GROUP(I)=1
         NMALES=NMALES+1
         ELSE IF (CARRAY(4).EQ.XXSIGN) THEN
         GROUP(I)=2
         ELSE
         IERROR=1
         WRITE(UNIT3,530) I,IPED
         END IF
         IF (CARRAY(2).EQ.BLANK8.NEQV.CARRAY(3).EQ.BLANK8) THEN
         IERROR=1
         WRITE(UNIT3,540) I,IPED
         END IF
         IF (CARRAY(2).EQ.BLANK8) NFOUND=NFOUND+1
         IF (CARRAY(5).NE.BLANK8) THEN
         NTWINS=NTWINS+1
         DO 30 J=1,LGR
         IF (GRP.EQ.GRLIST(J)) THEN
         JPTL=PTL(J)
         IF (PARENT(1,I).EQ.PARENT(1,JPTL).AND.PARENT(2,I).EQ.
     &         PARENT(2,JPTL)) GO TO 40
         IF (PARENT(1,I).EQ.PARENT(2,JPTL).AND.PARENT(2,I).EQ.
     &         PARENT(1,JPTL)) GO TO 40
         IERROR=1
         WRITE(UNIT3,550) JPTL,I,IPED
 40      IF (MOD(GROUP(I),2).NE.MOD(GROUP(JPTL),2)) THEN
            IERROR=1
            WRITE(UNIT3,560) JPTL,I,IPED
         END IF
         GROUP(I)=J*4+GROUP(I)
         NTL(J)=NTL(J)+1
         GO TO 50
         END IF
 30      CONTINUE
         IF (LGR.LT.MXTWIN) THEN
         LGR=LGR+1
         PTL(LGR)=I
         NTL(LGR)=1
         GRLIST(LGR)=GRP
         GROUP(I)=LGR*4+GROUP(I)
         ELSE
         IERROR=1
         WRITE(UNIT3,570) IPED,MXTWIN
         END IF
         END IF
 50      JSTART=1
         KSTART=1
         DO 60 J=1,NCVAR
            IF (J.GT.1) JSTART=JSTART+NALL(J-1)
            KEND=KSTART+NPTYPE(J)-1
            CTYPE=CARRAY(J+5)
            IF (CTYPE.EQ.BLANK8) THEN
               PHEN((J-1)*NPTOT+I)=0
            ELSE
               DO 70 K=KSTART,KEND
                  IF (CTYPE.EQ.PTYPE(K)) THEN
                     PHEN((J-1)*NPTOT+I)=K
                     GO TO 59
                  END IF
 70            CONTINUE
               CALL GETGEN(ALLELE(JSTART),IERROR,NALL(J),JPHEN,CTYPE)
               PHEN((J-1)*NPTOT+I)=-JPHEN
               IF (IERROR.EQ.1) WRITE(UNIT3,580) I,IPED,NAME(J)
            END IF
   59       KSTART=KEND+1
   60    CONTINUE
         DO 80 J=1,NVAR
            IF (CARRAY(NCVAR5+J).EQ.BLANK8) THEN
               VAR((I-1)*NVAR+J)=ABSENT
            ELSE
               READ(CARRAY(NCVAR5+J),'(F8.4)',ERR=1000)
     &               VAR((I-1)*NVAR+J)
            END IF
 80      CONTINUE
 10   CONTINUE
      NPEO=NPTOT
      DO 90 J=1,LGR
      IF (NTL(J).LE.1) THEN
      IERROR=1
      WRITE(UNIT3,590) PTL(J),IPED
      END IF
      IF (NTL(J).GE.3) WRITE(UNIT3,600) PTL(J),IPED
 90   NPEO=NPEO-NTL(J)+1
      IF (IERROR.NE.0) RETURN
      IF (NPEO.LT.NPTOT) THEN
      IEND=NPTOT
      DO 100 I=1,NPEO
      IF (GROUP(I)/4.EQ.0) GO TO 100
      DO 110 J=1,LGR
 110  IF (I.EQ.PTL(J)) GO TO 100
 140  IF (GROUP(IEND)/4.NE.0) THEN
      DO 120 J=1,LGR
      IF (IEND.EQ.PTL(J)) THEN
      PTL(J)=I
      GO TO 130
      END IF
 120  CONTINUE
      IEND=IEND-1
      GO TO 140
      END IF
 130  RSAVE=PERID(I)
      PERID(I)=PERID(IEND)
      PERID(IEND)=RSAVE
      DO 150 J=1,2
      RSAVE=PARENT(J,I)
      PARENT(J,I)=PARENT(J,IEND)
 150  PARENT(J,IEND)=RSAVE
      ISAVE=PERSON(I)
      PERSON(I)=PERSON(IEND)
      PERSON(IEND)=ISAVE
      ISAVE=GROUP(I)
      GROUP(I)=GROUP(IEND)
      GROUP(IEND)=ISAVE
      DO 160 J=1,NCVAR
      ISAVE=PHEN((J-1)*NPTOT+I)
      PHEN((J-1)*NPTOT+I)=PHEN((J-1)*NPTOT+IEND)
 160  PHEN((J-1)*NPTOT+IEND)=ISAVE
      DO 170 J=1,NVAR
      RSAVE=VAR((I-1)*NVAR+J)
      VAR((I-1)*NVAR+J)=VAR((IEND-1)*NVAR+J)
 170  VAR((IEND-1)*NVAR+J)=RSAVE
 100  CONTINUE
      END IF
      DO 180 I=1,NPTOT
      FATHER(I)=0
      MOTHER(I)=0
      DO 180 J=1,2
      PAR=PARENT(J,I)
      IF (PAR.NE.BR8) THEN
      DO 190 K=1,NPTOT
      IF (PERID(K).EQ.PAR) THEN
      IF (MOD(GROUP(K),2).EQ.1.AND.FATHER(I).EQ.0) THEN
      FATHER(I)=K
      ELSE IF (MOD(GROUP(K),2).EQ.0.AND.MOTHER(I).EQ.0) THEN
      MOTHER(I)=K
      ELSE
      IERROR=1
      WRITE(UNIT3,610) PERSON(I),IPED
      END IF
      GO TO 180
      END IF
 190  CONTINUE
      IERROR=1
      WRITE(UNIT3,620) J,PERSON(I),IPED
      END IF
 180  CONTINUE
      DO 200 I=1,NPEO
      J=FATHER(I)
      IF (J.EQ.0) GO TO 210
      K=GROUP(J)/4
      IF (K.EQ.0) GO TO 210
      FATHER(I)=PTL(K)
 210  J=MOTHER(I)
      IF (J.EQ.0) GO TO 200
      K=GROUP(J)/4
      IF (K.EQ.0) GO TO 200
      MOTHER(I)=PTL(K)
 200  CONTINUE
      DO 220 I=1,NPTOT
      PER=PERID(I)
      DO 220 J=I,NPTOT
      IF (PERID(J).EQ.PER.AND.J.NE.I) THEN
      IERROR=1
      WRITE(UNIT3,630) PERSON(I),PERSON(J),IPED
      END IF
 220  CONTINUE
      NPEO1=NPEO+1
      IF (NPEO.LT.NPTOT) THEN
      DO 230 I=1,NPEO
      IF (GROUP(I)/4.EQ.0) GO TO 230
      DO 240 J=NPEO1,NPTOT
      IF (GROUP(I)/4.NE.GROUP(J)/4) GO TO 240
      DO 250 K=1,NCVAR
      IF (PHEN((K-1)*NPTOT+I).EQ.PHEN((K-1)*NPTOT+J)) GO TO 250
      IF (PHEN((K-1)*NPTOT+I).EQ.0) THEN
      PHEN((K-1)*NPTOT+I)=PHEN((K-1)*NPTOT+J)
      ELSE IF (PHEN((K-1)*NPTOT+J).NE.0) THEN
      IERROR=1
      WRITE(UNIT3,640) PERSON(I),PERSON(J),IPED,NAME(K)
      END IF
 250  CONTINUE
 240  CONTINUE
 230  CONTINUE
      END IF
      IF (IERROR.NE.0) RETURN
      DO 260 I=NPEO1,NPTOT
 260  PERM(I)=I
      CALL LOOP(FATHER,MOTHER,PERM,IERROR,NPTOT,NPEO)
      IF (IERROR.NE.0) THEN
      WRITE(UNIT3,650) PERSON(IERROR),IPED
      IERROR=1
      RETURN
      END IF
      CALL PERMUT(RDUMMY,VAR,FATHER,GROUP,IDUMMY,MOTHER,PERM
     1,PERSON,PHEN,MAXPH,MAXV,NCVAR,NPEO,NPTOT,NVAR,UNIT1,IDFAM)
      RETURN
 1000 IERROR=2
      WRITE(UNIT3,660) I,IPED
      END

*======================================================================*
*  SUBROUTINE LOOP                                                     *
*======================================================================*
      SUBROUTINE LOOP(FATHER,MOTHER,PERM,IERROR,MAXPEO,NPEO)

      INTEGER FATHER(MAXPEO),MOTHER(MAXPEO),PERM(MAXPEO)

      IERROR=0
      M=1
      N=NPEO
      DO 10 I=1,NPEO
      IF (FATHER(I).EQ.0) THEN
      PERM(M)=I
      M=M+1
      ELSE
      PERM(N)=I+NPEO+NPEO
      N=N-1
      END IF
 10   CONTINUE
      M=1
 50   DO 20 K=M,NPEO
 20   IF (PERM(K).LE.NPEO) GO TO 30
      IERROR=MOD(PERM(M)-1,NPEO)+1
      RETURN
 30   ISAVE=PERM(K)
      PERM(K)=PERM(M)
      PERM(M)=ISAVE
      M=M+1
      IF (M.GT.NPEO) RETURN
      DO 40 I=M,NPEO
      IP=MOD(PERM(I)-1,NPEO)+1
      IF (FATHER(IP).EQ.ISAVE) PERM(I)=PERM(I)-NPEO
 40   IF (MOTHER(IP).EQ.ISAVE) PERM(I)=PERM(I)-NPEO
      GO TO 50
      END

*======================================================================*
*  SUBROUTINE PERMUT                                                   *
*======================================================================*
      SUBROUTINE PERMUT(RDUMMY,VAR,FATHER,GROUP,IDUMMY,MOTHER,PERM
     1,PERSON,PHEN,MAXPH,MAXV,NCVAR,NPEO,NPTOT,NVAR,UNIT1,IDFAM)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION RDUMMY(NPTOT),VAR(MAXV)
      INTEGER FATHER(NPTOT),GROUP(NPTOT),IDUMMY(NPTOT),MOTHER(NPTOT)
     1,PERM(NPTOT),PERSON(NPTOT),PHEN(MAXPH),UNIT1
      CHARACTER*8 IDFAM

      WRITE(UNIT1) IDFAM,NPEO,NPTOT
      DO 10 I=1,NPTOT
      II=PERM(I)
      J=FATHER(II)
      IF (J.EQ.0) THEN
      IDUMMY(I)=0
      ELSE
      DO 20 K=1,NPTOT
      IF (PERM(K).EQ.J) THEN
      IDUMMY(I)=K
      GO TO  10
      END IF
 20   CONTINUE
      END IF
 10   CONTINUE
      CALL ISCRAT(IDUMMY,NPTOT,UNIT1,.TRUE.)
      DO 30 I=1,NPTOT
      II=PERM(I)
      J=MOTHER(II)
      IF (J.EQ.0) THEN
      IDUMMY(I)=0
      ELSE
      DO 40 K=1,NPTOT
      IF (PERM(K).EQ.J) THEN
      IDUMMY(I)=K
      GO TO 30
      END IF
 40   CONTINUE
      END IF
 30   CONTINUE
      CALL ISCRAT(IDUMMY,NPTOT,UNIT1,.TRUE.)
      DO 50 I=1,NPTOT
      II=PERM(I)
 50   IDUMMY(I)=PERSON(II)
      CALL ISCRAT(IDUMMY,NPTOT,UNIT1,.TRUE.)
      DO 60 I=1,NPTOT
      II=PERM(I)
 60   IDUMMY(I)=GROUP(II)
      CALL ISCRAT(IDUMMY,NPTOT,UNIT1,.TRUE.)
      DO 70 J=1,NCVAR
      ISHIFT=(J-1)*NPTOT
      DO 80 I=1,NPTOT
      II=PERM(I)
 80   IDUMMY(I)=PHEN(ISHIFT+II)
      DO 90 I=1,NPTOT
 90   PHEN(ISHIFT+I)=IDUMMY(I)
 70   CONTINUE
      CALL ISCRAT(PHEN,MAXPH,UNIT1,.TRUE.)
      DO 100 J=1,NVAR
      DO 110 I=1,NPTOT
      II=PERM(I)
 110  RDUMMY(I)=VAR((II-1)*NVAR+J)
      DO 120 I=1,NPTOT
 120  VAR((I-1)*NVAR+J)=RDUMMY(I)
 100  CONTINUE
      IF (NVAR.GT.0) CALL RSCRAT(VAR,MAXV,UNIT1,.TRUE.)
      END

*======================================================================*
*  SUBROUTINE PREINF                                                   *
*======================================================================*
      SUBROUTINE PREINF(RARRAY,FATHER,IARRAY,LCVAR,MOTHER,NALL,NGEN
     1,PHEN,PHLIST,PPOINT,LNAME,MENDEL,XLINK,LENI,LENR,MAXA,MAXGL
     2,MAXI,MAXLST,MAXPEO,MAXPH,MXWORK,NCVAR,NLOCI,NPED,NPHSET,NPPEND
     3,NVAR,UNIT1,UNIT2,UNIT3)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION RARRAY(LENR)
      INTEGER FATHER(MAXPEO),IARRAY(LENI),IERROR(2),LCVAR(NLOCI)
     1,MOTHER(MAXPEO),NALL(NLOCI),NGEN(MAXPEO,NLOCI+1),PHEN(MAXPH)
     2,PHLIST(NPHSET),PPOINT(NPPEND),UNIT1,UNIT2,UNIT3
      CHARACTER*8 LNAME(NLOCI),IDFAM
      LOGICAL MENDEL(NLOCI),XLINK(NLOCI)

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      CALL ISCRAT(PHLIST,NPHSET,UNIT1,.FALSE.)
      CALL ISCRAT(PPOINT,NPPEND,UNIT1,.FALSE.)
      N2=MAXPEO+1
      N3=MAXPEO+N2
      N4=MAXPEO*(NLOCI+1)+N3
      N5=MAXPEO+N4
      N6=MAXPEO+N5
      MAXLG=LENI-N6+1
      IF (MAXLG.LE.0) THEN
        INEED=N6
        RETURN
      ENDIF
C      IF (MAXLG.LE.0) CALL ASTOP(UNIT3,'I','PREINF')
      IERROR(1)=0
      IERROR(2)=0
      MAXGL=0
      MAXI=0
      MAXLA=0
      DO 10 IPED=1,NPED
      CALL INF(RARRAY,IARRAY,FATHER,IARRAY(N6),IARRAY(N2),IARRAY(N3)
     1,IARRAY(N4),IERROR,LCVAR,MOTHER,NALL,NGEN,IARRAY(N5),PHEN,PHLIST
     2,PPOINT,LNAME,MENDEL,XLINK,IPED,LG,MAXLG,MAXPEO,MAXPH,LENR,MXWORK
     3,NCVAR,NLOCI,NPEO,NPHSET,NPPEND,NVAR,UNIT1,UNIT2,UNIT3,IDFAM)
      IF (INEED.NE.0) THEN
        INEED=INEED+MAXLG
        RETURN
      ENDIF
      MAXGL=MAX(MAXGL,LG)
      CALL PREORD(RARRAY,FATHER,IARRAY,MOTHER,NGEN(1,NLOCI+1),IPED
     1,LENI,LENR,LI,MAXA,MAXLA,MAXLST,MAXPEO,NPEO,UNIT2,UNIT3,IDFAM)
      IF (INEED.NE.0 .OR. RNEED.NE.0) RETURN
 10   MAXI=MAX(MAXI,LI)
      MAXA=MAXLA
      END

*======================================================================*
*  SUBROUTINE INF                                                      *
*======================================================================*
      SUBROUTINE INF(VAR,FAMILY,FATHER,GLIST,GINFO,GPOINT,GROUP
     1,IERROR,LCVAR,MOTHER,NALL,NGEN,PERSON,PHEN,PHLIST,PPOINT
     2,LNAME,MENDEL,XLINK,IPED,LG,MAXGL,MAXPEO,MAXPH,MAXV,MXWORK
     3,NCVAR,NLOCI,NPEO,NPHSET,NPPEND,NVAR,UNIT1,UNIT2,UNIT3,IDFAM)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION VAR(MAXV)
      INTEGER FAMILY(MAXPEO),FATHER(MAXPEO),GLIST(MAXGL)
     1,GINFO(MAXPEO),GPOINT(MAXPEO,NLOCI+1),GROUP(MAXPEO),IERROR(2)
     2,LCVAR(NLOCI),MOTHER(MAXPEO),NALL(NLOCI),NGEN(MAXPEO,NLOCI+1)
     3,PERSON(MAXPEO),PHEN(MAXPH),PHLIST(NPHSET),PPOINT(NPPEND)
     4,UNIT1,UNIT2,UNIT3
      CHARACTER*8 LNAME(NLOCI),IDFAM
      LOGICAL MENDEL(NLOCI),XLINK(NLOCI)

      READ(UNIT1) IDFAM,NPEO,NPTOT
      CALL ISCRAT(FATHER,NPTOT,UNIT1,.FALSE.)
      CALL ISCRAT(MOTHER,NPTOT,UNIT1,.FALSE.)
      CALL ISCRAT(PERSON,NPTOT,UNIT1,.FALSE.)
      CALL ISCRAT(GROUP,NPTOT,UNIT1,.FALSE.)
      LEN=NCVAR*NPTOT
      CALL ISCRAT(PHEN,LEN,UNIT1,.FALSE.)
      MVAR=NVAR*NPTOT
      IF (MVAR.GT.0) CALL RSCRAT(VAR,MVAR,UNIT1,.FALSE.)
      LG=0
      DO 10 LOCUS=1,NLOCI
      L=(LCVAR(LOCUS)-1)*NPTOT+1
      CALL INFER(FAMILY,FATHER,GLIST,GINFO,GPOINT(1,LOCUS),GROUP
     1,IERROR,MOTHER,NGEN(1,LOCUS),PERSON,PHEN(L),PHLIST,PPOINT,LG
     2,MAXGL,MAXPEO,NALL(LOCUS),NPEO,NPHSET,NPPEND,MENDEL(LOCUS)
     3,XLINK(LOCUS))
      IF (IERROR(1).NE.0) THEN
      WRITE(UNIT3,20) IPED,IDFAM,LNAME(LOCUS),IERROR(1)
 20   FORMAT(/,' *** ERROR *** PEDIGREE NUMBER',I4,' WITH ID ',A8
     1,'HAS AN INCONSISTENCY AT',/,' LOCUS ',A8,' NEAR PERSON NUMBER'
     2,I4,'.')
      CALL EXIT(1)
      ELSE IF (IERROR(2).NE.0) THEN
C      WRITE(UNIT3,30) IPED,IDFAM,LNAME(LOCUS)
C 30   FORMAT(/' PEDIGREE NUMBER',I4,' WITH ID ',A8,' EXCEEDS AVAILABLE'
C     1,' SPACE AT',/,' LOCUS ',A8,'.')
C      CALL ASTOP(UNIT3,'I','   INF')
      RETURN
      END IF
 10   CONTINUE
      CALL HAPLO(GLIST,GPOINT,NGEN,IERROR(2),LG,MAXGL,MAXPEO
     1,NLOCI,NPEO)
      IF (IERROR(2).NE.0) THEN
C      WRITE(UNIT3,40) IPED,IDFAM
C 40   FORMAT(/' PEDIGREE NUMBER',I4,' WITH ID ',A8,' EXCEEDS AVAILABLE'
C     1,' SPACE.')
C      CALL ASTOP(UNIT3,'I','   INF')
      RETURN
      END IF
      WRITE(UNIT2) IDFAM,NPEO,NPTOT,LG
      DO 50 I=1,NPEO
 50   MXWORK=MAX(MXWORK,NGEN(I,NLOCI+1))
      DO 60 I=1,NPEO
 60   IF (FATHER(I).EQ.0) GROUP(I)=-GROUP(I)
      CALL ISCRAT(PERSON,NPTOT,UNIT2,.TRUE.)
      CALL ISCRAT(GROUP,NPTOT,UNIT2,.TRUE.)
      CALL ISCRAT(NGEN(1,NLOCI+1),NPEO,UNIT2,.TRUE.)
      CALL ISCRAT(GLIST,LG,UNIT2,.TRUE.)
      CALL ISCRAT(GPOINT(1,NLOCI+1),NPEO,UNIT2,.TRUE.)
      IF (MVAR.GT.0) CALL RSCRAT(VAR,MVAR,UNIT2,.TRUE.)
      END

*======================================================================*
*  SUBROUTINE INFER                                                    *
*======================================================================*
      SUBROUTINE INFER(FAMILY,FATHER,GLIST,GINFO,GPOINT,GROUP
     1,IERROR,MOTHER,NGEN,PERSON,PHEN,PHLIST,PPOINT,LG,MAXGL
     2,MAXPEO,NALL,NPEO,NPHSET,NPPEND,MENDEL,XLINK)

      INTEGER FAMILY(MAXPEO),FATHER(MAXPEO),GLIST(MAXGL)
     1,GINFO(MAXPEO),GPOINT(MAXPEO),GROUP(MAXPEO),IERROR(2)
     2,MOTHER(MAXPEO),NGEN(MAXPEO),PERSON(MAXPEO),PHEN(MAXPEO)
     3,PHLIST(NPHSET),PPOINT(NPPEND),DAD
      LOGICAL INFO,MENDEL,REDO,XLINK

      DO 10 I=1,NPEO
      GINFO(I)=0
      CALL GSETUP(GLIST,GPOINT,GROUP,NGEN,PHEN,PHLIST,PPOINT
     1,I,IERROR(2),LG,MAXGL,MAXPEO,NALL,NPHSET,NPPEND,XLINK)
      IF (NGEN(I).EQ.0) IERROR(1)=PERSON(I)
 10   IF (IERROR(1).NE.0.OR.IERROR(2).NE.0) RETURN
      IF (.NOT.MENDEL) RETURN
      ITER=0
 60   LAST=ITER
      ITER=ITER+1
      INFO=.FALSE.
      DO 20 I=1,NPEO
      MOM=MOTHER(I)
      IF (MOM.LE.0) GO TO 20
      DAD=FATHER(I)
      FAMILY(1)=MOM
      FAMILY(2)=DAD
      REDO=GINFO(MOM).GE.LAST.OR.GINFO(DAD).GE.LAST
      NFAM=2
      DO 30 J=1,NPEO
      IF (MOTHER(J).EQ.MOM.AND.FATHER(J).EQ.DAD) THEN
      NFAM=NFAM+1
      FAMILY(NFAM)=J
      MOTHER(J)=-MOTHER(J)
      REDO=REDO.OR.GINFO(J).GE.LAST
      END IF
 30   CONTINUE
      IF (.NOT.REDO) GO TO 20
      CALL EXCLUD(FAMILY,GLIST,GPOINT,GROUP,NGEN,DAD,MAXGL,MAXPEO
     1,MOM,NFAM,XLINK)
      DO 40 J=1,NFAM
      K=FAMILY(J)
      CALL GPACK(GLIST,GPOINT,NGEN,PERSON,K,IERROR(1),LG,LOSS,MAXGL
     1,MAXPEO,NPEO)
      IF (IERROR(1).NE.0) RETURN
      IF (LOSS.GT.0) THEN
      GINFO(K)=ITER
      INFO=.TRUE.
      END IF
 40   CONTINUE
 20   CONTINUE
      DO 50 J=1,NPEO
 50   MOTHER(J)=-MOTHER(J)
      IF (INFO) GO TO 60
      END

*======================================================================*
*  SUBROUTINE GSETUP                                                   *
*======================================================================*
      SUBROUTINE GSETUP(GLIST,GPOINT,GROUP,NGEN,PHEN,PHLIST
     1,PPOINT,I,IERROR,LG,MAXGL,MAXPEO,NALL,NPHSET,NPPEND,XLINK)

      INTEGER GLIST(MAXGL),GPOINT(MAXPEO),GROUP(MAXPEO)
     1,NGEN(MAXPEO),PHEN(MAXPEO),PHLIST(NPHSET),PPOINT(NPPEND)
      LOGICAL XLINK

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      GPOINT(I)=LG+1
      IP=PHEN(I)
      IF (IP.EQ.0) THEN
      IF (XLINK.AND.MOD(GROUP(I),2).EQ.1) THEN
      IF (LG+NALL+NALL.GT.MAXGL) THEN
        INEED=LG+NALL+NALL
        GO TO 10
      ENDIF
C      IF (LG+NALL+NALL.GT.MAXGL) GO TO 10
      DO 20 K=1,NALL
 20   CALL PLUGIN(GLIST,K,K,LG)
      ELSE
      IF (LG+2*NALL*NALL.GT.MAXGL) THEN
        INEED=LG+2*NALL*NALL
        GO TO 10
      ENDIF
C      IF (LG+2*NALL*NALL.GT.MAXGL) GO TO 10
      DO 30 K=1,NALL
      DO 30 L=K,NALL
      CALL PLUGIN(GLIST,K,L,LG)
 30   IF (L.NE.K) CALL PLUGIN(GLIST,L,K,LG)
      END IF
      ELSE IF (IP.GT.0) THEN
      K1=PPOINT(IP)
      K2=PPOINT(IP+1)-1
      KTOT=K2-K1+1
      IF (XLINK.AND.MOD(GROUP(I),2).EQ.1) THEN
      IF (LG+KTOT+KTOT.GT.MAXGL) THEN
        INEED=LG+KTOT+KTOT
        GO TO 10
      ENDIF
C      IF (LG+KTOT+KTOT.GT.MAXGL) GO TO 10
      DO 40 K=K1,K2
      KG=PHLIST(K)
      KG1=(KG-1)/NALL+1
      KG2=KG-(KG-1)/NALL*NALL
 40   IF (KG1.EQ.KG2) CALL PLUGIN(GLIST,KG1,KG2,LG)
      ELSE
      IF (LG+4*KTOT.GT.MAXGL) THEN
        INEED=LG+4*KTOT
        GO TO 10
      ENDIF
C      IF (LG+4*KTOT.GT.MAXGL) GO TO 10
      DO 50 K=K1,K2
      KG=PHLIST(K)
      KG1=(KG-1)/NALL+1
      KG2=KG-(KG-1)/NALL*NALL
      CALL PLUGIN(GLIST,KG1,KG2,LG)
 50   IF (KG1.NE.KG2) CALL PLUGIN(GLIST,KG2,KG1,LG)
      END IF
      ELSE
      KG=-IP
      KG1=(KG-1)/NALL+1
      KG2=KG-(KG-1)/NALL*NALL
      IF (XLINK.AND.MOD(GROUP(I),2).EQ.1) THEN
      IF (LG+2.GT.MAXGL) THEN
        INEED=LG+2
        GO TO 10
      ENDIF
C      IF (LG+2.GT.MAXGL) GO TO 10
      IF (KG1.EQ.KG2) CALL PLUGIN(GLIST,KG1,KG2,LG)
      ELSE
      IF (LG+4.GT.MAXGL) THEN
        INEED=LG+4
        GO TO 10
      ENDIF
C      IF (LG+4.GT.MAXGL) GO TO 10
      CALL PLUGIN(GLIST,KG1,KG2,LG)
      IF (KG1.NE.KG2) CALL PLUGIN(GLIST,KG2,KG1,LG)
      END IF
      END IF
      NGEN(I)=(LG-GPOINT(I)+1)/2
      RETURN
 10   IERROR=1
      NGEN(I)=1
      END

*======================================================================*
*  SUBROUTINE PLUGIN                                                   *
*======================================================================*
      SUBROUTINE PLUGIN(GLIST,GENE1,GENE2,LG)

      INTEGER GLIST(*),GENE1,GENE2

      LG=LG+1
      GLIST(LG)=GENE1
      LG=LG+1
      GLIST(LG)=GENE2
      END

*======================================================================*
*  SUBROUTINE EXCLUD                                                   *
*======================================================================*
      SUBROUTINE EXCLUD(FAMILY,GLIST,GPOINT,GROUP,NGEN,DAD,MAXGL
     1,MAXPEO,MOM,NFAM,XLINK)

      INTEGER FAMILY(MAXPEO),GLIST(MAXGL),GPOINT(MAXPEO)
     1,GROUP(MAXPEO),NGEN(MAXPEO),DAD,GAMETE
      LOGICAL COMPAT,GIRL,XLINK

      DO 10 I=1,NFAM
      J=FAMILY(I)
      DO 10 K=GPOINT(J),GPOINT(J)+2*NGEN(J)-1
 10   GLIST(K)=-GLIST(K)
      DO 20 I=GPOINT(MOM),GPOINT(MOM)+2*NGEN(MOM)-1,2
      DO 20 J=GPOINT(DAD),GPOINT(DAD)+2*NGEN(DAD)-1,2
      DO 30 K=3,NFAM
      L=FAMILY(K)
      GIRL=MOD(GROUP(L),2).EQ.0
      DO 40 M=GPOINT(L),GPOINT(L)+2*NGEN(L)-1,2
      GAMETE=ABS(GLIST(M))
      COMPAT=GAMETE.EQ.ABS(GLIST(I)).OR.GAMETE.EQ.ABS(GLIST(I+1))
      IF (.NOT.COMPAT) GO TO 40
      IF (.NOT.XLINK.OR.GIRL) THEN
      GAMETE=ABS(GLIST(M+1))
      COMPAT=GAMETE.EQ.ABS(GLIST(J)).OR.GAMETE.EQ.ABS(GLIST(J+1))
      ELSE
      COMPAT=.TRUE.
      END IF
      IF (COMPAT) GO TO 30
 40   CONTINUE
      GO TO 20
 30   CONTINUE
      GLIST(I)=ABS(GLIST(I))
      GLIST(I+1)=ABS(GLIST(I+1))
      GLIST(J)=ABS(GLIST(J))
      GLIST(J+1)=ABS(GLIST(J+1))
      DO 50 K=3,NFAM
      L=FAMILY(K)
      GIRL=MOD(GROUP(L),2).EQ.0
      DO 60 M=GPOINT(L),GPOINT(L)+2*NGEN(L)-1,2
      GAMETE=ABS(GLIST(M))
      COMPAT=GAMETE.EQ.ABS(GLIST(I)).OR.GAMETE.EQ.ABS(GLIST(I+1))
      IF (.NOT.COMPAT) GO TO 60
      IF (.NOT.XLINK.OR.GIRL) THEN
      GAMETE=ABS(GLIST(M+1))
      COMPAT=GAMETE.EQ.ABS(GLIST(J)).OR.GAMETE.EQ.ABS(GLIST(J+1))
      ELSE
      COMPAT=.TRUE.
      END IF
      IF (COMPAT) THEN
      GLIST(M)=ABS(GLIST(M))
      GLIST(M+1)=ABS(GLIST(M+1))
      END IF
 60   CONTINUE
 50   CONTINUE
 20   CONTINUE
      END

*======================================================================*
*  SUBROUTINE GPACK                                                    *
*======================================================================*
      SUBROUTINE GPACK(GLIST,GPOINT,NGEN,PERSON,I,IERROR,LG,LOSS,MAXGL
     1,MAXPEO,NPEO)

      INTEGER GLIST(MAXGL),GPOINT(MAXPEO),NGEN(MAXPEO),PERSON(MAXPEO)

      ISTART=GPOINT(I)
      IEND=ISTART+2*NGEN(I)-1
      L=ISTART
      DO 10 K=ISTART,IEND
      IF (GLIST(K).GT.0) THEN
      GLIST(L)=GLIST(K)
      L=L+1
      END IF
 10   CONTINUE
      LOSS=K-L
      IF (LOSS.GT.0) THEN
      NGEN(I)=NGEN(I)-LOSS/2
      DO 20 K=IEND+1,LG
      GLIST(L)=GLIST(K)
 20   L=L+1
      DO 30 J=1,NPEO
      JSTART=GPOINT(J)
 30   IF (JSTART.GT.ISTART) GPOINT(J)=JSTART-LOSS
      LG=LG-LOSS
      END IF
      IF (NGEN(I).LE.0) IERROR=PERSON(I)
      END

*======================================================================*
*  SUBROUTINE HAPLO                                                    *
*======================================================================*
      SUBROUTINE HAPLO(GLIST,GPOINT,NGEN,IERROR,LG,MAXGL,MAXPEO
     1,NLOCI,NPEO)

      INTEGER GLIST(MAXGL),GPOINT(MAXPEO,NLOCI+1),NGEN(MAXPEO,NLOCI+1)

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      NLOCI2=NLOCI+NLOCI
      DO 10 I=1,NPEO
      NGENES=1
      DO 20 LOCUS=1,NLOCI
 20   NGENES=NGENES*NGEN(I,LOCUS)
      GPOINT(I,NLOCI+1)=LG+1
      IF (LG+NLOCI2*NGENES.GT.MAXGL) THEN
      INEED=LG+NLOCI2*NGENES
      IERROR=1
      RETURN
      END IF
      DO 30 J=0,NGENES-1
      JJ=J
      DO 40 LOCUS=1,NLOCI
      N=NGEN(I,LOCUS)
      JJJ=JJ/N
      L=GPOINT(I,LOCUS)+2*(JJ-JJJ*N)
      LG=LG+1
      GLIST(LG)=GLIST(L)
      GLIST(LG+NLOCI)=GLIST(L+1)
 40   JJ=JJJ
 30   LG=LG+NLOCI
      DO 50 J=0,NGENES-1
      IF (GLIST(GPOINT(I,NLOCI+1)+J*NLOCI2).LT.0) GO TO 50
      JJ=J
      NPROD=1
      JIDENT=0
      DO 60 LOCUS=1,NLOCI
      N=NGEN(I,LOCUS)
      JJJ=JJ/N
      L=JJ-JJJ*N
      M=GPOINT(I,LOCUS)+L+L
      IF (GLIST(M).LT.GLIST(M+1)) THEN
      IF (L+1.GE.N) GO TO 50
      IF (GLIST(M).NE.GLIST(M+3).OR.GLIST(M+1).NE.GLIST(M+2)) GO TO 50
      JIDENT=JIDENT+(L+1)*NPROD
      ELSE IF (GLIST(M).GT.GLIST(M+1)) THEN
      IF (L.LE.0) GO TO 50
      IF (GLIST(M).NE.GLIST(M-1).OR.GLIST(M+1).NE.GLIST(M-2)) GO TO 50
      JIDENT=JIDENT+(L-1)*NPROD
      ELSE
      JIDENT=JIDENT+L*NPROD
      END IF
      NPROD=NPROD*N
 60   JJ=JJJ
      IF (JIDENT.NE.J) THEN
      L=GPOINT(I,NLOCI+1)+JIDENT*NLOCI2
      DO 70 K=L,L+NLOCI2-1
 70   GLIST(K)=-GLIST(K)
      END IF
 50   CONTINUE
      LOSS=0
      L=GPOINT(I,NLOCI+1)
      DO 80 K=L,L+NGENES*NLOCI2-1
      IF (GLIST(K).GT.0) THEN
      GLIST(L)=GLIST(K)
      L=L+1
      ELSE
      LOSS=LOSS+1
      END IF
 80   CONTINUE
      NGEN(I,NLOCI+1)=NGENES-LOSS/(NLOCI2)
 10   LG=LG-LOSS
      IGNORE=GPOINT(1,NLOCI+1)-1
      LG=LG-IGNORE
      DO 90 I=1,NPEO
 90   GPOINT(I,NLOCI+1)=GPOINT(I,NLOCI+1)-IGNORE
      L=IGNORE
      DO 100 K=1,LG
      L=L+1
 100  GLIST(K)=GLIST(L)
      END

*======================================================================*
*  SUBROUTINE PREORD                                                   *
*======================================================================*
      SUBROUTINE PREORD(RARRAY,FATHER,IARRAY,MOTHER,NGEN,IPED,LENI
     1,LENR,LI,MAXA,MAXLA,MAXLST,MAXPEO,NPEO,UNIT2,UNIT3,IDFAM)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION RARRAY(LENR)
      INTEGER FATHER(MAXPEO),IARRAY(LENI),MOTHER(MAXPEO)
     1,NGEN(MAXPEO),UNIT2,UNIT3
      CHARACTER*8 IDFAM
      LOGICAL OPEROK,OPTOP

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      M2=MAXPEO+1
      M3=MAXPEO+M2
      IF (LENR.LT.3*MAXPEO) THEN
        RNEED=3*MAXPEO
        RETURN
      ENDIF
C      IF (LENR.LT.3*MAXPEO) CALL ASTOP(UNIT3,'R','PREORD')
      MAXAP=4*MAXPEO
      MAXS=9*MAXPEO
      N2=MAXAP+1
      N3=MAXAP+N2
      N4=MAXPEO+N3
      N5=MAXPEO+N4
      N6=MAXPEO+N5
      N7=MAXS+N6
      N8=MAXPEO+N7
      MAXI=LENI-N8+1
      IF (MAXI.LE.0) THEN
        INEED=N8
        RETURN
      ENDIF
C      IF (MAXI.LE.0) CALL ASTOP(UNIT3,'I','PREORD')
      OPTOP=.TRUE.
      MAXLAO=MAXLA
      CALL ORDER(RARRAY,RARRAY(M2),RARRAY(M3),IARRAY,IARRAY(N2)
     1,FATHER,IARRAY(N8),MOTHER,NGEN,IARRAY(N3),IARRAY(N4),IARRAY(N5)
     2,IARRAY(N6),IARRAY(N7),TOTOP,IERROR,LI,MAXA,MAXLAO,MAXAP,MAXI
     3,MAXLST,MAXPEO,MAXS,NPEO,OPTOP)
      IF (IERROR.NE.0.OR.TOTOP.GT.1.0D4) THEN
      INEED=0
      RNEED=0
      OPEROK=.TRUE.
      IF (IERROR.NE.0) OPEROK=.FALSE.
      OLDOP=TOTOP+1.0D3
      OPTOP=.FALSE.
      MAXLAS=MAXLA
      CALL ORDER(RARRAY,RARRAY(M2),RARRAY(M3),IARRAY,IARRAY(N2)
     1,FATHER,IARRAY(N8),MOTHER,NGEN,IARRAY(N3),IARRAY(N4),IARRAY(N5)
     2,IARRAY(N6),IARRAY(N7),TOTOP,IERROR,LI,MAXA,MAXLAS,MAXAP,MAXI
     3,MAXLST,MAXPEO,MAXS,NPEO,OPTOP)
      IF (IERROR.NE.0.AND..NOT.OPEROK) THEN
      IF (IERROR.EQ.1) THEN
        INEED=INEED+N8
        RETURN
      ENDIF
C      IF (IERROR.EQ.1) CALL ASTOP(UNIT3,'I','PREORD')
      IF (IERROR.EQ.2) THEN
        RETURN
C      WRITE(UNIT3,10) IPED,IDFAM
C 10   FORMAT(/' PEDIGREE NUMBER',I4,' WITH ID ',A8,' EXCEEDS AVAILABLE'
C     1,' SPACE.')
C      CALL ASTOP(UNIT3,'R','PREORD')
      END IF
      ELSE IF (IERROR.NE.0.OR.(TOTOP.GT.OLDOP.AND.OPEROK)) THEN
      OPTOP=.TRUE.
      CALL ORDER(RARRAY,RARRAY(M2),RARRAY(M3),IARRAY,IARRAY(N2)
     1,FATHER,IARRAY(N8),MOTHER,NGEN,IARRAY(N3),IARRAY(N4),IARRAY(N5)
     2,IARRAY(N6),IARRAY(N7),TOTOP,IERROR,LI,MAXA,MAXLAO,MAXAP,MAXI
     3,MAXLST,MAXPEO,MAXS,NPEO,OPTOP)
      END IF
      END IF
      IF (OPTOP) THEN
      MAXLA=MAXLAO
      ELSE
      MAXLA=MAXLAS
      END IF
      WRITE(UNIT2) LI
      CALL ISCRAT(IARRAY(N8),LI,UNIT2,.TRUE.)
      END

*======================================================================*
*  SUBROUTINE ORDER                                                    *
*======================================================================*
      SUBROUTINE ORDER(ADDIT,MULTI,SPACE,AMOUNT,APOINT,FATHER
     1,INSTR,MOTHER,NGEN,PERM,SETB,SETC,SETS,SLIST,TOTOP,IERROR
     2,LI,MAXA,MAXLA,MAXAP,MAXI,MAXLST,MAXPEO,MAXS,NPEO,OPTOP)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ADDIT(MAXPEO),MULTI(MAXPEO),SPACE(MAXPEO)
      INTEGER AMOUNT(MAXAP),APOINT(MAXAP),FATHER(MAXPEO),INSTR(MAXI)
     1,MOTHER(MAXPEO),NGEN(MAXPEO),PERM(MAXPEO),SETB(MAXPEO)
     2,SETC(MAXPEO),SETS(MAXS),SLIST(MAXPEO)
      LOGICAL FLAG,OPTOP

      TOTOP=0.0D0
      IERROR=0
      LA=0
      LI=0
      LP=0
      LS=0
      DO 10 I=1,NPEO
      ADDIT(I)=-1.0D0
 10   PERM(I)=I
      CALL SETUP(FATHER,MOTHER,SETS,LS,MAXPEO,MAXS,NPEO)
      DO 20 I=1,NPEO
      BEST1=1.0D20
      BEST2=1.0D20
      DO 30 JJ=I,NPEO
      J=PERM(JJ)
      IF (ADDIT(J).LT.0.0D0) THEN
      FLAG=.FALSE.
      CALL EVAL(ADDIT,MULTI,SPACE,AMOUNT,APOINT,INSTR,NGEN
     1,SETB,SETC,SETS,SLIST,IERROR,J,LA,LI,LP,LS,MAXA,MAXLA
     2,MAXAP,MAXI,MAXLST,MAXPEO,MAXS,FLAG)
      END IF
      IF (OPTOP) THEN
      CRIT1=ADDIT(J)+MULTI(J)
      CRIT2=SPACE(J)
      ELSE
      CRIT1=SPACE(J)
      CRIT2=ADDIT(J)+MULTI(J)
      END IF
      IF (CRIT1.LT.BEST1.OR.(CRIT1.EQ.BEST1.AND.CRIT2.LT.BEST2)) THEN
      KK=JJ
      BEST1=CRIT1
      BEST2=CRIT2
      END IF
 30   CONTINUE
      K=PERM(KK)
      FLAG=.TRUE.
      CALL EVAL(ADDIT,MULTI,SPACE,AMOUNT,APOINT,INSTR,NGEN
     1,SETB,SETC,SETS,SLIST,IERROR,K,LA,LI,LP,LS,MAXA,MAXLA
     2,MAXAP,MAXI,MAXLST,MAXPEO,MAXS,FLAG)
      IF (IERROR.NE.0) RETURN
      TOTOP=TOTOP+ADDIT(K)+MULTI(K)
      PERM(KK)=PERM(I)
 20   PERM(I)=K
      LI=LI+1
      INSTR(LI)=-5
      END

*======================================================================*
*  SUBROUTINE SETUP                                                    *
*======================================================================*
      SUBROUTINE SETUP(FATHER,MOTHER,SETS,LS,MAXPEO,MAXS,NPEO)

      INTEGER FATHER(MAXPEO),MOTHER(MAXPEO),SETS(MAXS)

      DO 10 K=1,NPEO
      I=FATHER(K)
      IF (I.NE.0) THEN
      J=MOTHER(K)
      IF (I.GT.J) THEN
      M=J
      J=I
      I=M
      END IF
      SETS(LS+1)=3
      SETS(LS+2)=0
      SETS(LS+3)=I
      SETS(LS+4)=J
      LS=LS+5
      SETS(LS)=K
      END IF
      SETS(LS+1)=1
      SETS(LS+2)=0
      LS=LS+3
 10   SETS(LS)=K
      END

*======================================================================*
*  SUBROUTINE EVAL                                                     *
*======================================================================*
      SUBROUTINE EVAL(ADDIT,MULTI,SPACE,AMOUNT,APOINT,INSTR
     1,NGEN,SETB,SETC,SETS,SLIST,IERROR,J,LA,LI,LP,LS,MAXA
     2,MAXLA,MAXAP,MAXI,MAXLST,MAXPEO,MAXS,FLAG)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ADDIT(MAXPEO),MULTI(MAXPEO),SPACE(MAXPEO)
      INTEGER AMOUNT(MAXAP),APOINT(MAXAP),INSTR(MAXI)
     1,NGEN(MAXPEO),SETB(MAXPEO),SETC(MAXPEO),SETS(MAXS)
     2,SLIST(MAXPEO),CARDB,CARDS
      LOGICAL DUPL,FLAG

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      SPACE(J)=0.0D0
      LSL=0
      NS=1
      SETB(1)=J
      CARDB=1
 30   IF (NS.LT.LS) THEN
      CARDS=SETS(NS)
      NSTART=NS+2
      CALL MEET(J,SETS(NSTART),SETC,LC,1,CARDS,MAXPEO)
      IF (LC.EQ.1) THEN
      LSL=LSL+1
      SLIST(LSL)=NS
      IF (SETS(NS+1).GT.0) THEN
      T=1.0D0
      DO 10 I=NSTART,NSTART+CARDS-1
 10   T=T*NGEN(SETS(I))
      SPACE(J)=SPACE(J)-T
      END IF
      CALL JOIN(SETS(NSTART),SETB,SETC,LC,CARDS,CARDB,MAXPEO)
      DO 20 I=1,LC
 20   SETB(I)=SETC(I)
      CARDB=LC
      END IF
      NS=NS+2+CARDS
      GO TO 30
      END IF
      T=1.0D0
      DO 40 I=1,CARDB
      IB=SETB(I)
      IF (IB.NE.J) T=T*NGEN(IB)
 40   IF (FLAG) ADDIT(IB)=-1.0D0
      SPACE(J)=SPACE(J)+T
      ADDIT(J)=T*NGEN(J)-T
      MULTI(J)=(LSL-1)*T*NGEN(J)
      IF (.NOT.FLAG) RETURN
      MULTI(J)=0.0D0
      MAXLST=MAX(MAXLST,CARDB)
      IF (LSL.EQ.1) THEN
      NS=SLIST(1)
      K=SETS(NS+1)
      IF (K.EQ.0) THEN
      IF (LA+NGEN(J).GT.MAXA) THEN
      IF (LP.GT.0) THEN
      CALL RINSTR(AMOUNT,APOINT,INSTR,LA,LI,LP,MAXAP,MAXI)
      IF (LI.GT.MAXI) IERROR=1
      IF (LA+NGEN(J).GT.MAXA) IERROR=2
      ELSE
      IERROR=2
      END IF
      IF (IERROR.EQ.1) INEED=LI
      IF (IERROR.EQ.2) RNEED=LA+NGEN(J)
      IF (IERROR.NE.0) RETURN
      END IF
      MAXLA=MAX(MAXLA,LA+NGEN(J))
      IPOINT=-LA-1
      ELSE
      IPOINT=APOINT(K)
      AMOUNT(K)=0
      END IF
      IF (LI+4.GT.MAXI) THEN
      INEED=LI+4
      IERROR=1
      RETURN
      END IF
      INSTR(LI+1)=-4
      INSTR(LI+2)=IPOINT
      LI=LI+3
      INSTR(LI)=J
      SETS(NS)=-1000
      SETS(NS+1)=-1000
      SETS(NS+2)=-1000
      CALL REPACK(SETS,-1000,LS,MAXS)
      ELSE
      DUPL=.FALSE.
      CALL FMULT(AMOUNT,APOINT,INSTR,NGEN,SETC,SETS,SLIST,MULTI(J)
     1,IERROR,J,LA,LI,LP,LS,LSL,MAXA,MAXLA,MAXAP,MAXI,MAXPEO
     2,MAXS,DUPL)
      IF (IERROR.NE.0) RETURN
      NSAVE=SLIST(1)
      CARDB=CARDB-1
      NSTART=NSAVE+2
      NS=1
 50   CARDS=SETS(NS)
      IF (CARDS.EQ.CARDB.AND.NS.NE.NSAVE) THEN
      CALL MEET(SETS(NSTART),SETS(NS+2),SETC,LC,CARDS,CARDS,MAXPEO)
      IF (LC.EQ.CARDS) THEN
      SLIST(2)=NS
      LSL=2
      DUPL=.TRUE.
      CALL FMULT(AMOUNT,APOINT,INSTR,NGEN,SETC,SETS,SLIST,MULTI(J)
     1,IERROR,J,LA,LI,LP,LS,LSL,MAXA,MAXLA,MAXAP,MAXI,MAXPEO
     2,MAXS,DUPL)
      RETURN
      END IF
      END IF
      NS=NS+2+CARDS
      IF (NS.LT.LS) GO TO 50
      END IF
      END

*======================================================================*
*  SUBROUTINE FMULT                                                    *
*======================================================================*
      SUBROUTINE FMULT(AMOUNT,APOINT,INSTR,NGEN,SETC,SETS,SLIST
     1,MULTI,IERROR,JJ,LA,LI,LP,LS,LSL,MAXA,MAXLA,MAXAP,MAXI
     2,MAXPEO,MAXS,DUPL)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION MULTI
      INTEGER AMOUNT(MAXAP),APOINT(MAXAP),INSTR(MAXI),NGEN(MAXPEO)
     1,SETC(MAXPEO),SETS(MAXS),SLIST(MAXPEO)
      LOGICAL DUPL,FLAG2

      INTEGER CNEED, INEED, LNEED, RNEED
      COMMON /NEEDED/ CNEED, INEED, LNEED, RNEED

      FLAG2=.FALSE.
 120  IF (LSL.EQ.2.AND..NOT.DUPL) FLAG2=.TRUE.
      TMIN=1.0D20
      DO 10 I=1,LSL
      IS=SLIST(I)
      DO 10 J=I+1,LSL
      JS=SLIST(J)
      CALL JOIN(SETS(IS+2),SETS(JS+2),SETC,LC,SETS(IS),SETS(JS),MAXPEO)
      T=1.0D0
      DO 20 K=1,LC
 20   T=T*NGEN(SETC(K))
      IF (T.LT.TMIN) THEN
      M=I
      N=J
      MS=IS
      NS=JS
      TMIN=T
      END IF
 10   CONTINUE
      MULTI=MULTI+TMIN
      IF (FLAG2) TMIN=TMIN/NGEN(JJ)
      LSL=LSL+1
      SLIST(LSL)=LS+1
      MPOINT=SETS(MS+1)
      NPOINT=SETS(NS+1)
      MS2=MS+2
      NS2=NS+2
      MEND=MS2+SETS(MS)-1
      NEND=NS2+SETS(NS)-1
      CALL JOIN(SETS(MS2),SETS(NS2),SETS(LS+3),IDIM,SETS(MS)
     1,SETS(NS),MAXPEO)
      T=0.0D0
      IF (MPOINT.EQ.0) THEN
      TM=1.0D0
      DO 30 K=MS2,MEND
 30   TM=TM*NGEN(SETS(K))
      T=T+TM
      END IF
      IF (NPOINT.EQ.0) THEN
      TN=1.0D0
      DO 40 K=NS2,NEND
 40   TN=TN*NGEN(SETS(K))
      T=T+TN
      END IF
      IF (IDIM.NE.SETS(MS).AND.IDIM.NE.SETS(NS)) T=T+TMIN
      IF (LA+INT(T).GT.MAXA) THEN
      IF (LP.GT.0) THEN
      CALL RINSTR(AMOUNT,APOINT,INSTR,LA,LI,LP,MAXAP,MAXI)
      IF (LI.GT.MAXI) IERROR=1
      IF (LA+INT(T).GT.MAXA) IERROR=2
      ELSE
      IERROR=2
      END IF
      IF (IERROR.EQ.1) INEED=LI
      IF (IERROR.EQ.2) RNEED=LA+INT(T)
      IF (IERROR.NE.0) RETURN
      END IF
      IF (LI+SETS(MS)+SETS(NS)+IDIM+8.GT.MAXI) THEN
      INEED=LI+SETS(MS)+SETS(NS)+IDIM+8
      IERROR=1
      RETURN
      END IF
      IF (FLAG2) THEN
      INSTR(LI+1)=-2
      ELSE
      INSTR(LI+1)=-1
      END IF
      INSTR(LI+2)=SETS(MS)
      INSTR(LI+3)=SETS(NS)
      LISAVE=LI+4
      LI=LI+6
      DO 50 K=MS2,MEND
      LI=LI+1
 50   INSTR(LI)=SETS(K)
      DO 60 K=NS2,NEND
      LI=LI+1
 60   INSTR(LI)=SETS(K)
      IF (FLAG2) THEN
      DO 70 I=1,IDIM
 70   IF (SETS(LS+2+I).EQ.JJ) INJ=I
      LI=LI+1
      INSTR(LI)=INJ
      SETS(LS+1)=IDIM-1
      ELSE
      SETS(LS+1)=IDIM
      END IF
      LI=LI+1
      INSTR(LI)=IDIM
      DO 80 I=1,IDIM
      LI=LI+1
 80   INSTR(LI)=SETS(LS+2+I)
      IF (FLAG2) SETS(LS+2+INJ)=-1000
      IF (MPOINT.EQ.0) THEN
      LP=LP+1
      MPOINT=LP
      APOINT(MPOINT)=LA+1
      INSTR(LISAVE)=-LA-1
      LA=LA+INT(TM)
      MAXLA=MAX(MAXLA,LA)
      ELSE
      INSTR(LISAVE)=APOINT(MPOINT)
      END IF
      AMOUNT(MPOINT)=0
      IF (NPOINT.EQ.0) THEN
      LP=LP+1
      NPOINT=LP
      APOINT(NPOINT)=LA+1
      INSTR(LISAVE+1)=-LA-1
      LA=LA+INT(TN)
      MAXLA=MAX(MAXLA,LA)
      ELSE
      INSTR(LISAVE+1)=APOINT(NPOINT)
      END IF
      AMOUNT(NPOINT)=0
      IF (IDIM.EQ.SETS(MS)) THEN
      K=MPOINT
      ELSE IF (IDIM.EQ.SETS(NS)) THEN
      K=NPOINT
      ELSE
      LP=LP+1
      K=LP
      APOINT(LP)=LA+1
      LA=LA+INT(TMIN)
      MAXLA=MAX(MAXLA,LA)
      END IF
      AMOUNT(K)=INT(TMIN)
      INSTR(LISAVE+2)=APOINT(K)
      SETS(LS+2)=K
      LS=LS+2+IDIM
      DO 90 K=MS,MEND
 90   SETS(K)=-1000
      DO 100 K=NS,NEND
 100  SETS(K)=-1000
      CALL REPACK(SETS,-1000,LS,MAXS)
      DO 110 K=1,LSL
      IF (K.GT.M.AND.K.LT.N) THEN
      SLIST(K-1)=SLIST(K)-(MEND-MS+1)
      ELSE IF (K.GT.N) THEN
      SLIST(K-2)=SLIST(K)-(MEND-MS+1)-(NEND-NS+1)
      END IF
 110  CONTINUE
      LSL=LSL-2
      IF (LSL.GT.1) GO TO 120
      SLIST(1)=LS-IDIM
      END

*======================================================================*
*  SUBROUTINE RINSTR                                                   *
*======================================================================*
      SUBROUTINE RINSTR(AMOUNT,APOINT,INSTR,LA,LI,LP,MAXAP,MAXI)

      INTEGER AMOUNT(MAXAP),APOINT(MAXAP),INSTR(MAXI)
      LOGICAL BADBLK

      BADBLK=.FALSE.
      IPOINT=1
      LENBLK=0
      JUNK=0
      LI=LI+2
      LISAVE=LI
      DO 10 I=1,LP
      IF (IPOINT.LT.APOINT(I).AND..NOT.BADBLK) THEN
      LI=LI+1
      IF (LI.GT.MAXI) RETURN
      INSTR(LI)=LENBLK
      LENBLK=0
      BADBLK=.TRUE.
      END IF
      LENBLK=LENBLK+APOINT(I)-IPOINT
      JUNK=JUNK+APOINT(I)-IPOINT
      IF (AMOUNT(I).GT.0.AND.BADBLK) THEN
      LI=LI+1
      IF (LI.GT.MAXI) RETURN
      INSTR(LI)=LENBLK
      LENBLK=0
      BADBLK=.FALSE.
      END IF
      LENBLK=LENBLK+AMOUNT(I)
      IPOINT=APOINT(I)+AMOUNT(I)
 10   APOINT(I)=APOINT(I)-JUNK
      LI=LI+1
      IF (LI.GT.MAXI) RETURN
      INSTR(LI)=LENBLK
      INSTR(LISAVE-1)=-3
      INSTR(LISAVE)=LI-LISAVE
      LA=APOINT(LP)+AMOUNT(LP)-1
      END

*======================================================================*
*  SUBROUTINE REPACK                                                   *
*======================================================================*
      SUBROUTINE REPACK(LIST,JUNK,LL,NLIST)

      INTEGER LIST(NLIST)

      K=0
      DO 10 L=1,LL
      IF (LIST(L).NE.JUNK) THEN
      K=K+1
      LIST(K)=LIST(L)
      END IF
 10   CONTINUE
      LL=K
      END

*======================================================================*
*  SUBROUTINE MEET                                                     *
*======================================================================*
      SUBROUTINE MEET(SETA,SETB,SETC,LC,NA,NB,NC)

      INTEGER SETA(NA),SETB(NB),SETC(NC)

      I=1
      J=1
      LC=0
 10   K=SETA(I)-SETB(J)
      IF (K.EQ.0) THEN
      LC=LC+1
      SETC(LC)=SETA(I)
      I=I+1
      J=J+1
      ELSE IF (K.LT.0) THEN
      I=I+1
      ELSE
      J=J+1
      END IF
      IF (I.GT.NA.OR.J.GT.NB) RETURN
      GO TO 10
      END

*======================================================================*
*  SUBROUTINE JOIN                                                     *
*======================================================================*
      SUBROUTINE JOIN(SETA,SETB,SETC,LC,NA,NB,NC)

      INTEGER SETA(NA),SETB(NB),SETC(NC)

      I=1
      J=1
      LC=0
 30   K=SETA(I)-SETB(J)
      LC=LC+1
      IF (K.EQ.0) THEN
      SETC(LC)=SETA(I)
      I=I+1
      J=J+1
      ELSE IF (K.LT.0) THEN
      SETC(LC)=SETA(I)
      I=I+1
      ELSE
      SETC(LC)=SETB(J)
      J=J+1
      END IF
      IF (I.GT.NA) THEN
      DO 10 K=J,NB
      LC=LC+1
 10   SETC(LC)=SETB(K)
      RETURN
      ELSE IF (J.GT.NB) THEN
      DO 20 K=I,NA
      LC=LC+1
 20   SETC(LC)=SETA(K)
      RETURN
      ELSE
      GO TO 30
      END IF
      END

*======================================================================*
*  SUBROUTINE SEARCH                                                   *
*======================================================================*
      SUBROUTINE SEARCH(ALLFRQ,ARRAY,CNSTR,CVALUE,DELTA,DF,DFOLD
     1,EXTRA,GRID,HESS,PAR,PARMAX,PARMIN,PAROLD,TABLE,VAR,WORK1,WORK2
     2,WORK3,GLIST,GPOINT,GROUP,INSTR,IWORK,NGEN,NSWEEP,PERSON,PNAME
     3,XLINK,COND,MAXA,MAXALL,MAXGL,MAXI,MAXLST,MAXPAR,MAXPEO,MAXTAB
     4,MAXV,MAXVAR,MCNSTR,MUTATE,MXITER,MXSTEP,MXWORK,NCNSTR,NCONV
     5,NEXTRA,NLOCI,NPAR,NPED,NPOINT,NVAR,PROBLM,UNIT2,UNIT3,BASE
     6,TRAVEL,ASYCV,STAND)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ALLFRQ(NLOCI,MAXALL),ARRAY(MAXA)
     1,CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),DELTA(MAXPAR),DF(MAXPAR)
     2,DFOLD(MAXPAR),EXTRA(NEXTRA),GRID(NPOINT,MAXPAR)
     3,HESS(MAXPAR,MAXPAR),PAR(MAXPAR),PARMAX(MAXPAR),PARMIN(MAXPAR)
     4,PAROLD(MAXPAR),TABLE(MAXTAB,MAXTAB),VAR(MAXV),WORK1(MXWORK)
     5,WORK2(MXWORK),WORK3(MAXPAR),LOGLIK
      INTEGER GLIST(MAXGL),GPOINT(MAXPEO),GROUP(MAXPEO),INSTR(MAXI)
     1,IWORK(MAXLST,3),NGEN(MAXPEO),NSWEEP(MAXPAR),PERSON(MAXPEO)
     2,COND,PROBLM,SEED,UNIT2,UNIT3
      CHARACTER*8 PNAME(MAXPAR),BASE,TRAVEL
      LOGICAL XLINK(NLOCI),ASYCV,EXACT,FORWRD,STAND,UMOVE

      SAVE SMALL,TOL,SEED,EXACT
      DATA SMALL,TOL,SEED,EXACT/1.0D-12,1.0D-8,25431,.FALSE./

      MAXIW=3*MAXLST
      ABSENT=ARRAY(1)
      CONV=ARRAY(2)
      DP=ARRAY(3)
      XXRATE=ARRAY(4)
      XYRATE=ARRAY(5)
      UMOVE=.FALSE.
      IF (NPAR.GT.0) THEN
         DO 10 I=1,NPAR
            PAR(I)=1.0D-6
            PARMAX(I)=1.0D20
            PARMIN(I)=-1.0D20
            WRITE(PNAME(I),'(I6)') I
            PNAME(I)(2:4)='PAR'
            DO 20 J=1,NPAR
 20         HESS(I,J)=0.0D0
 10      HESS(I,I)=1.0D0
         DO 30 I=1,NCNSTR
            CVALUE(I)=0.0D0
            DO 30 J=1,NPAR
 30      CNSTR(I,J)=0.0D0
         CALL INITAL(ALLFRQ,CNSTR,CVALUE,EXTRA,GRID,PAR,PARMAX,PARMIN,
     &      PNAME,XLINK,XXRATE,XYRATE,MAXALL,MUTATE,MCNSTR,NEXTRA,NLOCI,
     &      MAXPAR,NPOINT,NVAR,PROBLM,UNIT3,TRAVEL)
      END IF
      IF (TRAVEL(1:4).EQ.'GRID') THEN
         LAST=NPOINT
         ITER=1
 50      IF (ITER.LE.NPOINT) THEN
            IF (.NOT.UMOVE) THEN
               DO 40 J=1,NPAR
 40            PAR(J)=GRID(ITER,J)
            END IF
            CALL FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,   PAR,
     &                PARMAX, VAR,    WORK1,  WORK2,  WORK3,  GLIST,
     &                GPOINT, GROUP,  INSTR,  IWORK,  NGEN,   PERSON,
     &                XLINK,  ABSENT, DP,     F,      XXRATE, XYRATE,
     &                COND,   ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR,
     &                MUTATE, MXWORK, 0,      NEXTRA, NLOCI,  NPED,
     &                NPEO,   NPTOT,  NVAR,   UNIT2,  UNIT3,  FORWRD,
     &                UMOVE)
            CALL SCOR(DF,WORK1,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
            CALL OUTPUT(EXTRA,PAR,WORK1,PNAME,LOGLIK,ITER,LAST,MAXPAR,
     &            NEXTRA,NPAR,0,UNIT3,BASE,TRAVEL,STAND,UMOVE)
            ITER=ITER+1
            GO TO 50
         END IF
      ELSE
         CALL PREOPT(CNSTR,CVALUE,PAR,PARMAX,PARMIN,TABLE,WORK2,
     &         PNAME,CNORM,TOL,IERROR,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,
     &         UNIT3,TRAVEL)
         IF (IERROR.GE.1) CALL EXIT(1)
         ITER=1
         LAST=MXITER
         NCRIT=0
         FORWRD=.TRUE.
         CALL FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,   PAR,
     &             PARMAX, VAR,    WORK1,  WORK2,  WORK3,  GLIST,
     &             GPOINT, GROUP,  INSTR,  IWORK,  NGEN,   PERSON,
     &             XLINK,  ABSENT, DP,     F,      XXRATE, XYRATE,
     &             COND,   ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &             MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR,
     &             MUTATE, MXWORK, NPAR,   NEXTRA, NLOCI,  NPED,
     &             NPEO,   NPTOT,  NVAR,   UNIT2,  UNIT3,  FORWRD,
     &             UMOVE)
         CALL SCOR(DF,WORK1,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
         CALL OUTPUT(EXTRA,PAR,WORK1,PNAME,LOGLIK,1,LAST,MAXPAR,
     &         NEXTRA,NPAR,0,UNIT3,BASE,TRAVEL,STAND,UMOVE)
         IF (MXITER.GT.1) THEN
            DO 60 ITER=2,MXITER
 90         CALL SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM,
     &            MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)
            CALL QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2,
     &            NSWEEP,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,
     &            NTAB)
            IF (NCYCLE.GE.0) THEN
               HMIN=1.0D20
               DO 70 J=1,NPAR
 70            IF (HESS(J,J).GT.0.0D0) HMIN=MIN(HMIN,HESS(J,J))
               DO 80 J=1,NPAR
 80            HESS(J,J)=MAX(HESS(J,J),HMIN)*(1.0D0+RANDOM(SEED))
               IF (.NOT.UMOVE) GO TO 90
            ENDIF
            D=0.0D0
            DO 100 J=1,NPAR
 100        D=D+DF(J)*DELTA(J)
            IF (.NOT.EXACT) THEN
               IF (FORWRD.AND.D.GE.0.0D0) THEN
                  FORWRD=.FALSE.
                  CALL FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,
     &                      PAR,    PARMAX, VAR,    WORK1,  WORK2,
     &                      WORK3,  GLIST,  GPOINT, GROUP,  INSTR,
     &                      IWORK,  NGEN,   PERSON, XLINK,  ABSENT,
     &                      DP,     F,      XXRATE, XYRATE, COND,
     &                      ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                      MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,
     &                      MAXVAR, MUTATE, MXWORK, NPAR,   NEXTRA,
     &                      NLOCI,  NPED,   NPEO,   NPTOT,  NVAR,
     &                      UNIT2,  UNIT3,  FORWRD, UMOVE)
                  GO TO 90
               END IF
               FORWRD=D.LE.-CONV.AND.NCRIT.EQ.0
            END IF
            T=1.0D0
            IF (UMOVE) T=0.0D0
            NSTEP=0
            D=MIN(D,0.0D0)
            FOLD=F
            DO 110 J=1,NPAR
               PAROLD(J)=PAR(J)
 110        DFOLD(J)=DF(J)
 130        DO 120 J=1,NPAR
 120        PAR(J)=PAROLD(J)+T*DELTA(J)
            CALL FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,   PAR,
     &                PARMAX, VAR,    WORK1,  WORK2,  WORK3,  GLIST,
     &                GPOINT, GROUP,  INSTR,  IWORK,  NGEN,   PERSON,
     &                XLINK,  ABSENT, DP,     F,      XXRATE, XYRATE,
     &                COND,   ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR,
     &                MUTATE, MXWORK, NPAR,   NEXTRA, NLOCI,  NPED,
     &                NPEO,   NPTOT,  NVAR,   UNIT2,  UNIT3,  FORWRD,
     &                UMOVE)
            IF (.NOT. UMOVE                 .AND.
     &          F .GT. FOLD + 0.1D0 * T * D .AND.
     &          NSTEP .LT. MXSTEP                 ) THEN
               T1=-0.5D0*D*T*T/(F-FOLD-T*D)
               T2=0.1D0*T
               T=MAX(T1,T2)
               NSTEP=NSTEP+1
               GO TO 130
            ENDIF
            IF (ABS(FOLD-F).GT.CONV) NCRIT=-1
            NCRIT=NCRIT+1
            IF (NCRIT.GE.NCONV) GO TO 140
            CALL SCOR(DF,WORK1,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
            CALL OUTPUT(EXTRA,PAR,WORK1,PNAME,LOGLIK,ITER,LAST,
     &            MAXPAR,NEXTRA,NPAR,NSTEP,UNIT3,BASE,TRAVEL,STAND,
     &            UMOVE)
            DO 150 J=1,NPAR
 150        DELTA(J)=PAR(J)-PAROLD(J)
            C1=0.0D0
            DO 160 J=1,NPAR
            S=0.0D0
            DO 170 K=1,NPAR
 170        S=S+HESS(J,K)*DELTA(K)
            WORK1(J)=S
 160        C1=C1+DELTA(J)*S
            C2=0.0D0
            DO 180 J=1,NPAR
 180        C2=C2+(DF(J)-DFOLD(J))*DELTA(J)
            IF (C1.GT.0.0D0) THEN
               IF (C2.GT.0.2D0*C1) THEN
                  C3=1.0D0
               ELSE
                  C3=0.8D0*C1/(C1-C2)
               END IF
               DO 190 J=1,NPAR
 190           WORK2(J)=C3*(DF(J)-DFOLD(J))+(1.0D0-C3)*WORK1(J)
               C4=C3*C2+(1.0D0-C3)*C1
               DO 200 J=1,NPAR
               DO 200 K=1,NPAR
 200           HESS(J,K)=HESS(J,K)-
     &               WORK1(J)*WORK1(K)/C1+WORK2(J)*WORK2(K)/C4
            END IF
 60         CONTINUE
            RETURN
         ENDIF
 140     IF (ITER.NE.MXITER) THEN
            CALL SCOR(DF,WORK1,F,LOGLIK,MAXPAR,NPAR,TRAVEL)
            CALL OUTPUT(EXTRA,PAR,WORK1,PNAME,LOGLIK,ITER,ITER,MAXPAR,
     &            NEXTRA,NPAR,NSTEP,UNIT3,BASE,TRAVEL,STAND,UMOVE)
         ENDIF
         IF (ASYCV) THEN
            IF (.NOT.EXACT) THEN
               DP23=DP**0.66667D0
               IF (FORWRD) THEN
                  FORWRD=.FALSE.
                  CALL FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,
     &                      PAR,    PARMAX, VAR,    WORK1,  WORK2,
     &                      WORK3,  GLIST,  GPOINT, GROUP,  INSTR,
     &                      IWORK,  NGEN,   PERSON, XLINK,  ABSENT,
     &                      DP,     F,      XXRATE, XYRATE, COND,
     &                      ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                      MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,
     &                      MAXVAR, MUTATE, MXWORK, NPAR,   NEXTRA,
     &                      NLOCI,  NPED,   NPEO,   NPTOT,  NVAR,
     &                      UNIT2,  UNIT3,  FORWRD, UMOVE)
               END IF
            ELSE
               DP23=DP
            END IF
            DO 210 J=1,NPAR
            IF (PAR(J) .LE. PARMIN(J)+SMALL .OR.
     &          PAR(J) .GE. PARMAX(J)-SMALL      ) THEN
               NSWEEP(J)=0
            ELSE
               NSWEEP(J)=1
               DPJ=DP23*MAX(ABS(PAR(J)),1.0D0)
               PAR(J)=PAR(J)+DPJ
               CALL FUN (ALLFRQ, ARRAY,  DFOLD,  EXTRA,  HESS,   PAR,
     &                   PARMAX, VAR,    WORK1,  WORK2,  WORK3,  GLIST,
     &                   GPOINT, GROUP,  INSTR,  IWORK,  NGEN,   PERSON,
     &                   XLINK,  ABSENT, DP,     F,      XXRATE, XYRATE,
     &                   COND,   ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                   MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR,
     &                   MUTATE, MXWORK, J,      NEXTRA, NLOCI,  NPED,
     &                   NPEO,   NPTOT,  NVAR,   UNIT2,  UNIT3,  FORWRD,
     &                   UMOVE)
               PAR(J)=PAR(J)-DPJ
            END IF
            DO 220 I=1,J
            IF (NSWEEP(I).EQ.0.OR.NSWEEP(J).EQ.0) THEN
               HESS(I,J)=0.0D0
            ELSE
               HESS(I,J)=(DFOLD(I)-DF(I))/DPJ
            END IF
 220        HESS(J,I)=HESS(I,J)
 210        CONTINUE
C            DO I=1,NPAR-1
C            DO J=1,NPAR-1
C            WRITE(6,'(D15.8)') HESS(I,J)
C            ENDDO
C            ENDDO
            CALL ASYCOV(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK1,WORK2,
     &            NSWEEP,PNAME,CNORM,SMALL,TOL,MAXPAR,MAXTAB,MCNSTR,
     &            NCNSTR,NPAR,UNIT3)
         END IF
      END IF
      END

*======================================================================*
*  FUNCTION RANDOM                                                     *
*======================================================================*
      FUNCTION RANDOM(SEED1)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      INTEGER SEED1,SEED2,SEED3

      SAVE SEED2,SEED3
      DATA SEED2,SEED3/2321,18777/

      SEED1=171*MOD(SEED1,177)-2*(SEED1/177)
      SEED2=172*MOD(SEED2,176)-35*(SEED2/176)
      SEED3=170*MOD(SEED3,178)-63*(SEED3/178)
      IF (SEED1.LT.0) SEED1=SEED1+30269
      IF (SEED2.LT.0) SEED2=SEED2+30307
      IF (SEED3.LT.0) SEED3=SEED3+30323
      R=DBLE(SEED1)/30269.D0+DBLE(SEED2)/30307.D0+DBLE(SEED3)/30323.D0
      RANDOM=MOD(R,1.0D0)
      END

*======================================================================*
*  SUBROUTINE SCOR                                                     *
*======================================================================*
      SUBROUTINE SCOR(DF,SCORE,F,LOGLIK,MAXPAR,NPAR,TRAVEL)

      DOUBLE PRECISION DF(MAXPAR),SCORE(MAXPAR),F,LOGLIK
      CHARACTER*8 TRAVEL

      LOGLIK=-F
      IF (TRAVEL(1:1).EQ.'G') THEN
         DO 10 I=1,NPAR
 10      SCORE(I)=0.0D0
      ELSE
         DO 20 I=1,NPAR
 20      SCORE(I)=-DF(I)
      END IF
      END

*======================================================================*
*  SUBROUTINE PREOPT                                                   *
*======================================================================*
      SUBROUTINE PREOPT(CNSTR,CVALUE,PAR,PARMAX,PARMIN,TABLE,WORK2
     1,PNAME,CNORM,TOL,IERROR,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR
     2,UNIT3,TRAVEL)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),PAR(MAXPAR)
     1,PARMAX(MAXPAR),PARMIN(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK2(MAXTAB)
      INTEGER UNIT3
      CHARACTER*8 PNAME(MAXPAR),TRAVEL
      LOGICAL INV

      INV=.FALSE.
      IERROR=0
      DO 10 I=1,NPAR
      IF (PAR(I).LT.PARMIN(I)) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,20) I
 20   FORMAT(' *** ERROR *** PARAMETER',I3,' IS LESS THAN ITS MINIMUM.')
      ELSE IF (PAR(I).GT.PARMAX(I)) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,30) I
 30   FORMAT(' *** ERROR *** PARAMETER',I3,' EXCEEDS ITS MAXIMUM.')
      END IF
 10   CONTINUE
      DO 40 I=1,NCNSTR
      S=0.0D0
      DO 50 J=1,NPAR
 50   S=S+CNSTR(I,J)*PAR(J)
      IF (ABS(S-CVALUE(I)).GT.1.0D-4) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,60) I
 60   FORMAT(' *** ERROR *** LINEAR EQUALITY CONSTRAINT',I3
     1,' IS NOT SATISFIED.')
      END IF
 40   CONTINUE
      DO 70 J=1,NCNSTR
      DO 70 I=1,J
      S=0.0D0
      DO 80 K=1,NPAR
 80   S=S+CNSTR(I,K)*CNSTR(J,K)
 70   TABLE(I,J)=S
      NTAB=NCNSTR
      DO 90 I=1,NCNSTR
      IF (TABLE(I,I).LT.TOL) THEN
      IERROR=IERROR+1
      WRITE(UNIT3,100) I
 100  FORMAT(' *** ERROR *** LINEAR EQUALITY CONSTRAINT',I3
     1,' IS UNDEFINED OR A',/,' COMBINATION OF PREVIOUS ONES.')
      ELSE
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
      END IF
 90   CONTINUE
      CNORM=0.0D0
      DO 110 I=1,NPAR
      DO 110 J=1,NPAR
      S=0.0D0
      DO 120 K=1,NCNSTR
 120  S=S+CNSTR(K,I)*CNSTR(K,J)
 110  CNORM=CNORM+S*S
      CNORM=SQRT(CNORM)
      IF (TRAVEL(1:6).EQ.'SEARCH'.AND.NPAR.GT.0) THEN
      WRITE(UNIT3,130)
 130  FORMAT(/,' PARAMETER MINIMA AND MAXIMA:')
      WRITE(UNIT3,140) (PNAME(I),I=1,NPAR)
 140  FORMAT(100(/6(4X,A8),:))
      WRITE(UNIT3,150) (PARMIN(I),I=1,NPAR)
      WRITE(UNIT3,150) (PARMAX(I),I=1,NPAR)
 150  FORMAT(/100(6(1X,D11.4),:,/))
      IF (NCNSTR.GT.0) THEN
      WRITE(UNIT3,160)
 160  FORMAT(/,' PARAMETER CONSTRAINTS:')
      WRITE(UNIT3,170) (PNAME(I),I=1,NPAR)
 170  FORMAT(/'    CVALUE  ',5(4X,A8),:,100(/6(4X,A8),:))
      DO 180 I=1,NCNSTR
 180  WRITE(UNIT3,150) CVALUE(I),(CNSTR(I,J),J=1,NPAR)
      END IF
      END IF
      END

*======================================================================*
*  SUBROUTINE SETTAB                                                   *
*======================================================================*
      SUBROUTINE SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),DF(MAXPAR)
     1,HESS(MAXPAR,MAXPAR),PAR(MAXPAR),TABLE(MAXTAB,MAXTAB)
     2,WORK2(MAXTAB)

      IF (NCNSTR.EQ.0) THEN
      C=1.0D0
      ELSE
      HNORM=0.0D0
      DO 10 I=1,NPAR
      DO 10 J=1,NPAR
 10   HNORM=HNORM+HESS(I,J)**2
      HNORM=SQRT(HNORM)
      C=HNORM/CNORM
      DO 20 I=1,NCNSTR
      S=CVALUE(I)
      DO 30 J=1,NPAR
 30   S=S-CNSTR(I,J)*PAR(J)
 20   WORK2(I)=S
      END IF
      NTAB=NPAR+NCNSTR+1
      N1=NPAR+1
      DO 40 K=1,NPAR
      DO 40 J=1,K
      S=0.0D0
      DO 50 I=1,NCNSTR
 50   S=S+CNSTR(I,J)*CNSTR(I,K)
 40   TABLE(J,K)=HESS(J,K)+C*S
      DO 60 I=1,NCNSTR
      K=NPAR+I
      DO 70 J=1,NPAR
 70   TABLE(J,K)=CNSTR(I,J)
      DO 80 J=N1,K
 80   TABLE(J,K)=0.0D0
 60   CONTINUE
      DO 90 J=1,NPAR
 90   TABLE(J,NTAB)=-DF(J)
      DO 100 J=1,NCNSTR
 100  TABLE(J+NPAR,NTAB)=WORK2(J)
      TABLE(NTAB,NTAB)=0.0D0
      END

*======================================================================*
*  SUBROUTINE QDPROG                                                   *
*======================================================================*
      SUBROUTINE QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2
     1,NSWEEP,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,NTAB)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION DELTA(MAXPAR),PAR(MAXPAR),PARMAX(MAXPAR)
     1,PARMIN(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK1(MAXPAR)
     2,WORK2(MAXTAB)
      INTEGER NSWEEP(MAXPAR)
      LOGICAL INV

      TOLS=-TOL*1.0D-3
      NCYCLE=0
      INV=.FALSE.
      DO 10 I=1,NPAR
      IF (TABLE(I,I).LE.0.0D0) RETURN
      WORK1(I)=TABLE(I,I)
 10   DELTA(I)=0.0D0
      DO 20 I=1,NPAR
      IF (TABLE(I,I)/WORK1(I).LT.TOL) RETURN
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
 20   NSWEEP(I)=1
      DO 30 I=1,NCNSTR
      K=NPAR+I
      IF (TABLE(K,K).GE.0.0D0) RETURN
 30   CALL SWEEP(TABLE,WORK2,K,MAXTAB,NTAB,INV)
 70   IF (NCYCLE.GE.1000) RETURN
      A=1.0D0
      DO 40 I=1,NPAR
      IF (NSWEEP(I).EQ.1) THEN
      UI=TABLE(I,NTAB)
      IF (UI.GT.0.0D0) THEN
      AI=PARMAX(I)-PAR(I)-DELTA(I)
      ELSE
      AI=PARMIN(I)-PAR(I)-DELTA(I)
      END IF
      IF (ABS(AI).LT.ABS(UI)) A=MIN(A,AI/UI)
      END IF
 40   CONTINUE
      DO 50 I=1,NPAR
      IF (NSWEEP(I).EQ.1) THEN
      UI=TABLE(I,NTAB)
      DELTA(I)=DELTA(I)+A*UI
      TABLE(I,NTAB)=(1.0D0-A)*UI
      END IF
 50   CONTINUE
      DO 60 I=1,NPAR
      IF (NSWEEP(I).EQ.1.AND.TABLE(I,I)/WORK1(I).LT.TOLS.AND
     1.(PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL.OR
     2.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL)) THEN
      INV=.TRUE.
      NCYCLE=NCYCLE+1
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
      NSWEEP(I)=0
      GO TO 70
      END IF
 60   CONTINUE
      DO 80 I=1,NPAR
      UI=TABLE(I,NTAB)
      IF (NSWEEP(I).EQ.0.AND
     1.((UI.GT.0.0D0.AND.PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL).OR
     2.(UI.LT.0.0D0.AND.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL))) THEN
      INV=.FALSE.
      NCYCLE=NCYCLE+1
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
      NSWEEP(I)=1
      GO TO 70
      END IF
 80   CONTINUE
      NCYCLE=-1
      END

*======================================================================*
*  SUBROUTINE SWEEP                                                    *
*======================================================================*
      SUBROUTINE SWEEP(TABLE,WORK,K,MAXTAB,NTAB,INV)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION TABLE(MAXTAB,MAXTAB),WORK(MAXTAB)
      LOGICAL INV

      DO 10 I=1,K
      WORK(I)=TABLE(I,K)
 10   TABLE(I,K)=0.0D0
      K1=K+1
      DO 20 I=K1,NTAB
      WORK(I)=TABLE(K,I)
 20   TABLE(K,I)=0.0D0
      S=WORK(K)
      IF (INV) THEN
      WORK(K)=1.0D0
      ELSE
      WORK(K)=-1.0D0
      END IF
      DO 30 J=1,NTAB
      DO 30 I=1,J
 30   TABLE(I,J)=TABLE(I,J)-WORK(I)*WORK(J)/S
      END

*======================================================================*
*  SUBROUTINE ASYCOV                                                   *
*======================================================================*
      SUBROUTINE ASYCOV(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK1
     1,WORK2,NSWEEP,PNAME,CNORM,SMALL,TOL,MAXPAR,MAXTAB,MCNSTR
     2,NCNSTR,NPAR,UNIT3)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),DF(MAXPAR)
     1,HESS(MAXPAR,MAXPAR),PAR(MAXPAR),TABLE(MAXTAB,MAXTAB)
     2,WORK1(MAXPAR),WORK2(MAXTAB)
      INTEGER NSWEEP(MAXPAR),UNIT3
      CHARACTER*8 PNAME(MAXPAR)
      LOGICAL INV

      OPEN(99,FILE='genfreq.se',STATUS='UNKNOWN')
      INV=.FALSE.
      NTIMES=1
 110  CALL SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)
      DO 10 I=1,NPAR
      IF (NSWEEP(I).EQ.1.AND.TABLE(I,I).LE.0.0D0) GO TO 20
 10   WORK1(I)=TABLE(I,I)
      DO 30 I=1,NPAR
      IF (NSWEEP(I).NE.1) GO TO 30
      IF (TABLE(I,I)/WORK1(I).LT.TOL) GO TO 20
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
 30   CONTINUE
      DO 40 I=1,NCNSTR
      K=I+NPAR
 40   IF (TABLE(K,K).LT.0.0D0) CALL
     :SWEEP(TABLE,WORK2,K,MAXTAB,NTAB,INV)
      DO 50 J=1,NPAR
      IF (ABS(TABLE(J,J)).LT.SMALL) NSWEEP(J)=0
      IF (NSWEEP(J).EQ.1) THEN
      IF (TABLE(J,J).GT.0.0D0) GO TO 20
      WORK2(J)=SQRT(-TABLE(J,J))
      ELSE
      WORK2(J)=0.0D0
      END IF
      DO 50 I=1,J
      IF (NSWEEP(I).EQ.1.AND.NSWEEP(J).EQ.1) THEN
      TABLE(I,J)=-TABLE(I,J)/(WORK2(I)*WORK2(J))
      ELSE
      TABLE(I,J)=0.0D0
      END IF
 50   CONTINUE
      WRITE(UNIT3,60)
 60   FORMAT(/,' ASYMPTOTIC STANDARD ERRORS OF THE PARAMETERS:')
      WRITE(UNIT3,70) (PNAME(I),I=1,NPAR)
 70   FORMAT(100(/6(4X,A8),:))
      WRITE(UNIT3,80) (WORK2(I),I=1,NPAR)
 80   FORMAT(100(/6(1X,D11.4),:))
      WRITE(UNIT3,90)
 90   FORMAT(/,' ASYMPTOTIC CORRELATION MATRIX OF THE PARAMETERS:')
      WRITE(UNIT3,70) (PNAME(I),I=1,NPAR)
      DO 100 J=1,NPAR
      WRITE(99,'(F12.10)') DSQRT(TABLE(J,J)*WORK2(J)*WORK2(J))
 100  WRITE(UNIT3,80) (TABLE(I,J),I=1,J)
      CLOSE(99)
      RETURN
 20   IF (NTIMES.LT.6) THEN
         NTIMES=NTIMES+1
         CNORM=1.0D-1*CNORM
         GO TO 110
      END IF
      WRITE(UNIT3,120)
 120  FORMAT(/,' THE ASYMPTOTIC COVARIANCE MATRIX CANNOT BE COMPUTED.')
      CLOSE(99)
      END

*======================================================================*
*  SUBROUTINE FUN                                                      *
*======================================================================*
      SUBROUTINE FUN (ALLFRQ, ARRAY,  DF,     EXTRA,  HESS,   PAR,
     &                PARMAX, VAR,    WORK1,  WORK2,  WORK3,  GLIST,
     &                GPOINT, GROUP,  INSTR,  IWORK,  NGEN,   PERSON,
     &                XLINK,  ABSENT, DP,     F,      XXRATE, XYRATE,
     &                COND,   ITER,   MAXA,   MAXALL, MAXGL,  MAXI,
     &                MAXIW,  MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR,
     &                MUTATE, MXWORK, NDERIV, NEXTRA, NLOCI,  NPED,
     &                NPEO,   NPTOT,  NVAR,   UNIT2,  UNIT3,  FORWRD,
     &                UMOVE)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION   ALLFRQ(NLOCI,MAXALL), ARRAY(MAXA),DF(MAXPAR)
      DOUBLE PRECISION   EXTRA(NEXTRA), HESS(MAXPAR,MAXPAR)
      DOUBLE PRECISION   PAR(MAXPAR), PARMAX(MAXPAR)
      DOUBLE PRECISION   VAR(MAXV), WORK1(MXWORK), WORK2(MXWORK)
      DOUBLE PRECISION   WORK3(MAXPAR)
      INTEGER            GLIST(MAXGL), GPOINT(MAXPEO), GROUP(MAXPEO)
      INTEGER            INSTR(MAXI), IWORK(MAXIW), NGEN(MAXPEO)
      INTEGER            PERSON(MAXPEO), COND, PED, UNIT2, UNIT3
      CHARACTER*8        IDFAM
      LOGICAL            XLINK(NLOCI), FORWRD, UMOVE

      F=0.0D0
      DO 10 I=1,NDERIV
 10   DF(I)=0.0D0
      IF (UMOVE.AND.NPED.GT.1) THEN
         DO 20 J=1,NDERIV
            DO 20 I=1,NDERIV
 20      HESS(I,J)=0.0D0
      END IF
      IF (NPED.GT.1.OR.ITER.EQ.1) REWIND(UNIT2)
      DO 30 PED=1,NPED
         IF (NPED.GT.1.OR.ITER.EQ.1) THEN
            READ(UNIT2) IDFAM,NPEO,NPTOT,LG
            CALL ISCRAT(PERSON,NPTOT,UNIT2,.FALSE.)
            CALL ISCRAT(GROUP,NPTOT,UNIT2,.FALSE.)
            CALL ISCRAT(NGEN,NPEO,UNIT2,.FALSE.)
            CALL ISCRAT(GLIST,LG,UNIT2,.FALSE.)
            CALL ISCRAT(GPOINT,NPEO,UNIT2,.FALSE.)
            MVAR=NVAR*NPTOT
            IF (MVAR.GT.0) CALL RSCRAT(VAR,MVAR,UNIT2,.FALSE.)
            READ(UNIT2) LI
            CALL ISCRAT(INSTR,LI,UNIT2,.FALSE.)
         END IF
         NPEO1=NPEO+1
         CALL OPERAT(ALLFRQ,ARRAY,EXTRA,PAR,VAR,WORK1,WORK2,GLIST,
     &         GPOINT,GROUP,INSTR,IWORK,NGEN,PERSON,XLINK,ABSENT,G,
     &         XXRATE,XYRATE,MAXA,MAXALL,MAXGL,MAXI,MAXIW,MAXLST,
     &         MAXPAR,MAXPEO,MAXV,MAXVAR,MUTATE,MXWORK,NEXTRA,NLOCI,
     &         NPEO1,NPTOT,NVAR,PED,UNIT3,IDFAM)
         CALL NEWLIK(EXTRA,PAR,G,COND,ITER,NEXTRA,MAXPAR,NPED,PED)
         F=F-G
         DO 40 I=1,NDERIV
            PTEMP=PAR(I)
            D=DP*MAX(ABS(PAR(I)),1.0D0)
            IF (FORWRD) THEN
               IF (PAR(I)+D.GE.PARMAX(I)) D=-D
               PAR(I)=PTEMP+D
               CALL OPERAT (ALLFRQ, ARRAY,  EXTRA,  PAR,    VAR,
     &                      WORK1,  WORK2,  GLIST,  GPOINT, GROUP,
     &                      INSTR,  IWORK,  NGEN,   PERSON, XLINK,
     &                      ABSENT, GPLUS,  XXRATE, XYRATE, MAXA,
     &                      MAXALL, MAXGL,  MAXI,   MAXIW,  MAXLST,
     &                      MAXPAR, MAXPEO, MAXV,   MAXVAR, MUTATE,
     &                      MXWORK, NEXTRA, NLOCI,  NPEO1,  NPTOT,
     &                      NVAR,   PED,    UNIT3,  IDFAM)
               CALL NEWLIK (EXTRA, PAR, GPLUS, COND, ITER, NEXTRA,
     &               MAXPAR, NPED, PED)
               WORK3(I)=(GPLUS-G)/D
               DF(I)=DF(I)-(GPLUS-G)/D
            ELSE
               PAR(I)=PTEMP+D
               CALL OPERAT (ALLFRQ, ARRAY,  EXTRA,  PAR,    VAR,
     &                      WORK1,  WORK2,  GLIST,  GPOINT, GROUP,
     &                      INSTR,  IWORK,  NGEN,   PERSON, XLINK,
     &                      ABSENT, GPLUS,  XXRATE, XYRATE, MAXA,
     &                      MAXALL, MAXGL,  MAXI,   MAXIW,  MAXLST,
     &                      MAXPAR, MAXPEO, MAXV,   MAXVAR, MUTATE,
     &                      MXWORK, NEXTRA, NLOCI,  NPEO1,  NPTOT,
     &                      NVAR,   PED,    UNIT3,  IDFAM)
               CALL NEWLIK (EXTRA, PAR, GPLUS, COND, ITER, NEXTRA,
     &               MAXPAR, NPED, PED)
               PAR(I)=PTEMP-D
               CALL OPERAT (ALLFRQ, ARRAY,  EXTRA,  PAR,    VAR,
     &                      WORK1,  WORK2,  GLIST,  GPOINT, GROUP,
     &                      INSTR,  IWORK,  NGEN,   PERSON, XLINK,
     &                      ABSENT, GMINUS, XXRATE, XYRATE, MAXA,
     &                      MAXALL, MAXGL,  MAXI,   MAXIW,  MAXLST,
     &                      MAXPAR, MAXPEO, MAXV,   MAXVAR, MUTATE,
     &                      MXWORK, NEXTRA, NLOCI,  NPEO1,  NPTOT,
     &                      NVAR,   PED,    UNIT3,  IDFAM)
               CALL NEWLIK (EXTRA, PAR, GMINUS, COND, ITER, NEXTRA,
     &               MAXPAR, NPED, PED)
               WORK3(I)=(GPLUS-GMINUS)/(D+D)
               DF(I)=DF(I)-(GPLUS-GMINUS)/(D+D)
            END IF
 40      PAR(I)=PTEMP
         IF (UMOVE.AND.NPED.GT.1) THEN
            DO 50 J=1,NDERIV
               DO 50 I=1,NDERIV
 50         HESS(I,J)=HESS(I,J)+WORK3(I)*WORK3(J)
         END IF
 30   CONTINUE
      END

*======================================================================*
*  SUBROUTINE OPERAT                                                   *
*======================================================================*
      SUBROUTINE OPERAT (ALLFRQ, ARRAY,  EXTRA,  PAR,    VAR,    WORK1,
     &                   WORK2,  GLIST,  GPOINT, GROUP,  INSTR,  IWORK,
     &                   NGEN,   PERSON, XLINK,  ABSENT, LOGLIK, XXRATE,
     &                   XYRATE, MAXA,   MAXALL, MAXGL,  MAXI,   MAXIW,
     &                   MAXLST, MAXPAR, MAXPEO, MAXV,   MAXVAR, MUTATE,
     &                   MXWORK, NEXTRA, NLOCI,  NPEO1,  NPTOT,  NVAR,
     &                   PED,    UNIT3,  IDFAM)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ALLFRQ(NLOCI,MAXALL),ARRAY(MAXA),EXTRA(NEXTRA)
     1,PAR(MAXPAR),VAR(MAXV),WORK1(MXWORK),WORK2(MXWORK),LOGLIK
      INTEGER GLIST(MAXGL),GPOINT(MAXPEO),GROUP(MAXPEO),INSTR(MAXI)
     1,IWORK(MAXIW),JDIM(2),JPOINT(2),JSTART(2),NGEN(MAXPEO)
     2,PERSON(MAXPEO),PED,UNIT3
      CHARACTER*8 IDFAM
      LOGICAL XLINK(NLOCI)

      IERROR=0
      LI=0
      LOGLIK=0.0D0
      SCALE=0.0D0

 70   LI=LI+1
      IOPER=-INSTR(LI)

      GO TO (10,10,20,30,40), IOPER

 10   JDIM(1)=INSTR(LI+1)
      JDIM(2)=INSTR(LI+2)
      JPOINT(1)=INSTR(LI+3)
      JPOINT(2)=INSTR(LI+4)
      LI=LI+5
      IPOINT=INSTR(LI)
      DO 50 J=1,2
      JD=JDIM(J)
      JP=-JPOINT(J)
      JSTART(J)=LI+1
      IF (JP.GT.0) THEN
      JPOINT(J)=JP
      IF (JD.EQ.1) THEN
      CALL PANDP(ALLFRQ,ARRAY(JP),EXTRA,PAR,VAR,WORK1,GLIST
     1,GPOINT,GROUP,NGEN,PERSON,XLINK,ABSENT,XXRATE,XYRATE
     2,INSTR(LI+1),MAXALL,MAXPAR,MAXVAR,MUTATE,NEXTRA,NLOCI
     3,NPEO1,NPTOT,NVAR,PED)
      ELSE
      CALL TRAN(ARRAY(JP),EXTRA,PAR,WORK1,WORK2,VAR,GLIST,GPOINT
     1,GROUP,NGEN,PERSON,XLINK,ABSENT,XXRATE,XYRATE,INSTR(LI+1)
     2,INSTR(LI+2),INSTR(LI+3),MAXPAR,MAXVAR,MUTATE,NEXTRA,NLOCI
     3,NVAR,PED)
      END IF
      END IF
 50   LI=LI+JD
      IF (IOPER.EQ.2) THEN
      LI=LI+1
      K=INSTR(LI)
      END IF
      IDIM=INSTR(LI+1)
      ISTART=LI+2
      LI=LI+IDIM+1
      N1=1+MAXLST+MAXLST
      CALL MULSUM(ARRAY,INSTR(ISTART),IWORK,IWORK(N1),JDIM
     1,INSTR(JSTART(1)),INSTR(JSTART(2)),JPOINT,NGEN,SCALE,IDIM
     2,IERROR,IOPER,IPOINT,K,MAXLST)
      GO TO 60
 20   CALL APACK(ARRAY,INSTR,LI)
      GO TO 70
 30   LI=LI+1
      IP=INSTR(LI)
      LI=LI+1
      I=INSTR(LI)
      IF (IP.LT.0) THEN
      IP=-IP
      CALL PANDP(ALLFRQ,ARRAY(IP),EXTRA,PAR,VAR,WORK1,GLIST
     1,GPOINT,GROUP,NGEN,PERSON,XLINK,ABSENT,XXRATE,XYRATE,I
     2,MAXALL,MAXPAR,MAXVAR,MUTATE,NEXTRA,NLOCI,NPEO1,NPTOT
     3,NVAR,PED)
      END IF
      CALL ASUM(ARRAY(IP),NGEN,LOGLIK,I,IERROR)
 60   IF (IERROR.EQ.0) GO TO 70
      WRITE(UNIT3,80) PED,IDFAM,PERSON(IERROR)
 80   FORMAT(/,' *** ERROR *** PEDIGREE NUMBER',I4,' WITH ID ',A8
     1,' HAS AN INCONSISTENCY',/,' NEAR PERSON NUMBER',I4,'.')
      WRITE(UNIT3,90) (PAR(I),I=1,MAXPAR)
 90   FORMAT(/,' PARAMETERS JUST BEFORE STOP:',(T30,3(1X,D11.4)/))
      CALL EXIT(1)
 40   LOGLIK=LOGLIK+SCALE
      END

*======================================================================*
*  SUBROUTINE MULSUM                                                   *
*======================================================================*
      SUBROUTINE MULSUM(ARRAY,ILIST,INCR,INDEX,JDIM,JLIST1,JLIST2
     1,JPOINT,NGEN,SCALE,IDIM,IERROR,IOPER,IPOINT,K,MAXLST)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION ARRAY(*)
      INTEGER ILIST(*),INCR(MAXLST,*),INDEX(*),JDIM(*),JLIST1(*)
     1,JLIST2(*),JPOINT(*),NGEN(*),PSKIP,QSKIP

      AHI=0.0D0
      ALO=1.0D20
      LOCP=JPOINT(1)
      LOCQ=JPOINT(2)
      LOCR=IPOINT
      DO 10 I=1,IDIM
 10   INDEX(I)=1
      IF (IOPER.EQ.2) THEN
      L=ILIST(K)
      NK=NGEN(L)
      NKMIN1=NK-1
      KMIN1=K-1
      ELSE
      K=0
      END IF
      DO 20 J=1,2
      JD=JDIM(J)
      NMULT=1
      INDEXM=1
      DO 30 INDEXR=1,IDIM
      IF (INDEXM.GT.JD) THEN
      NMULT=1-NMULT
      DO 40 L=INDEXR,IDIM
 40   INCR(L,J)=NMULT
      GO TO 50
      END IF
      L=ILIST(INDEXR)
      IF ((J.EQ.1.AND.L.EQ.JLIST1(INDEXM))
     1.OR.(J.EQ.2.AND.L.EQ.JLIST2(INDEXM))) THEN
      IF (INDEXR.EQ.K) IC=NMULT
      NMULT=NMULT*NGEN(L)
      INCR(INDEXR,J)=1
      INDEXM=INDEXM+1
      ELSE
      INCR(INDEXR,J)=1-NMULT
      END IF
 30   CONTINUE
 50   IF (IOPER.EQ.2) THEN
      IF (J.EQ.1) THEN
      PSKIP=IC
      ELSE
      QSKIP=IC
      END IF
      IC=NKMIN1*IC
      DO 60 INDEXR=1,KMIN1
 60   INCR(INDEXR,J)=INCR(INDEXR,J)-IC
      END IF
 20   CONTINUE
 90   A=ARRAY(LOCP)*ARRAY(LOCQ)
      IF (IOPER.EQ.2) THEN
      INDEX(K)=NK
      DO 70 I=1,NKMIN1
      LOCP=LOCP+PSKIP
      LOCQ=LOCQ+QSKIP
 70   A=A+ARRAY(LOCP)*ARRAY(LOCQ)
      END IF
      ARRAY(LOCR)=A
      IF (A.GT.0.0D0) THEN
      AHI=MAX(AHI,A)
      ALO=MIN(ALO,A)
      END IF
      DO 80 I=1,IDIM
      L=ILIST(I)
      IF (INDEX(I).NE.NGEN(L)) THEN
      INDEX(I)=INDEX(I)+1
      LOCP=LOCP+INCR(I,1)
      LOCQ=LOCQ+INCR(I,2)
      LOCR=LOCR+1
      GO TO 90
      ELSE
      INDEX(I)=1
      END IF
 80   CONTINUE
      IF (AHI.LE.0.0D0) THEN
      IERROR=ILIST(1)
      IF (IOPER.EQ.2) IERROR=ILIST(K)
      RETURN
      END IF
      IF (AHI.GT.1.0D10.OR.(ALO.LE.1.0D-10.AND.AHI.LT.1.0D0)) THEN
      SCALE=SCALE+LOG(AHI)
      DO 100 I=IPOINT,LOCR
      A=ARRAY(I)
 100  IF (A.GT.0.0D0) ARRAY(I)=A/AHI
      END IF
      END

*======================================================================*
*  SUBROUTINE APACK                                                    *
*======================================================================*
      SUBROUTINE APACK(ARRAY,INSTR,LI)

      DOUBLE PRECISION ARRAY(*)
      INTEGER INSTR(*)

      I=0
      JSTART=1
      LI=LI+1
      DO 10 K=1,INSTR(LI)
      LI=LI+1
      IF (MOD(K,2).EQ.1) THEN
      JEND=JSTART+INSTR(LI)-1
      DO 20 J=JSTART,JEND
      I=I+1
 20   ARRAY(I)=ARRAY(J)
      ELSE
      JSTART=JEND+INSTR(LI)+1
      END IF
 10   CONTINUE
      END

*======================================================================*
*  SUBROUTINE ASUM                                                     *
*======================================================================*
      SUBROUTINE ASUM(ARRAY,NGEN,LOGLIK,I,IERROR)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ARRAY(*),LOGLIK
      INTEGER NGEN(*)

      A=0.0D0
      DO 10 L=1,NGEN(I)
 10   A=A+ARRAY(L)
      IF (A.LE.0.0D0) THEN
      IERROR=I
      RETURN
      ELSE
      LOGLIK=LOGLIK+LOG(A)
      END IF
      END

*======================================================================*
*  SUBROUTINE PANDP                                                    *
*======================================================================*
      SUBROUTINE PANDP(ALLFRQ,ARRAY,EXTRA,PAR,VAR,WORK1,GLIST
     1,GPOINT,GROUP,NGEN,PERSON,XLINK,ABSENT,XXRATE,XYRATE,I
     2,MAXALL,MAXPAR,MAXVAR,MUTATE,NEXTRA,NLOCI,NPEO1,NPTOT
     3,NVAR,PED)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ALLFRQ(NLOCI,*),ARRAY(*),EXTRA(*),PAR(*)
     1,VAR(*),WORK1(*)
      INTEGER GLIST(*),GPOINT(*),GROUP(*),NGEN(*),PERSON(*)
     1,PED,PERI
      LOGICAL XLINK(*),MALE

      IGROUP=GROUP(I)
      MALE=MOD(ABS(IGROUP),2).EQ.1
      ITWIN=ABS(IGROUP)/4
      PERI=PERSON(I)
      IVAR=(I-1)*NVAR+1
      IP=GPOINT(I)
      NGTYPE=NGEN(I)
      CALL APEN(EXTRA,PAR,ARRAY,VAR(IVAR),GLIST(IP),XLINK,ABSENT
     1,XXRATE,XYRATE,MUTATE,NEXTRA,NGTYPE,NLOCI,MAXPAR,MAXVAR,PED
     2,PERI,MALE)
      IF (IGROUP.LT.0) THEN
      CALL APRIOR(ALLFRQ,EXTRA,PAR,WORK1,VAR(IVAR),GLIST(IP)
     1,XLINK,ABSENT,XXRATE,XYRATE,MAXALL,MUTATE,NEXTRA,NGTYPE
     2,NLOCI,MAXPAR,MAXVAR,PED,PERI,MALE)
      DO 10 IGEN=1,NGTYPE
 10   ARRAY(IGEN)=ARRAY(IGEN)*WORK1(IGEN)
      END IF
      IF (ITWIN.NE.0) THEN
      DO 20 J=NPEO1,NPTOT
      JTWIN=ABS(GROUP(J))/4
      IF (JTWIN.EQ.ITWIN) THEN
      JVAR=(J-1)*NVAR+1
      CALL APEN(EXTRA,PAR,WORK1,VAR(JVAR),GLIST(IP),XLINK,ABSENT
     1,XXRATE,XYRATE,MUTATE,NEXTRA,NGTYPE,NLOCI,MAXPAR,MAXVAR,PED
     2,PERSON(J),MALE)
      DO 30 IGEN=1,NGTYPE
 30   ARRAY(IGEN)=ARRAY(IGEN)*WORK1(IGEN)
      END IF
 20   CONTINUE
      END IF
      END

*======================================================================*
*  SUBROUTINE TRAN                                                     *
*======================================================================*
      SUBROUTINE TRAN(ARRAY,EXTRA,PAR,TI,TJ,VAR,GLIST,GPOINT,GROUP
     1,NGEN,PERSON,XLINK,ABSENT,XXRATE,XYRATE,I,J,K,MAXPAR,MAXVAR
     2,MUTATE,NEXTRA,NLOCI,NVAR,PED)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DOUBLE PRECISION ARRAY(*),EXTRA(*),PAR(*),TI(*),TJ(*),VAR(*)
      INTEGER GLIST(*),GPOINT(*),GROUP(*),NGEN(*),PERSON(*),PED,PERI
     1,PERJ,PERK
      LOGICAL XLINK(*),HET,MALEI,MALEJ,MALEK,ZEROI,ZEROJ

      IA=1
      NLOCI1=NLOCI-1
      NLOCI2=NLOCI+NLOCI
      MALEI=MOD(ABS(GROUP(I)),2).EQ.1
      PERI=PERSON(I)
      IVAR=(I-1)*NVAR+1
      ISTART=GPOINT(I)
      NGENI=NGEN(I)
      MALEJ=MOD(ABS(GROUP(J)),2).EQ.1
      PERJ=PERSON(J)
      JVAR=(J-1)*NVAR+1
      JSTART=GPOINT(J)
      NGENJ=NGEN(J)
      MALEK=MOD(ABS(GROUP(K)),2).EQ.1
      PERK=PERSON(K)
      KVAR=(K-1)*NVAR+1
      KSTART=GPOINT(K)
      DO 10 KP=KSTART,KSTART+NGEN(K)*NLOCI2-1,NLOCI2
      HET=.FALSE.
      DO 20 KL=KP,KP+NLOCI1
      IF (GLIST(KL).NE.GLIST(KL+NLOCI)) THEN
      HET=.TRUE.
      GO TO 30
      END IF
 20   CONTINUE
 30   CALL ATRANS(EXTRA,PAR,TJ,VAR(JVAR),VAR(KVAR),GLIST(KP)
     1,GLIST(JSTART),XLINK,ABSENT,XXRATE,XYRATE,MUTATE,NEXTRA
     2,NGENJ,NLOCI,MAXPAR,MAXVAR,PED,PERJ,PERK,MALEJ,MALEK)
      ZEROJ=.TRUE.
      DO 40 JGEN=1,NGENJ
      IF (TJ(JGEN).NE.0.0D0) THEN
      ZEROJ=.FALSE.
      GO TO 50
      END IF
 40   CONTINUE
 50   IF (.NOT.ZEROJ) THEN
      CALL ATRANS(EXTRA,PAR,TI,VAR(IVAR),VAR(KVAR),GLIST(KP+NLOCI)
     1,GLIST(ISTART),XLINK,ABSENT,XXRATE,XYRATE,MUTATE,NEXTRA
     2,NGENI,NLOCI,MAXPAR,MAXVAR,PED,PERI,PERK,MALEI,MALEK)
      ZEROI=.TRUE.
      DO 60 IGEN=1,NGENI
      IF (TI(IGEN).NE.0.0D0) THEN
      ZEROI=.FALSE.
      GO TO  70
      END IF
 60   CONTINUE
      END IF
 70   IAOLD=IA
      IF (ZEROJ.OR.ZEROI) THEN
      DO 80 JGEN=1,NGENJ
      DO 80 IGEN=1,NGENI
      ARRAY(IA)=0.0D0
 80   IA=IA+1
      ELSE
      DO 90 JGEN=1,NGENJ
      DO 90 IGEN=1,NGENI
      ARRAY(IA)=TJ(JGEN)*TI(IGEN)
 90   IA=IA+1
      END IF
      IF (HET) THEN
      CALL ATRANS(EXTRA,PAR,TJ,VAR(JVAR),VAR(KVAR),GLIST(KP+NLOCI)
     1,GLIST(JSTART),XLINK,ABSENT,XXRATE,XYRATE,MUTATE,NEXTRA
     2,NGENJ,NLOCI,MAXPAR,MAXVAR,PED,PERJ,PERK,MALEJ,MALEK)
      ZEROJ=.TRUE.
      DO 100 JGEN=1,NGENJ
      IF (TJ(JGEN).NE.0.0D0) THEN
      ZEROJ=.FALSE.
      GO TO 110
      END IF
 100  CONTINUE
 110  IF (.NOT.ZEROJ) THEN
      CALL ATRANS(EXTRA,PAR,TI,VAR(IVAR),VAR(KVAR),GLIST(KP)
     1,GLIST(ISTART),XLINK,ABSENT,XXRATE,XYRATE,MUTATE,NEXTRA
     2,NGENI,NLOCI,MAXPAR,MAXVAR,PED,PERI,PERK,MALEI,MALEK)
      ZEROI=.TRUE.
      DO 120 IGEN=1,NGENI
      IF (TI(IGEN).NE.0.0D0) THEN
      ZEROI=.FALSE.
      GO TO 130
      END IF
 120  CONTINUE
 130  IF (.NOT.ZEROI) THEN
      IA=IAOLD
      DO 140 JGEN=1,NGENJ
      DO 140 IGEN=1,NGENI
      ARRAY(IA)=ARRAY(IA)+TJ(JGEN)*TI(IGEN)
 140  IA=IA+1
      END IF
      END IF
      END IF
 10   CONTINUE
      END
