# ---------------------------------
# Finds VRPN
# Adds library to target
# Adds include path
# ---------------------------------
FIND_PATH(PATH_VRPN include/vrpn_BaseClass.h PATHS $ENV{OV_DEP_VRPN} $ENV{VRPN_ROOT} NO_DEFAULT_PATH)
FIND_PATH(PATH_VRPN include/vrpn_BaseClass.h PATHS $ENV{OV_DEP_VRPN} $ENV{VRPN_ROOT})
IF(PATH_VRPN)
	MESSAGE(STATUS "  Found VRPN...")
	INCLUDE_DIRECTORIES(${PATH_VRPN}/include)

	IF(WIN32)
		FIND_LIBRARY(LIB_VRPN vrpn PATHS ${PATH_VRPN}/lib NO_DEFAULT_PATH)
		FIND_LIBRARY(LIB_VRPN vrpn PATHS ${PATH_VRPN}/lib)
		IF(LIB_VRPN)
			MESSAGE(STATUS "    [  OK  ] lib ${LIB_VRPN}")
			TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_VRPN})
		ELSE(LIB_VRPN)
			MESSAGE(STATUS "    [FAILED] lib vrpn")
		ENDIF(LIB_VRPN)
	ENDIF(WIN32)

	IF(UNIX)
		FIND_LIBRARY(LIB_VRPNSERVER vrpnserver PATHS ${PATH_VRPN}/lib NO_DEFAULT_PATH)
		FIND_LIBRARY(LIB_VRPNSERVER vrpnserver PATHS ${PATH_VRPN}/lib)
		IF(LIB_VRPNSERVER)
			MESSAGE(STATUS "    [  OK  ] lib ${LIB_VRPNSERVER}")
			TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_VRPNSERVER})
		ELSE(LIB_VRPNSERVER)
			MESSAGE(STATUS "    [FAILED] lib vrpnserver")
		ENDIF(LIB_VRPNSERVER)
	ENDIF(UNIX)

	FIND_LIBRARY(LIB_QUAT quat PATHS ${PATH_VRPN}/lib NO_DEFAULT_PATH)
	FIND_LIBRARY(LIB_QUAT quat PATHS ${PATH_VRPN}/lib)
	IF(LIB_QUAT)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_QUAT}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_QUAT})
	ELSE(LIB_QUAT)
		MESSAGE(STATUS "    [FAILED] lib quat")
	ENDIF(LIB_QUAT)

	ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyVRPN)
ELSE(PATH_VRPN)
	MESSAGE(STATUS "  FAILED to find VRPN")
ENDIF(PATH_VRPN)
