# ---------------------------------
# Finds Ogre3D toolkit
#
# Sets Ogre3D_FOUND
# Sets Ogre3D_LIBRARIES
# Sets Ogre3D_LIBRARY_DIRS
# Sets Ogre3D_LDFLAGS
# Sets Ogre3D_LDFLAGS_OTHERS
# Sets Ogre3D_INCLUDE_DIRS
# Sets Ogre3D_CFLAGS
# Sets Ogre3D_CFLAGS_OTHERS
#
# Adds library to target
# Adds include path
# ---------------------------------

IF(WIN32)
	INCLUDE("FindThirdPartyBoost_Thread")
	FIND_PATH(PATH_Ogre3D include/OGRE/Ogre.h PATHS $ENV{OV_DEP_OGRE} $ENV{OGRE_HOME})
	IF(PATH_Ogre3D)
		SET(Ogre3D_FOUND TRUE)
		SET(OIS_FOUND TRUE)
		SET(Ogre3D_INCLUDE_DIRS ${PATH_Ogre3D}/include/OGRE ${PATH_Ogre3D}/include/OIS)
		IF(CMAKE_BUILD_TYPE STREQUAL "Debug")
			SET(Ogre3D_LIBRARIES OgreMain_d OIS_d)
		ELSE(CMAKE_BUILD_TYPE STREQUAL "Debug")
			SET(Ogre3D_LIBRARIES OgreMain OIS)
		ENDIF(CMAKE_BUILD_TYPE STREQUAL "Debug")
		SET(Ogre3D_LIBRARY_DIRS ${PATH_Ogre3D}/lib/${CMAKE_BUILD_TYPE} )
	ENDIF(PATH_Ogre3D)
ENDIF(WIN32)

IF(UNIX)
	INCLUDE("FindThirdPartyPkgConfig")
	pkg_check_modules(Ogre3D OGRE)
	pkg_check_modules(OIS OIS)
ENDIF(UNIX)

IF(Ogre3D_FOUND AND OIS_FOUND)
	MESSAGE(STATUS "  Found Ogre3D/OIS...")
	INCLUDE_DIRECTORIES(${OIS_INCLUDE_DIRS} ${Ogre3D_INCLUDE_DIRS})
	ADD_DEFINITIONS(${OIS_CFLAGS} ${Ogre3D_CFLAGS})
	ADD_DEFINITIONS(${OIS_CFLAGS_OTHERS} ${Ogre3D_CFLAGS_OTHERS})
	LINK_DIRECTORIES(${OIS_LIBRARY_DIRS} ${Ogre3D_LIBRARY_DIRS})
	FOREACH(Ogre3D_LIB ${OIS_LIBRARIES} ${Ogre3D_LIBRARIES})
		SET(Ogre3D_LIB1 "Ogre3D_LIB1-NOTFOUND")
		FIND_LIBRARY(Ogre3D_LIB1 NAMES ${Ogre3D_LIB} PATHS ${Ogre3D_LIBRARY_DIRS} ${Ogre3D_LIBDIR} NO_DEFAULT_PATH)
		FIND_LIBRARY(Ogre3D_LIB1 NAMES ${Ogre3D_LIB})
		IF(Ogre3D_LIB1)
			MESSAGE(STATUS "    [  OK  ] Third party lib ${Ogre3D_LIB1}")
			TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${Ogre3D_LIB1})
		ELSE(Ogre3D_LIB1)
			MESSAGE(STATUS "    [FAILED] Third party lib ${Ogre3D_LIB}")
		ENDIF(Ogre3D_LIB1)
	ENDFOREACH(Ogre3D_LIB)

	ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyOgre3D)
ELSE(Ogre3D_FOUND AND OIS_FOUND)
	MESSAGE(STATUS "  FAILED to find Ogre3D/OIS...")
ENDIF(Ogre3D_FOUND AND OIS_FOUND)
