# ---------------------------------
# Finds ITPP toolkit
#
# Sets ITPP_FOUND
# Sets ITPP_LIBRARIES
# Sets ITPP_LIBRARY_DIRS
# Sets ITPP_LDFLAGS
# Sets ITPP_LDFLAGS_OTHERS
# Sets ITPP_INCLUDE_DIRS
# Sets ITPP_CFLAGS
# Sets ITPP_CFLAGS_OTHERS
#
# Adds library to target
# Adds include path
# ---------------------------------

IF(WIN32)
	FIND_PATH(PATH_ITPP include/itpp/itbase.h PATHS $ENV{OV_DEP_ITPP})
	IF(PATH_ITPP)
		SET(ITPP_FOUND TRUE)
		SET(ITPP_INCLUDE_DIRS ${PATH_ITPP}/include)
		IF(CMAKE_BUILD_TYPE STREQUAL "Debug")
			SET(ITPP_LIBRARIES libblas.a libfftw3-3 liblapack.a libgcc.a libg2c.a itppd)
		ELSE(CMAKE_BUILD_TYPE STREQUAL "Debug")
			SET(ITPP_LIBRARIES libblas.a libfftw3-3 liblapack.a libgcc.a libg2c.a itpp)
		ENDIF(CMAKE_BUILD_TYPE STREQUAL "Debug")
		SET(ITPP_LIBRARY_DIRS ${PATH_ITPP}/lib )
	ENDIF(PATH_ITPP)
ENDIF(WIN32)

IF(UNIX)
	INCLUDE("FindThirdPartyPkgConfig")
	pkg_check_modules(ITPP itpp)
ENDIF(UNIX)

IF(ITPP_FOUND)
	MESSAGE(STATUS "  Found it++...")
	INCLUDE_DIRECTORIES(${ITPP_INCLUDE_DIRS})
	ADD_DEFINITIONS(${ITPP_CFLAGS})
	ADD_DEFINITIONS(${ITPP_CFLAGS_OTHERS})
	LINK_DIRECTORIES(${ITPP_LIBRARY_DIRS})
	FOREACH(ITPP_LIB ${ITPP_LIBRARIES})
		SET(ITPP_LIB1 "ITPP_LIB1-NOTFOUND")
		FIND_LIBRARY(ITPP_LIB1 NAMES ${ITPP_LIB} PATHS ${ITPP_LIBRARY_DIRS} ${ITPP_LIBDIR} NO_DEFAULT_PATH)
		FIND_LIBRARY(ITPP_LIB1 NAMES ${ITPP_LIB})
		IF(ITPP_LIB1)
			MESSAGE(STATUS "    [  OK  ] Third party lib ${ITPP_LIB1}")
			TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${ITPP_LIB1})
		ELSE(ITPP_LIB1)
			MESSAGE(STATUS "    [FAILED] Third party lib ${ITPP_LIB}")
		ENDIF(ITPP_LIB1)
	ENDFOREACH(ITPP_LIB)

	ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyITPP)
ELSE(ITPP_FOUND)
	MESSAGE(STATUS "  FAILED to find it++...")
ENDIF(ITPP_FOUND)
