# ---------------------------------
# Finds module XML
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_XML "Dynamically link OpenViBE module XML" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_XML)
	ADD_DEFINITIONS(-DXML_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_XML)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_XML)
	SET(OPENVIBE_MODULE_XML_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_XML)
	SET(OPENVIBE_MODULE_XML_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_XML)

FIND_PATH(PATH_OPENVIBE_MODULES_XML include/xml/defines.h PATHS $ENV{OpenViBE_modules}/xml $ENV{OpenViBE_module_xml})
IF(PATH_OPENVIBE_MODULES_XML)
	MESSAGE(STATUS "  Found OpenViBE module XML...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_XML}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_XML OpenViBE-module-XML-${OPENVIBE_MODULE_XML_LINKING} PATHS ${PATH_OPENVIBE_MODULES_XML}/lib)
	IF(LIB_OPENVIBE_MODULE_XML)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_XML}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_XML})
	ELSE(LIB_OPENVIBE_MODULE_XML)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-XML-${OPENVIBE_MODULE_XML_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_XML)

	ADD_DEFINITIONS(-DTARGET_HAS_XML)
ELSE(PATH_OPENVIBE_MODULES_XML)
	MESSAGE(STATUS "  FAILED to find OpenViBE module XML...")
ENDIF(PATH_OPENVIBE_MODULES_XML)
