# ---------------------------------
# Finds module System
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM "Dynamically link OpenViBE module System" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM)
	ADD_DEFINITIONS(-DSystem_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM)
	SET(OPENVIBE_MODULE_SYSTEM_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM)
	SET(OPENVIBE_MODULE_SYSTEM_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_SYSTEM)

FIND_PATH(PATH_OPENVIBE_MODULES_SYSTEM include/system/defines.h PATHS $ENV{OpenViBE_modules}/system $ENV{OpenViBE_module_system})
IF(PATH_OPENVIBE_MODULES_SYSTEM)
	MESSAGE(STATUS "  Found OpenViBE module System...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_SYSTEM}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_SYSTEM OpenViBE-module-System-${OPENVIBE_MODULE_SYSTEM_LINKING} PATHS ${PATH_OPENVIBE_MODULES_SYSTEM}/lib)
	IF(LIB_OPENVIBE_MODULE_SYSTEM)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_SYSTEM}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_SYSTEM})
	ELSE(LIB_OPENVIBE_MODULE_SYSTEM)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-System-${OPENVIBE_MODULE_SYSTEM_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_SYSTEM)

	ADD_DEFINITIONS(-DTARGET_HAS_System)
ELSE(PATH_OPENVIBE_MODULES_SYSTEM)
	MESSAGE(STATUS "  FAILED to find OpenViBE module System...")
ENDIF(PATH_OPENVIBE_MODULES_SYSTEM)
