# ---------------------------------
# Finds module Socket
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET "Dynamically link OpenViBE module Socket" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET)
	ADD_DEFINITIONS(-DSocket_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET)
	SET(OPENVIBE_MODULE_SOCKET_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET)
	SET(OPENVIBE_MODULE_SOCKET_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_SOCKET)

FIND_PATH(PATH_OPENVIBE_MODULES_SOCKET include/socket/defines.h PATHS $ENV{OpenViBE_modules}/socket $ENV{OpenViBE_module_socket})
IF(PATH_OPENVIBE_MODULES_SOCKET)
	MESSAGE(STATUS "  Found OpenViBE module Socket...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_SOCKET}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_SOCKET OpenViBE-module-Socket-${OPENVIBE_MODULE_SOCKET_LINKING} PATHS ${PATH_OPENVIBE_MODULES_SOCKET}/lib)
	IF(LIB_OPENVIBE_MODULE_SOCKET)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_SOCKET}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_SOCKET})
	ELSE(LIB_OPENVIBE_MODULE_SOCKET)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-Socket-${OPENVIBE_MODULE_SOCKET_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_SOCKET)

	ADD_DEFINITIONS(-DTARGET_HAS_Socket)
ELSE(PATH_OPENVIBE_MODULES_SOCKET)
	MESSAGE(STATUS "  FAILED to find OpenViBE module Socket...")
ENDIF(PATH_OPENVIBE_MODULES_SOCKET)
