# ---------------------------------
# Finds module FS
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_FS "Dynamically link OpenViBE module FS" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_FS)
	ADD_DEFINITIONS(-DFS_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_FS)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_FS)
	SET(OPENVIBE_MODULE_FS_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_FS)
	SET(OPENVIBE_MODULE_FS_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_FS)

FIND_PATH(PATH_OPENVIBE_MODULES_FS include/fs/defines.h PATHS $ENV{OpenViBE_modules}/fs $ENV{OpenViBE_module_fs})
IF(PATH_OPENVIBE_MODULES_FS)
	MESSAGE(STATUS "  Found OpenViBE module FS...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_FS}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_FS OpenViBE-module-FS-${OPENVIBE_MODULE_FS_LINKING} PATHS ${PATH_OPENVIBE_MODULES_FS}/lib)
	IF(LIB_OPENVIBE_MODULE_FS)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_FS}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_FS})
	ELSE(LIB_OPENVIBE_MODULE_FS)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-FS-${OPENVIBE_MODULE_FS_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_FS)

	ADD_DEFINITIONS(-DTARGET_HAS_FS)
ELSE(PATH_OPENVIBE_MODULES_FS)
	MESSAGE(STATUS "  FAILED to find OpenViBE module FS...")
ENDIF(PATH_OPENVIBE_MODULES_FS)
