# ---------------------------------
# Finds module EBML
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_EBML "Dynamically link OpenViBE module EBML" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_EBML)
	ADD_DEFINITIONS(-DEBML_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_EBML)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_EBML)
	SET(OPENVIBE_MODULE_EBML_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_EBML)
	SET(OPENVIBE_MODULE_EBML_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_EBML)

FIND_PATH(PATH_OPENVIBE_MODULES_EBML include/ebml/defines.h PATHS $ENV{OpenViBE_modules}/ebml $ENV{OpenViBE_module_ebml})
IF(PATH_OPENVIBE_MODULES_EBML)
	MESSAGE(STATUS "  Found OpenViBE module EBML...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_EBML}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_EBML OpenViBE-module-EBML-${OPENVIBE_MODULE_EBML_LINKING} PATHS ${PATH_OPENVIBE_MODULES_EBML}/lib)
	IF(LIB_OPENVIBE_MODULE_EBML)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_EBML}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_EBML})
	ELSE(LIB_OPENVIBE_MODULE_EBML)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-EBML-${OPENVIBE_MODULE_EBML_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_EBML)

	ADD_DEFINITIONS(-DTARGET_HAS_EBML)
ELSE(PATH_OPENVIBE_MODULES_EBML)
	MESSAGE(STATUS "  FAILED to find OpenViBE module EBML...")
ENDIF(PATH_OPENVIBE_MODULES_EBML)
