# ---------------------------------
# Finds module Automaton 
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON "Dynamically link OpenViBE module Automaton" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON)
	ADD_DEFINITIONS(-DAUTOMATON_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON)
	SET(OPENVIBE_MODULE_AUTOMATON_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON)
	SET(OPENVIBE_MODULE_AUTOMATON_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_AUTOMATON)

FIND_PATH(PATH_OPENVIBE_MODULES_AUTOMATON include/automaton/defines.h PATHS $ENV{OpenViBE_modules}/automaton $ENV{OpenViBE_module_automaton})
IF(PATH_OPENVIBE_MODULES_AUTOMATON)
	MESSAGE(STATUS "  Found OpenViBE module Automaton...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_AUTOMATON}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_AUTOMATON OpenViBE-module-Automaton-${OPENVIBE_MODULE_AUTOMATON_LINKING} PATHS ${PATH_OPENVIBE_MODULES_AUTOMATON}/lib)
	IF(LIB_OPENVIBE_MODULE_AUTOMATON)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_AUTOMATON}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_AUTOMATON})
	ELSE(LIB_OPENVIBE_MODULE_AUTOMATON)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-Automaton-${OPENVIBE_MODULE_AUTOMATON_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_AUTOMATON)

	ADD_DEFINITIONS(-DTARGET_HAS_Automaton)
ELSE(PATH_OPENVIBE_MODULES_AUTOMATON)
	MESSAGE(STATUS "  FAILED to find OpenViBE module Automaton...")
ENDIF(PATH_OPENVIBE_MODULES_AUTOMATON)
