# ---------------------------------
# Finds OpenViBE
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE "Dynamically link OpenViBE" ON)

IF(DYNAMIC_LINK_OPENVIBE)
	ADD_DEFINITIONS(-DOV_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE)

IF(DYNAMIC_LINK_OPENVIBE)
	SET(OPENVIBE_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE)
	SET(OPENVIBE_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE)

FIND_PATH(PATH_OPENVIBE include/openvibe/ov_all.h PATHS $ENV{OpenViBE})
IF(PATH_OPENVIBE)
	MESSAGE(STATUS "  Found OpenViBE...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE}/include)
	FIND_LIBRARY(LIB_OPENVIBE OpenViBE-${OPENVIBE_LINKING} PATH ${PATH_OPENVIBE}/lib)
	IF(LIB_OPENVIBE)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE})
	ELSE(LIB_OPENVIBE)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-${OPENVIBE_LINKING}")
	ENDIF(LIB_OPENVIBE)

	ADD_DEFINITIONS(-DTARGET_HAS_OpenViBE)
ELSE(PATH_OPENVIBE)
	MESSAGE(STATUS "  FAILED to find OpenViBE...")
ENDIF(PATH_OPENVIBE)


