# -*- coding: utf-8 -*-
# -*- coding: utf8 -*-
"""Autogenerated file - DO NOT EDIT
If you spot a bug, please report it on the mailing list and/or change the generator."""

import os

from ...base import (CommandLine, CommandLineInputSpec, SEMLikeCommandLine,
                     TraitedSpec, File, Directory, traits, isdefined,
                     InputMultiPath, OutputMultiPath)


class SimilarityIndexInputSpec(CommandLineInputSpec):
    outputCSVFilename = File(desc="output CSV Filename", exists=True, argstr="--outputCSVFilename %s")
    ANNContinuousVolume = File(desc="ANN Continuous volume to be compared to the manual volume", exists=True, argstr="--ANNContinuousVolume %s")
    inputManualVolume = File(desc="input manual(reference) volume", exists=True, argstr="--inputManualVolume %s")
    thresholdInterval = traits.Float(desc="Threshold interval to compute similarity index between zero and one", argstr="--thresholdInterval %f")


class SimilarityIndexOutputSpec(TraitedSpec):
    pass


class SimilarityIndex(SEMLikeCommandLine):

    """title: BRAINSCut:SimilarityIndexComputation

category: BRAINS.Segmentation

description: Automatic analysis of BRAINSCut Output

version: 1.0

license: https://www.nitrc.org/svn/brains/BuildScripts/trunk/License.txt

contributor: Eunyoung Regin Kim

"""

    input_spec = SimilarityIndexInputSpec
    output_spec = SimilarityIndexOutputSpec
    _cmd = " SimilarityIndex "
    _outputs_filenames = {}
    _redirect_x = False


class BRAINSTalairachInputSpec(CommandLineInputSpec):
    AC = InputMultiPath(traits.Float, desc="Location of AC Point ", sep=",", argstr="--AC %s")
    ACisIndex = traits.Bool(desc="AC Point is Index", argstr="--ACisIndex ")
    PC = InputMultiPath(traits.Float, desc="Location of PC Point ", sep=",", argstr="--PC %s")
    PCisIndex = traits.Bool(desc="PC Point is Index", argstr="--PCisIndex ")
    SLA = InputMultiPath(traits.Float, desc="Location of SLA Point ", sep=",", argstr="--SLA %s")
    SLAisIndex = traits.Bool(desc="SLA Point is Index", argstr="--SLAisIndex ")
    IRP = InputMultiPath(traits.Float, desc="Location of IRP Point ", sep=",", argstr="--IRP %s")
    IRPisIndex = traits.Bool(desc="IRP Point is Index", argstr="--IRPisIndex ")
    inputVolume = File(desc="Input image used to define physical space of images", exists=True, argstr="--inputVolume %s")
    outputBox = traits.Either(traits.Bool, File(), hash_files=False, desc="Name of the resulting Talairach Bounding Box file", argstr="--outputBox %s")
    outputGrid = traits.Either(traits.Bool, File(), hash_files=False, desc="Name of the resulting Talairach Grid file", argstr="--outputGrid %s")


class BRAINSTalairachOutputSpec(TraitedSpec):
    outputBox = File(desc="Name of the resulting Talairach Bounding Box file", exists=True)
    outputGrid = File(desc="Name of the resulting Talairach Grid file", exists=True)


class BRAINSTalairach(SEMLikeCommandLine):

    """title: BRAINS Talairach

category: BRAINS.Segmentation

description: This program creates a VTK structured grid defining the Talairach coordinate system based on four points: AC, PC, IRP, and SLA. The resulting structred grid can be written as either a classic VTK file or the new VTK XML file format. Two representations of the resulting grid can be written. The first is a bounding box representation that also contains the location of the AC and PC points. The second representation is the full Talairach grid representation that includes the additional rows of boxes added to the inferior allowing full coverage of the cerebellum.

version: 0.1

documentation-url: http://www.nitrc.org/plugins/mwiki/index.php/brains:BRAINSTalairach

license: https://www.nitrc.org/svn/brains/BuildScripts/trunk/License.txt

contributor: Steven Dunn and Vincent Magnotta

acknowledgements: Funding for this work was provided by NIH/NINDS award NS050568

"""

    input_spec = BRAINSTalairachInputSpec
    output_spec = BRAINSTalairachOutputSpec
    _cmd = " BRAINSTalairach "
    _outputs_filenames = {'outputGrid': 'outputGrid', 'outputBox': 'outputBox'}
    _redirect_x = False


class BRAINSTalairachMaskInputSpec(CommandLineInputSpec):
    inputVolume = File(desc="Input image used to define physical space of resulting mask", exists=True, argstr="--inputVolume %s")
    talairachParameters = File(desc="Name of the Talairach parameter file.", exists=True, argstr="--talairachParameters %s")
    talairachBox = File(desc="Name of the Talairach box file.", exists=True, argstr="--talairachBox %s")
    hemisphereMode = traits.Enum("left", "right", "both", desc="Mode for box creation: left, right, both", argstr="--hemisphereMode %s")
    expand = traits.Bool(desc="Expand exterior box to include surface CSF", argstr="--expand ")
    outputVolume = traits.Either(traits.Bool, File(), hash_files=False, desc="Output filename for the resulting binary image", argstr="--outputVolume %s")


class BRAINSTalairachMaskOutputSpec(TraitedSpec):
    outputVolume = File(desc="Output filename for the resulting binary image", exists=True)


class BRAINSTalairachMask(SEMLikeCommandLine):

    """title: Talairach Mask

category: BRAINS.Segmentation

description: This program creates a binary image representing the specified Talairach region. The input is an example image to define the physical space for the resulting image, the Talairach grid representation in VTK format, and the file containing the Talairach box definitions to be generated. These can be combined in BRAINS to create a label map using the procedure Brains::WorkupUtils::CreateLabelMapFromBinaryImages.

version: 0.1

documentation-url: http://www.nitrc.org/plugins/mwiki/index.php/brains:BRAINSTalairachMask

license: https://www.nitrc.org/svn/brains/BuildScripts/trunk/License.txt

contributor: Steven Dunn and Vincent Magnotta

acknowledgements: Funding for this work was provided by NIH/NINDS award NS050568

"""

    input_spec = BRAINSTalairachMaskInputSpec
    output_spec = BRAINSTalairachMaskOutputSpec
    _cmd = " BRAINSTalairachMask "
    _outputs_filenames = {'outputVolume': 'outputVolume.nii'}
    _redirect_x = False
