#include <iostream>
#include <string>
#include <vector>

#include <wx/log.h>

#include "StringConvert.h"
#include "NewMetaVolume.h"

using namespace jcs;
using namespace std;


NewMetaVolume::NewMetaVolume(const char* filename, const char* he, const char* re) 
	: BasicVolumeFormat(filename, he, re)
{
}


void
NewMetaVolume::WriteHeader(Basic3DHeader* header_3d)
{ 
	NewMetaHeader* header = dynamic_cast<NewMetaHeader*>(header_3d);
	if (header == 0) {
		wxLogError(_T("Object not meta header type"));
		return;
	}

	if (!mOpenHeaderFile(std::ios::out)) {
		wxLogError(_T("Cannot create meta image header file %s"),
			mFileName.GetFullName().c_str());
		return;
	}

	mHeaderFile << "ObjectType = Image" << endl;

	mHeaderFile << "NDims = " << header->nDims << endl;
	
	mHeaderFile << "DimSize =";
	for (int i = 0; i < header->nDims; ++i)
		mHeaderFile << " " << header->dimSize[i];
	mHeaderFile << endl;

	mHeaderFile << "ElementSpacing =";
	for (int i = 0; i < header->nDims; ++i)
		mHeaderFile << " " << header->elementSpacing[i];
	mHeaderFile << endl;

	mHeaderFile << "Position =";
	for (int i = 0; i < header->nDims; ++i)
		mHeaderFile << " " << header->origin[i];
	mHeaderFile << endl;

	mHeaderFile << "Orientation =";
	for (unsigned int i = 0; i < header->orientation.size(); ++i)
		mHeaderFile << " " << header->orientation.at(i);
	mHeaderFile << endl;

	mHeaderFile << "CenterOfRotation = 0 0 0" << endl;

	mHeaderFile << "AnatomicalOrientation = LPS" << endl;

	mHeaderFile << "ElementByteOrderMSB = " << header->byteOrderMSB << endl;

	mHeaderFile << "ElementNumberOfChannels = " << header->numberOfChannels << endl;

	mHeaderFile << "ElementType = " << MET_ValueTypeName[header->elementType] << endl;

	mHeaderFile << "HeaderSize = " << header->headerSize << endl;

	for (vector<string>::const_iterator it = header->extraFields.begin();
		it != header->extraFields.end(); ++it) {
			mHeaderFile << *it << endl;
		}

	mHeaderFile << "ElementDataFile = " << header->elementFile.c_str() << endl;

	for (vector<string>::const_iterator it = header->sourceFileVector.begin();
		it != header->sourceFileVector.end(); ++it) {
			mHeaderFile << *it << endl;
		}

			
	mCloseHeaderFile();

	if (verbose) cout << "Wrote " << mFileName.GetFullPath().mb_str(wxConvLocal) << endl;

}




