/*
//
//  Copyright 1997-2012 Torsten Rohlfing
//
//  Copyright 2004-2012 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 3517 $
//
//  $LastChangedDate: 2011-10-27 12:42:15 -0700 (Thu, 27 Oct 2011) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkThinPlateSplineXform_h_included_
#define __cmtkThinPlateSplineXform_h_included_

#include <cmtkconfig.h>

#include <Base/cmtkXform.h>

namespace
cmtk
{

/** \addtogroup Base */
//@{
/** Class for landmark-based thin plate spline nonrigid coordinate transformation.
 *\see F.L. Bookstein, "Principal warps: Thin-plate splines and the decomposition of deformations," IEEE Transactions on Pattern Analysis and Machine Intelligence, vol. 11, no. 6, pp. 567-585, 1989. 
 */
class ThinPlateSplineXform :
  public Xform
{
public:
  /// This class type.
  typedef ThinPlateSplineXform Self;
  
  /// Pointer to this class.
  typedef SmartPointer<Self> SmartPtr;

  /// Pointer to constant object of this class.
  typedef SmartConstPointer<Self> SmartConstPtr;

  /// Superclass type.
  typedef Xform Superclass;

};

//@}

} // namespace cmtk

#endif // #ifndef __cmtkThinPlateSplineXform_h_included_

