function norm_coord(infile)

P=spm_get(1,'iy_*.img','Select deformation');

P=[repmat(P,3,1) [',1';',2';',3']];
V=spm_vol(P);

file = spm_load(infile);
outfname = strcat('spm_',infile);
outfile = fopen(outfname,'w');
fprintf('Writing output file %s %d\n', outfname, length(file));

for i = 1:length(file),
	x=file(i,1);
	y=file(i,2);
	z=file(i,3);
	c = [x y z]';
	vx = inv(V(1).mat)*[c ; 1];  % The voxel in the deformation to sample
	normx = spm_sample_vol(V(1),vx(1),vx(2),vx(3),1);
	normy = spm_sample_vol(V(2),vx(1),vx(2),vx(3),1);
	normz = spm_sample_vol(V(3),vx(1),vx(2),vx(3),1);
	fprintf('%d\n',i-1);
	fprintf(outfile,'%d %.2f %.2f %.2f\n',i-1,normx,normy,normz);
end;
fclose(outfile);
