/*
% $Id$
% Copyright (C) 2010, 2011 Alois Schloegl <a.schloegl@ieee.org>
% This file is part of the "BioSig for C/C++" repository 
% (biosig4c++) at http://biosig.sf.net/ 

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 3
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

#include "mathlink.h"
#include "../biosig.h"
#include <stdlib.h>

#define VERBOSE_LEVEL 0

void sload(const char *fn, int *SZ, long SZlen) {

	HDRTYPE *hdr = constructHDR(0,0);

if (VERBOSE_LEVEL > 5)
	fprintf(stdout,"=== start sload ===\n");

// contains [experiment,series,sweep,trace] numbers for selecting data. 
	size_t k = 0;
	while (k < SZlen && k < 5) { 
		hdr->AS.SegSel[k] = (uint32_t)SZ[k];
		k++;
	}


	// ********* open file and read header ************
	hdr = sopen(fn, "r", hdr);
	if (serror2(hdr)) {
		destructHDR(hdr);
		fprintf(stdout,"Cannot open file <%s>\n", fn);
		return;
	}

if (VERBOSE_LEVEL > 5)
	fprintf(stdout,"open filename <%s>NoOfChans=%i\n", fn, hdr->NS);

	// ********** read data ********************
	hdr->FLAG.ROW_BASED_CHANNELS = 0;
	sread(NULL, 0, hdr->NRec*hdr->SPR, hdr);
	if (serror2(hdr)) {
		destructHDR(hdr);
		fprintf(stdout,"Error reading data from file <%s>\n", fn);
		return;
	}

#ifdef _WIN32
	long int sz[2];
#else
	size_t sz[2];
#endif
	sz[0] = hdr->data.size[1];
	sz[1] = hdr->data.size[0];
	MLPutFunction(stdlink, "List", 3);
		// write data matrix 
		MLPutRealArray(stdlink, hdr->data.block, sz, NULL, 2);

		// generate and write time axis
		double *t = (double*)malloc(hdr->NRec*hdr->SPR*sizeof(double));
		for (k=0; k<hdr->NRec*hdr->SPR;) {
			t[k] = (++k)/hdr->SampleRate;
		}
		MLPutRealList(stdlink, t, hdr->NRec*hdr->SPR);
		free(t); 

		// generate and write header information in JSON format
		char *str = NULL;
		asprintf_hdr2json(&str, hdr);
		MLPutString(stdlink, str);
		free(str);

if (VERBOSE_LEVEL > 5) {
	for (k=0;k<hdr->NS;k++)
		fprintf(stdout,"%f ",hdr->data.block[k]);
		fprintf(stdout,"\n\nopen filename <%s>@%p sz=[%i,%i]\n", fn, hdr->data.block, hdr->data.size[0], hdr->data.size[1]);
	}

	// *********** close file *********************
	sclose(hdr);
	destructHDR(hdr);
	return;
}



int main(int argc, char *argv[]) {
   return MLMain(argc, argv);
}



