/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.rollback.ThroughRenameInfo;

public class UnversionedAndNotTouchedFilesGroupCollector
extends EmptyChangelistBuilder {
    private final List<Couple<File>> myToBeDeleted;
    private final Map<File, ThroughRenameInfo> myFromTo = new HashMap<File, ThroughRenameInfo>();
    private TreeMap<String, File> myRenames;
    private Set<String> myAlsoReverted;

    UnversionedAndNotTouchedFilesGroupCollector() {
        this.myToBeDeleted = new ArrayList<Couple<File>>();
    }

    public void processUnversionedFile(VirtualFile file) {
        this.toFromTo(file);
    }

    public void markRename(@NotNull File beforeFile, @NotNull File afterFile) {
        if (beforeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFile", "org/jetbrains/idea/svn/rollback/UnversionedAndNotTouchedFilesGroupCollector", "markRename"));
        }
        if (afterFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFile", "org/jetbrains/idea/svn/rollback/UnversionedAndNotTouchedFilesGroupCollector", "markRename"));
        }
        this.myToBeDeleted.add((Couple<File>)Couple.of((Object)beforeFile, (Object)afterFile));
    }

    public ThroughRenameInfo findToFile(@NotNull FilePath file, @Nullable File firstTo) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/UnversionedAndNotTouchedFilesGroupCollector", "findToFile"));
        }
        String path = FilePathsHelper.convertPath((FilePath)file);
        if (this.myAlsoReverted.contains(path)) {
            return null;
        }
        NavigableMap<String, File> head = this.myRenames.headMap(path, true);
        if (head == null || head.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : head.descendingMap().entrySet()) {
            if (path.equals(entry.getKey())) {
                return null;
            }
            if (!path.startsWith((String)entry.getKey())) continue;
            String convertedBase = FileUtil.toSystemIndependentName((String)((String)entry.getKey()));
            String convertedChild = FileUtil.toSystemIndependentName((String)file.getPath());
            String relativePath = FileUtil.getRelativePath((String)convertedBase, (String)convertedChild, (char)'/');
            assert (relativePath != null);
            return new ThroughRenameInfo((File)entry.getValue(), new File((File)entry.getValue(), relativePath), firstTo, file.getIOFile(), firstTo != null);
        }
        return null;
    }

    private void toFromTo(VirtualFile file) {
        FilePathImpl path = new FilePathImpl(file);
        ThroughRenameInfo info = this.findToFile((FilePath)path, null);
        if (info != null) {
            this.myFromTo.put(path.getIOFile(), info);
        }
    }

    private void processChangeImpl(Change change) {
        FilePath after;
        ThroughRenameInfo info;
        if (change.getAfterRevision() != null && (info = this.findToFile(after = change.getAfterRevision().getFile(), change.getBeforeRevision() == null ? null : change.getBeforeRevision().getFile().getIOFile())) != null) {
            this.myFromTo.put(after.getIOFile(), info);
        }
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processIgnoredFile(VirtualFile file) {
        this.toFromTo(file);
    }

    public List<Couple<File>> getToBeDeleted() {
        return this.myToBeDeleted;
    }

    public Map<File, ThroughRenameInfo> getFromTo() {
        return this.myFromTo;
    }

    public void setRenamesMap(TreeMap<String, File> renames) {
        this.myRenames = renames;
    }

    public void setAlsoReverted(Set<String> alsoReverted) {
        this.myAlsoReverted = alsoReverted;
    }
}

