/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class ExternalsDefinitionParser {
    @NotNull
    public static Map<String, String> parseExternalsProperty(@NotNull String externals) throws SvnBindException {
        if (externals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externals", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "parseExternalsProperty"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (String external : StringUtil.splitByLines((String)externals, (boolean)true)) {
            map.put(ExternalsDefinitionParser.parseRelativeDirectory(external), external);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "parseExternalsProperty"));
        }
        return hashMap;
    }

    @NotNull
    public static String parseRelativeDirectory(@NotNull String s) throws SvnBindException {
        String result;
        int length;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "parseRelativeDirectory"));
        }
        if (ExternalsDefinitionParser.isUnescapedQuote(s = s.trim(), (length = s.length()) - 1)) {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length - 1, '\"');
            ExternalsDefinitionParser.assertIndex(s, index, "Could not find start quote");
            result = s.substring(index + 1, length - 1);
        } else {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length, ' ');
            ExternalsDefinitionParser.assertIndex(s, index, "Could not find separating space");
            result = s.substring(index + 1);
        }
        String string = ExternalsDefinitionParser.unescape(result);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "parseRelativeDirectory"));
        }
        return string;
    }

    private static void assertIndex(@NotNull String s, int index, @NotNull String message) throws SvnBindException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "assertIndex"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "assertIndex"));
        }
        if (index < 0) {
            throw new SvnBindException(message + " - " + s);
        }
    }

    @NotNull
    private static String unescape(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "unescape"));
        }
        String string = s.replace("\\", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "unescape"));
        }
        return string;
    }

    private static int lastUnescapedIndexOf(@NotNull String s, int from, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "lastUnescapedIndexOf"));
        }
        int result = from;
        while ((result = s.lastIndexOf(c, result - 1)) != -1 && !ExternalsDefinitionParser.isUnescaped(s, result, c)) {
        }
        return result;
    }

    private static boolean isUnescapedQuote(@NotNull String s, int index) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "isUnescapedQuote"));
        }
        return ExternalsDefinitionParser.isUnescaped(s, index, '\"');
    }

    private static boolean isUnescaped(@NotNull String s, int index, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser", "isUnescaped"));
        }
        return StringUtil.isChar((CharSequence)s, (int)index, (char)c) && !StringUtil.isChar((CharSequence)s, (int)(index - 1), (char)'\\');
    }
}

