/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AreaMap;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PairProcessor;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoWorker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class OneRecursiveShotMergeInfoWorker
implements MergeInfoWorker {
    @NotNull
    private final MergeContext myMergeContext;
    private final AreaMap<String, Map<String, SVNMergeRangeList>> myDataMap;
    private final Object myLock;
    private final String myFromUrlRelative;

    public OneRecursiveShotMergeInfoWorker(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/mergeinfo/OneRecursiveShotMergeInfoWorker", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myLock = new Object();
        this.myDataMap = AreaMap.create((PairProcessor)new PairProcessor<String, String>(){

            public boolean process(String parentUrl, String childUrl) {
                if (".".equals(parentUrl)) {
                    return true;
                }
                return SVNPathUtil.isAncestor((String)OneRecursiveShotMergeInfoWorker.this.ensureUrlFromSlash(parentUrl), (String)OneRecursiveShotMergeInfoWorker.this.ensureUrlFromSlash(childUrl));
            }
        });
        String url = SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getSourceUrl());
        this.myFromUrlRelative = this.ensureUrlFromSlash(url);
    }

    private String ensureUrlFromSlash(String url) {
        return url.startsWith("/") ? url : "/" + url;
    }

    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        PropertyConsumer handler = new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                String key = OneRecursiveShotMergeInfoWorker.this.keyFromFile(path);
                Object object = OneRecursiveShotMergeInfoWorker.this.myLock;
                synchronized (object) {
                    OneRecursiveShotMergeInfoWorker.this.myDataMap.put((Object)key, (Object)SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(OneRecursiveShotMergeInfoWorker.replaceSeparators(PropertyValue.toString(property.getValue()))), null));
                }
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        };
        File path = new File(this.myMergeContext.getWcInfo().getPath());
        this.myMergeContext.getVcs().getFactory(path).createPropertyClient().getProperty(SvnTarget.fromFile((File)path), "svn:mergeinfo", SVNRevision.WORKING, depth, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SvnMergeInfoCache.MergeCheckResult isMerged(String relativeToRepoURLPath, long revisionNumber) {
        String relativeToWc = SVNPathUtil.getRelativePath((String)this.myFromUrlRelative, (String)this.ensureUrlFromSlash(relativeToRepoURLPath));
        if (relativeToWc == null) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        InfoProcessor processor = new InfoProcessor(relativeToWc, this.myFromUrlRelative, revisionNumber);
        Object object = this.myLock;
        synchronized (object) {
            this.myDataMap.getSimiliar((Object)OneRecursiveShotMergeInfoWorker.keyFromPath(relativeToWc), (PairProcessor)processor);
        }
        return SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
    }

    private String keyFromFile(File file) {
        String path = FileUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getPath(), (String)file.getAbsolutePath(), (char)File.separatorChar).replace(File.separatorChar, '/');
        return OneRecursiveShotMergeInfoWorker.keyFromPath(path);
    }

    private static String keyFromPath(String path) {
        return SystemInfo.isFileSystemCaseSensitive ? path : path.toUpperCase();
    }

    private static String replaceSeparators(String s) {
        return s.replace("\r\r", "\r").replace('\r', '\n').replace("\n\n", "\n");
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, SVNMergeRangeList>> {
        private final String myWcLevelRelativeSourceUrl;
        private boolean myMerged;
        private final String myFilePathAsked;
        private final long myRevisionAsked;

        public InfoProcessor(String filePathAsked, String wcLevelRelativeSourceUrl, long revisionAsked) {
            this.myFilePathAsked = filePathAsked;
            this.myRevisionAsked = revisionAsked;
            this.myWcLevelRelativeSourceUrl = wcLevelRelativeSourceUrl.startsWith("/") ? wcLevelRelativeSourceUrl : "/" + wcLevelRelativeSourceUrl;
        }

        public boolean isMerged() {
            return this.myMerged;
        }

        public boolean process(String relativeFileSubpath, Map<String, SVNMergeRangeList> map) {
            boolean processed = false;
            boolean self = relativeFileSubpath.equals(this.myFilePathAsked);
            if (map.isEmpty()) {
                this.myMerged = false;
                return true;
            }
            block0: for (Map.Entry<String, SVNMergeRangeList> entry : map.entrySet()) {
                String relativeUrl = entry.getKey();
                boolean urlMatches = false;
                if (".".equals(relativeUrl) || "".equals(relativeUrl)) {
                    urlMatches = true;
                } else {
                    relativeUrl = relativeUrl.startsWith("/") ? relativeUrl : "/" + relativeUrl;
                    urlMatches = SVNPathUtil.isAncestor((String)this.myWcLevelRelativeSourceUrl, (String)relativeUrl);
                }
                if (!urlMatches) continue;
                processed = true;
                SVNMergeRangeList rangesList = entry.getValue();
                for (SVNMergeRange range : rangesList.getRanges()) {
                    boolean inInterval;
                    long startRevision = range.getStartRevision() + 1L;
                    long endRevision = range.getEndRevision();
                    boolean isInheritable = range.isInheritable();
                    boolean bl = inInterval = this.myRevisionAsked >= startRevision && this.myRevisionAsked <= endRevision;
                    if (!isInheritable && !self || !inInterval) continue;
                    this.myMerged = true;
                    break block0;
                }
            }
            return processed;
        }
    }
}

