/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitHistoryClient
extends BaseSvnClient
implements HistoryClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public void doLog(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, @Nullable String[] revisionProperties, @Nullable LogEntryConsumer logEntryConsumer) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/history/SvnKitHistoryClient", "doLog"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevision", "org/jetbrains/idea/svn/history/SvnKitHistoryClient", "doLog"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endRevision", "org/jetbrains/idea/svn/history/SvnKitHistoryClient", "doLog"));
        }
        try {
            void handler;
            SVNLogClient client = this.myVcs.getSvnKitManager().createLogClient();
            if (target.isFile()) {
                client.doLog(new File[]{target.getFile()}, startRevision, endRevision, target.getPegRevision(), stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, SvnKitHistoryClient.toHandler((LogEntryConsumer)handler));
            } else {
                client.doLog(target.getURL(), ArrayUtil.EMPTY_STRING_ARRAY, target.getPegRevision(), startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, SvnKitHistoryClient.toHandler((LogEntryConsumer)handler));
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Nullable
    private static ISVNLogEntryHandler toHandler(final @Nullable LogEntryConsumer handler) {
        ISVNLogEntryHandler result = null;
        if (handler != null) {
            result = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    handler.consume(LogEntry.create(logEntry));
                }
            };
        }
        return result;
    }
}

