/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<SvnFileRevision> {
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffFromHistoryHandler(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "<init>"));
        }
        super(vcs.getProject());
        this.myVcs = vcs;
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull SvnFileRevision rev1, @Nullable SvnFileRevision rev2) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        if (rev1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev1", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        File file = path.getIOFile();
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev1.getURL()), (SVNRevision)rev1.getRevision());
        SvnTarget target2 = rev2 != null ? SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev2.getURL()), (SVNRevision)rev2.getRevision()) : SvnTarget.fromFile((File)file);
        List<Change> list = this.executeDiff(path, target1, target2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        return list;
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull SvnFileRevision rev) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getAffectedChanges"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getAffectedChanges"));
        }
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev.getURL()), (SVNRevision)SVNRevision.create((long)0L));
        SvnTarget target2 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev.getURL()), (SVNRevision)rev.getRevision());
        List<Change> list = this.executeDiff(path, target1, target2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getAffectedChanges"));
        }
        return list;
    }

    @NotNull
    protected String getPresentableName(@NotNull SvnFileRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getPresentableName"));
        }
        String string = revision.getRevisionNumber().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @NotNull SvnTarget target1, @NotNull SvnTarget target2) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "executeDiff"));
        }
        if (target1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target1", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "executeDiff"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target2", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "executeDiff"));
        }
        File file = path.getIOFile();
        ClientFactory factory = target2.isURL() ? this.myVcs.getFactory(file) : DirectoryWithBranchComparer.getClientFactory(this.myVcs, file);
        List<Change> list = factory.createDiffClient().compare(target1, target2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler", "executeDiff"));
        }
        return list;
    }
}

