/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.SoftHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.browse.DirectoryEntry;

public class SvnRepositoryCache {
    private final Map<String, List<DirectoryEntry>> myMap = new SoftHashMap();
    private final Map<String, String> myErrorsMap = new SoftHashMap();

    public static SvnRepositoryCache getInstance() {
        return (SvnRepositoryCache)ServiceManager.getService(SvnRepositoryCache.class);
    }

    private SvnRepositoryCache() {
    }

    @Nullable
    public List<DirectoryEntry> getChildren(String parent) {
        return this.myMap.get(parent);
    }

    @Nullable
    public String getError(String parent) {
        return this.myErrorsMap.get(parent);
    }

    public void put(String parent, String error) {
        this.myMap.remove(parent);
        this.myErrorsMap.put(parent, error);
    }

    public void put(String parent, List<DirectoryEntry> children) {
        this.myErrorsMap.remove(parent);
        this.myMap.put(parent, children);
    }

    public void remove(String parent) {
        this.myErrorsMap.remove(parent);
        this.myMap.remove(parent);
    }

    public void clear(String repositoryRootUrl) {
        Iterator<Map.Entry<String, List<DirectoryEntry>>> iterator = this.myMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<DirectoryEntry>> entry = iterator.next();
            if (!entry.getKey().startsWith(repositoryRootUrl)) continue;
            iterator.remove();
        }
    }
}

