/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable DirectoryEntryConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "list"));
        }
        this.assertUrl(target);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.list, parameters, null);
        Info info = this.myFactory.createInfoClient().doInfo(target.getURL(), target.getPegRevision(), revision);
        try {
            CmdBrowseClient.parseOutput(target.getURL(), command, handler, info != null ? info.getRepositoryRootURL() : null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public long createDirectory(@NotNull SvnTarget target, @NotNull String message, boolean makeParents) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "createDirectory"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "createDirectory"));
        }
        this.assertUrl(target);
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<String>)parameters, target);
        CommandUtil.put((List<String>)parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener = new CmdCheckinClient.CommandListener(null);
        this.execute(this.myVcs, target, SvnCommandName.mkdir, parameters, listener);
        return listener.getCommittedRevision();
    }

    private static void parseOutput(@NotNull SVNURL url, @NotNull CommandExecutor command, @Nullable DirectoryEntryConsumer handler, @Nullable SVNURL repositoryUrl) throws VcsException, SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "parseOutput"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "parseOutput"));
        }
        try {
            TargetLists lists = CommandUtil.parse(command.getOutput(), TargetLists.class);
            if (handler != null && lists != null) {
                for (TargetList list : lists.lists) {
                    for (Entry entry : list.entries) {
                        handler.consume(entry.toDirectoryEntry(url, repositoryUrl));
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    public static class Entry {
        @XmlAttribute(name="kind", required=true)
        public NodeKind kind;
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="size")
        public long size;
        public CommitInfo.Builder commit;
        public Lock.Builder lock;

        @NotNull
        public DirectoryEntry toDirectoryEntry(@NotNull SVNURL url, @Nullable SVNURL repositoryUrl) throws SVNException {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/browse/CmdBrowseClient$Entry", "toDirectoryEntry"));
            }
            DirectoryEntry directoryEntry = new DirectoryEntry(url.appendPath(this.name, false), repositoryUrl, PathUtil.getFileName((String)this.name), this.kind, this.commit != null ? this.commit.build() : null, this.name);
            if (directoryEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/browse/CmdBrowseClient$Entry", "toDirectoryEntry"));
            }
            return directoryEntry;
        }
    }

    public static class TargetList {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="entry")
        public List<Entry> entries = new ArrayList<Entry>();
    }

    @XmlRootElement(name="lists")
    public static class TargetLists {
        @XmlElement(name="list")
        public List<TargetList> lists = new ArrayList<TargetList>();
    }
}

