/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnMergeProvider
implements MergeProvider {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.actions.SvnMergeProvider");

    public SvnMergeProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MergeData loadRevisions(final @NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "loadRevisions"));
        }
        final MergeData data = new MergeData();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                ByteArrayOutputStream contents;
                File oldFile = null;
                File newFile = null;
                File workingFile = null;
                boolean mergeCase = false;
                SvnVcs vcs = SvnVcs.getInstance(SvnMergeProvider.this.myProject);
                Info info = vcs.getInfo(file);
                if (info != null) {
                    oldFile = info.getConflictOldFile();
                    newFile = info.getConflictNewFile();
                    workingFile = info.getConflictWrkFile();
                    boolean bl = mergeCase = workingFile == null || workingFile.getName().contains("working");
                    if (workingFile == null) {
                        LOG.info("Null working file when merging text conflict for " + file.getPath() + " old file: " + oldFile + " new file: " + newFile);
                    }
                    if (mergeCase) {
                        oldFile = info.getConflictNewFile();
                        newFile = info.getConflictOldFile();
                        workingFile = info.getConflictWrkFile();
                    }
                } else {
                    throw new VcsException("Could not get info for " + file.getPath());
                }
                data.LAST_REVISION_NUMBER = new SvnRevisionNumber(info.getRevision());
                if (oldFile == null || newFile == null || workingFile == null) {
                    ByteArrayOutputStream bos = SvnMergeProvider.this.getBaseRevisionContents(vcs, file);
                    data.ORIGINAL = bos.toByteArray();
                    data.LAST = bos.toByteArray();
                    data.CURRENT = SvnMergeProvider.readFile(new File(file.getPath()));
                } else {
                    data.ORIGINAL = SvnMergeProvider.readFile(oldFile);
                    data.LAST = SvnMergeProvider.readFile(newFile);
                    data.CURRENT = SvnMergeProvider.readFile(workingFile);
                }
                if (mergeCase && !Arrays.equals((contents = SvnMergeProvider.this.getBaseRevisionContents(vcs, file)).toByteArray(), data.ORIGINAL)) {
                    byte[] original = data.ORIGINAL;
                    data.ORIGINAL = data.LAST;
                    data.LAST = original;
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)VcsBundle.message((String)"multiple.file.merge.loading.progress.title", (Object[])new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData = data;
        if (mergeData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "loadRevisions"));
        }
        return mergeData;
    }

    private ByteArrayOutputStream getBaseRevisionContents(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "getBaseRevisionContents"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "getBaseRevisionContents"));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] contents = SvnUtil.getFileContents(vcs, SvnTarget.fromFile((File)new File(file.getPath())), SVNRevision.BASE, SVNRevision.UNDEFINED);
            bos.write(contents);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return bos;
    }

    private static byte[] readFile(File workingFile) throws VcsException {
        try {
            return FileUtil.loadFileBytes((File)workingFile);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "conflictResolvedForFile"));
        }
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        File path = new File(file.getPath());
        try {
            vcs.getFactory(path).createConflictClient().resolve(path, Depth.EMPTY, false, true, true);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            parent.refresh(true, false);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "isBinary"));
        }
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        try {
            File ioFile = new File(file.getPath());
            PropertyClient client = vcs.getFactory(ioFile).createPropertyClient();
            PropertyValue value = client.getProperty(SvnTarget.fromFile((File)ioFile), "svn:mime-type", false, SVNRevision.WORKING);
            if (value != null && SvnMergeProvider.isBinaryMimeType(value.toString())) {
                return true;
            }
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    private static boolean isBinaryMimeType(@NotNull String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mimeType", "org/jetbrains/idea/svn/actions/SvnMergeProvider", "isBinaryMimeType"));
        }
        return !mimeType.startsWith("text/");
    }
}

