/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.sphinx;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SphinxBaseCommand {
    protected boolean setWorkDir(Module module) {
        ReSTService service = ReSTService.getInstance((Module)module);
        String workDir = service.getWorkdir();
        if (workDir.isEmpty()) {
            AskForWorkDir dialog = new AskForWorkDir(module.getProject());
            dialog.show();
            if (!dialog.isOK()) {
                return false;
            }
            service.setWorkdir(dialog.getInputFile());
        }
        return true;
    }

    public void execute(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/rest/sphinx/SphinxBaseCommand", "execute"));
        }
        Project project = module.getProject();
        try {
            if (!this.setWorkDir(module)) {
                return;
            }
            ProcessHandler process = this.createProcess(module);
            new RunContentExecutor(project, process).withFilter((Filter)new PythonTracebackFilter(project)).withTitle("reStructuredText").withRerun(new Runnable(){

                @Override
                public void run() {
                    SphinxBaseCommand.this.execute(module);
                }
            }).withAfterCompletion(this.getAfterTask(module)).run();
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"ReStructuredText Error");
        }
    }

    @Nullable
    protected Runnable getAfterTask(final Module module) {
        return new Runnable(){

            @Override
            public void run() {
                ReSTService service = ReSTService.getInstance((Module)module);
                LocalFileSystem.getInstance().refreshAndFindFileByPath(service.getWorkdir());
            }
        };
    }

    private ProcessHandler createProcess(Module module) throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine(module, Collections.<String>emptyList());
        ProcessHandler handler = PythonProcessRunner.createProcess((GeneralCommandLine)commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        return handler;
    }

    protected GeneralCommandLine createCommandLine(Module module, List<String> params) throws ExecutionException {
        GeneralCommandLine cmd = new GeneralCommandLine();
        Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
        if (sdk == null) {
            throw new ExecutionException("No sdk specified");
        }
        ReSTService service = ReSTService.getInstance((Module)module);
        cmd.setWorkDirectory(service.getWorkdir().isEmpty() ? module.getProject().getBaseDir().getPath() : service.getWorkdir());
        PythonCommandLineState.createStandardGroupsIn((GeneralCommandLine)cmd);
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        String commandPath = PythonHelpersLocator.getHelperPath((String)"pycharm/pycharm_load_entry_point.py");
        if (commandPath == null) {
            throw new ExecutionException("Cannot find sphinx-quickstart.");
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath != null) {
            cmd.setExePath(sdkHomePath);
        }
        cmd.addParameter(commandPath);
        if (params != null) {
            for (String p : params) {
                script_params.addParameter(p);
            }
        }
        cmd.setPassParentEnvironment(true);
        PythonEnvUtil.setPythonIOEncoding((Map)cmd.getEnvironment(), (String)"utf-8");
        PythonEnvUtil.setPythonUnbuffered((Map)cmd.getEnvironment());
        cmd.getEnvironment().put("PYCHARM_EP_DIST", "Sphinx");
        cmd.getEnvironment().put("PYCHARM_EP_NAME", "sphinx-quickstart");
        ArrayList pathList = Lists.newArrayList((Iterable)PythonCommandLineState.getAddedPaths((Sdk)sdk));
        pathList.addAll(PythonCommandLineState.collectPythonPath((Module)module));
        PythonCommandLineState.initPythonPath((GeneralCommandLine)cmd, (boolean)true, (List)pathList, (String)sdkHomePath);
        PythonSdkType.patchCommandLineForVirtualenv((GeneralCommandLine)cmd, (String)sdkHomePath, (boolean)true);
        BuildoutFacet facet = BuildoutFacet.getInstance((Module)module);
        if (facet != null) {
            facet.patchCommandLineForBuildout(cmd);
        }
        return cmd;
    }

    public static class AskForWorkDir
    extends DialogWrapper {
        private TextFieldWithBrowseButton myInputFile;
        private JPanel myPanel;

        private AskForWorkDir(Project project) {
            super(project);
            this.$$$setupUI$$$();
            this.setTitle("Set Sphinx Working Directory: ");
            this.init();
            VirtualFile baseDir = project.getBaseDir();
            String path = baseDir != null ? baseDir.getPath() : "";
            this.myInputFile.setText(path);
            this.myInputFile.setEditable(false);
            this.myInputFile.addBrowseFolderListener("Choose sphinx working directory (containing makefile): ", null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
            this.myPanel.setPreferredSize(new Dimension(600, 20));
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public String getInputFile() {
            return this.myInputFile.getText();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            ((Component)jPanel).setEnabled(false);
            JLabel jLabel = new JLabel();
            jLabel.setText("Sphinx working directory");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myInputFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

