/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run.sphinx;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.rest.run.RestConfigurationEditor;
import com.jetbrains.rest.run.RestRunConfiguration;
import com.jetbrains.rest.run.sphinx.SphinxCommandLineState;
import com.jetbrains.rest.run.sphinx.SphinxTasksModel;
import org.jetbrains.annotations.NotNull;

public class SphinxRunConfiguration
extends RestRunConfiguration {
    public SphinxRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        RestConfigurationEditor editor = new RestConfigurationEditor(this.getProject(), this, new SphinxTasksModel());
        editor.setConfigurationName("Sphinx task");
        editor.setOpenInBrowserVisible(false);
        editor.setInputDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
        editor.setOutputDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return editor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/rest/run/sphinx/SphinxRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/rest/run/sphinx/SphinxRunConfiguration", "getState"));
        }
        return new SphinxCommandLineState(this, env);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.getInputFile())) {
            throw new RuntimeConfigurationError("Please specify input directory name.");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getOutputFile())) {
            throw new RuntimeConfigurationError("Please specify output directory name.");
        }
    }

    public String suggestedName() {
        return "sphinx task in " + this.getName();
    }
}

