/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.RestFileType;
import com.jetbrains.rest.run.docutils.DocutilsRunConfiguration;
import com.jetbrains.rest.run.sphinx.SphinxRunConfiguration;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RestRunConfigurationType
implements ConfigurationType {
    public final ConfigurationFactory DOCUTILS_FACTORY = new DocutilsRunConfigurationFactory(this);
    public final ConfigurationFactory SPHINX_FACTORY = new SphinxRunConfigurationFactory(this);
    private String myId = "docs";

    public String getDisplayName() {
        return RestBundle.message((String)"runcfg.docutils.display_name", (Object[])new Object[0]);
    }

    public static RestRunConfigurationType getInstance() {
        return (RestRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(RestRunConfigurationType.class);
    }

    public String getConfigurationTypeDescription() {
        return RestBundle.message((String)"runcfg.docutils.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return RestFileType.INSTANCE.getIcon();
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/run/RestRunConfigurationType", "getId"));
        }
        return string;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.DOCUTILS_FACTORY, this.SPHINX_FACTORY};
    }

    private static class SphinxRunConfigurationFactory
    extends RestConfigurationFactory {
        protected SphinxRunConfigurationFactory(ConfigurationType type) {
            super(type, "Sphinx task");
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new SphinxRunConfiguration(project, (ConfigurationFactory)this);
        }
    }

    private static class DocutilsRunConfigurationFactory
    extends RestConfigurationFactory {
        protected DocutilsRunConfigurationFactory(ConfigurationType type) {
            super(type, "Docutils task");
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new DocutilsRunConfiguration(project, (ConfigurationFactory)this);
        }
    }

    private static abstract class RestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        private final String myName;

        public RestConfigurationFactory(@NotNull ConfigurationType type, @NotNull String name) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/rest/run/RestRunConfigurationType$RestConfigurationFactory", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/rest/run/RestRunConfigurationType$RestConfigurationFactory", "<init>"));
            }
            super(type);
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }
}

