/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.rest.run.RestRunConfiguration;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class RestCommandLineState
extends PythonCommandLineState {
    protected final RestRunConfiguration myConfiguration;

    public RestCommandLineState(RestRunConfiguration configuration, ExecutionEnvironment env) {
        super((AbstractPythonRunConfiguration)configuration, env);
        this.myConfiguration = configuration;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String key;
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exe_options = parametersList.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfiguration.getInterpreterOptions());
        ParamsGroup script_parameters = parametersList.getParamsGroup("Script");
        assert (script_parameters != null);
        String runner = PythonHelpersLocator.getHelperPath((String)this.getRunnerPath());
        if (runner != null) {
            script_parameters.addParameter(runner);
        }
        if ((key = this.getKey()) != null) {
            script_parameters.addParameter(key);
        }
        script_parameters.addParameter(this.getTask());
        String params = this.myConfiguration.getParams();
        if (params != null) {
            script_parameters.addParametersString(params);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getInputFile())) {
            script_parameters.addParameter(this.myConfiguration.getInputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            script_parameters.addParameter(this.myConfiguration.getOutputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfiguration.getWorkingDirectory());
        }
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        final Runnable afterTask = this.getAfterTask();
        ProcessHandler processHandler = PythonProcessRunner.createProcess((GeneralCommandLine)commandLine);
        if (afterTask != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    SwingUtilities.invokeLater(afterTask);
                }
            });
        }
        return processHandler;
    }

    @Nullable
    protected Runnable getAfterTask() {
        return null;
    }

    @Nullable
    protected VirtualFile findOutput() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getOutputFile());
            if (virtualFile == null) {
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getWorkingDirectory() + this.myConfiguration.getOutputFile());
            }
            return virtualFile;
        }
        return null;
    }

    protected abstract String getRunnerPath();

    protected abstract String getTask();

    @Nullable
    protected abstract String getKey();
}

