/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.quickfixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.inspections.RestRoleInspection;
import org.jetbrains.annotations.NotNull;

public class AddIgnoredRoleFix
implements LocalQuickFix,
LowPriorityAction {
    private final String myRole;
    private RestRoleInspection myInspection;

    public AddIgnoredRoleFix(String role, RestRoleInspection visitor) {
        this.myRole = role;
        this.myInspection = visitor;
    }

    @NotNull
    public String getName() {
        String string = RestBundle.message((String)"QFIX.ignore.role", (Object[])new Object[]{this.myRole});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/quickfixes/AddIgnoredRoleFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Ignore undefined role" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/quickfixes/AddIgnoredRoleFix", "getFamilyName"));
        }
        return "Ignore undefined role";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/rest/quickfixes/AddIgnoredRoleFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/rest/quickfixes/AddIgnoredRoleFix", "applyFix"));
        }
        if (!this.myInspection.ignoredRoles.contains((Object)this.myRole)) {
            this.myInspection.ignoredRoles.add((Object)this.myRole);
            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)profile);
        }
    }
}

