/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.RestFile;
import com.jetbrains.rest.RestTokenTypes;
import com.jetbrains.rest.RestUtil;
import com.jetbrains.rest.inspections.RestInspection;
import com.jetbrains.rest.inspections.RestInspectionVisitor;
import com.jetbrains.rest.psi.RestDirectiveBlock;
import com.jetbrains.rest.psi.RestRole;
import com.jetbrains.rest.quickfixes.AddIgnoredRoleFix;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RestRoleInspection
extends RestInspection {
    public JDOMExternalizableStringList ignoredRoles = new JDOMExternalizableStringList();

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = RestBundle.message((String)"INSP.role.not.defined", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/inspections/RestRoleInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/rest/inspections/RestRoleInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, (List<String>)this.ignoredRoles);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/inspections/RestRoleInspection", "buildVisitor"));
        }
        return visitor;
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore roles", (List)this.ignoredRoles);
        return form.getContentPanel();
    }

    private class Visitor
    extends RestInspectionVisitor {
        private final ImmutableSet<String> myIgnoredRoles;
        Set<String> mySphinxRoles;

        public Visitor(ProblemsHolder holder, List<String> ignoredRoles) {
            super(holder);
            this.mySphinxRoles = new HashSet();
            this.myIgnoredRoles = ImmutableSet.copyOf(ignoredRoles);
            Project project = holder.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
            if (module == null) {
                return;
            }
            String dir = ReSTService.getInstance((Module)module).getWorkdir();
            if (!dir.isEmpty()) {
                this.fillSphinxRoles(dir, project);
            }
        }

        private void fillSphinxRoles(String dir, Project project) {
            VirtualFile config = LocalFileSystem.getInstance().findFileByPath((dir.endsWith("/") ? dir : dir + "/") + "conf.py");
            if (config == null) {
                return;
            }
            PsiFile configFile = PsiManager.getInstance((Project)project).findFile(config);
            if (configFile instanceof PyFile) {
                PyFile file = (PyFile)configFile;
                List functions = file.getTopLevelFunctions();
                for (PyFunction function : functions) {
                    PyStatement[] statements;
                    if (!"setup".equals(function.getName())) continue;
                    PyStatementList stList = function.getStatementList();
                    for (PyStatement statement : statements = stList.getStatements()) {
                        PyExpression arg;
                        if (statement instanceof PyExpressionStatement) {
                            statement = ((PyExpressionStatement)statement).getExpression();
                        }
                        if (!(statement instanceof PyCallExpression) || !((PyCallExpression)statement).isCalleeText(new String[]{"add_role"}) || !((arg = ((PyCallExpression)statement).getArguments()[0]) instanceof PyStringLiteralExpression)) continue;
                        this.mySphinxRoles.add(((PyStringLiteralExpression)arg).getStringValue());
                    }
                }
            }
        }

        public void visitRole(RestRole node) {
            RestFile file = (RestFile)node.getContainingFile();
            if (PsiTreeUtil.getParentOfType((PsiElement)node, RestDirectiveBlock.class) != null) {
                return;
            }
            PsiElement sibling = node.getNextSibling();
            if (sibling == null || sibling.getNode().getElementType() != RestTokenTypes.INTERPRETED) {
                return;
            }
            if (RestUtil.PREDEFINED_ROLES.contains(node.getText()) || this.myIgnoredRoles.contains((Object)node.getRoleName())) {
                return;
            }
            if (RestUtil.SPHINX_ROLES.contains(node.getText()) || RestUtil.SPHINX_ROLES.contains(":py" + node.getText()) || this.mySphinxRoles.contains(node.getRoleName())) {
                return;
            }
            HashSet definedRoles = new HashSet();
            RestDirectiveBlock[] directives = (RestDirectiveBlock[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestDirectiveBlock.class);
            if (directives != null) {
                for (RestDirectiveBlock block : directives) {
                    PsiElement role;
                    if (!block.getDirectiveName().equals("role::") || (role = block.getFirstChild().getNextSibling()) == null) continue;
                    String roleName = role.getText().trim();
                    int index = roleName.indexOf(40);
                    if (index != -1) {
                        roleName = roleName.substring(0, index);
                    }
                    definedRoles.add(roleName);
                }
            }
            if (definedRoles.contains(node.getRoleName())) {
                return;
            }
            this.registerProblem((PsiElement)node, "Not defined role '" + node.getRoleName() + "'", new AddIgnoredRoleFix(node.getRoleName(), RestRoleInspection.this));
        }
    }
}

