/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.inspections;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.rest.validation.RestElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestInspectionVisitor
extends RestElementVisitor {
    @Nullable
    private final ProblemsHolder myHolder;

    public RestInspectionVisitor(@Nullable ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public RestInspectionVisitor(@Nullable ProblemsHolder problemsHolder, @NotNull LocalInspectionToolSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/rest/inspections/RestInspectionVisitor", "<init>"));
        }
        this.myHolder = problemsHolder;
    }

    @Nullable
    protected ProblemsHolder getHolder() {
        return this.myHolder;
    }

    protected final void registerProblem(PsiElement element, String message) {
        if (element == null || element.getTextLength() == 0) {
            return;
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem(element, message, new LocalQuickFix[0]);
        }
    }

    protected final void registerProblem(@Nullable PsiElement element, @NotNull String message, @NotNull LocalQuickFix quickFix) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        if (quickFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFix", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        if (element == null || element.getTextLength() == 0) {
            return;
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem(element, message, new LocalQuickFix[]{quickFix});
        }
    }

    protected final void registerProblem(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        this.registerProblem(psiElement, descriptionTemplate, highlightType, hintAction, (TextRange)null, fixes);
    }

    protected final void registerProblem(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/jetbrains/rest/inspections/RestInspectionVisitor", "registerProblem"));
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem((ProblemDescriptor)new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, rangeInElement, hintAction, this.myHolder.isOnTheFly()));
        }
    }
}

