/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.jetbrains.python.ReSTService;
import com.jetbrains.rest.RestLanguage;
import org.jetbrains.annotations.NotNull;

public class RestLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile vFile, @NotNull Project project) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/rest/RestLanguageSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/rest/RestLanguageSubstitutor", "getLanguage"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (module == null) {
            return null;
        }
        boolean txtIsRst = ReSTService.getInstance((Module)module).txtIsRst();
        if (txtIsRst) {
            return RestLanguage.INSTANCE;
        }
        return null;
    }
}

